/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.editors;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.CommandUtils;

public class R4EDeltaCompareEditorInput
extends CompareEditorInput {
    private final ITypedElement fTargetElement;
    private final ITypedElement fBaseElement;

    public R4EDeltaCompareEditorInput(R4EFileVersion aTargetVersion, R4EFileVersion aBaseVersion) {
        super(new CompareConfiguration());
        this.fTargetElement = CommandUtils.createTypedElement(aTargetVersion);
        this.fBaseElement = CommandUtils.createTypedElement(aBaseVersion);
        this.getCompareConfiguration().setProperty("IGNORE_WHITESPACE", (Object)true);
    }

    public ITypedElement getAncestorElement() {
        return null;
    }

    public ITypedElement getTargetElement() {
        return this.fTargetElement;
    }

    public ITypedElement getBaseElement() {
        return this.fBaseElement;
    }

    public Object prepareCompareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        return this.prepareInput(monitor);
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.fTargetElement == null && this.fBaseElement == null) {
            R4EUIPlugin.Ftracer.traceWarning("Nothing to compare, both sides are NULL");
            return null;
        }
        Differencer differencer = new Differencer();
        return differencer.findDifferences(false, monitor, null, null, (Object)this.fTargetElement, (Object)this.fBaseElement);
    }
}

