/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.mylyn.reviews.frame.core.model.ReviewComponent;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewType;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.Persistence;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.core.utils.ResourceUtils;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReview;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewExtended;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.mylyn.reviews.r4e.upgrade.ui.R4EUpgradeController;
import org.eclipse.swt.widgets.Display;

public class OpenElementHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Opening Element...";

    public Object execute(ExecutionEvent aEvent) {
        final List<IR4EUIModelElement> selectedElements = UIUtils.getCommandUIElements();
        Job job = new Job(COMMAND_MESSAGE){
            public String familyName;
            {
                super($anonymous0);
                this.familyName = "R4EUI";
            }

            public boolean belongsTo(Object aFamily) {
                return this.familyName.equals(aFamily);
            }

            public IStatus run(IProgressMonitor aMonitor) {
                R4EUIModelController.setJobInProgress(true);
                aMonitor.beginTask(OpenElementHandler.COMMAND_MESSAGE, -1);
                if (!selectedElements.isEmpty()) {
                    IR4EUIModelElement element = null;
                    IR4EUIModelElement upgradedElement = null;
                    try {
                        element = (IR4EUIModelElement)selectedElements.get(0);
                        if (element instanceof R4EUIReview) {
                            R4EUIPlugin.Ftracer.traceInfo("Opening element " + element.getName());
                            upgradedElement = OpenElementHandler.this.checkReviewCompatibility((R4EUIReview)element);
                            if (upgradedElement == null) {
                                R4EUIModelController.setJobInProgress(false);
                                aMonitor.done();
                                return Status.CANCEL_STATUS;
                            }
                        } else {
                            upgradedElement = element;
                        }
                        upgradedElement.open();
                        R4EUIModelController.setJobInProgress(false);
                        UIUtils.setNavigatorViewFocus(upgradedElement, 1);
                    }
                    catch (ResourceHandlingException e) {
                        UIUtils.displayResourceErrorDialog(e);
                        if (element != null && element instanceof R4EUIReviewBasic) {
                            element.close();
                        }
                    }
                    catch (CompatibilityException e) {
                        UIUtils.displayCompatibilityErrorDialog(e);
                        if (element != null && element instanceof R4EUIReviewBasic) {
                            element.close();
                        }
                    }
                    catch (FileNotFoundException e) {
                        R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                        R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), e);
                        final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "File not found error detected while opening element", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, e.getMessage(), (Throwable)e), 4);
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                dialog.open();
                            }
                        });
                    }
                }
                R4EUIModelController.setJobInProgress(false);
                aMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private R4EUIReview checkReviewCompatibility(R4EUIReview aUiReview) throws ResourceHandlingException, CompatibilityException {
        String oldVersion;
        R4EUIReview originalUiReview = aUiReview;
        R4EUIReview newUiReview = null;
        R4EUIReviewBasic activeReview = R4EUIModelController.getActiveReview();
        if (activeReview != null) {
            activeReview.close();
        }
        R4EUIModelController.resetToDefaultSerialization();
        if (originalUiReview instanceof R4EUIReviewBasic) return originalUiReview;
        String reviewName = originalUiReview.getReview().getName();
        R4EUIReviewGroup parentGroup = (R4EUIReviewGroup)originalUiReview.getParent();
        String newVersion = Persistence.Roots.REVIEW.getVersion();
        String validReviewName = ResourceUtils.toValidFileName((String)reviewName);
        URI upgradeRootUri = URI.createFileURI((String)(String.valueOf(parentGroup.getReviewGroup().getFolder()) + "/" + validReviewName));
        URI reviewResourceUri = upgradeRootUri.appendSegment(String.valueOf(validReviewName) + "_review.xrer");
        try {
            oldVersion = R4EUpgradeController.getVersionFromResourceFile((URI)reviewResourceUri);
        }
        catch (IOException e1) {
            throw new ResourceHandlingException("Cannot find Review Group resource file " + reviewResourceUri, (Throwable)e1);
        }
        if (originalUiReview.checkCompatibility(upgradeRootUri, "Review " + reviewName, oldVersion, newVersion, true)) {
            parentGroup.close();
            parentGroup.open();
            R4EUIReview upgradedUiReview = parentGroup.getReview(reviewName);
            R4EReview upgradedReview = upgradedUiReview.getReview();
            if (upgradedReview.getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_FORMAL)) {
                newUiReview = new R4EUIReviewExtended(parentGroup, upgradedReview, upgradedReview.getType(), false);
                ((R4EUIReviewExtended)newUiReview).setName(String.valueOf(((R4EUIReviewExtended)newUiReview).getPhaseString(((R4EReviewState)upgradedReview.getState()).getState())) + ": " + upgradedReview.getName());
            } else {
                newUiReview = new R4EUIReviewBasic(parentGroup, upgradedReview, upgradedReview.getType(), false);
            }
            parentGroup.replaceReview(upgradedUiReview, newUiReview);
            if (oldVersion.equals(newVersion)) return newUiReview;
            try {
                R4EUIModelController.stampVersion((ReviewComponent)upgradedReview, R4EUIModelController.getReviewer(), newVersion);
                return newUiReview;
            }
            catch (OutOfSyncException e) {
                R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                R4EUIModelController.FModelExt.closeR4EReview(upgradedReview);
                R4EUIModelController.setJobInProgress(false);
                return null;
            }
        } else {
            R4EUIModelController.setJobInProgress(false);
            return null;
        }
    }
}

