/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UserValidationDialog
extends Dialog {
    private Text username;
    private Text password;
    private UIServices.AuthenticationInfo result = null;
    private Button saveButton;
    private final String titleMessage;
    private final Image titleImage;
    private final String message;
    private final int dialogImageType;

    public UserValidationDialog(Shell parentShell, String titleMessage, Image titleImage, String message) {
        this(null, parentShell, titleMessage, titleImage, message, 4);
    }

    public UserValidationDialog(UIServices.AuthenticationInfo lastUsed, Shell parentShell, String titleMessage, Image titleImage, String message) {
        this(lastUsed, parentShell, titleMessage, titleImage, message, 8);
    }

    private UserValidationDialog(UIServices.AuthenticationInfo lastUsed, Shell parentShell, String titleMessage, Image titleImage, String message, int dialogImageType) {
        super(parentShell);
        this.result = lastUsed;
        this.titleMessage = titleMessage;
        this.titleImage = titleImage;
        this.message = message;
        this.dialogImageType = dialogImageType;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.titleMessage);
        newShell.setImage(this.titleImage);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createImageSection(container);
        this.createFieldsSection(container);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createImageSection(Composite composite) {
        Image image = composite.getDisplay().getSystemImage(this.dialogImageType);
        if (image != null) {
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            label.setImage(image);
        }
    }

    private void createFieldsSection(Composite composite) {
        Composite fieldContainer = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        fieldContainer.setLayout((Layout)layout);
        GridData layoutData = new GridData();
        fieldContainer.setLayoutData((Object)layoutData);
        Label label = new Label(fieldContainer, 16448);
        GridData data = new GridData(1, 1, false, false, 2, 1);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setText(this.message);
        label = new Label(fieldContainer, 0);
        label.setText(ProvUIMessages.UserValidationDialog_UsernameLabel);
        this.username = new Text(fieldContainer, 2048);
        layoutData = new GridData(4, 1, true, false);
        this.username.setLayoutData((Object)layoutData);
        this.username.setText(this.getUserName());
        label = new Label(fieldContainer, 0);
        label.setText(ProvUIMessages.UserValidationDialog_PasswordLabel);
        this.password = new Text(fieldContainer, 0x400800);
        layoutData = new GridData(4, 1, true, false);
        this.password.setLayoutData((Object)layoutData);
        this.password.setText(this.getPassword());
        this.saveButton = new Button(fieldContainer, 32);
        this.saveButton.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.saveButton.setText(ProvUIMessages.UserValidationDialog_SavePasswordButton);
        this.saveButton.setSelection(this.saveResult());
    }

    protected void okPressed() {
        this.result = new UIServices.AuthenticationInfo(this.username.getText(), this.password.getText(), this.saveButton.getSelection());
        super.okPressed();
    }

    public UIServices.AuthenticationInfo getResult() {
        return this.result;
    }

    private String getUserName() {
        return this.result != null ? this.result.getUserName() : "";
    }

    private String getPassword() {
        return this.result != null ? this.result.getPassword() : "";
    }

    private boolean saveResult() {
        return this.result != null ? this.result.saveResult() : false;
    }
}

