/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.TEXTMETRIC;

public final class FontMetrics {
    public TEXTMETRIC handle;
    private int nativeZoom;

    FontMetrics() {
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FontMetrics)) {
            return false;
        }
        TEXTMETRIC metric = ((FontMetrics)object).handle;
        return this.handle.tmHeight == metric.tmHeight && this.handle.tmAscent == metric.tmAscent && this.handle.tmDescent == metric.tmDescent && this.handle.tmInternalLeading == metric.tmInternalLeading && this.handle.tmExternalLeading == metric.tmExternalLeading && this.handle.tmAveCharWidth == metric.tmAveCharWidth && this.handle.tmMaxCharWidth == metric.tmMaxCharWidth && this.handle.tmWeight == metric.tmWeight && this.handle.tmOverhang == metric.tmOverhang && this.handle.tmDigitizedAspectX == metric.tmDigitizedAspectX && this.handle.tmDigitizedAspectY == metric.tmDigitizedAspectY && this.handle.tmItalic == metric.tmItalic && this.handle.tmUnderlined == metric.tmUnderlined && this.handle.tmStruckOut == metric.tmStruckOut && this.handle.tmPitchAndFamily == metric.tmPitchAndFamily && this.handle.tmCharSet == metric.tmCharSet;
    }

    public int getAscent() {
        return DPIUtil.pixelToPoint(this.handle.tmAscent - this.handle.tmInternalLeading, this.getZoom());
    }

    public double getAverageCharacterWidth() {
        return this.getAverageCharWidth();
    }

    @Deprecated
    public int getAverageCharWidth() {
        return DPIUtil.pixelToPoint(this.handle.tmAveCharWidth, this.getZoom());
    }

    public int getDescent() {
        return DPIUtil.pixelToPoint(this.handle.tmDescent, this.getZoom());
    }

    public int getHeight() {
        return DPIUtil.pixelToPoint(this.handle.tmHeight, this.getZoom());
    }

    public int getLeading() {
        return this.getHeight() - this.getAscent() - this.getDescent();
    }

    private int getZoom() {
        return DPIUtil.getZoomForAutoscaleProperty(this.nativeZoom);
    }

    public int hashCode() {
        return this.handle.tmHeight ^ this.handle.tmAscent ^ this.handle.tmDescent ^ this.handle.tmInternalLeading ^ this.handle.tmExternalLeading ^ this.handle.tmAveCharWidth ^ this.handle.tmMaxCharWidth ^ this.handle.tmWeight ^ this.handle.tmOverhang ^ this.handle.tmDigitizedAspectX ^ this.handle.tmDigitizedAspectY ^ this.handle.tmItalic ^ this.handle.tmUnderlined ^ this.handle.tmStruckOut ^ this.handle.tmPitchAndFamily ^ this.handle.tmCharSet;
    }

    public static FontMetrics win32_new(TEXTMETRIC handle, int nativeZoom) {
        FontMetrics fontMetrics = new FontMetrics();
        fontMetrics.handle = handle;
        fontMetrics.nativeZoom = nativeZoom;
        return fontMetrics;
    }
}

