/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.auth.events;

import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.eclipse.equinox.security.auth.ILoginContextListener;

public class SecurityEventsManager {
    private final Vector<ILoginContextListener> listeners = new Vector(5);

    public synchronized void addListener(ILoginContextListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(ILoginContextListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyLoginBegin(Subject subject) {
        for (ILoginContextListener listener : this.listeners) {
            listener.onLoginStart(subject);
        }
    }

    public void notifyLoginEnd(Subject subject, LoginException loginException) {
        for (ILoginContextListener listener : this.listeners) {
            listener.onLoginFinish(subject, loginException);
        }
    }

    public void notifyLogoutBegin(Subject subject) {
        for (ILoginContextListener listener : this.listeners) {
            listener.onLogoutStart(subject);
        }
    }

    public void notifyLogoutEnd(Subject subject, LoginException loginException) {
        for (ILoginContextListener listener : this.listeners) {
            listener.onLogoutFinish(subject, loginException);
        }
    }
}

