/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.net.URI;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.oomph.setup.internal.installer.AbstractSimpleDialog;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallerDialog;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallerPage;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SimpleReadmePage
extends SimpleInstallerPage {
    private URI readmeURI;
    private Browser browser;

    public SimpleReadmePage(Composite parent, SimpleInstallerDialog dialog) {
        super(parent, dialog, true);
    }

    protected void createContent(Composite container) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginLeft = 17;
        layout.marginRight = 11;
        layout.marginTop = 39;
        layout.marginBottom = 30;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        container.setLayout((Layout)layout);
        container.setBackgroundMode(2);
        container.setBackground(AbstractSimpleDialog.COLOR_WHITE);
        Label title = new Label(container, 0);
        title.setText("README");
        title.setForeground(UIUtil.getEclipseThemeColor());
        title.setFont(SimpleInstallerDialog.getFont(3, "bold"));
        title.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.browser = new Browser(container, 0);
        this.browser.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).indent(0, 20).create());
        this.browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changed(LocationEvent event) {
                SimpleReadmePage.this.styleBrowser();
            }
        });
    }

    private void styleBrowser() {
        StringBuilder styleInjection = new StringBuilder();
        styleInjection.append("var newStyle = document.createElement(\"style\");\n");
        styleInjection.append("newStyle.setAttribute(\"type\", \"text/css\");\n");
        styleInjection.append("newStyle.innerHTML = \"body{overflow-x:hidden}\"\n");
        styleInjection.append("document.getElementsByTagName(\"head\")[0].appendChild(newStyle);\n");
        this.browser.execute(styleInjection.toString());
    }

    public URI getReadmeURI() {
        return this.readmeURI;
    }

    public void setReadmeURI(URI readmeURI) {
        if (this.readmeURI != readmeURI) {
            this.readmeURI = readmeURI;
            if (readmeURI != null) {
                this.browser.setUrl(readmeURI.toString());
            }
        }
    }
}

