/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.repository.helpers;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.repository.helpers.Messages;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.osgi.util.NLS;

public class RepositoryHelper {
    private static final Pattern WORKSPACE_KEY_PATTERN = Pattern.compile("\\s*<key href=\"(file:/.*)\\.metadata/\\.plugins/org\\.eclipse\\.oomph\\.setup/workspace\\.setup#/\"/>");
    protected static final String FILE_SCHEME = "file";

    public static URI localRepoURIHelper(URI location) {
        if (location == null) {
            return null;
        }
        if (location.getScheme() == null) {
            location = new File(location.getPath()).getAbsoluteFile().toURI();
        } else if (location.getScheme().length() == 1) {
            location = new File(URIUtil.toUnencodedString((URI)location)).toURI();
        } else if (!FILE_SCHEME.equalsIgnoreCase(location.getScheme())) {
            return location;
        }
        String lowerCase = location.toString().toLowerCase();
        if (lowerCase.endsWith(".jar") || lowerCase.endsWith(".zip")) {
            return URIUtil.toJarURI((URI)location, null);
        }
        return location;
    }

    public static <T> IRepository<T> validDestinationRepository(IRepository<T> repository) {
        if (!repository.isModifiable()) {
            throw new IllegalStateException(NLS.bind((String)Messages.DestinationNotModifiable, (Object)repository.getLocation()));
        }
        return repository;
    }

    /*
     * Unable to fully structure code
     */
    public static IStatus checkRepositoryLocationSyntax(URI location) {
        block7: {
            block8: {
                if (location == null) {
                    throw new IllegalArgumentException("Location cannot be null");
                }
                if (!location.isAbsolute()) {
                    return new Status(4, "org.eclipse.equinox.p2.repository", Messages.locationMustBeAbsolute);
                }
                scheme = location.getScheme();
                if (scheme == null) {
                    return Status.error((String)Messages.schemeNotProvided);
                }
                try {
                    new URL(scheme, "dummy.com", -1, "dummy.txt");
                    break block7;
                }
                catch (MalformedURLException e) {
                    reg = RegistryFactory.getRegistry();
                    if (reg == null) break block8;
                    handlersExtensionPoint = reg.getExtensionPoint("org.eclipse.ecf.filetransfer.urlStreamHandlerService");
                    var9_6 = configurationElements = handlersExtensionPoint.getConfigurationElements();
                    var8_7 = configurationElements.length;
                    var7_8 = 0;
                    ** while (var7_8 < var8_7)
                }
lbl-1000:
                // 1 sources

                {
                    configurationElement = var9_6[var7_8];
                    protocol = configurationElement.getAttribute("protocol");
                    if (Objects.equals(scheme, protocol)) {
                        return Status.OK_STATUS;
                    }
                    ++var7_8;
                    continue;
                }
            }
            return new Status(4, "org.eclipse.equinox.p2.repository", Messages.schemeNotSupported, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> IRepository<T> createMemoryComposite(IProvisioningAgent agent, Class<? extends IRepositoryManager<T>> repoManagerClass, String repositoryType) {
        if (agent == null) {
            return null;
        }
        IRepositoryManager manager = (IRepositoryManager)agent.getService(repoManagerClass);
        if (manager == null) {
            return null;
        }
        IRepositoryManager iRepositoryManager = manager;
        synchronized (iRepositoryManager) {
            URI repositoryURI;
            do {
                try {
                    repositoryURI = new URI("memory:" + String.valueOf(UUID.randomUUID()));
                }
                catch (URISyntaxException e) {
                    return null;
                }
            } while (manager.contains(repositoryURI));
            try {
                IRepository result = manager.createRepository(repositoryURI, repositoryURI.toString(), repositoryType, null);
                manager.removeRepository(repositoryURI);
                return result;
            }
            catch (ProvisionException e) {
                LogHelper.log((ProvisionException)e);
                return null;
            }
        }
    }

    public static List<Path> getSharedBundlePools() {
        Path agentsInfoLocation = RepositoryHelper.getAgentManagerLocation().resolve("agents.info");
        if (Files.isRegularFile(agentsInfoLocation, new LinkOption[0])) {
            Charset encoding = RepositoryHelper.getSharedAgentEncoding();
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (Stream<String> agentLocations = Files.lines(agentsInfoLocation, encoding);){
                    ArrayList<Path> result = new ArrayList<Path>();
                    agentLocations.map(agentLocation -> Path.of(agentLocation, "pools.info")).filter(path -> Files.isRegularFile(path, new LinkOption[0])).forEach(poolsInfoLocation -> {
                        try {
                            Throwable throwable = null;
                            Object var4_6 = null;
                            try (Stream<String> poolLocations = Files.lines(poolsInfoLocation, encoding);){
                                poolLocations.map(string -> Path.of(string, new String[0])).filter(poolLocation -> Files.exists(poolLocation.resolve("artifacts.xml"), new LinkOption[0])).forEach(result::add);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception ex) {
                            LogHelper.log((IStatus)Status.warning((String)("The bundle pools load failed: " + String.valueOf(poolsInfoLocation)), (Throwable)ex));
                        }
                    });
                    return result;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                LogHelper.log((IStatus)Status.warning((String)("The agents load failed: " + String.valueOf(agentsInfoLocation)), (Throwable)ex));
            }
        }
        return List.of();
    }

    public static List<Path> getWorkspaceBundlePools() {
        Path locations = Path.of(System.getProperty("user.home"), ".eclipse/org.eclipse.oomph.setup/setups/locations.setup");
        if (Files.isRegularFile(locations, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (Stream<String> allLocations = Files.lines(locations);){
                    return allLocations.map(location -> {
                        Matcher matcher = WORKSPACE_KEY_PATTERN.matcher((CharSequence)location);
                        if (matcher.matches()) {
                            try {
                                return Path.of(URI.create(matcher.group(1)));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return null;
                    }).filter(Objects::nonNull).distinct().map(workspace -> workspace.resolve(".metadata/.plugins/org.eclipse.pde.core/.bundle_pool")).filter(pool -> Files.isRegularFile(pool.resolve("artifacts.xml"), new LinkOption[0])).toList();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                LogHelper.log((IStatus)Status.warning((String)("The locations load failed: " + String.valueOf(locations)), (Throwable)ex));
            }
        }
        return List.of();
    }

    private static Path getAgentManagerLocation() {
        return Path.of(System.getProperty("user.home"), ".eclipse/org.eclipse.oomph.p2");
    }

    private static Charset getSharedAgentEncoding() {
        Path encodingInfo = RepositoryHelper.getAgentManagerLocation().resolve("encoding.info");
        if (Files.isRegularFile(encodingInfo, new LinkOption[0])) {
            try {
                return Charset.forName(Files.readString(encodingInfo).trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Charset.defaultCharset();
    }
}

