/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ExceptionStash;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;

public abstract class Device
implements Drawable {
    protected static final int CHANGE_SCALEFACTOR = 1;
    long gsettingsProc;
    Callback gsettingsCallback;
    boolean isConnected = false;
    long displaySettings;
    protected long xDisplay;
    long shellHandle;
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    Object trackingLock;
    volatile boolean disposed;
    long logProc;
    Callback logCallback;
    String[] log_domains = new String[]{"", "GLib-GObject", "GLib", "GObject", "Pango", "ATK", "GdkPixbuf", "Gdk", "Gtk", "GnomeVFS", "GIO"};
    int[] handler_ids = new int[this.log_domains.length];
    int warningLevel;
    static Callback XErrorCallback;
    static Callback XIOErrorCallback;
    static long XErrorProc;
    static long XIOErrorProc;
    static long XNullErrorProc;
    static long XNullIOErrorProc;
    static Device[] Devices;
    static final Color COLOR_BLACK;
    static final Color COLOR_DARK_RED;
    static final Color COLOR_DARK_GREEN;
    static final Color COLOR_DARK_YELLOW;
    static final Color COLOR_DARK_BLUE;
    static final Color COLOR_DARK_MAGENTA;
    static final Color COLOR_DARK_CYAN;
    static final Color COLOR_GRAY;
    static final Color COLOR_DARK_GRAY;
    static final Color COLOR_RED;
    static final Color COLOR_TRANSPARENT;
    static final Color COLOR_GREEN;
    static final Color COLOR_YELLOW;
    static final Color COLOR_BLUE;
    static final Color COLOR_MAGENTA;
    static final Color COLOR_CYAN;
    static final Color COLOR_WHITE;
    Font systemFont;
    Point dpi;
    long emptyTab;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;

    static {
        Devices = new Device[4];
        COLOR_TRANSPARENT = new Color(255, 255, 255, 0);
        COLOR_BLACK = new Color(0, 0, 0);
        COLOR_DARK_RED = new Color(128, 0, 0);
        COLOR_DARK_GREEN = new Color(0, 128, 0);
        COLOR_DARK_YELLOW = new Color(128, 128, 0);
        COLOR_DARK_BLUE = new Color(0, 0, 128);
        COLOR_DARK_MAGENTA = new Color(128, 0, 128);
        COLOR_DARK_CYAN = new Color(0, 128, 128);
        COLOR_GRAY = new Color(192, 192, 192);
        COLOR_DARK_GRAY = new Color(128, 128, 128);
        COLOR_RED = new Color(255, 0, 0);
        COLOR_GREEN = new Color(0, 255, 0);
        COLOR_YELLOW = new Color(255, 255, 0);
        COLOR_BLUE = new Color(0, 0, 255);
        COLOR_MAGENTA = new Color(255, 0, 255);
        COLOR_CYAN = new Color(0, 255, 255);
        COLOR_WHITE = new Color(255, 255, 255);
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData data) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (data != null) {
                this.debug = data.debug;
                this.tracking = data.tracking;
            }
            if (this.tracking) {
                this.startTracking();
            }
            this.create(data);
            this.init();
            Device.register(this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean isTracking() {
        this.checkDevice();
        return this.tracking;
    }

    public void setTracking(boolean tracking) {
        this.checkDevice();
        if (tracking == this.tracking) {
            return;
        }
        this.tracking = tracking;
        if (tracking) {
            this.startTracking();
        } else {
            this.stopTracking();
        }
    }

    private void startTracking() {
        this.errors = new Error[128];
        this.objects = new Object[128];
        this.trackingLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopTracking() {
        Object object = this.trackingLock;
        synchronized (object) {
            this.objects = null;
            this.errors = null;
            this.trackingLock = null;
        }
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    protected void create(DeviceData data) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (ExceptionStash exceptions = new ExceptionStash();){
                if (this.isDisposed()) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                this.checkDevice();
                try {
                    this.release();
                }
                catch (Error | RuntimeException ex) {
                    exceptions.stash(ex);
                }
                this.destroy();
                Device.deregister(this);
                this.xDisplay = 0L;
                this.disposed = true;
                if (this.tracking) {
                    this.tracking = false;
                    this.stopTracking();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int i = 0;
            while (i < this.objects.length) {
                if (this.objects[i] == object) {
                    this.objects[i] = null;
                    this.errors[i] = null;
                    return;
                }
                ++i;
            }
        }
    }

    static synchronized Device findDevice(long xDisplay) {
        int i = 0;
        while (i < Devices.length) {
            Device device = Devices[i];
            if (device != null && device.xDisplay == xDisplay) {
                return device;
            }
            ++i;
        }
        return null;
    }

    static synchronized void deregister(Device device) {
        int i = 0;
        while (i < Devices.length) {
            if (device == Devices[i]) {
                Device.Devices[i] = null;
            }
            ++i;
        }
    }

    protected void destroy() {
    }

    public Rectangle getBounds() {
        this.checkDevice();
        return new Rectangle(0, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData data = new DeviceData();
        data.debug = this.debug;
        data.tracking = this.tracking;
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                int count = 0;
                int length = this.objects.length;
                int i = 0;
                while (i < length) {
                    if (this.objects[i] != null) {
                        ++count;
                    }
                    ++i;
                }
                int index = 0;
                data.objects = new Object[count];
                data.errors = new Error[count];
                int i2 = 0;
                while (i2 < length) {
                    if (this.objects[i2] != null) {
                        data.objects[index] = this.objects[i2];
                        data.errors[index] = this.errors[i2];
                        ++index;
                    }
                    ++i2;
                }
            }
        } else {
            data.objects = new Object[0];
            data.errors = new Error[0];
        }
        return data;
    }

    public Rectangle getClientArea() {
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        return 0;
    }

    public Point getDPI() {
        this.checkDevice();
        return this.getScreenDPI();
    }

    public FontData[] getFontList(String faceName, boolean scalable) {
        long context;
        this.checkDevice();
        if (!scalable) {
            return new FontData[0];
        }
        long[] family = new long[1];
        long[] face = new long[1];
        long[] families = new long[1];
        int[] n_families = new int[1];
        long[] faces = new long[1];
        int[] n_faces = new int[1];
        if (GTK.GTK4) {
            long fontMap = OS.pango_cairo_font_map_get_default();
            context = OS.pango_font_map_create_context(fontMap);
        } else {
            context = GDK.gdk_pango_context_get();
        }
        OS.pango_context_list_families(context, families, n_families);
        int nFds = 0;
        FontData[] fds = new FontData[faceName != null ? 4 : n_families[0]];
        int i = 0;
        while (i < n_families[0]) {
            C.memmove(family, families[0] + (long)(i * C.PTR_SIZEOF), (long)C.PTR_SIZEOF);
            boolean match = true;
            if (faceName != null) {
                long familyName = OS.pango_font_family_get_name(family[0]);
                int length = C.strlen(familyName);
                byte[] buffer = new byte[length];
                C.memmove(buffer, familyName, (long)length);
                String name = new String(Converter.mbcsToWcs(buffer));
                match = faceName.equalsIgnoreCase(name);
            }
            if (match) {
                OS.pango_font_family_list_faces(family[0], faces, n_faces);
                int j = 0;
                while (j < n_faces[0]) {
                    C.memmove(face, faces[0] + (long)(j * C.PTR_SIZEOF), (long)C.PTR_SIZEOF);
                    long fontDesc = OS.pango_font_face_describe(face[0]);
                    Font font = Font.gtk_new(this, fontDesc);
                    FontData data = font.getFontData()[0];
                    if (nFds == fds.length) {
                        FontData[] newFds = new FontData[fds.length + n_families[0]];
                        System.arraycopy(fds, 0, newFds, 0, nFds);
                        fds = newFds;
                    }
                    fds[nFds++] = data;
                    OS.pango_font_description_free(fontDesc);
                    ++j;
                }
                OS.g_free(faces[0]);
                if (faceName != null) break;
            }
            ++i;
        }
        OS.g_free(families[0]);
        OS.g_object_unref(context);
        if (nFds == fds.length) {
            return fds;
        }
        FontData[] result = new FontData[nFds];
        System.arraycopy(fds, 0, result, 0, nFds);
        return result;
    }

    Point getScreenDPI() {
        long screen;
        int dpi;
        Point ptDPI = GTK.GTK4 ? new Point(96, 96) : ((dpi = (int)GDK.gdk_screen_get_resolution(screen = GDK.gdk_screen_get_default())) == -1 ? new Point(96, 96) : new Point(dpi, dpi));
        return ptDPI;
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        switch (id) {
            case 37: {
                return COLOR_TRANSPARENT;
            }
            case 2: {
                return COLOR_BLACK;
            }
            case 4: {
                return COLOR_DARK_RED;
            }
            case 6: {
                return COLOR_DARK_GREEN;
            }
            case 8: {
                return COLOR_DARK_YELLOW;
            }
            case 10: {
                return COLOR_DARK_BLUE;
            }
            case 12: {
                return COLOR_DARK_MAGENTA;
            }
            case 14: {
                return COLOR_DARK_CYAN;
            }
            case 15: {
                return COLOR_GRAY;
            }
            case 16: {
                return COLOR_DARK_GRAY;
            }
            case 3: {
                return COLOR_RED;
            }
            case 5: {
                return COLOR_GREEN;
            }
            case 7: {
                return COLOR_YELLOW;
            }
            case 9: {
                return COLOR_BLUE;
            }
            case 11: {
                return COLOR_MAGENTA;
            }
            case 13: {
                return COLOR_CYAN;
            }
            case 1: {
                return COLOR_WHITE;
            }
        }
        return COLOR_BLACK;
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.systemFont;
    }

    public boolean getWarnings() {
        this.checkDevice();
        return this.warningLevel == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        if (this.debug && this.xDisplay != 0L) {
            Class<?> clazz;
            Class<?> clazz2 = clazz = this.getClass();
            synchronized (clazz2) {
                int index = 0;
                while (index < Devices.length) {
                    if (Devices[index] != null) break;
                    ++index;
                }
                if (index == Devices.length) {
                    XErrorCallback = new Callback(clazz, "XErrorProc", 2);
                    XNullErrorProc = XErrorCallback.getAddress();
                    XIOErrorCallback = new Callback(clazz, "XIOErrorProc", 1);
                    XNullIOErrorProc = XIOErrorCallback.getAddress();
                    XErrorProc = OS.XSetErrorHandler(XNullErrorProc);
                    XIOErrorProc = OS.XSetIOErrorHandler(XNullIOErrorProc);
                }
            }
            if (this.debug) {
                OS.XSynchronize(this.xDisplay, true);
            }
        }
        if (this.xDisplay != 0L) {
            this.logCallback = new Callback(this, "logProc", 4);
            this.logProc = this.logCallback.getAddress();
            if (this.debug) {
                int flags = -1;
                int i = 0;
                while (i < this.log_domains.length) {
                    byte[] log_domain = Converter.wcsToMbcs(this.log_domains[i], true);
                    this.handler_ids[i] = OS.g_log_set_handler(log_domain, flags, this.logProc, 0L);
                    ++i;
                }
            }
        }
        this.emptyTab = OS.pango_tab_array_new(1, false);
        if (this.emptyTab == 0L) {
            SWT.error(2);
        }
        OS.pango_tab_array_set_tab(this.emptyTab, 0, 0L, 1);
        this.shellHandle = GTK.GTK4 ? GTK4.gtk_window_new() : GTK3.gtk_window_new(0);
        if (this.shellHandle == 0L) {
            SWT.error(2);
        }
        GTK.gtk_widget_realize(this.shellHandle);
        this.dpi = this.getDPI();
        DPIUtil.setDeviceZoom(this.getDeviceZoom());
        long[] defaultFontArray = new long[1];
        long defaultFont = 0L;
        long context = GTK.gtk_widget_get_style_context(this.shellHandle);
        if ("ppc64le".equals(System.getProperty("os.arch"))) {
            defaultFont = GTK3.gtk_style_context_get_font(context, 0);
        } else if (GTK.GTK4) {
            int length;
            long[] fontPtr = new long[1];
            long settings = GTK.gtk_settings_get_default();
            OS.g_object_get(settings, GTK.gtk_style_property_font, fontPtr, 0L);
            if (fontPtr[0] != 0L && (length = C.strlen(fontPtr[0])) != 0) {
                byte[] fontString = new byte[length + 1];
                C.memmove(fontString, fontPtr[0], (long)length);
                OS.g_free(fontPtr[0]);
                defaultFont = OS.pango_font_description_from_string(fontString);
            }
        } else {
            GTK.gtk_style_context_save(context);
            GTK.gtk_style_context_set_state(context, 0L);
            GTK3.gtk_style_context_get(context, 0, GTK.gtk_style_property_font, defaultFontArray, 0L);
            GTK.gtk_style_context_restore(context);
            defaultFont = defaultFontArray[0];
        }
        defaultFont = OS.pango_font_description_copy(defaultFont);
        Point screenDPI = this.getScreenDPI();
        if (this.dpi.y != screenDPI.y) {
            int size = OS.pango_font_description_get_size(defaultFont);
            OS.pango_font_description_set_size(defaultFont, size * this.dpi.y / screenDPI.y);
        }
        this.systemFont = Font.gtk_new(this, defaultFont);
        this.overrideThemeValues();
    }

    private void overrideThemeValues() {
        String additionalCSSPath;
        long provider = GTK.gtk_css_provider_new();
        BiFunction<String, Boolean, String> load = (path, isResource) -> {
            try {
                BufferedReader buffer = isResource != false ? new BufferedReader(new InputStreamReader(Device.class.getResourceAsStream((String)path))) : new BufferedReader(new FileReader(new File((String)path)));
                return buffer.lines().collect(Collectors.joining("\n"));
            }
            catch (IOException e) {
                System.err.println("SWT Warning: Failed to load " + (isResource != false ? "resource: " : "file: ") + path);
                return "";
            }
        };
        StringBuilder combinedCSS = new StringBuilder();
        if (!GTK.GTK4) {
            combinedCSS.append(load.apply("/org/eclipse/swt/internal/gtk/swt_functional_gtk_3_20.css", true));
        }
        if (System.getProperty("org.eclipse.swt.internal.gtk.noThemingFixes") == null) {
            combinedCSS.append(load.apply("/org/eclipse/swt/internal/gtk/swt_theming_fixes_gtk_3_20.css", true));
            if (GTK.GTK_VERSION >= OS.VERSION(3, 24, 5)) {
                combinedCSS.append(load.apply("/org/eclipse/swt/internal/gtk/swt_theming_fixes_gtk_3_24_5.css", true));
            }
            if (GTK.GTK4) {
                combinedCSS.append(load.apply("/org/eclipse/swt/internal/gtk/swt_theming_fixes_gtk_4_0_0.css", true));
            }
        }
        if ((additionalCSSPath = System.getProperty("org.eclipse.swt.internal.gtk.cssFile")) != null) {
            combinedCSS.append(load.apply(additionalCSSPath, false));
        }
        if (GTK.GTK4) {
            long display = GDK.gdk_display_get_default();
            if (display == 0L || provider == 0L) {
                System.err.println("SWT Warning: Override of theme values failed. Reason: could not acquire display or provider.");
                return;
            }
            GTK4.gtk_style_context_add_provider_for_display(display, provider, 600);
        } else {
            long screen = GDK.gdk_screen_get_default();
            if (screen == 0L || provider == 0L) {
                System.err.println("SWT Warning: Override of theme values failed. Reason: could not acquire screen or provider.");
                return;
            }
            GTK3.gtk_style_context_add_provider_for_screen(screen, provider, 600);
        }
        if (GTK.GTK4) {
            GTK4.gtk_css_provider_load_from_data(provider, Converter.wcsToMbcs(combinedCSS.toString(), true), -1L);
        } else {
            GTK3.gtk_css_provider_load_from_data(provider, Converter.wcsToMbcs(combinedCSS.toString(), true), -1L, null);
        }
    }

    @Override
    public abstract long internal_new_GC(GCData var1);

    @Override
    public abstract void internal_dispose_GC(long var1, GCData var3);

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean loadFont(String path) {
        this.checkDevice();
        if (path == null) {
            SWT.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(path, true);
        return OS.FcConfigAppFontAddFile(0L, buffer);
    }

    long logProc(long log_domain, long log_level, long message, long user_data) {
        if (DEBUG) {
            new Error().printStackTrace();
        }
        if (this.warningLevel == 0) {
            if (DEBUG || this.debug) {
                new Error().printStackTrace();
            }
            OS.g_log_default_handler(log_domain, (int)log_level, message, 0L);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void new_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int i = 0;
            while (i < this.objects.length) {
                if (this.objects[i] == null) {
                    this.objects[i] = object;
                    this.errors[i] = new Error();
                    return;
                }
                ++i;
            }
            Object[] newObjects = new Object[this.objects.length + 128];
            System.arraycopy(this.objects, 0, newObjects, 0, this.objects.length);
            newObjects[this.objects.length] = object;
            this.objects = newObjects;
            Error[] newErrors = new Error[this.errors.length + 128];
            System.arraycopy(this.errors, 0, newErrors, 0, this.errors.length);
            newErrors[this.errors.length] = new Error();
            this.errors = newErrors;
        }
    }

    static synchronized void register(Device device) {
        int i = 0;
        while (i < Devices.length) {
            if (Devices[i] == null) {
                Device.Devices[i] = device;
                return;
            }
            ++i;
        }
        Device[] newDevices = new Device[Devices.length + 4];
        System.arraycopy(Devices, 0, newDevices, 0, Devices.length);
        newDevices[Device.Devices.length] = device;
        Devices = newDevices;
    }

    protected void release() {
        if (this.shellHandle != 0L) {
            if (GTK.GTK4) {
                GTK4.gtk_window_destroy(this.shellHandle);
            } else {
                GTK3.gtk_widget_destroy(this.shellHandle);
            }
        }
        this.shellHandle = 0L;
        if (this.systemFont != null) {
            this.systemFont.dispose();
        }
        this.systemFont = null;
        if (this.emptyTab != 0L) {
            OS.pango_tab_array_free(this.emptyTab);
        }
        this.emptyTab = 0L;
        if (this.xDisplay != 0L) {
            int i = 0;
            while (i < this.handler_ids.length) {
                if (this.handler_ids[i] != 0) {
                    byte[] log_domain = Converter.wcsToMbcs(this.log_domains[i], true);
                    OS.g_log_remove_handler(log_domain, this.handler_ids[i]);
                    this.handler_ids[i] = 0;
                }
                ++i;
            }
            this.logCallback.dispose();
            this.logCallback = null;
            this.handler_ids = null;
            this.log_domains = null;
            this.logProc = 0L;
        }
        if (this.gsettingsCallback != null) {
            this.gsettingsCallback.dispose();
            this.gsettingsCallback = null;
        }
        this.gsettingsProc = 0L;
    }

    public void setWarnings(boolean warnings) {
        block9: {
            block8: {
                this.checkDevice();
                if (!warnings) break block8;
                if (--this.warningLevel != 0) break block9;
                if (this.debug) {
                    return;
                }
                if (this.logProc != 0L) {
                    int i = 0;
                    while (i < this.handler_ids.length) {
                        if (this.handler_ids[i] != 0) {
                            byte[] log_domain = Converter.wcsToMbcs(this.log_domains[i], true);
                            OS.g_log_remove_handler(log_domain, this.handler_ids[i]);
                            this.handler_ids[i] = 0;
                        }
                        ++i;
                    }
                }
                break block9;
            }
            if (this.warningLevel++ == 0) {
                if (this.debug) {
                    return;
                }
                if (this.logProc != 0L) {
                    int flags = -1;
                    int i = 0;
                    while (i < this.log_domains.length) {
                        byte[] log_domain = Converter.wcsToMbcs(this.log_domains[i], true);
                        this.handler_ids[i] = OS.g_log_set_handler(log_domain, flags, this.logProc, 0L);
                        ++i;
                    }
                }
            }
        }
    }

    static long XErrorProc(long xDisplay, long xErrorEvent) {
        Device device = Device.findDevice(xDisplay);
        if (device != null) {
            if (device.warningLevel == 0) {
                if (DEBUG || device.debug) {
                    new SWTError().printStackTrace();
                }
                OS.Call(XErrorProc, xDisplay, xErrorEvent);
            }
        } else {
            if (DEBUG) {
                new SWTError().printStackTrace();
            }
            OS.Call(XErrorProc, xDisplay, xErrorEvent);
        }
        return 0L;
    }

    static long XIOErrorProc(long xDisplay) {
        Device device = Device.findDevice(xDisplay);
        if (device != null) {
            if (DEBUG || device.debug) {
                new SWTError().printStackTrace();
            }
        } else if (DEBUG) {
            new SWTError().printStackTrace();
        }
        OS.Call(XIOErrorProc, xDisplay, 0L);
        return 0L;
    }

    protected int getDeviceZoom() {
        long monitor;
        int dpi = 96;
        long display = GDK.gdk_display_get_default();
        if (GTK.GTK4) {
            long surface = GTK4.gtk_native_get_surface(GTK4.gtk_widget_get_native(this.shellHandle));
            monitor = GDK.gdk_display_get_monitor_at_surface(display, surface);
        } else {
            monitor = GDK.gdk_display_get_monitor_at_point(display, 0, 0);
        }
        if (monitor != 0L) {
            int scale = GDK.gdk_monitor_get_scale_factor(monitor);
            dpi *= scale;
        }
        return DPIUtil.mapDPIToZoom(dpi);
    }
}

