/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.util.Optional;
import java.util.function.Function;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.eclipse.swt.graphics.ImageGcDrawer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class DPIUtil {
    private static final int DPI_ZOOM_100 = 96;
    private static int deviceZoom = 100;
    private static int nativeDeviceZoom = 100;
    private static final AutoScaleMethod AUTO_SCALE_METHOD_SETTING;
    private static AutoScaleMethod autoScaleMethod;
    private static String autoScaleValue;
    private static final boolean USE_CAIRO_AUTOSCALE;
    private static final String SWT_AUTOSCALE = "swt.autoScale";
    private static final String SWT_AUTOSCALE_METHOD = "swt.autoScale.method";
    private static final String SWT_AUTOSCALE_UPDATE_ON_RUNTIME = "swt.autoScale.updateOnRuntime";

    static {
        USE_CAIRO_AUTOSCALE = SWT.getPlatform().equals("gtk");
        autoScaleValue = System.getProperty(SWT_AUTOSCALE);
        String value = System.getProperty(SWT_AUTOSCALE_METHOD);
        AUTO_SCALE_METHOD_SETTING = AutoScaleMethod.forString(value).orElse(AutoScaleMethod.AUTO);
        autoScaleMethod = AUTO_SCALE_METHOD_SETTING != AutoScaleMethod.AUTO ? AUTO_SCALE_METHOD_SETTING : AutoScaleMethod.NEAREST;
    }

    public static ImageData autoScaleDown(Device device, ImageData imageData) {
        if (deviceZoom == 100 || imageData == null || device != null && !device.isAutoScalable()) {
            return imageData;
        }
        float scaleFactor = 1.0f / DPIUtil.getScalingFactor(deviceZoom);
        return DPIUtil.autoScaleImageData(device, imageData, scaleFactor);
    }

    public static int[] autoScaleDown(int[] pointArray) {
        if (deviceZoom == 100 || pointArray == null) {
            return pointArray;
        }
        float scaleFactor = DPIUtil.getScalingFactor(deviceZoom);
        int[] returnArray = new int[pointArray.length];
        int i = 0;
        while (i < pointArray.length) {
            returnArray[i] = Math.round((float)pointArray[i] / scaleFactor);
            ++i;
        }
        return returnArray;
    }

    public static int[] autoScaleDown(Drawable drawable, int[] pointArray) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return pointArray;
        }
        return DPIUtil.autoScaleDown(pointArray);
    }

    public static float[] autoScaleDown(float[] size) {
        return DPIUtil.scaleDown(size, deviceZoom);
    }

    public static float[] scaleDown(float[] size, int zoom) {
        if (zoom == 100 || size == null) {
            return size;
        }
        float scaleFactor = DPIUtil.getScalingFactor(zoom);
        float[] scaledSize = new float[size.length];
        int i = 0;
        while (i < scaledSize.length) {
            scaledSize[i] = size[i] / scaleFactor;
            ++i;
        }
        return scaledSize;
    }

    public static float[] autoScaleDown(Drawable drawable, float[] size) {
        return DPIUtil.scaleDown(drawable, size, deviceZoom);
    }

    public static float[] scaleDown(Drawable drawable, float[] size, int zoom) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return size;
        }
        return DPIUtil.scaleDown(size, zoom);
    }

    public static int autoScaleDown(int size) {
        return DPIUtil.scaleDown(size, deviceZoom);
    }

    public static int scaleDown(int size, int zoom) {
        if (zoom == 100 || size == -1) {
            return size;
        }
        float scaleFactor = DPIUtil.getScalingFactor(zoom);
        return Math.round((float)size / scaleFactor);
    }

    public static int autoScaleDown(Drawable drawable, int size) {
        return DPIUtil.scaleDown(drawable, size, deviceZoom);
    }

    public static int scaleDown(Drawable drawable, int size, int zoom) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return size;
        }
        return DPIUtil.scaleDown(size, zoom);
    }

    public static float autoScaleDown(float size) {
        return DPIUtil.scaleDown(size, deviceZoom);
    }

    public static float scaleDown(float size, int zoom) {
        if (zoom == 100 || size == -1.0f) {
            return size;
        }
        float scaleFactor = DPIUtil.getScalingFactor(zoom);
        return size / scaleFactor;
    }

    public static float autoScaleDown(Drawable drawable, float size) {
        return DPIUtil.scaleDown(drawable, size, deviceZoom);
    }

    public static float scaleDown(Drawable drawable, float size, int zoom) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return size;
        }
        return DPIUtil.scaleDown(size, zoom);
    }

    public static Point autoScaleDown(Point point) {
        return DPIUtil.scaleDown(point, deviceZoom);
    }

    public static Point scaleDown(Point point, int zoom) {
        if (zoom == 100 || point == null) {
            return point;
        }
        Point.OfFloat fPoint = FloatAwareGeometryFactory.createFrom(point);
        float scaleFactor = DPIUtil.getScalingFactor(zoom);
        float scaledX = fPoint.getX() / scaleFactor;
        float scaledY = fPoint.getY() / scaleFactor;
        return new Point.OfFloat(scaledX, scaledY);
    }

    public static Point autoScaleDown(Drawable drawable, Point point) {
        return DPIUtil.scaleDown(drawable, point, deviceZoom);
    }

    public static Point scaleDown(Drawable drawable, Point point, int zoom) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return point;
        }
        return DPIUtil.scaleDown(point, zoom);
    }

    public static Rectangle autoScaleDown(Rectangle rect) {
        return DPIUtil.scaleDown(rect, deviceZoom);
    }

    public static Rectangle scaleDown(Rectangle rect, int zoom) {
        return DPIUtil.scaleBounds(rect, 100, zoom);
    }

    public static Rectangle autoScaleDown(Drawable drawable, Rectangle rect) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return rect;
        }
        return DPIUtil.scaleDown(rect, deviceZoom);
    }

    public static Rectangle scaleDown(Drawable drawable, Rectangle rect, int zoom) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return rect;
        }
        return DPIUtil.scaleDown(rect, zoom);
    }

    public static ImageData scaleImageData(Device device, ImageData imageData, int targetZoom, int currentZoom) {
        if (imageData == null || targetZoom == currentZoom || device != null && !device.isAutoScalable()) {
            return imageData;
        }
        float scaleFactor = (float)targetZoom / (float)currentZoom;
        return DPIUtil.autoScaleImageData(device, imageData, scaleFactor);
    }

    public static ImageData scaleImageData(Device device, ElementAtZoom<ImageData> elementAtZoom, int targetZoom) {
        return DPIUtil.scaleImageData(device, elementAtZoom.element(), targetZoom, elementAtZoom.zoom());
    }

    public static ImageData autoScaleImageData(Device device, ImageData imageData, final float scaleFactor) {
        boolean useSmoothScaling;
        final int width = imageData.width;
        final int height = imageData.height;
        int scaledWidth = Math.round((float)width * scaleFactor);
        int scaledHeight = Math.round((float)height * scaleFactor);
        boolean bl = useSmoothScaling = DPIUtil.isSmoothScalingEnabled() && imageData.getTransparencyType() != 2;
        if (useSmoothScaling) {
            final Image original = new Image(device, zoom -> imageData);
            ImageGcDrawer drawer = new ImageGcDrawer(){

                @Override
                public void drawOn(GC gc, int imageWidth, int imageHeight) {
                    gc.setAntialias(1);
                    Image.drawScaled(gc, original, width, height, scaleFactor);
                }

                @Override
                public int getGcStyle() {
                    return 0x40000000;
                }
            };
            Image resultImage = new Image(device, drawer, scaledWidth, scaledHeight);
            ImageData result = resultImage.getImageData(100);
            original.dispose();
            resultImage.dispose();
            return result;
        }
        return imageData.scaledTo(scaledWidth, scaledHeight);
    }

    public static boolean isSmoothScalingEnabled() {
        return autoScaleMethod == AutoScaleMethod.SMOOTH;
    }

    public static Rectangle scaleBounds(Rectangle rect, int targetZoom, int currentZoom) {
        if (rect == null || targetZoom == currentZoom) {
            return rect;
        }
        Rectangle.OfFloat fRect = FloatAwareGeometryFactory.createFrom(rect);
        float scaleFactor = DPIUtil.getScalingFactor(targetZoom, currentZoom);
        float scaledX = fRect.getX() * scaleFactor;
        float scaledY = fRect.getY() * scaleFactor;
        float scaledWidth = fRect.getWidth() * scaleFactor;
        float scaledHeight = fRect.getHeight() * scaleFactor;
        return new Rectangle.OfFloat(scaledX, scaledY, scaledWidth, scaledHeight);
    }

    public static ImageData autoScaleImageData(Device device, ImageData imageData, int imageDataZoomFactor) {
        if (deviceZoom == imageDataZoomFactor || imageData == null || device != null && !device.isAutoScalable()) {
            return imageData;
        }
        float scaleFactor = (float)deviceZoom / (float)imageDataZoomFactor;
        return DPIUtil.autoScaleImageData(device, imageData, scaleFactor);
    }

    public static ImageData autoScaleUp(Device device, ImageData imageData) {
        return DPIUtil.autoScaleImageData(device, imageData, 100);
    }

    public static int[] autoScaleUp(int[] pointArray) {
        return DPIUtil.scaleUp(pointArray, deviceZoom);
    }

    public static int[] scaleUp(int[] pointArray, int zoom) {
        if (zoom == 100 || pointArray == null) {
            return pointArray;
        }
        float scaleFactor = DPIUtil.getScalingFactor(zoom);
        int[] returnArray = new int[pointArray.length];
        int i = 0;
        while (i < pointArray.length) {
            returnArray[i] = Math.round((float)pointArray[i] * scaleFactor);
            ++i;
        }
        return returnArray;
    }

    public static int[] autoScaleUp(Drawable drawable, int[] pointArray) {
        return DPIUtil.scaleUp(drawable, pointArray, deviceZoom);
    }

    public static int[] scaleUp(Drawable drawable, int[] pointArray, int zoom) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return pointArray;
        }
        return DPIUtil.scaleUp(pointArray, zoom);
    }

    public static int autoScaleUp(int size) {
        return DPIUtil.scaleUp(size, deviceZoom);
    }

    public static int scaleUp(int size, int zoom) {
        if (zoom == 100 || size == -1) {
            return size;
        }
        float scaleFactor = DPIUtil.getScalingFactor(zoom);
        return Math.round((float)size * scaleFactor);
    }

    public static int autoScaleUp(Drawable drawable, int size) {
        return DPIUtil.scaleUp(drawable, size, deviceZoom);
    }

    public static int scaleUp(Drawable drawable, int size, int zoom) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return size;
        }
        return DPIUtil.scaleUp(size, zoom);
    }

    public static float autoScaleUp(float size) {
        return DPIUtil.scaleUp(size, deviceZoom);
    }

    public static float scaleUp(float size, int zoom) {
        if (zoom == 100 || size == -1.0f) {
            return size;
        }
        float scaleFactor = DPIUtil.getScalingFactor(zoom);
        return size * scaleFactor;
    }

    public static float autoScaleUp(Drawable drawable, float size) {
        return DPIUtil.scaleUp(drawable, size, deviceZoom);
    }

    public static float scaleUp(Drawable drawable, float size, int zoom) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return size;
        }
        return DPIUtil.scaleUp(size, zoom);
    }

    public static Point autoScaleUp(Point point) {
        return DPIUtil.scaleUp(point, deviceZoom);
    }

    public static Point scaleUp(Point point, int zoom) {
        if (zoom == 100 || point == null) {
            return point;
        }
        Point.OfFloat fPoint = FloatAwareGeometryFactory.createFrom(point);
        float scaleFactor = DPIUtil.getScalingFactor(zoom);
        float scaledX = fPoint.getX() * scaleFactor;
        float scaledY = fPoint.getY() * scaleFactor;
        return new Point.OfFloat(scaledX, scaledY);
    }

    public static Point autoScaleUp(Drawable drawable, Point point) {
        return DPIUtil.scaleUp(drawable, point, deviceZoom);
    }

    public static Point scaleUp(Drawable drawable, Point point, int zoom) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return point;
        }
        return DPIUtil.scaleUp(point, zoom);
    }

    public static Rectangle autoScaleUp(Rectangle rect) {
        return DPIUtil.scaleUp(rect, deviceZoom);
    }

    public static Rectangle scaleUp(Rectangle rect, int zoom) {
        return DPIUtil.scaleBounds(rect, zoom, 100);
    }

    public static Rectangle autoScaleUp(Drawable drawable, Rectangle rect) {
        return DPIUtil.scaleUp(drawable, rect, deviceZoom);
    }

    public static Rectangle scaleUp(Drawable drawable, Rectangle rect, int zoom) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return rect;
        }
        return DPIUtil.scaleUp(rect, zoom);
    }

    private static float getScalingFactor(int zoom) {
        return DPIUtil.getScalingFactor(zoom, 100);
    }

    private static float getScalingFactor(int targetZoom, int currentZoom) {
        if (USE_CAIRO_AUTOSCALE) {
            return 1.0f;
        }
        if (targetZoom <= 0) {
            targetZoom = deviceZoom;
        }
        return (float)targetZoom / (float)currentZoom;
    }

    public static int mapDPIToZoom(int dpi) {
        double zoom = (double)dpi * 100.0 / 96.0;
        int roundedZoom = (int)Math.round(zoom);
        return roundedZoom;
    }

    public static int mapZoomToDPI(int zoom) {
        double dpi = (double)zoom / 100.0 * 96.0;
        int roundedDpi = (int)Math.round(dpi);
        return roundedDpi;
    }

    public static ElementAtZoom<ImageData> validateAndGetImageDataAtZoom(ImageDataProvider provider, int zoom) {
        ElementAtZoom<ImageData> imageDataAtZoom;
        if (provider == null) {
            SWT.error(4);
        }
        if ((imageDataAtZoom = DPIUtil.getElementAtZoom(z -> provider.getImageData((int)z), zoom)) == null) {
            SWT.error(5, null, ": ImageDataProvider [" + String.valueOf(provider) + "] returns null ImageData at 100% zoom.");
        }
        return imageDataAtZoom;
    }

    public static ElementAtZoom<String> validateAndGetImagePathAtZoom(ImageFileNameProvider provider, int zoom) {
        ElementAtZoom<String> imagePathAtZoom;
        if (provider == null) {
            SWT.error(4);
        }
        if ((imagePathAtZoom = DPIUtil.getElementAtZoom(z -> provider.getImagePath((int)z), zoom)) == null) {
            SWT.error(5, null, ": ImageFileNameProvider [" + String.valueOf(provider) + "] returns null filename at 100% zoom.");
        }
        return imagePathAtZoom;
    }

    private static <T> ElementAtZoom<T> getElementAtZoom(Function<Integer, T> elementForZoomProvider, int zoom) {
        T dataAt100Percent;
        T dataAt200Percent;
        T dataAt150Percent;
        T dataAtOriginalZoom = elementForZoomProvider.apply(zoom);
        if (dataAtOriginalZoom != null) {
            return new ElementAtZoom<T>(dataAtOriginalZoom, zoom);
        }
        if (zoom > 100 && zoom <= 150 && (dataAt150Percent = elementForZoomProvider.apply(150)) != null) {
            return new ElementAtZoom<T>(dataAt150Percent, 150);
        }
        if (zoom > 100 && (dataAt200Percent = elementForZoomProvider.apply(200)) != null) {
            return new ElementAtZoom<T>(dataAt200Percent, 200);
        }
        if (zoom != 100 && (dataAt100Percent = elementForZoomProvider.apply(100)) != null) {
            return new ElementAtZoom<T>(dataAt100Percent, 100);
        }
        return null;
    }

    public static int getNativeDeviceZoom() {
        return nativeDeviceZoom;
    }

    public static int getDeviceZoom() {
        return deviceZoom;
    }

    public static void setDeviceZoom(int nativeDeviceZoom) {
        boolean preserveScalingMethod;
        int deviceZoom;
        DPIUtil.nativeDeviceZoom = nativeDeviceZoom;
        DPIUtil.deviceZoom = deviceZoom = DPIUtil.getZoomForAutoscaleProperty(nativeDeviceZoom);
        System.setProperty("org.eclipse.swt.internal.deviceZoom", Integer.toString(deviceZoom));
        boolean bl = preserveScalingMethod = SWT.getPlatform().equals("gtk") && deviceZoom == 100;
        if (!preserveScalingMethod && AUTO_SCALE_METHOD_SETTING == AutoScaleMethod.AUTO) {
            autoScaleMethod = DPIUtil.sholdUseSmoothScaling() ? AutoScaleMethod.SMOOTH : AutoScaleMethod.NEAREST;
        }
    }

    private static boolean sholdUseSmoothScaling() {
        return switch (SWT.getPlatform()) {
            case "gtk" -> {
                if (deviceZoom / 100 * 100 != deviceZoom) {
                    yield true;
                }
                yield false;
            }
            case "win32" -> DPIUtil.isMonitorSpecificScalingActive();
            default -> false;
        };
    }

    public static int getZoomForAutoscaleProperty(int nativeDeviceZoom) {
        return DPIUtil.getZoomForAutoscaleProperty(nativeDeviceZoom, autoScaleValue);
    }

    private static int getZoomForAutoscaleProperty(int nativeDeviceZoom, String autoScaleValue) {
        int zoom = 0;
        if (autoScaleValue != null) {
            if ("false".equalsIgnoreCase(autoScaleValue)) {
                zoom = 100;
            } else if ("half".equalsIgnoreCase(autoScaleValue)) {
                zoom = (int)Math.rint((double)nativeDeviceZoom / 50.0) * 50;
            } else if ("quarter".equalsIgnoreCase(autoScaleValue)) {
                zoom = Math.round((float)nativeDeviceZoom / 25.0f) * 25;
            } else if ("exact".equalsIgnoreCase(autoScaleValue)) {
                zoom = nativeDeviceZoom;
            } else {
                try {
                    int zoomValue = Integer.parseInt(autoScaleValue);
                    zoom = Math.max(Math.min(zoomValue, 1600), 25);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (zoom == 0) {
            zoom = Math.max((nativeDeviceZoom + 25) / 100 * 100, 100);
        }
        return zoom;
    }

    public static void runWithAutoScaleValue(String autoScaleValue, Runnable runnable) {
        String initialAutoScaleValue = DPIUtil.autoScaleValue;
        DPIUtil.autoScaleValue = autoScaleValue;
        deviceZoom = DPIUtil.getZoomForAutoscaleProperty(nativeDeviceZoom);
        try {
            runnable.run();
        }
        finally {
            DPIUtil.autoScaleValue = initialAutoScaleValue;
            deviceZoom = DPIUtil.getZoomForAutoscaleProperty(nativeDeviceZoom);
        }
    }

    public static void setMonitorSpecificScaling(boolean activate) {
        System.setProperty(SWT_AUTOSCALE_UPDATE_ON_RUNTIME, Boolean.toString(activate));
    }

    public static boolean isMonitorSpecificScalingActive() {
        boolean updateOnRuntimeValue = Boolean.getBoolean(SWT_AUTOSCALE_UPDATE_ON_RUNTIME);
        return updateOnRuntimeValue;
    }

    public static void setAutoScaleForMonitorSpecificScaling() {
        boolean isDefaultAutoScale;
        boolean bl = isDefaultAutoScale = autoScaleValue == null;
        if (isDefaultAutoScale) {
            autoScaleValue = "quarter";
        } else if (!DPIUtil.isSupportedAutoScaleForMonitorSpecificScaling()) {
            throw new SWTError(20, "monitor-specific scaling is only implemented for auto-scale values \"quarter\", \"exact\", \"false\" or a concrete zoom value, but \"" + autoScaleValue + "\" has been specified");
        }
    }

    private static boolean isSupportedAutoScaleForMonitorSpecificScaling() {
        if (autoScaleValue == null) {
            return false;
        }
        switch (autoScaleValue.toLowerCase()) {
            case "exact": 
            case "false": 
            case "quarter": {
                return true;
            }
        }
        try {
            Integer.parseInt(autoScaleValue);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static final class AutoScaleImageDataProvider
    implements ImageDataProvider {
        Device device;
        ImageData imageData;
        int currentZoom;

        public AutoScaleImageDataProvider(Device device, ImageData data, int zoom) {
            this.device = device;
            this.imageData = data;
            this.currentZoom = zoom;
        }

        @Override
        public ImageData getImageData(int zoom) {
            return DPIUtil.scaleImageData(this.device, this.imageData, zoom, this.currentZoom);
        }
    }

    private static enum AutoScaleMethod {
        AUTO,
        NEAREST,
        SMOOTH;


        public static Optional<AutoScaleMethod> forString(String s) {
            AutoScaleMethod[] autoScaleMethodArray = AutoScaleMethod.values();
            int n = autoScaleMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                AutoScaleMethod v = autoScaleMethodArray[n2];
                if (v.name().equalsIgnoreCase(s)) {
                    return Optional.of(v);
                }
                ++n2;
            }
            return Optional.empty();
        }
    }

    public record ElementAtZoom<T>(T element, int zoom) {
        public ElementAtZoom {
            if (element == null) {
                SWT.error(4);
            }
            if (zoom <= 0) {
                SWT.error(5);
            }
        }
    }

    private class FloatAwareGeometryFactory {
        private FloatAwareGeometryFactory() {
        }

        static Rectangle.OfFloat createFrom(Rectangle rectangle) {
            if (rectangle instanceof Rectangle.OfFloat) {
                return (Rectangle.OfFloat)rectangle;
            }
            return new Rectangle.OfFloat(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        static Point.OfFloat createFrom(Point point) {
            if (point instanceof Point.OfFloat) {
                return (Point.OfFloat)point;
            }
            return new Point.OfFloat(point.x, point.y);
        }
    }
}

