/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;

public class StructuredViewerTreeIterator
extends AbstractTreeIterator<Object> {
    private static final long serialVersionUID = 1L;
    private final transient StructuredViewer viewer;
    private final transient IStructuredContentProvider structuredContentProvider;
    private final transient ITreeContentProvider treeContentProvider;
    private final transient ViewerFilter[] filters;
    private final transient ViewerComparator comparator;

    public static final StructuredViewerTreeIterator create(StructuredViewer viewer) {
        IContentProvider contentProvider = viewer.getContentProvider();
        if (contentProvider instanceof Provider) {
            return ((Provider)contentProvider).create();
        }
        return new StructuredViewerTreeIterator(viewer);
    }

    protected StructuredViewerTreeIterator(StructuredViewer viewer) {
        super((Object)viewer, false);
        this.viewer = viewer;
        IContentProvider contentProvider = viewer.getContentProvider();
        this.structuredContentProvider = contentProvider instanceof IStructuredContentProvider ? (IStructuredContentProvider)contentProvider : null;
        this.treeContentProvider = contentProvider instanceof ITreeContentProvider ? (ITreeContentProvider)contentProvider : null;
        this.filters = viewer.getFilters();
        this.comparator = viewer.getComparator();
    }

    protected Iterator<Object> getChildren(Object object) {
        if (object == this.viewer) {
            if (this.structuredContentProvider != null) {
                Object parent = this.viewer.getInput();
                Object[] elements = this.structuredContentProvider.getElements(parent);
                return this.getFilteredSortedChildren(parent, elements);
            }
        } else if (this.treeContentProvider != null) {
            Object[] children = this.treeContentProvider.getChildren(object);
            return this.getFilteredSortedChildren(object, children);
        }
        return Collections.emptyList().iterator();
    }

    protected Iterator<Object> getFilteredSortedChildren(Object parent, Object[] children) {
        Object[] result = children;
        if (result.length > 0 && (this.filters.length > 0 || this.comparator != null)) {
            Object[] filteredSortedResult = children;
            if (this.filters.length > 0) {
                ViewerFilter[] viewerFilterArray = this.filters;
                int n = this.filters.length;
                int n2 = 0;
                while (n2 < n) {
                    ViewerFilter viewerFilter = viewerFilterArray[n2];
                    filteredSortedResult = viewerFilter.filter((Viewer)this.viewer, parent, filteredSortedResult);
                    ++n2;
                }
            }
            if (this.comparator == null) {
                result = filteredSortedResult;
            } else {
                if (filteredSortedResult == result) {
                    filteredSortedResult = (Object[])filteredSortedResult.clone();
                }
                this.comparator.sort((Viewer)this.viewer, filteredSortedResult);
                result = filteredSortedResult;
            }
        }
        return Arrays.asList(result).iterator();
    }

    public static interface Provider {
        public StructuredViewerTreeIterator create();
    }
}

