/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.impl;

import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.StringSubstitutionTask;
import org.eclipse.oomph.setup.impl.Messages;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.osgi.util.NLS;

public class StringSubstitutionTaskImpl
extends SetupTaskImpl
implements StringSubstitutionTask {
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final String VALUE_EDEFAULT = null;
    protected String value = VALUE_EDEFAULT;
    private IValueVariable valueVariable;

    protected StringSubstitutionTaskImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return SetupPackage.Literals.STRING_SUBSTITUTION_TASK;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String newValue) {
        String oldValue = this.value;
        this.value = newValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldValue, (Object)this.value));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getName();
            }
            case 11: {
                return this.getValue();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setName((String)newValue);
                return;
            }
            case 11: {
                this.setValue((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 11: {
                this.setValue(VALUE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 11: {
                return VALUE_EDEFAULT == null ? this.value != null : !VALUE_EDEFAULT.equals(this.value);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", value: ");
        result.append(this.value);
        result.append(')');
        return result.toString();
    }

    @Override
    public Object getOverrideToken() {
        return this.createToken(this.getName());
    }

    @Override
    public int getProgressMonitorWork() {
        return 0;
    }

    @Override
    public boolean isNeeded(SetupTaskContext context) throws Exception {
        IValueVariable variable = this.getValueVariable(false);
        if (variable == null) {
            return true;
        }
        String value = this.getValue();
        return !StringUtil.isEmpty((String)value) && !value.equals(variable.getValue()) || !StringUtil.safe((String)this.getDescription()).equals(StringUtil.safe((String)variable.getDescription()));
    }

    @Override
    public void perform(SetupTaskContext context) throws Exception {
        String name = this.getName();
        String value = this.getValue();
        context.log(NLS.bind((String)Messages.StringSubstitutionTaskImpl_SettingVariable_message, (Object)name, (Object)value));
        IValueVariable variable = this.getValueVariable(true);
        variable.setDescription(this.getDescription());
        if (!StringUtil.isEmpty((String)value)) {
            variable.setValue(value);
        }
    }

    private IValueVariable getValueVariable(boolean force) throws Exception {
        if (this.valueVariable == null) {
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            this.valueVariable = manager.getValueVariable(this.getName());
            if (force && this.valueVariable == null) {
                this.valueVariable = manager.newValueVariable(this.getName(), null);
                manager.addVariables(new IValueVariable[]{this.valueVariable});
            }
        }
        return this.valueVariable;
    }
}

