/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.SecureXMLUtil;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.updatesite.Activator;
import org.eclipse.equinox.internal.p2.updatesite.Messages;
import org.eclipse.equinox.internal.p2.updatesite.SiteBundle;
import org.eclipse.equinox.internal.p2.updatesite.SiteCategory;
import org.eclipse.equinox.internal.p2.updatesite.SiteFeature;
import org.eclipse.equinox.internal.p2.updatesite.SiteIU;
import org.eclipse.equinox.internal.p2.updatesite.SiteModel;
import org.eclipse.equinox.p2.publisher.eclipse.URLEntry;
import org.eclipse.equinox.p2.repository.spi.RepositoryReference;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class CategoryParser
extends DefaultHandler {
    private static final String PLUGIN_ID = Activator.ID;
    private static final String ARCHIVE = "archive";
    private static final String CATEGORY = "category";
    private static final String CATEGORY_DEF = "category-def";
    private static final String DESCRIPTION = "description";
    private static final String FEATURE = "feature";
    private static final String BUNDLE = "bundle";
    private static final String SITE = "site";
    private static final String IU = "iu";
    private static final String QUERY = "query";
    private static final String EXPRESSION = "expression";
    private static final String PARAM = "param";
    private static final String REPOSITORY_REF = "repository-reference";
    private static final String STATS_URI = "stats";
    private static final int STATE_ARCHIVE = 3;
    private static final int STATE_CATEGORY = 4;
    private static final int STATE_CATEGORY_DEF = 5;
    private static final int STATE_DESCRIPTION_CATEGORY_DEF = 7;
    private static final int STATE_DESCRIPTION_SITE = 6;
    private static final int STATE_FEATURE = 2;
    private static final int STATE_BUNDLE = 12;
    private static final int STATE_IGNORED_ELEMENT = -1;
    private static final int STATE_INITIAL = 0;
    private static final int STATE_IU = 8;
    private static final int STATE_EXPRESSION = 9;
    private static final int STATE_PARAM = 10;
    private static final int STATE_QUERY = 11;
    private static final int STATE_SITE = 1;
    private static final int STATE_REPOSITORY_REF = 13;
    private static final int STATE_STATS = 14;
    private boolean DESCRIPTION_SITE_ALREADY_SEEN = false;
    Stack<Object> objectStack = new Stack();
    private SAXParser parser;
    Stack<Integer> stateStack = new Stack();
    private final List<String> messageKeys = new ArrayList<String>(4);
    private MultiStatus status = null;

    private static void debug(String s) {
        Tracing.debug((String)("CategoryParser: " + s));
    }

    static void log(Exception e) {
        LogHelper.log((IStatus)new Status(4, Activator.ID, "Internal Error", (Throwable)e));
    }

    static void log(String message) {
        LogHelper.log((IStatus)new Status(2, Activator.ID, message, null));
    }

    static void log(String message, Exception e) {
        LogHelper.log((IStatus)new Status(2, Activator.ID, message, (Throwable)e));
    }

    public CategoryParser(URI siteLocation) {
        this.stateStack = new Stack();
        this.objectStack = new Stack();
        try {
            SAXParserFactory parserfactory = SecureXMLUtil.newSecureSAXParserFactory();
            parserfactory.setNamespaceAware(true);
            this.parser = parserfactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            CategoryParser.log(e);
        }
        catch (SAXException e) {
            CategoryParser.log(e);
        }
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            CategoryParser.debug("Created");
        }
    }

    public int currentState() {
        Integer state = this.stateStack.peek();
        if (state != null) {
            return state;
        }
        return -1;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        Object text = new String(ch, start, length);
        int state = this.currentState();
        switch (state) {
            case 6: 
            case 7: {
                this.objectStack.push(text);
                break;
            }
            case 9: 
            case 10: {
                text = ((String)text).trim();
                String existing = null;
                if (this.objectStack.peek() instanceof String) {
                    existing = (String)this.objectStack.pop();
                }
                if (existing != null) {
                    text = existing + (String)text;
                }
                this.objectStack.push(text);
                break;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        Object text = null;
        URLEntry info = null;
        int state = this.currentState();
        switch (state) {
            case -1: 
            case 3: 
            case 4: 
            case 11: {
                this.stateStack.pop();
                break;
            }
            case 0: {
                this.internalError(Messages.DefaultSiteParser_ParsingStackBackToInitialState);
                break;
            }
            case 1: {
                this.stateStack.pop();
                if (!(this.objectStack.peek() instanceof String)) break;
                text = (String)this.objectStack.pop();
                SiteModel site = (SiteModel)this.objectStack.peek();
                site.getDescription().setAnnotation((String)text);
                break;
            }
            case 2: {
                this.stateStack.pop();
                this.objectStack.pop();
                break;
            }
            case 12: {
                this.stateStack.pop();
                this.objectStack.pop();
                break;
            }
            case 8: {
                this.stateStack.pop();
                SiteIU completeIU = (SiteIU)this.objectStack.pop();
                String id = completeIU.getID();
                String expression = completeIU.getQueryExpression();
                if (id != null || expression != null) break;
                this.internalError("The IU must specify an id or an expression to match against.");
                break;
            }
            case 9: {
                this.stateStack.pop();
                if (!(this.objectStack.peek() instanceof String)) break;
                text = (String)this.objectStack.pop();
                SiteIU iu = (SiteIU)this.objectStack.peek();
                iu.setQueryExpression((String)text);
                if (!Tracing.DEBUG_GENERATOR_PARSING) break;
                CategoryParser.debug("Found Expression: " + (String)text);
                break;
            }
            case 10: {
                this.stateStack.pop();
                if (!(this.objectStack.peek() instanceof String)) break;
                text = (String)this.objectStack.pop();
                SiteIU iu = (SiteIU)this.objectStack.peek();
                iu.addQueryParams((String)text);
                if (!Tracing.DEBUG_GENERATOR_PARSING) break;
                CategoryParser.debug("Found Param: " + (String)text);
                break;
            }
            case 5: {
                this.stateStack.pop();
                if (this.objectStack.peek() instanceof String) {
                    text = (String)this.objectStack.pop();
                    SiteCategory category = (SiteCategory)this.objectStack.peek();
                    category.setDescription((String)text);
                }
                this.objectStack.pop();
                break;
            }
            case 13: {
                this.stateStack.pop();
                break;
            }
            case 14: {
                this.stateStack.pop();
                break;
            }
            case 6: {
                this.stateStack.pop();
                text = "";
                while (this.objectStack.peek() instanceof String) {
                    String newText = (String)this.objectStack.pop();
                    if (this.trailingSpace(newText) && !this.leadingSpace((String)text)) {
                        text = " " + (String)text;
                    }
                    text = newText.trim() + (String)text;
                    if (!this.leadingSpace(newText) || this.leadingSpace((String)text)) continue;
                    text = " " + (String)text;
                }
                text = ((String)text).trim();
                info = (URLEntry)this.objectStack.pop();
                if (text != null) {
                    info.setAnnotation((String)text);
                }
                SiteModel siteModel = (SiteModel)this.objectStack.peek();
                if (this.DESCRIPTION_SITE_ALREADY_SEEN) {
                    CategoryParser.debug(NLS.bind((String)Messages.DefaultSiteParser_ElementAlreadySet, (Object[])new String[]{this.getState(state)}));
                }
                siteModel.setDescription(info);
                this.DESCRIPTION_SITE_ALREADY_SEEN = true;
                break;
            }
            case 7: {
                SiteCategory category;
                this.stateStack.pop();
                text = "";
                while (this.objectStack.peek() instanceof String) {
                    String newText = (String)this.objectStack.pop();
                    if (this.trailingSpace(newText) && !this.leadingSpace((String)text)) {
                        text = " " + (String)text;
                    }
                    text = newText.trim() + (String)text;
                    if (!this.leadingSpace(newText) || this.leadingSpace((String)text)) continue;
                    text = " " + (String)text;
                }
                text = ((String)text).trim();
                info = (URLEntry)this.objectStack.pop();
                if (text != null) {
                    info.setAnnotation((String)text);
                }
                if ((category = (SiteCategory)this.objectStack.peek()).getDescription() != null) {
                    this.internalError(NLS.bind((String)Messages.DefaultSiteParser_ElementAlreadySet, (Object[])new String[]{this.getState(state), category.getLabel()}));
                    break;
                }
                this.checkTranslated(info.getAnnotation());
                category.setDescription(info.getAnnotation());
                break;
            }
            default: {
                this.internalError(NLS.bind((String)Messages.DefaultSiteParser_UnknownEndState, (Object[])new String[]{this.getState(state)}));
            }
        }
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            CategoryParser.debug("End Element:" + uri + ":" + localName + ":" + qName);
        }
    }

    private void error(IStatus error) {
        if (this.status == null) {
            this.status = new MultiStatus(PLUGIN_ID, 0, Messages.DefaultSiteParser_ErrorParsingSite, null);
        }
        this.status.add(error);
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            LogHelper.log((IStatus)error);
        }
    }

    @Override
    public void error(SAXParseException ex) {
        this.logStatus(ex);
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        this.logStatus(ex);
        throw ex;
    }

    private String getState(int state) {
        switch (state) {
            case -1: {
                return "Ignored";
            }
            case 0: {
                return "Initial";
            }
            case 1: {
                return "Site";
            }
            case 2: {
                return "Feature";
            }
            case 12: {
                return "Bundle";
            }
            case 8: {
                return "IU";
            }
            case 3: {
                return "Archive";
            }
            case 4: {
                return "Category";
            }
            case 5: {
                return "Category Def";
            }
            case 7: {
                return "Description / Category Def";
            }
            case 6: {
                return "Description / Site";
            }
            case 13: {
                return "Repository Reference";
            }
            case 14: {
                return "Stats Repository";
            }
        }
        return Messages.DefaultSiteParser_UnknownState;
    }

    public MultiStatus getStatus() {
        return this.status;
    }

    private void handleCategoryDefState(String elementName, Attributes attributes) {
        switch (elementName) {
            case "description": {
                this.stateStack.push(7);
                this.processInfo(attributes);
                break;
            }
            case "category": {
                this.stateStack.push(4);
                this.processCategory(attributes);
                break;
            }
            default: {
                this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{elementName, this.getState(this.currentState())}));
            }
        }
    }

    private void handleCategoryState(String elementName, Attributes attributes) {
        this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{elementName, this.getState(this.currentState())}));
    }

    private void handleFeatureState(String elementName, Attributes attributes) {
        if (elementName.equals(CATEGORY)) {
            this.stateStack.push(4);
            this.processCategory(attributes);
        } else {
            this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{elementName, this.getState(this.currentState())}));
        }
    }

    private void handleBundleState(String elementName, Attributes attributes) {
        if (elementName.equals(CATEGORY)) {
            this.stateStack.push(4);
            this.processCategory(attributes);
        } else {
            this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{elementName, this.getState(this.currentState())}));
        }
    }

    private void handleInitialState(String elementName, Attributes attributes) throws SAXException {
        if (!elementName.equals(SITE)) {
            this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{elementName, this.getState(this.currentState())}));
            throw new SAXException(Messages.DefaultSiteParser_InvalidXMLStream);
        }
        this.stateStack.push(1);
        this.processSite(attributes);
    }

    private void handleSiteState(String elementName, Attributes attributes) {
        switch (elementName) {
            case "description": {
                this.stateStack.push(6);
                this.processInfo(attributes);
                break;
            }
            case "feature": {
                this.stateStack.push(2);
                this.processFeature(attributes);
                break;
            }
            case "bundle": {
                this.stateStack.push(12);
                this.processBundle(attributes);
                break;
            }
            case "iu": {
                this.stateStack.push(8);
                this.processIU(attributes);
                break;
            }
            case "archive": {
                this.stateStack.push(3);
                this.processArchive(attributes);
                break;
            }
            case "category-def": {
                this.stateStack.push(5);
                this.processCategoryDef(attributes);
                break;
            }
            case "repository-reference": {
                this.stateStack.push(13);
                this.processRepositoryReference(attributes);
                break;
            }
            case "stats": {
                this.stateStack.push(14);
                this.processStatsInfo(attributes);
                break;
            }
            default: {
                this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{elementName, this.getState(this.currentState())}));
            }
        }
    }

    private void handleStatsState(String elementName, Attributes attributes) {
        switch (elementName) {
            case "feature": {
                this.stateStack.push(2);
                this.processStatsFeature(attributes);
                break;
            }
            case "bundle": {
                this.stateStack.push(12);
                this.processStatsBundle(attributes);
                break;
            }
            default: {
                this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{elementName, this.getState(this.currentState())}));
            }
        }
    }

    private void handleIUState(String elementName, Attributes attributes) {
        switch (elementName) {
            case "query": {
                this.stateStack.push(11);
                this.processQuery(attributes);
                break;
            }
            case "category": {
                this.stateStack.push(4);
                this.processCategory(attributes);
                break;
            }
            default: {
                this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{elementName, this.getState(this.currentState())}));
            }
        }
    }

    private void handleQueryState(String elementName, Attributes attributes) {
        switch (elementName) {
            case "expression": {
                this.stateStack.push(9);
                this.processExpression(attributes);
                break;
            }
            case "param": {
                this.stateStack.push(10);
                this.processParam(attributes);
                break;
            }
            default: {
                this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{elementName, this.getState(this.currentState())}));
            }
        }
    }

    private void handleExpression(String elementName, Attributes attributes) {
        this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{elementName, this.getState(this.currentState())}));
    }

    private void handleParamState(String elementName, Attributes attributes) {
        this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{elementName, this.getState(this.currentState())}));
    }

    private void internalError(String message) {
        this.error((IStatus)new Status(4, PLUGIN_ID, 0, message, null));
    }

    private void internalErrorUnknownTag(String msg) {
        this.stateStack.push(-1);
        this.internalError(msg);
    }

    private boolean leadingSpace(String str) {
        if (str.length() <= 0) {
            return false;
        }
        return Character.isWhitespace(str.charAt(0));
    }

    private void logStatus(SAXParseException ex) {
        String msg;
        String name = ex.getSystemId();
        name = name == null ? "" : name.substring(1 + name.lastIndexOf("/"));
        if (name.equals("")) {
            msg = NLS.bind((String)Messages.DefaultSiteParser_ErrorParsing, (Object[])new String[]{ex.getMessage()});
        } else {
            Object[] values = new String[]{name, Integer.toString(ex.getLineNumber()), Integer.toString(ex.getColumnNumber()), ex.getMessage()};
            msg = NLS.bind((String)Messages.DefaultSiteParser_ErrorlineColumnMessage, (Object[])values);
        }
        this.error((IStatus)new Status(4, PLUGIN_ID, msg, (Throwable)ex));
    }

    public SiteModel parse(InputStream in) throws SAXException, IOException {
        this.stateStack.push(0);
        this.parser.parse(new InputSource(in), (DefaultHandler)this);
        if (this.objectStack.isEmpty()) {
            throw new SAXException(Messages.DefaultSiteParser_NoSiteTag);
        }
        if (this.objectStack.peek() instanceof SiteModel) {
            SiteModel site = (SiteModel)this.objectStack.pop();
            site.setMessageKeys(this.messageKeys);
            return site;
        }
        Object stack = "";
        Iterator iter = this.objectStack.iterator();
        while (iter.hasNext()) {
            stack = (String)stack + iter.next().toString() + "\r\n";
        }
        throw new SAXException(NLS.bind((String)Messages.DefaultSiteParser_WrongParsingStack, (Object[])new String[]{stack}));
    }

    private void processArchive(Attributes attributes) {
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            CategoryParser.debug("End processing Archive");
        }
    }

    private void processCategory(Attributes attributes) {
        String category = attributes.getValue("name");
        Object obj = this.objectStack.peek();
        if (obj instanceof SiteFeature) {
            ((SiteFeature)obj).addCategoryName(category);
        } else if (obj instanceof SiteBundle) {
            ((SiteBundle)obj).addCategoryName(category);
        } else if (obj instanceof SiteIU) {
            ((SiteIU)obj).addCategoryName(category);
        } else if (obj instanceof SiteCategory) {
            ((SiteCategory)obj).addCategoryName(category);
        }
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            CategoryParser.debug("End processing Category: name:" + category);
        }
    }

    private void processCategoryDef(Attributes attributes) {
        SiteCategory category = new SiteCategory();
        String name = attributes.getValue("name");
        String label = attributes.getValue("label");
        this.checkTranslated(label);
        category.setName(name);
        category.setLabel(label);
        SiteModel site = (SiteModel)this.objectStack.peek();
        site.addCategory(category);
        this.objectStack.push(category);
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            CategoryParser.debug("End processing CategoryDef: name:" + name + " label:" + label);
        }
    }

    private void processRepositoryReference(Attributes attributes) {
        String location = attributes.getValue("location");
        String nickname = attributes.getValue("name");
        try {
            URI uri = URIUtil.fromString((String)location);
            boolean enabled = Boolean.parseBoolean(attributes.getValue("enabled"));
            RepositoryReference metadata = new RepositoryReference(uri, nickname, 0, enabled ? 1 : 0);
            RepositoryReference artifact = new RepositoryReference(uri, nickname, 1, enabled ? 1 : 0);
            SiteModel site = (SiteModel)this.objectStack.peek();
            site.addRepositoryReference(metadata);
            site.addRepositoryReference(artifact);
        }
        catch (URISyntaxException uRISyntaxException) {}
    }

    private void processStatsInfo(Attributes attributes) {
        String location = attributes.getValue("location");
        try {
            URIUtil.fromString((String)location);
            SiteModel site = (SiteModel)this.objectStack.peek();
            site.setStatsURIString(location);
        }
        catch (URISyntaxException uRISyntaxException) {}
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            CategoryParser.debug("End processing Repository Reference: location:" + location);
        }
    }

    private void processStatsFeature(Attributes attributes) {
        boolean noId;
        SiteFeature feature = new SiteFeature();
        String id = attributes.getValue("id");
        String ver = attributes.getValue("version");
        boolean bl = noId = id == null || id.trim().equals("");
        if (noId) {
            this.internalError(NLS.bind((String)Messages.DefaultSiteParser_Missing, (Object[])new String[]{"url", this.getState(this.currentState())}));
        }
        feature.setFeatureIdentifier(id);
        feature.setFeatureVersion(ver);
        SiteModel site = (SiteModel)this.objectStack.peek();
        site.addStatsFeature(feature);
        this.objectStack.push(feature);
        feature.setSiteModel(site);
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            CategoryParser.debug("End Processing Stats Feature Tag: id:" + id + " version:" + ver);
        }
    }

    private void processStatsBundle(Attributes attributes) {
        boolean noId;
        SiteBundle bundle = new SiteBundle();
        String id = attributes.getValue("id");
        String ver = attributes.getValue("version");
        boolean bl = noId = id == null || id.trim().equals("");
        if (noId) {
            this.internalError(NLS.bind((String)Messages.DefaultSiteParser_Missing, (Object[])new String[]{"url", this.getState(this.currentState())}));
        }
        bundle.setBundleIdentifier(id);
        bundle.setBundleVersion(ver);
        SiteModel site = (SiteModel)this.objectStack.peek();
        site.addStatsBundle(bundle);
        this.objectStack.push(bundle);
        bundle.setSiteModel(site);
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            CategoryParser.debug("End Processing Stats Bundle Tag: id:" + id + " version:" + ver);
        }
    }

    private void processFeature(Attributes attributes) {
        boolean noId;
        SiteFeature feature = new SiteFeature();
        String id = attributes.getValue("id");
        String ver = attributes.getValue("version");
        String os = attributes.getValue("os");
        String ws = attributes.getValue("ws");
        String arch = attributes.getValue("arch");
        boolean bl = noId = id == null || id.trim().equals("");
        if (noId) {
            this.internalError(NLS.bind((String)Messages.DefaultSiteParser_Missing, (Object[])new String[]{"url", this.getState(this.currentState())}));
        }
        feature.setFeatureIdentifier(id);
        feature.setFeatureVersion(ver);
        feature.setOS(os);
        feature.setWS(ws);
        feature.setArch(arch);
        SiteModel site = (SiteModel)this.objectStack.peek();
        site.addFeature(feature);
        feature.setSiteModel(site);
        this.objectStack.push(feature);
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            CategoryParser.debug("End Processing Feature Tag: id:" + id + " version:" + ver);
        }
    }

    private void processBundle(Attributes attributes) {
        boolean noId;
        SiteBundle bundle = new SiteBundle();
        String id = attributes.getValue("id");
        String ver = attributes.getValue("version");
        String os = attributes.getValue("os");
        String ws = attributes.getValue("ws");
        String arch = attributes.getValue("arch");
        boolean bl = noId = id == null || id.trim().equals("");
        if (noId) {
            this.internalError(NLS.bind((String)Messages.DefaultSiteParser_Missing, (Object[])new String[]{"url", this.getState(this.currentState())}));
        }
        bundle.setBundleIdentifier(id);
        bundle.setBundleVersion(ver);
        bundle.setOS(os);
        bundle.setWS(ws);
        bundle.setArch(arch);
        SiteModel site = (SiteModel)this.objectStack.peek();
        site.addBundle(bundle);
        bundle.setSiteModel(site);
        this.objectStack.push(bundle);
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            CategoryParser.debug("End Processing Bundle Tag: id:" + id + " version:" + ver);
        }
    }

    private void processIU(Attributes attributes) {
        SiteIU iu = new SiteIU();
        SiteModel site = (SiteModel)this.objectStack.peek();
        String id = attributes.getValue("id");
        String range = attributes.getValue("range");
        id = id == null ? null : id.trim();
        range = range == null ? null : range.trim();
        iu.setID(id);
        iu.setRange(range);
        site.addIU(iu);
        this.objectStack.push(iu);
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            CategoryParser.debug("End processing iu.");
        }
    }

    private void processExpression(Attributes attributes) {
        SiteIU iu = (SiteIU)this.objectStack.peek();
        iu.setQueryType(attributes.getValue("type"));
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            CategoryParser.debug("End processing Expression: " + iu.getQueryType());
        }
    }

    private void processQuery(Attributes attributes) {
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            CategoryParser.debug("End processing Query.");
        }
    }

    private void processParam(Attributes attributes) {
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            CategoryParser.debug("End processing Param.");
        }
    }

    private void processInfo(Attributes attributes) {
        URLEntry inf = new URLEntry();
        String infoURL = attributes.getValue("url");
        inf.setURL(infoURL);
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            CategoryParser.debug("Processed Info: url:" + infoURL);
        }
        this.objectStack.push(inf);
    }

    private void processSite(Attributes attributes) {
        SiteModel site = new SiteModel();
        this.objectStack.push(site);
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            CategoryParser.debug("End process Site tag.");
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (Tracing.DEBUG_GENERATOR_PARSING) {
            CategoryParser.debug("State: " + this.currentState());
            CategoryParser.debug("Start Element: uri:" + uri + " local Name:" + localName + " qName:" + qName);
        }
        switch (this.currentState()) {
            case -1: {
                this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{localName, this.getState(this.currentState())}));
                break;
            }
            case 0: {
                this.handleInitialState(localName, attributes);
                break;
            }
            case 1: {
                this.handleSiteState(localName, attributes);
                break;
            }
            case 2: {
                this.handleFeatureState(localName, attributes);
                break;
            }
            case 12: {
                this.handleBundleState(localName, attributes);
                break;
            }
            case 8: {
                this.handleIUState(localName, attributes);
                break;
            }
            case 9: {
                this.handleExpression(localName, attributes);
                break;
            }
            case 11: {
                this.handleQueryState(localName, attributes);
                break;
            }
            case 10: {
                this.handleParamState(localName, attributes);
                break;
            }
            case 3: {
                this.handleSiteState(localName, attributes);
                break;
            }
            case 4: {
                this.handleCategoryState(localName, attributes);
                break;
            }
            case 5: {
                this.handleCategoryDefState(localName, attributes);
                break;
            }
            case 6: {
                this.handleSiteState(localName, attributes);
                break;
            }
            case 7: {
                this.handleSiteState(localName, attributes);
                break;
            }
            case 14: {
                this.handleStatsState(localName, attributes);
                break;
            }
            default: {
                this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownStartState, (Object[])new String[]{this.getState(this.currentState())}));
            }
        }
    }

    private boolean trailingSpace(String str) {
        if (str.length() <= 0) {
            return false;
        }
        return Character.isWhitespace(str.charAt(str.length() - 1));
    }

    private void checkTranslated(String value) {
        if (value != null && value.length() > 1 && value.startsWith("%")) {
            this.messageKeys.add(value.substring(1));
        }
    }
}

