/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.progress.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.progress.IProgressService;
import org.eclipse.e4.ui.progress.internal.AbstractProgressViewer;
import org.eclipse.e4.ui.progress.internal.FinishedJobs;
import org.eclipse.e4.ui.progress.internal.JobTreeElement;
import org.eclipse.e4.ui.progress.internal.ProgressInfoItem;
import org.eclipse.e4.ui.progress.internal.ProgressMessages;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class DetailedProgressViewer
extends AbstractProgressViewer {
    private static final int MAX_DISPLAYED = 20;
    Composite control;
    private ScrolledComposite scrolled;
    private Composite noEntryArea;
    private IProgressService progressService;
    private FinishedJobs finishedJobs;
    private final Map<JobTreeElement, ProgressInfoItem> jobItemControls = new HashMap<JobTreeElement, ProgressInfoItem>();

    public DetailedProgressViewer(Composite parent, int style, IProgressService progressService, FinishedJobs finishedJobs) {
        this.progressService = progressService;
        this.finishedJobs = finishedJobs;
        this.scrolled = new ScrolledComposite(parent, 0x200 | style);
        int height = JFaceResources.getDefaultFont().getFontData()[0].getHeight();
        this.scrolled.getVerticalBar().setIncrement(height * 2);
        this.scrolled.setExpandHorizontal(true);
        this.scrolled.setExpandVertical(true);
        this.control = new Composite((Composite)this.scrolled, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.control.setLayout((Layout)layout);
        this.control.setBackground(parent.getDisplay().getSystemColor(25));
        this.control.addFocusListener((FocusListener)new FocusAdapter(){
            private boolean settingFocus = false;

            public void focusGained(FocusEvent e) {
                if (!this.settingFocus) {
                    this.settingFocus = true;
                    DetailedProgressViewer.this.setFocus();
                    this.settingFocus = false;
                }
            }
        });
        this.control.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                DetailedProgressViewer.this.updateVisibleItems();
            }

            public void controlResized(ControlEvent e) {
                DetailedProgressViewer.this.updateVisibleItems();
            }
        });
        this.scrolled.setContent((Control)this.control);
        this.hookControl((Control)this.control);
        this.noEntryArea = new Composite((Composite)this.scrolled, 0);
        this.noEntryArea.setLayout((Layout)new GridLayout());
        this.noEntryArea.setBackground(this.noEntryArea.getDisplay().getSystemColor(25));
        Label noEntryLabel = new Label(this.noEntryArea, 0);
        noEntryLabel.setText(ProgressMessages.ProgressView_NoOperations);
        noEntryLabel.setBackground(this.noEntryArea.getDisplay().getSystemColor(25));
        GridData textData = new GridData(2);
        noEntryLabel.setLayoutData((Object)textData);
    }

    @Override
    public void add(Object[] elements) {
        ViewerComparator sorter = this.getComparator();
        HashSet<JobTreeElement> newItems = new HashSet<JobTreeElement>(this.jobItemControls.keySet());
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element != null) {
                newItems.add((JobTreeElement)element);
            }
            ++n2;
        }
        Object[] infos = newItems.toArray(new JobTreeElement[0]);
        if (sorter != null) {
            sorter.sort((Viewer)this, infos);
        }
        this.reorderControls(infos);
        this.control.layout(true);
        this.updateForShowingProgress();
    }

    private void updateForShowingProgress() {
        Composite newContent;
        Composite composite = newContent = this.control.getChildren().length > 0 ? this.control : this.noEntryArea;
        if (this.scrolled.getContent() != newContent) {
            this.scrolled.setContent((Control)newContent);
        }
    }

    private ProgressInfoItem createNewItem(JobTreeElement info) {
        final ProgressInfoItem item = new ProgressInfoItem(this.control, 0, info, this.progressService, this.finishedJobs);
        item.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                DetailedProgressViewer.this.updateVisibleProgressItems(new Control[]{item});
            }

            public void controlResized(ControlEvent e) {
                DetailedProgressViewer.this.updateVisibleProgressItems(new Control[]{item});
            }
        });
        item.setIndexListener(new ProgressInfoItem.IndexListener(){

            @Override
            public void selectNext() {
                DetailedProgressViewer.this.selectNext(item);
            }

            @Override
            public void selectPrevious() {
                DetailedProgressViewer.this.selectPrevious(item);
            }

            @Override
            public void select() {
                for (ProgressInfoItem child : DetailedProgressViewer.this.jobItemControls.values()) {
                    if (((Object)((Object)item)).equals((Object)child)) continue;
                    child.selectWidgets(false);
                }
                item.selectWidgets(true);
            }
        });
        item.refresh();
        return item;
    }

    protected void selectPrevious(ProgressInfoItem item) {
        Control[] children = this.control.getChildren();
        int i = 0;
        while (i < children.length) {
            ProgressInfoItem child = (ProgressInfoItem)children[i];
            if (((Object)((Object)item)).equals((Object)child)) {
                ProgressInfoItem previous = i == 0 ? (ProgressInfoItem)children[children.length - 1] : (ProgressInfoItem)children[i - 1];
                item.selectWidgets(false);
                previous.selectWidgets(true);
                return;
            }
            ++i;
        }
    }

    protected void selectNext(ProgressInfoItem item) {
        Control[] children = this.control.getChildren();
        int i = 0;
        while (i < children.length) {
            ProgressInfoItem child = (ProgressInfoItem)children[i];
            if (((Object)((Object)item)).equals((Object)child)) {
                ProgressInfoItem next = i == children.length - 1 ? (ProgressInfoItem)children[0] : (ProgressInfoItem)children[i + 1];
                item.selectWidgets(false);
                next.selectWidgets(true);
                return;
            }
            ++i;
        }
    }

    protected Widget doFindInputItem(Object element) {
        return null;
    }

    protected Widget doFindItem(Object element) {
        Control[] existingChildren;
        if (element instanceof JobTreeElement) {
            return (Widget)this.jobItemControls.get(element);
        }
        Control[] controlArray = existingChildren = this.control.getChildren();
        int n = existingChildren.length;
        int n2 = 0;
        while (n2 < n) {
            Control controlElement = controlArray[n2];
            if (!controlElement.isDisposed() && controlElement.getData() != null && controlElement.getData().equals(element)) {
                return controlElement;
            }
            ++n2;
        }
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        if (this.usingElementMap()) {
            this.unmapElement(item);
        }
        item.dispose();
        this.add(new Object[]{element});
    }

    public Control getControl() {
        return this.scrolled;
    }

    protected List<Object> getSelectionFromWidget() {
        return new ArrayList<Object>(0);
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        this.refreshAll();
        this.updateForShowingProgress();
    }

    protected void internalRefresh(Object element) {
        if (element == null) {
            return;
        }
        if (element.equals(this.getRoot())) {
            this.refreshAll();
            return;
        }
        Widget widget = this.findItem(element);
        if (widget == null) {
            this.add(new Object[]{element});
            return;
        }
        ((ProgressInfoItem)widget).refresh();
        Point size = this.control.computeSize(-1, -1);
        size.x = 0;
        size.y += 4;
        this.scrolled.setMinSize(size);
    }

    @Override
    public void remove(Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Widget item;
            Object element = objectArray[n2];
            JobTreeElement treeElement = (JobTreeElement)element;
            if (this.finishedJobs.isKept(treeElement)) {
                item = this.doFindItem(element);
                if (item != null) {
                    ((ProgressInfoItem)item).refresh();
                }
            } else {
                Object parent;
                item = this.doFindItem(treeElement);
                if (item == null && (parent = treeElement.getParent()) != null) {
                    item = this.doFindItem(parent);
                }
                if (item != null) {
                    this.jobItemControls.remove(element);
                    this.unmapElement(element);
                    item.dispose();
                }
            }
            ++n2;
        }
        Control[] existingChildren = this.control.getChildren();
        int i = 0;
        while (i < existingChildren.length) {
            ProgressInfoItem item = (ProgressInfoItem)existingChildren[i];
            item.setColor(i);
            ++i;
        }
        this.control.layout(true);
        this.updateForShowingProgress();
    }

    public void reveal(Object element) {
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
    }

    public void cancelSelection() {
    }

    public void setFocus() {
        Control[] children = this.control.getChildren();
        if (children.length > 0) {
            ((ProgressInfoItem)children[0]).setButtonFocus();
        } else {
            this.noEntryArea.setFocus();
        }
    }

    private void refreshAll() {
        Object[] infos = this.getSortedChildren(this.getRoot());
        this.reorderControls(infos);
        this.control.layout(true);
        this.updateForShowingProgress();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void reorderControls(Object[] toShowJobElements) {
        limit = Math.min(toShowJobElements.length, 20);
        if (limit == 0) {
            for (Control existing : this.jobItemControls.values()) {
                existing.dispose();
            }
            this.jobItemControls.clear();
            return;
        }
        existingControls = this.control.getChildren();
        lastControl = null;
        exIndex = 0;
        i = 0;
        while (i < limit) {
            block16: {
                jobElement = (JobTreeElement)toShowJobElements[i];
                item = this.jobItemControls.get(jobElement);
                if (item != null) ** GOTO lbl27
                item = this.createNewItem(jobElement);
                this.jobItemControls.put(jobElement, item);
                if (exIndex >= existingControls.length) break block16;
                if (lastControl == null) {
                    item.moveAbove(null);
                } else {
                    item.moveBelow((Control)lastControl);
                }
                break block16;
                while (existingControls[exIndex] == null || existingControls[exIndex].isDisposed()) {
                    ++exIndex;
lbl27:
                    // 2 sources

                    if (exIndex < existingControls.length) continue;
                }
                if (exIndex < existingControls.length && existingControls[exIndex] != item) {
                    if (lastControl == null) {
                        item.moveAbove(null);
                    } else {
                        item.moveBelow((Control)lastControl);
                    }
                    j = exIndex + 1;
                    while (j < existingControls.length) {
                        if (existingControls[j] == item) {
                            existingControls[j] = null;
                            break;
                        }
                        ++j;
                    }
                } else {
                    ++exIndex;
                }
            }
            item.setColor(i);
            lastControl = item;
            ++i;
        }
        i = exIndex;
        while (i < existingControls.length) {
            if (existingControls[i] != null) {
                this.jobItemControls.remove(existingControls[i].getData());
                existingControls[i].dispose();
            }
            ++i;
        }
    }

    private void updateVisibleItems() {
        this.updateVisibleProgressItems(this.control.getChildren());
    }

    private void updateVisibleProgressItems(Control ... progressInfoItems) {
        int top = this.scrolled.getOrigin().y;
        int bottom = top + this.scrolled.getParent().getBounds().height;
        Control[] controlArray = progressInfoItems;
        int n = progressInfoItems.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            ProgressInfoItem item = (ProgressInfoItem)element;
            item.setDisplayed(top, bottom);
            ++n2;
        }
    }

    public ProgressInfoItem[] getProgressInfoItems() {
        Control[] children = this.control.getChildren();
        ProgressInfoItem[] progressInfoItems = new ProgressInfoItem[children.length];
        System.arraycopy(children, 0, progressInfoItems, 0, children.length);
        assert (children.length == this.jobItemControls.size());
        return progressInfoItems;
    }
}

