/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.actions.OpenFileAction;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.eclipse.ui.internal.ShowInMenu;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.IViewDescriptor;

public class OpenResourceDialog
extends FilteredResourcesSelectionDialog {
    private static final int OPEN_WITH_ID = 1025;
    private static final int SHOW_IN_ID = 1026;
    private Button showInButton;
    private Button openWithButton;

    public OpenResourceDialog(Shell parentShell, IContainer container, int typesMask) {
        super(parentShell, true, container, typesMask);
        this.setTitle(IDEWorkbenchMessages.OpenResourceDialog_title);
    }

    protected void fillContextMenu(IMenuManager menuManager) {
        super.fillContextMenu(menuManager);
        StructuredSelection selectedItems = this.getSelectedItems();
        if (selectedItems.isEmpty()) {
            return;
        }
        IWorkbenchPage activePage = this.getActivePage();
        if (activePage == null) {
            return;
        }
        menuManager.add((IContributionItem)new Separator());
        OpenFileAction openFileAction = new OpenFileAction(activePage){

            @Override
            public void run() {
                OpenResourceDialog.this.okPressed();
            }
        };
        openFileAction.selectionChanged((IStructuredSelection)selectedItems);
        if (openFileAction.isEnabled()) {
            menuManager.add((IAction)openFileAction);
            IAdaptable selectedAdaptable = this.getSelectedAdaptable();
            if (selectedAdaptable != null) {
                MenuManager subMenu = new MenuManager(IDEWorkbenchMessages.OpenResourceDialog_openWithMenu_label);
                ResourceOpenWithMenu openWithMenu = new ResourceOpenWithMenu(activePage, selectedAdaptable);
                subMenu.add((IContributionItem)openWithMenu);
                menuManager.add((IContributionItem)subMenu);
            }
        }
        MenuManager showInMenuManager = new MenuManager(IDEWorkbenchMessages.OpenResourceDialog_showInMenu_label);
        ResourceShowInMenu showInMenu = new ResourceShowInMenu((IStructuredSelection)selectedItems, activePage.getWorkbenchWindow());
        showInMenuManager.add((IContributionItem)showInMenu);
        menuManager.add((IContributionItem)showInMenuManager);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        int buttonWidth;
        GridLayout parentLayout = (GridLayout)parent.getLayout();
        parentLayout.makeColumnsEqualWidth = false;
        this.showInButton = this.createDropdownButton(parent, 1026, IDEWorkbenchMessages.OpenResourceDialog_showInButton_text, (MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                OpenResourceDialog.this.showShowInMenu();
            }
        });
        this.setButtonLayoutData(this.showInButton);
        this.openWithButton = this.createDropdownButton(parent, 1025, IDEWorkbenchMessages.OpenResourceDialog_openWithButton_text, (MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                OpenResourceDialog.this.showOpenWithMenu();
            }
        });
        this.setButtonLayoutData(this.openWithButton);
        GridData showInLayoutData = (GridData)this.showInButton.getLayoutData();
        GridData openWithLayoutData = (GridData)this.openWithButton.getLayoutData();
        showInLayoutData.widthHint = buttonWidth = Math.max(showInLayoutData.widthHint, openWithLayoutData.widthHint);
        openWithLayoutData.widthHint = buttonWidth;
        new Label(parent, 0).setLayoutData((Object)new GridData(5, 0));
        ++parentLayout.numColumns;
        Button okButton = this.createButton(parent, 0, IDEWorkbenchMessages.OpenResourceDialog_openButton_text, true);
        Button cancelButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        GridData cancelLayoutData = (GridData)cancelButton.getLayoutData();
        GridData okLayoutData = (GridData)okButton.getLayoutData();
        cancelLayoutData.widthHint = buttonWidth = Math.max(cancelLayoutData.widthHint, okLayoutData.widthHint);
        okLayoutData.widthHint = buttonWidth;
    }

    private Button createDropdownButton(Composite parent, int id, String label, MouseListener mouseListener) {
        char textEmbedding = parent.getOrientation() == 0x2000000 ? (char)'\u202a' : '\u202b';
        Button button = this.createButton(parent, id, String.valueOf(textEmbedding) + label + '\u202c', false);
        if (Util.isMac()) {
            button.setText(String.valueOf(button.getText()) + " \u25be");
        } else {
            int dropDownOrientation = parent.getOrientation() == 0x2000000 ? 0x4000000 : 0x2000000;
            button.setOrientation(dropDownOrientation);
            button.setImage(WorkbenchImages.getImage((String)"IMG_LCL_BUTTON_MENU"));
            button.addMouseListener(mouseListener);
        }
        return button;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                this.showOpenWithMenu();
                break;
            }
            case 1026: {
                this.showShowInMenu();
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    protected void updateButtonsEnableState(IStatus status) {
        Button okButton = this.getOkButton();
        if (this.isButtonReady(okButton) && this.isButtonReady(this.showInButton) && this.isButtonReady(this.openWithButton)) {
            if (status.matches(4) || this.getSelectedItems().size() == 0) {
                okButton.setEnabled(false);
                this.openWithButton.setEnabled(false);
                this.showInButton.setEnabled(false);
            } else if (this.getSelectedItems().toList().stream().allMatch(IFile.class::isInstance)) {
                okButton.setEnabled(true);
                this.openWithButton.setEnabled(this.getSelectedItems().size() == 1);
                this.showInButton.setEnabled(true);
            } else {
                okButton.setEnabled(false);
                this.openWithButton.setEnabled(false);
                this.showInButton.setEnabled(true);
            }
        }
    }

    private boolean isButtonReady(Button button) {
        return button != null && !button.isDisposed();
    }

    private IAdaptable getSelectedAdaptable() {
        StructuredSelection s = this.getSelectedItems();
        if (s.size() != 1) {
            return null;
        }
        Object selectedElement = s.getFirstElement();
        if (selectedElement instanceof IAdaptable) {
            return (IAdaptable)selectedElement;
        }
        return null;
    }

    private IWorkbenchPage getActivePage() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        return activeWorkbenchWindow.getActivePage();
    }

    private void showOpenWithMenu() {
        IWorkbenchPage activePage = this.getActivePage();
        if (activePage == null) {
            return;
        }
        IAdaptable selectedAdaptable = this.getSelectedAdaptable();
        if (selectedAdaptable == null) {
            return;
        }
        ResourceOpenWithMenu openWithMenu = new ResourceOpenWithMenu(activePage, selectedAdaptable);
        this.showMenu(this.openWithButton, (IContributionItem)openWithMenu);
    }

    private void showShowInMenu() {
        IWorkbenchPage activePage = this.getActivePage();
        if (activePage == null) {
            return;
        }
        StructuredSelection selectedItems = this.getSelectedItems();
        if (selectedItems.isEmpty()) {
            return;
        }
        ResourceShowInMenu showInMenu = new ResourceShowInMenu((IStructuredSelection)selectedItems, activePage.getWorkbenchWindow());
        this.showMenu(this.showInButton, (IContributionItem)showInMenu);
    }

    private void showMenu(Button button, IContributionItem menuContribution) {
        Menu menu = new Menu((Control)button);
        Point p = button.getLocation();
        p.y += button.getSize().y;
        p = button.getParent().toDisplay(p);
        menu.setLocation(p);
        menuContribution.fill(menu, 0);
        menu.setVisible(true);
    }

    private final class ResourceOpenWithMenu
    extends OpenWithMenu {
        private ResourceOpenWithMenu(IWorkbenchPage page, IAdaptable file) {
            super(page, file);
        }

        @Override
        protected void openEditor(IEditorDescriptor editorDescriptor, boolean openUsingDescriptor) {
            OpenResourceDialog.this.computeResult();
            OpenResourceDialog.this.setResult(Collections.EMPTY_LIST);
            OpenResourceDialog.this.close();
            super.openEditor(editorDescriptor, openUsingDescriptor);
        }
    }

    private final class ResourceShowInMenu
    extends ShowInMenu {
        private final IStructuredSelection selectedItems;

        private ResourceShowInMenu(IStructuredSelection selectedItems, IWorkbenchWindow workbenchWindow) {
            this.selectedItems = selectedItems;
            this.setId(ContributionItemFactory.VIEWS_SHOW_IN.getId());
            this.initialize((IServiceLocator)workbenchWindow);
        }

        protected ShowInContext getContext(IWorkbenchPart sourcePart) {
            return new ShowInContext(null, (ISelection)this.selectedItems);
        }

        protected IWorkbenchPart getSourcePart() {
            return null;
        }

        protected IContributionItem getContributionItem(IViewDescriptor viewDescriptor) {
            final String targetId = viewDescriptor.getId();
            String label = String.valueOf('&') + viewDescriptor.getLabel();
            ImageDescriptor icon = viewDescriptor.getImageDescriptor();
            Action action = new Action(label, icon){

                public void run() {
                    OpenResourceDialog.this.computeResult();
                    OpenResourceDialog.this.setResult(Collections.EMPTY_LIST);
                    OpenResourceDialog.this.close();
                    IWorkbenchPage page = OpenResourceDialog.this.getActivePage();
                    try {
                        IViewPart view = page.showView(targetId);
                        IShowInTarget target = this.getShowInTarget((IWorkbenchPart)view);
                        if (target == null || !target.show(ResourceShowInMenu.this.getContext(null))) {
                            page.getWorkbenchWindow().getShell().getDisplay().beep();
                        }
                    }
                    catch (PartInitException e) {
                        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.ui.ide", 4, "", (Throwable)e));
                    }
                }

                private IShowInTarget getShowInTarget(IWorkbenchPart targetPart) {
                    return (IShowInTarget)Adapters.adapt((Object)targetPart, IShowInTarget.class);
                }
            };
            action.setId(targetId);
            return new ActionContributionItem((IAction)action);
        }
    }
}

