/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.base.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.base.BasePackage;
import org.eclipse.oomph.base.ModelElement;
import org.eclipse.oomph.base.provider.BaseEditPlugin;
import org.eclipse.oomph.edit.BasePasteCommand;
import org.eclipse.oomph.util.PropertiesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelElementItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public ModelElementItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            this.itemPropertyDescriptors = new ArrayList<IItemPropertyDescriptor>(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean add(IItemPropertyDescriptor itemPropertyDescriptor) {
                    int size = this.size();
                    if (size == 0) {
                        super.add(itemPropertyDescriptor);
                    } else {
                        super.add(size - 1, itemPropertyDescriptor);
                    }
                    return true;
                }
            };
            this.itemPropertyDescriptors.add(new EClassPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator()));
        }
        return this.itemPropertyDescriptors;
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(BasePackage.Literals.MODEL_ELEMENT__ANNOTATIONS);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public boolean hasChildren(Object object) {
        return this.hasChildren(object, true);
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        return this.getString("_UI_ModelElement_type");
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(ModelElement.class)) {
            case 0: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(BasePackage.Literals.MODEL_ELEMENT__ANNOTATIONS, BaseFactory.eINSTANCE.createAnnotation()));
    }

    public Command createCommand(Object object, EditingDomain domain, Class<? extends Command> commandClass, CommandParameter commandParameter) {
        if (commandClass == BasePasteCommand.class) {
            CommandParameter oldCommandParameter = commandParameter;
            Collection collection = (commandParameter = this.unwrapCommandValues(commandParameter, commandClass)).getCollection();
            if (collection == null) {
                return UnexecutableCommand.INSTANCE;
            }
            Command result = this.createPasteCommand(domain, commandParameter.getEOwner(), commandParameter.getEStructuralFeature(), collection, commandParameter.getIndex());
            return this.wrapCommand(result, object, commandClass, commandParameter, oldCommandParameter);
        }
        return super.createCommand(object, domain, commandClass, commandParameter);
    }

    protected Command createPasteCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        return new PasteAlternativeVisitor(domain, owner, feature, collection, index){

            @Override
            protected Collection<?> filterAlternatives(Collection<?> alternativeCollection) {
                return ModelElementItemProvider.this.filterAlternatives(this.domain, this.owner, alternativeCollection);
            }
        }.createCommand();
    }

    protected Collection<?> filterAlternatives(EditingDomain domain, Object owner, Collection<?> alternatives) {
        return alternatives;
    }

    protected final Command createDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
        Command dragAndDropCommand = this.createPrimaryDragAndDropCommand(domain, owner, location, operations, operation, collection);
        if (!dragAndDropCommand.canExecute()) {
            Command alternativeDragAndDropCommand = this.createAlternativeDragAndDropCommand(domain, owner, location, operations, operation, collection);
            if (alternativeDragAndDropCommand.canExecute()) {
                dragAndDropCommand.dispose();
                dragAndDropCommand = alternativeDragAndDropCommand;
            } else {
                alternativeDragAndDropCommand.dispose();
            }
        }
        return dragAndDropCommand;
    }

    protected Command createPrimaryDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
        return new BaseDragAndDropCommand(domain, owner, location, operations, operation, collection);
    }

    protected Command createAlternativeDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
        return new DragAndDropAlternativeVisitor(domain, owner, location, operations, operation, collection){

            @Override
            protected Collection<?> filterAlternatives(Collection<?> alternativeCollection) {
                return ModelElementItemProvider.this.filterAlternatives(this.domain, this.owner, this.location, this.operations, this.operation, alternativeCollection);
            }
        }.createCommand();
    }

    protected Collection<?> filterAlternatives(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> alternatives) {
        return this.filterAlternatives(domain, owner, alternatives);
    }

    protected ItemPropertyDescriptor createItemPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable, boolean multiLine, boolean sortChoices, Object staticImage, String category, String[] filterFlags) {
        if (feature instanceof EReference) {
            return new HierarchicalPropertyDescriptor(adapterFactory, resourceLocator, displayName, description, feature, isSettable, multiLine, sortChoices, staticImage, category, filterFlags){

                @Override
                protected Object filterParent(AdapterFactoryItemDelegator itemDelegator, EStructuralFeature feature, Object object) {
                    return ModelElementItemProvider.this.filterParent(itemDelegator, feature, object);
                }

                public Collection<?> getChoiceOfValues(Object object) {
                    return ModelElementItemProvider.this.filterChoices(super.getChoiceOfValues(object), this.feature, object);
                }

                public String[] getFilterFlags(Object object) {
                    String[] filterFlags = super.getFilterFlags(object);
                    if (filterFlags != null && filterFlags.length == 1 && "org.eclipse.ui.views.properties.expert.conditional".equals(filterFlags[0])) {
                        EObject eObject = (EObject)object;
                        if (eObject.eIsSet(this.feature)) {
                            return null;
                        }
                        return PropertiesUtil.EXPERT_FILTER;
                    }
                    return filterFlags;
                }
            };
        }
        return new ItemPropertyDescriptor(adapterFactory, resourceLocator, displayName, description, feature, isSettable, multiLine, sortChoices, staticImage, category, filterFlags){

            public Collection<?> getChoiceOfValues(Object object) {
                return ModelElementItemProvider.this.filterChoices(super.getChoiceOfValues(object), this.feature, object);
            }

            public boolean isChoiceArbitrary(Object object) {
                return ModelElementItemProvider.this.isChoiceArbitrary(this.feature, object);
            }

            public String[] getFilterFlags(Object object) {
                String[] filterFlags = super.getFilterFlags(object);
                if (filterFlags != null && filterFlags.length == 1 && "org.eclipse.ui.views.properties.expert.conditional".equals(filterFlags[0])) {
                    EObject eObject = (EObject)object;
                    if (eObject.eIsSet(this.feature)) {
                        return null;
                    }
                    return PropertiesUtil.EXPERT_FILTER;
                }
                return filterFlags;
            }
        };
    }

    protected Object filterParent(AdapterFactoryItemDelegator itemDelegator, EStructuralFeature feature, Object object) {
        return object;
    }

    protected Collection<?> filterChoices(Collection<?> choices, EStructuralFeature feature, Object object) {
        return choices;
    }

    protected boolean isChoiceArbitrary(EStructuralFeature feature, Object object) {
        return false;
    }

    public ResourceLocator getResourceLocator() {
        return ((IChildCreationExtender)this.adapterFactory).getResourceLocator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BaseDragAndDropCommand
    extends DragAndDropCommand {
        public BaseDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
            super(domain, owner, location, operations, operation, collection);
        }

        protected boolean prepareDropLinkOn() {
            this.dragCommand = IdentityCommand.INSTANCE;
            this.dropCommand = SetCommand.create((EditingDomain)this.domain, (Object)this.owner, null, (Object)this.collection);
            if (!this.dropCommand.canExecute() && this.collection.size() == 1) {
                this.dropCommand.dispose();
                this.dropCommand = SetCommand.create((EditingDomain)this.domain, (Object)this.owner, null, this.collection.iterator().next());
            }
            if (!this.dropCommand.canExecute() || !this.analyzeForDropLinkEnablement(this.dropCommand)) {
                this.dropCommand.dispose();
                this.dropCommand = AddCommand.create((EditingDomain)this.domain, (Object)this.owner, null, (Collection)this.collection);
                if (!this.analyzeForDropLinkEnablement(this.dropCommand)) {
                    this.dropCommand.dispose();
                    this.dropCommand = UnexecutableCommand.INSTANCE;
                }
            }
            boolean result = this.dropCommand.canExecute();
            return result;
        }

        protected boolean analyzeForDropLinkEnablement(Command command) {
            if (command instanceof AddCommand) {
                AddCommand addCommand = (AddCommand)command;
                if (this.isNonContainment(addCommand.getFeature())) {
                    return true;
                }
                EList ownerList = addCommand.getOwnerList();
                if (ownerList != null && ((EReference)addCommand.getFeature()).isResolveProxies()) {
                    for (Object value : addCommand.getCollection()) {
                        EObject eObject = (EObject)value;
                        if (eObject.eContainer() == null) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            if (command instanceof SetCommand) {
                return this.isNonContainment(((SetCommand)command).getFeature());
            }
            if (command instanceof CommandWrapper) {
                return this.analyzeForDropLinkEnablement(((CommandWrapper)command).getCommand());
            }
            if (command instanceof CompoundCommand) {
                for (Command childCommand : ((CompoundCommand)command).getCommandList()) {
                    if (!this.analyzeForDropLinkEnablement(childCommand)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CommandAlternativeVisitor {
        protected EditingDomain domain;
        protected Object owner;
        protected Collection<?> collection;

        public CommandAlternativeVisitor(EditingDomain domain, Object owner, Collection<?> collection) {
            this.domain = domain;
            this.owner = owner;
            this.collection = collection;
        }

        public Command createCommand() {
            ArrayList<EObject> alternativeCollection = new ArrayList<EObject>();
            HashMap<EObject, EObject> fullConversionMap = new HashMap<EObject, EObject>();
            for (Object object : this.collection) {
                if (!(object instanceof EObject)) continue;
                EObject eObject = (EObject)object;
                EClass eClass = eObject.eClass();
                for (EAnnotation eAnnotation : eClass.getEAnnotations()) {
                    EClass conversionEClass;
                    EMap details;
                    String conversionEClassURI;
                    if (!"http://www.eclipse.org/oomph/base/Conversion".equals(eAnnotation.getSource()) || (conversionEClassURI = (String)(details = eAnnotation.getDetails()).get((Object)"eClass")) == null || (conversionEClass = this.getConversionEClass(this.domain, this.owner, URI.createURI((String)conversionEClassURI))) == null) continue;
                    HashMap<EObject, EObject> conversionMap = new HashMap<EObject, EObject>();
                    conversionMap.put((EObject)eClass, (EObject)conversionEClass);
                    for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
                        String name = eStructuralFeature.getName();
                        EStructuralFeature conversionEStructuralFeature = conversionEClass.getEStructuralFeature(name);
                        conversionMap.put((EObject)eStructuralFeature, (EObject)conversionEStructuralFeature);
                    }
                    for (Map.Entry entry : details) {
                        String key = (String)entry.getKey();
                        EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(key);
                        if (eStructuralFeature == null) continue;
                        String value = (String)entry.getValue();
                        EStructuralFeature conversionEStructuralFeature = conversionEClass.getEStructuralFeature(value);
                        conversionMap.put((EObject)eStructuralFeature, (EObject)conversionEStructuralFeature);
                    }
                    ConversionCopier copier = new ConversionCopier(conversionMap);
                    EObject copy = copier.copy(eObject);
                    copier.copyReferences();
                    Command probeCommand = this.createCommand(Collections.singleton(copy));
                    if (probeCommand.canExecute()) {
                        alternativeCollection.add(eObject);
                        fullConversionMap.putAll(conversionMap);
                    }
                    probeCommand.dispose();
                }
            }
            if (!alternativeCollection.isEmpty()) {
                ConversionCopier copier = new ConversionCopier(fullConversionMap);
                Collection<?> alternatives = this.filterAlternatives(copier.copyAll(alternativeCollection));
                copier.copyReferences();
                if (!alternatives.isEmpty()) {
                    Command command = this.createCommand(alternatives);
                    if (command.canExecute()) {
                        return command;
                    }
                    command.dispose();
                }
            }
            return UnexecutableCommand.INSTANCE;
        }

        protected EClass getConversionEClass(EditingDomain domain, Object owner, URI uri) {
            ResourceSet resourceSet = domain.getResourceSet();
            if (resourceSet != null) {
                EObject eObject = resourceSet.getEObject(uri, false);
                if (eObject instanceof EClass) {
                    return (EClass)eObject;
                }
                try {
                    ResourceSetImpl temporaryResourceSet = new ResourceSetImpl();
                    eObject = temporaryResourceSet.getEObject(uri, true);
                    if (eObject instanceof EClass && (eObject = resourceSet.getEObject(uri, true)) instanceof EClass) {
                        return (EClass)eObject;
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return null;
        }

        protected abstract Command createCommand(Collection<?> var1);

        protected Collection<?> filterAlternatives(Collection<?> alternatives) {
            return alternatives;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConversionCopier
    extends EcoreUtil.Copier {
        private static final long serialVersionUID = 1L;
        private transient Map<EObject, EObject> conversionMap;

        public ConversionCopier(Map<EObject, EObject> conversionMap) {
            this.conversionMap = conversionMap;
        }

        protected EClass getTarget(EClass eClass) {
            return (EClass)this.conversionMap.get(eClass);
        }

        protected EStructuralFeature getTarget(EStructuralFeature eStructuralFeature) {
            return (EStructuralFeature)this.conversionMap.get(eStructuralFeature);
        }

        protected void copyAttributeValue(EAttribute eAttribute, EObject eObject, Object value, EStructuralFeature.Setting setting) {
            if (value != null) {
                Class instanceClass2;
                EDataType eAttributeType = eAttribute.getEAttributeType();
                EDataType eType = (EDataType)setting.getEStructuralFeature().getEType();
                Class instanceClass = eType.getInstanceClass();
                if (instanceClass != (instanceClass2 = eAttributeType.getInstanceClass()) || instanceClass == null) {
                    if (eAttribute.isMany()) {
                        ArrayList<Object> values = new ArrayList<Object>();
                        for (Object element : (Collection)value) {
                            values.add(EcoreUtil.createFromString((EDataType)eType, (String)EcoreUtil.convertToString((EDataType)eAttributeType, element)));
                        }
                        value = values;
                    } else {
                        value = EcoreUtil.createFromString((EDataType)eType, (String)EcoreUtil.convertToString((EDataType)eAttributeType, (Object)value));
                    }
                }
            }
            super.copyAttributeValue(eAttribute, eObject, (Object)value, setting);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DragAndDropAlternativeVisitor
    extends CommandAlternativeVisitor {
        protected float location;
        protected int operations;
        protected int operation;

        public DragAndDropAlternativeVisitor(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
            super(domain, owner, collection);
            this.location = location;
            this.operations = operations;
            this.operation = operation;
        }

        @Override
        protected Command createCommand(final Collection<?> alternatives) {
            return new BaseDragAndDropCommand(this.domain, this.owner, this.location, this.operations, this.operation, alternatives){

                public boolean validate(Object owner, float location, int operations, int operation, Collection<?> collection) {
                    if (DragAndDropAlternativeVisitor.this.collection.equals(collection)) {
                        collection = alternatives;
                    }
                    return super.validate(owner, location, operations, operation, collection);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EClassPropertyDescriptor
    implements IItemPropertyDescriptor {
        private static Object image;
        private static final IItemLabelProvider LABEL_PROVIDER;

        static {
            LABEL_PROVIDER = new IItemLabelProvider(){

                public String getText(Object object) {
                    EClass eClass = (EClass)object;
                    String instanceTypeName = eClass.getInstanceTypeName();
                    if (instanceTypeName != null) {
                        return instanceTypeName;
                    }
                    return EcoreUtil.getURI((EObject)eClass).toString();
                }

                public Object getImage(Object object) {
                    return image;
                }
            };
        }

        public EClassPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator) {
            if (image == null) {
                image = new AdapterFactoryItemDelegator(adapterFactory).getImage((Object)EcorePackage.Literals.ECLASS);
            }
        }

        public IItemLabelProvider getLabelProvider(Object object) {
            return LABEL_PROVIDER;
        }

        public Object getPropertyValue(Object object) {
            return ((EObject)object).eClass();
        }

        public boolean isPropertySet(Object object) {
            return true;
        }

        public boolean canSetProperty(Object object) {
            return false;
        }

        public void resetPropertyValue(Object object) {
        }

        public void setPropertyValue(Object object, Object value) {
        }

        public String getCategory(Object object) {
            return null;
        }

        public String getDescription(Object object) {
            return BaseEditPlugin.INSTANCE.getString("_UI_ModelClass_description");
        }

        public String getDisplayName(Object object) {
            return BaseEditPlugin.INSTANCE.getString("_UI_ModelClass_feature");
        }

        public String[] getFilterFlags(Object object) {
            return PropertiesUtil.EXPERT_FILTER;
        }

        public Object getHelpContextIds(Object object) {
            return null;
        }

        public String getId(Object object) {
            return this.getDisplayName(object);
        }

        public boolean isCompatibleWith(Object object, Object anotherObject, IItemPropertyDescriptor anotherPropertyDescriptor) {
            return false;
        }

        public Object getFeature(Object object) {
            return "eClass";
        }

        public boolean isMany(Object object) {
            return false;
        }

        public Collection<?> getChoiceOfValues(Object object) {
            return Collections.emptyList();
        }

        public boolean isMultiLine(Object object) {
            return false;
        }

        public boolean isSortChoices(Object object) {
            return false;
        }
    }

    public static class HierarchicalItemLabelProvider
    implements IItemLabelProvider {
        protected AdapterFactoryItemDelegator itemDelegator;

        public HierarchicalItemLabelProvider(AdapterFactoryItemDelegator itemDelegator) {
            this.itemDelegator = itemDelegator;
        }

        public String getText(Object object) {
            if (object instanceof EList) {
                StringBuilder result = new StringBuilder();
                for (Object child : (List)object) {
                    if (result.length() != 0) {
                        result.append(", ");
                    }
                    result.append(this.getText(child));
                }
                return result.toString();
            }
            StringBuilder builder = new StringBuilder(this.getBasicText(object));
            int index = builder.length();
            object = this.getParent(object);
            while (object != null) {
                if (builder.length() == index) {
                    builder.insert(index, " (");
                    index += 2;
                } else {
                    builder.insert(index, " - ");
                }
                String text = this.getQualifierText(object);
                builder.insert(index, text);
                object = this.getParent(object);
            }
            if (builder.length() != index) {
                builder.append(")");
            }
            return builder.toString();
        }

        protected String getBasicText(Object object) {
            return this.itemDelegator.getText(object);
        }

        protected String getQualifierText(Object object) {
            return this.itemDelegator.getText(object);
        }

        protected Object getParent(Object object) {
            Object parent = this.itemDelegator.getParent(object);
            if (parent instanceof Resource) {
                Object unwrappedObject = AdapterFactoryEditingDomain.unwrap((Object)object);
                if (unwrappedObject instanceof EObject) {
                    return ((EObject)unwrappedObject).eContainer();
                }
                return null;
            }
            return parent;
        }

        public Object getImage(Object object) {
            return this.itemDelegator.getImage(object);
        }
    }

    public static class HierarchicalPropertyDescriptor
    extends ItemPropertyDescriptor {
        protected IItemLabelProvider labelProvider;

        public HierarchicalPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable, boolean multiLine, boolean sortChoices, Object staticImage, String category, String[] filterFlags) {
            super(adapterFactory, resourceLocator, displayName, description, feature, isSettable, multiLine, sortChoices, staticImage, category, filterFlags);
        }

        protected IItemLabelProvider createLabelProvider() {
            return new HierarchicalItemLabelProvider(this.itemDelegator){

                protected Object getParent(Object object) {
                    return HierarchicalPropertyDescriptor.this.filterParent(this.itemDelegator, HierarchicalPropertyDescriptor.this.feature, super.getParent(object));
                }
            };
        }

        protected Object filterParent(AdapterFactoryItemDelegator itemDelegator, EStructuralFeature feature, Object object) {
            return object;
        }

        public IItemLabelProvider getLabelProvider(Object object) {
            if (this.labelProvider == null) {
                this.labelProvider = this.createLabelProvider();
            }
            return this.labelProvider;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PasteAlternativeVisitor
    extends CommandAlternativeVisitor {
        protected Object feature;
        protected int index;

        public PasteAlternativeVisitor(EditingDomain domain, Object owner, Object feature, Collection<?> collection, int index) {
            super(domain, owner, collection);
            this.feature = feature;
            this.index = index;
        }

        @Override
        protected Command createCommand(Collection<?> alternatives) {
            return AddCommand.create((EditingDomain)this.domain, (Object)this.owner, (Object)this.feature, alternatives, (int)this.index);
        }
    }
}

