/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLHandshakeException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.impl.GenericXMLResourceFactoryImpl;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.engine.ProfilePreferences;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.ICompositeRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.base.ModelElement;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.internal.setup.SetupPrompter;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.VersionSegment;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.ProfileTransaction;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.InstallationTask;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.Project;
import org.eclipse.oomph.setup.ProjectCatalog;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.Stream;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.VariableTask;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.internal.core.util.ECFURIHandlerImpl;
import org.eclipse.oomph.setup.internal.core.util.ResourceMirror;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.p2.P2Task;
import org.eclipse.oomph.setup.p2.SetupP2Factory;
import org.eclipse.oomph.setup.p2.SetupP2Package;
import org.eclipse.oomph.setup.util.SetupUtil;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.UserCallback;
import org.eclipse.oomph.util.WorkerPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketplaceCatalogGenerator
implements IApplication {
    private static final String PROCESSING_ANNOTATION_SOURCE = "Processing";
    private static final String CATEGORIES_ANNOTATION_SOURCE = "http://www.eclipse.org/oomph/setup/Categories";
    private static final String TAGS_ANNOTATION_SOURCE = "http://www.eclipse.org/oomph/setup/Tags";
    private static final String UNSELECTED_ANNOTATION_SOURCE = "Unselected";
    private static final String SELECTED_ANNOTATION_SOURCE = "Selected";
    private File outputLocation;
    private URI outputLocationURI;
    private File poolLocation;
    private ResourceSet resourceSet;
    private IMetadataRepositoryManager manager;
    private final Map<String, IMetadataRepository> repos = Collections.synchronizedMap(new HashMap());
    private final Map<String, Exception> bogusRepos = new HashMap<String, Exception>();

    public Object start(IApplicationContext context) throws Exception {
        String[] arguments = (String[])context.getArguments().get("application.args");
        LinkedHashMap<String, URI> nodeURIs = new LinkedHashMap<String, URI>();
        this.outputLocation = File.createTempFile("marketplace", "-report");
        boolean skip = false;
        if (arguments != null) {
            int i = 0;
            while (i < arguments.length) {
                String option = arguments[i];
                if ("-output".equals(option) || "-o".equals(option)) {
                    this.outputLocation = new File(arguments[++i]).getCanonicalFile();
                } else if ("-skip".equals(option) || "-s".equals(option)) {
                    skip = true;
                }
                if ("-listing".equals(option) || "-l".equals(option)) {
                    nodeURIs.put("", URI.createURI((String)arguments[++i]));
                }
                ++i;
            }
        }
        this.outputLocation.mkdirs();
        if (!this.outputLocation.isDirectory()) {
            throw new RuntimeException("Cannot create '" + this.outputLocation + "'");
        }
        File userHome = new File(this.outputLocation, "home");
        userHome.mkdirs();
        System.setProperty("user.home", userHome.toString());
        System.out.println("Local user home: '" + userHome + "'");
        this.outputLocationURI = URI.createFileURI((String)this.outputLocation.toString());
        this.poolLocation = new File(userHome, ".p2/pool");
        this.resourceSet = SetupCoreUtil.createResourceSet();
        this.manager = this.getMetadataRepositoryManager();
        try {
            this.resourceSet.getLoadOptions().put("OPTION_CACHE_HANDLING", ECFURIHandlerImpl.CacheHandling.CACHE_WITH_ETAG_CHECKING);
            if (!skip) {
                this.perform(nodeURIs);
            }
            if (Boolean.FALSE.booleanValue()) {
                this.generateReport();
            }
            this.generateMinimizedResult();
            return null;
        }
        finally {
            Job.getJobManager().join(ProfilePreferences.PROFILE_SAVE_JOB_FAMILY, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private URI getJREURI() {
        return this.outputLocationURI.appendSegment("jre");
    }

    private URI getTargetResourceURI() {
        return this.outputLocationURI.appendSegment("generated.setup");
    }

    private URI getResolvedResourceURI() {
        return this.outputLocationURI.appendSegment("resolved.setup");
    }

    private URI getResolvedMinimizedResourceURI() {
        return this.outputLocationURI.appendSegment("resolved-minimized.setup");
    }

    public void perform(Map<String, URI> nodeURIs) throws Exception {
        String updateURL;
        List nodes;
        boolean normalizeP2Tasks = true;
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new GenericXMLResourceFactoryImpl());
        long startListings = System.currentTimeMillis();
        if (nodeURIs.isEmpty()) {
            long startCategories = System.currentTimeMillis();
            LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
            URI baseSearchURI = URI.createURI((String)"https://marketplace.eclipse.org/api/p/search/apachesolr_search/%20");
            Resource resource = this.resourceSet.getResource(baseSearchURI, true);
            EObject documentRoot = (EObject)resource.getContents().get(0);
            EObject marketplace = (EObject)documentRoot.eContents().get(0);
            for (EObject search : marketplace.eContents()) {
                int count = Integer.parseInt((String)this.get(search, "count"));
                System.err.println("Listing count: " + count);
                int i = 0;
                while (i * 10 < count) {
                    URI listingURI = baseSearchURI.appendQuery("page_num=" + i);
                    uris.add(listingURI);
                    ++i;
                }
            }
            ResourceMirror resourceMirror = new ResourceMirror(this.resourceSet, 50);
            resourceMirror.perform(uris);
            resourceMirror.dispose();
            System.out.println("Gathering " + uris.size() + " categories: " + (startListings - startCategories) / 1000L);
            for (URI listingURI : uris) {
                Resource listingResource = this.resourceSet.getResource(listingURI, true);
                EObject documentRoot2 = (EObject)listingResource.getContents().get(0);
                EObject marketplace2 = (EObject)documentRoot2.eContents().get(0);
                List searches = (List)this.get(marketplace2, "search");
                for (AnyType search : searches) {
                    nodes = (List)this.get((EObject)search, "node");
                    for (Object node : nodes) {
                        String id;
                        URI nodeURI;
                        updateURL = this.getContent((EObject)node, "updateurl");
                        if (StringUtil.isEmpty((String)updateURL) || (nodeURI = nodeURIs.get(id = (String)this.get((EObject)node, "id"))) != null) continue;
                        String nodeURL = (String)this.get((EObject)node, "url");
                        nodeURI = URI.createURI((String)nodeURL);
                        nodeURIs.put(id, nodeURI);
                    }
                }
            }
        }
        LinkedHashMap<String, String> platformVersions = new LinkedHashMap<String, String>();
        platformVersions.put("platform.version=4.2", "Juno");
        platformVersions.put("platform.version=4.3", "Kepler");
        platformVersions.put("platform.version=4.4", "Luna");
        platformVersions.put("platform.version=4.5", "Mars");
        platformVersions.put("platform.version=4.6", "Neon");
        platformVersions.put("platform.version=4.7", "Oxygen");
        platformVersions.put("platform.version=4.8", "Photon");
        platformVersions.put("platform.version=4.9", "2018-09");
        platformVersions.put("platform.version=4.10", "2018-12");
        platformVersions.put("platform.version=4.11", "2019-03");
        platformVersions.put("platform.version=4.12", "2019-06");
        platformVersions.put("platform.version=4.13", "2019-09");
        platformVersions.put("platform.version=4.14", "2019-12");
        platformVersions.put("platform.version=4.15", "2020-03");
        platformVersions.put("platform.version=4.16", "2020-06");
        platformVersions.put("platform.version=4.17", "2020-09");
        LinkedHashSet<URI> nodeQueryURIs = new LinkedHashSet<URI>();
        String[] querySegments = new String[]{"api", "p"};
        for (URI nodeURI : nodeURIs.values()) {
            for (String platformVersion : platformVersions.keySet()) {
                nodeQueryURIs.add(nodeURI.appendSegments(querySegments).appendQuery(platformVersion));
            }
        }
        ResourceMirror resourceMirror = new ResourceMirror(this.resourceSet, 50);
        resourceMirror.perform(nodeQueryURIs);
        resourceMirror.dispose();
        long startRepositoryLoads = System.currentTimeMillis();
        System.out.println("Gathering " + nodeQueryURIs.size() + " listings: " + (startRepositoryLoads - startListings) / 1000L);
        LinkedHashSet<String> updateURLs = new LinkedHashSet<String>();
        for (URI listingURI : nodeQueryURIs) {
            System.err.println("Loading: " + listingURI);
            Resource listingResource = this.resourceSet.getResource(listingURI, true);
            EList contents = listingResource.getContents();
            if (contents.isEmpty()) {
                System.err.println("Empty listing: '" + listingURI + "'");
                continue;
            }
            EObject documentRoot = (EObject)contents.get(0);
            EObject marketplace = (EObject)documentRoot.eContents().get(0);
            nodes = (List)this.get(marketplace, "node");
            for (Object node : nodes) {
                updateURL = this.getContent((EObject)node, "updateurl");
                if (StringUtil.isEmpty((String)updateURL)) continue;
                if (updateURL.endsWith("/")) {
                    updateURL = updateURL.substring(0, updateURL.length() - 1);
                }
                updateURLs.add(updateURL);
            }
        }
        System.out.println("Loading repositories");
        Resource productCatalogResource = this.resourceSet.getResource(URI.createURI((String)"index:/org.eclipse.products.setup"), true);
        TreeIterator it = productCatalogResource.getAllContents();
        while (it.hasNext()) {
            EObject eObject = (EObject)it.next();
            if (!(eObject instanceof Repository)) continue;
            updateURLs.add(((Repository)eObject).getURL());
        }
        for (String version : platformVersions.values()) {
            updateURLs.add("http://download.eclipse.org/releases/" + version.toLowerCase());
        }
        updateURLs.add("http://download.eclipse.org/oomph/updates/milestone/latest");
        RepositoryLoader repositoryLoader = new RepositoryLoader(this);
        repositoryLoader.perform(updateURLs);
        repositoryLoader.dispose();
        List<IQuery> jreQuery = Arrays.asList(QueryUtil.createIUQuery((String)"a.jre.javase"), QueryUtil.createLatestIUQuery());
        IQueryResult jreResult = this.manager.query(QueryUtil.createCompoundQuery(jreQuery, (boolean)true), (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit jreIU = (IInstallableUnit)jreResult.iterator().next();
        System.out.println("JRE IU + " + jreIU);
        URI jrep2uri = this.getJREURI();
        IOUtil.deleteBestEffort((File)new File(jrep2uri.toFileString()));
        java.net.URI jreLocation = new java.net.URI(jrep2uri.toString());
        this.manager.removeRepository(jreLocation);
        IMetadataRepository jreRepository = this.manager.createRepository(jreLocation, "jre", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", Collections.emptyMap());
        jreRepository.addInstallableUnits(Collections.singleton(jreIU));
        System.out.println("Processing + " + nodeQueryURIs.size() + " listings");
        LinkedHashMap<String, Project> projects = new LinkedHashMap<String, Project>();
        for (URI listingURI : nodeQueryURIs) {
            Resource listingResource = this.resourceSet.getResource(listingURI, true);
            EList contents = listingResource.getContents();
            if (contents.isEmpty()) {
                System.err.println("Empty Listing: '" + listingURI);
                continue;
            }
            EObject documentRoot = (EObject)contents.get(0);
            EObject marketplace = (EObject)documentRoot.eContents().get(0);
            List nodes2 = (List)this.get(marketplace, "node");
            for (AnyType node : nodes2) {
                int platformsSize;
                String id = (String)this.get((EObject)node, "id");
                Project project = (Project)projects.get(id);
                if (project == null) {
                    String projectLabel = (String)this.get((EObject)node, "name");
                    projectLabel = projectLabel.trim().replace("&amp;", "&");
                    project = SetupFactory.eINSTANCE.createProject();
                    project.setLabel(projectLabel);
                    project.setDescription(SetupUtil.escape((String)this.getContent((EObject)node, "shortdescription")));
                    String image = this.getContent((EObject)node, "image");
                    if (image != null) {
                        URI imageURI = URI.createURI((String)image);
                        imageURI = imageURI.trimQuery();
                        BaseUtil.setAnnotation((ModelElement)project, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"imageURI", (String)imageURI.toString());
                    }
                    String nodeURL = (String)this.get((EObject)node, "url");
                    URI nodeURI = URI.createURI((String)nodeURL);
                    String title = nodeURI.lastSegment();
                    project.setName(title);
                    BaseUtil.setAnnotation((ModelElement)project, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"siteURI", (String)nodeURL);
                    BaseUtil.setAnnotation((ModelElement)project, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"marketplace", (String)listingURI.trimQuery().toString());
                    BaseUtil.setAnnotation((ModelElement)project, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"marketplaceID", (String)id);
                    List<AnyType> nodeCategories = this.get((EObject)node, "categories", "category");
                    for (AnyType nodeCategory : nodeCategories) {
                        String projectCategoryName = (String)this.get((EObject)nodeCategory, "name");
                        String projectCategoryURL = (String)this.get((EObject)nodeCategory, "url");
                        BaseUtil.setAnnotation((ModelElement)project, (String)CATEGORIES_ANNOTATION_SOURCE, (String)projectCategoryName, (String)projectCategoryURL);
                    }
                    List<AnyType> nodeTags = this.get((EObject)node, "tags", "tag");
                    for (AnyType nodeTag : nodeTags) {
                        String projectCategoryName = (String)this.get((EObject)nodeTag, "name");
                        String projectCategoryURL = (String)this.get((EObject)nodeTag, "url");
                        BaseUtil.setAnnotation((ModelElement)project, (String)TAGS_ANNOTATION_SOURCE, (String)projectCategoryName, (String)projectCategoryURL);
                    }
                    projects.put(id, project);
                }
                Stream stream = SetupFactory.eINSTANCE.createStream();
                String platformVersionQuery = listingURI.query();
                String streamVersion = (String)platformVersions.get(platformVersionQuery);
                String version = this.getContent((EObject)node, "version");
                stream.setName(streamVersion.toLowerCase());
                stream.setLabel(StringUtil.isEmpty((String)version) ? streamVersion : String.valueOf(streamVersion) + " - " + version);
                BaseUtil.setAnnotation((ModelElement)stream, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"marketplace", (String)listingURI.toString());
                String updateURL2 = this.getContent((EObject)node, "updateurl");
                if (StringUtil.isEmpty((String)updateURL2)) continue;
                if (updateURL2.endsWith("/")) {
                    updateURL2 = updateURL2.substring(0, updateURL2.length() - 1);
                }
                P2Task p2Task = SetupP2Factory.eINSTANCE.createP2Task();
                Repository updateRepository = P2Factory.eINSTANCE.createRepository(updateURL2);
                p2Task.getRepositories().add((Object)updateRepository);
                p2Task.getRepositories().add((Object)P2Factory.eINSTANCE.createRepository(this.getJREURI().toString()));
                EList requirements = p2Task.getRequirements();
                List<AnyType> ius = this.get((EObject)node, "ius", "iu");
                for (AnyType iu : ius) {
                    String selected;
                    String iuID = this.getContent(iu);
                    String name = this.getName(updateURL2, iuID);
                    if (name == null) {
                        name = this.getName("http://download.eclipse.org/releases/" + streamVersion.toLowerCase(), iuID);
                    }
                    if (name == null && !iuID.endsWith(".feature.group")) {
                        name = this.getName(updateURL2, String.valueOf(iuID) + ".feature.group");
                        if (name == null) {
                            name = this.getName("http://download.eclipse.org/releases/" + streamVersion.toLowerCase(), String.valueOf(iuID) + ".feature.group");
                        }
                        if (name != null) {
                            iuID = String.valueOf(iuID) + ".feature.group";
                        }
                    }
                    Requirement requirement = P2Factory.eINSTANCE.createRequirement(iuID);
                    VersionRange iuVersionRange = this.getVersionRange(updateURL2, iuID);
                    if (iuVersionRange != null) {
                        requirement.setVersionRange(iuVersionRange);
                    }
                    requirements.add((Object)requirement);
                    Iterator specificIUs = this.getIUs(updateURL2, iuID);
                    Iterator<IInstallableUnit> iterator = specificIUs.iterator();
                    while (iterator.hasNext()) {
                        IInstallableUnitPatch iuPatch;
                        IRequirement lifeCycle;
                        IInstallableUnit specificIU = iterator.next();
                        if (!(specificIU instanceof IInstallableUnitPatch) || !((lifeCycle = (iuPatch = (IInstallableUnitPatch)specificIU).getLifeCycle()) instanceof IRequiredCapability)) continue;
                        IRequiredCapability requiredCapability = (IRequiredCapability)lifeCycle;
                        String patchedNamespace = requiredCapability.getNamespace();
                        String patchedName = requiredCapability.getName();
                        Requirement patchRequirement = P2Factory.eINSTANCE.createRequirement(patchedName);
                        patchRequirement.setNamespace(patchedNamespace);
                        requirements.add((Object)patchRequirement);
                        break;
                    }
                    if (!this.bogusRepos.containsKey(updateURL2)) {
                        BaseUtil.setAnnotation((ModelElement)requirement, (String)"Data", (String)"name", (String)(name == null ? "BogusIU" : name));
                        IMetadataRepository repository = this.repos.get(updateURL2);
                        if (!updateURL2.equals(repository.getLocation().toString())) {
                            System.err.println("###");
                        }
                    }
                    if (!Boolean.FALSE.booleanValue() || (selected = (String)this.get((EObject)iu, "selected")) == null) continue;
                    requirement.getAnnotations().add((Object)BaseFactory.eINSTANCE.createAnnotation("FALSE".equals(selected) ? UNSELECTED_ANNOTATION_SOURCE : SELECTED_ANNOTATION_SOURCE));
                }
                Exception bogusRepoException = this.bogusRepos.get(updateURL2);
                if (bogusRepoException != null) {
                    BaseUtil.setAnnotation((ModelElement)updateRepository, (String)"BogusRepo", (String)"message", (String)this.buildMessage(bogusRepoException));
                }
                if (requirements.isEmpty()) {
                    BaseUtil.setAnnotation((ModelElement)stream, (String)"BogusEmptyRequirements", (String)"message", (String)"The listing contains no <ius>");
                }
                p2Task.setLabel(project.getLabel());
                stream.getSetupTasks().add((Object)p2Task);
                List<AnyType> platforms = this.get((EObject)node, "platforms", "platform");
                if (platforms.isEmpty()) {
                    BaseUtil.setAnnotation((ModelElement)stream, (String)"BogusEmptyPlatforms", (String)"message", (String)"The listing contains no <platforms>");
                    System.err.println("###");
                }
                if ((platformsSize = platforms.size()) < 3) {
                    boolean or = platformsSize > 1;
                    StringBuilder filter = new StringBuilder();
                    if (or) {
                        filter.append("(|");
                    }
                    for (AnyType platform : platforms) {
                        String platformName = this.getContent(platform);
                        if ("Windows".equals(platformName)) {
                            filter.append("(osgi.os=win32)");
                            continue;
                        }
                        if ("Mac".equals(platformName)) {
                            filter.append("(osgi.os=mac)");
                            continue;
                        }
                        if (!"Linux/GTK".equals(platformName)) continue;
                        filter.append("(&(osgi.os=linux)(osgi.ws=gtk))");
                    }
                    if (or) {
                        filter.append(')');
                    }
                    p2Task.setFilter(filter.toString());
                }
                TreeSet<Version> nodePlatformVersions = new TreeSet<Version>();
                String eclipseVersions = this.getContent((EObject)node, "eclipseversion");
                if (StringUtil.isEmpty((String)eclipseVersions)) {
                    BaseUtil.setAnnotation((ModelElement)stream, (String)"BogusEmptyEclipseVersion", (String)"message", (String)"The listing contains no eclipseversion");
                    System.err.println("###");
                } else {
                    for (String eclipseVersion : StringUtil.explode((String)eclipseVersions, (String)",")) {
                        nodePlatformVersions.add(Version.create((String)eclipseVersion.trim()));
                    }
                }
                if (nodePlatformVersions.isEmpty()) {
                    System.err.println("###");
                } else {
                    Version upperBound;
                    VersionRange upperVersionRange;
                    Version upperBoundVersion;
                    ArrayList versions = new ArrayList(nodePlatformVersions);
                    Version lowerBound = (Version)versions.get(0);
                    VersionRange versionRange = lowerBound.equals(upperBoundVersion = (upperVersionRange = P2Factory.eINSTANCE.createVersionRange(upperBound = (Version)versions.get(versions.size() - 1), VersionSegment.MINOR)).getMaximum()) ? new VersionRange(lowerBound, true, upperBoundVersion, true) : new VersionRange(lowerBound, true, upperBoundVersion, upperVersionRange.getIncludeMaximum());
                    String platformVersion = platformVersionQuery.substring(platformVersionQuery.indexOf(61) + 1);
                    VersionRange minimalRange = P2Factory.eINSTANCE.createVersionRange(Version.create((String)platformVersion), VersionSegment.MINOR);
                    VersionRange intersection = minimalRange.intersect(versionRange);
                    BaseUtil.setAnnotation((ModelElement)stream, (String)"VersionRange", (String)(intersection == null ? "reject" : "accept"), (String)versionRange.toString());
                    if (intersection == null) {
                        BaseUtil.setAnnotation((ModelElement)stream, (String)"VersionRange", (String)"reject", (String)minimalRange.toString());
                    }
                    Requirement platformRequirement = P2Factory.eINSTANCE.createRequirement("org.eclipse.platform.feature.group");
                    requirements.add(0, (Object)platformRequirement);
                }
                project.getStreams().add((Object)stream);
            }
        }
        ArrayList projectList = new ArrayList(projects.values());
        Collections.sort(projectList, new Comparator<Project>(){

            @Override
            public int compare(Project p1, Project p2) {
                return p1.getLabel().compareToIgnoreCase(p2.getLabel());
            }
        });
        Iterator it2 = projectList.iterator();
        while (it2.hasNext()) {
            Stream otherStream;
            Project project = (Project)it2.next();
            EList streams = project.getStreams();
            int size = streams.size();
            if (size == 0) {
                it2.remove();
                continue;
            }
            if (size <= 1 || !normalizeP2Tasks) continue;
            Stream stream = (Stream)streams.get(0);
            EList setupTasks = stream.getSetupTasks();
            boolean allEqual = true;
            int i = 1;
            while (i < size) {
                otherStream = (Stream)streams.get(i);
                if (!EcoreUtil.equals((List)setupTasks, (List)otherStream.getSetupTasks())) {
                    allEqual = false;
                    break;
                }
                ++i;
            }
            if (allEqual) {
                project.getSetupTasks().addAll((Collection)setupTasks);
                i = 1;
                while (i < size) {
                    otherStream = (Stream)streams.get(i);
                    otherStream.getSetupTasks().clear();
                    ++i;
                }
                continue;
            }
            P2Task p2Task = SetupP2Factory.eINSTANCE.createP2Task();
            String label = project.getLabel();
            p2Task.setLabel(label);
            for (Stream s : streams) {
                P2Task streamSetupTask = (P2Task)s.getSetupTasks().get(0);
                streamSetupTask.setLabel(null);
            }
            EList requirements = p2Task.getRequirements();
            P2Task streamP2Task = (P2Task)stream.getSetupTasks().get(0);
            Iterator it22 = streamP2Task.getRequirements().iterator();
            while (it22.hasNext()) {
                P2Task otherStreamP2Task;
                Stream otherStream2;
                Requirement requirement = (Requirement)it22.next();
                ArrayList<Requirement> requirementsToRemove = new ArrayList<Requirement>();
                int i2 = 1;
                while (i2 < size) {
                    otherStream2 = (Stream)streams.get(i2);
                    otherStreamP2Task = (P2Task)otherStream2.getSetupTasks().get(0);
                    for (Requirement otherRequirement : otherStreamP2Task.getRequirements()) {
                        if (!EcoreUtil.equals((EObject)requirement, (EObject)otherRequirement)) continue;
                        requirementsToRemove.add(otherRequirement);
                        break;
                    }
                    ++i2;
                }
                if (requirementsToRemove.size() != size - 1) continue;
                it22.remove();
                requirements.add((Object)requirement);
                i2 = 1;
                while (i2 < size) {
                    otherStream2 = (Stream)streams.get(i2);
                    otherStreamP2Task = (P2Task)otherStream2.getSetupTasks().get(0);
                    otherStreamP2Task.getRequirements().removeAll(requirementsToRemove);
                    ++i2;
                }
            }
            project.getSetupTasks().add((Object)p2Task);
            project.setLabel(String.valueOf(label) + " **");
        }
        Resource output = this.resourceSet.createResource(this.getTargetResourceURI());
        ProjectCatalog projectCatalog = SetupFactory.eINSTANCE.createProjectCatalog();
        projectCatalog.setName("extensions");
        projectCatalog.setLabel("Extensions");
        projectCatalog.getProjects().addAll(projectList);
        output.getContents().add((Object)projectCatalog);
        output.save(null);
        long startTesting = System.currentTimeMillis();
        System.out.println("Loaded repositories : " + (startTesting - startRepositoryLoads) / 1000L);
        this.test();
        long finishTesting = System.currentTimeMillis();
        System.out.println("Testing : " + (finishTesting - startTesting) / 1000L);
    }

    private void generateReport() throws Exception {
        Resource resource = this.resourceSet.getResource(this.getResolvedResourceURI(), true);
        this.generateReport(resource);
    }

    private void generateMinimizedResult() {
        Resource resource = this.resourceSet.getResource(this.getResolvedResourceURI(), true);
        HashSet<Object> objectsToDelete = new HashSet<Object>();
        TreeIterator treeIterator = resource.getAllContents();
        while (treeIterator.hasNext()) {
            EObject eObject = (EObject)treeIterator.next();
            if (eObject instanceof Annotation) {
                Annotation annotation = (Annotation)eObject;
                String source = annotation.getSource();
                if (TAGS_ANNOTATION_SOURCE.equals(source) || CATEGORIES_ANNOTATION_SOURCE.equals(source) || UNSELECTED_ANNOTATION_SOURCE.equals(source) || SELECTED_ANNOTATION_SOURCE.equals(source) || PROCESSING_ANNOTATION_SOURCE.equals(source)) {
                    objectsToDelete.add(annotation);
                    continue;
                }
                if (!"http://www.eclipse.org/oomph/setup/BrandingInfo".equals(source) || !(annotation.eContainer() instanceof Stream)) continue;
                objectsToDelete.add(annotation);
                continue;
            }
            if (!(eObject instanceof BasicEMap.Entry) || !"marketplace".equals(((BasicEMap.Entry)eObject).getKey())) continue;
            objectsToDelete.add(eObject);
        }
        for (EObject eObject : objectsToDelete) {
            EcoreUtil.remove((EObject)eObject);
        }
        resource.setURI(this.getResolvedMinimizedResourceURI());
        try {
            resource.save(Collections.singletonMap("LINE_WIDTH", Integer.MAX_VALUE));
        }
        catch (IOException iOException) {
            throw new IORuntimeException((Throwable)iOException);
        }
    }

    private void dump(EObject eObject) {
        Resource resource;
        if (eObject != null && (resource = eObject.eResource()) != null) {
            HashMap<String, List<EObject>> options = new HashMap<String, List<EObject>>();
            options.put("ROOT_OBJECTS", Collections.singletonList(eObject));
            try {
                resource.save((OutputStream)System.out, options);
                System.out.println();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void test() throws Exception {
        final File installationLocationRoot = new File(this.outputLocation, "installation-test");
        installationLocationRoot.delete();
        installationLocationRoot.mkdirs();
        Resource resource = this.resourceSet.getResource(this.getTargetResourceURI(), true);
        resource.setURI(this.getResolvedResourceURI());
        ProjectCatalog projectCatalog = (ProjectCatalog)resource.getContents().get(0);
        Resource productCatalogResource = this.resourceSet.getResource(URI.createURI((String)"index:/org.eclipse.products.setup"), true);
        Product platformIDEProduct = (Product)productCatalogResource.getEObject("//@products[name='org.eclipse.platform.ide']");
        final LinkedHashMap<String, ProductVersion> productVersions = new LinkedHashMap<String, ProductVersion>();
        for (ProductVersion productVersion : platformIDEProduct.getVersions()) {
            productVersions.put(productVersion.getName(), productVersion);
        }
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 4);
        for (final Project project : projectCatalog.getProjects()) {
            executor.submit(new Runnable(){

                public void run() {
                    for (Stream stream : project.getStreams()) {
                        String state = BaseUtil.getAnnotation((ModelElement)stream, (String)MarketplaceCatalogGenerator.PROCESSING_ANNOTATION_SOURCE, (String)"state");
                        if ("done".equals(state) || "ignored".equals(state)) continue;
                        BaseUtil.setAnnotation((ModelElement)stream, (String)MarketplaceCatalogGenerator.PROCESSING_ANNOTATION_SOURCE, (String)"state", (String)"started");
                        Workspace workspace = SetupContext.createWorkspace();
                        EList workspaceStreams = workspace.getStreams();
                        workspaceStreams.clear();
                        workspaceStreams.add((Object)stream);
                        ProductVersion productVersion = (ProductVersion)productVersions.get(stream.getName());
                        if (productVersion == null) {
                            BaseUtil.setAnnotation((ModelElement)stream, (String)MarketplaceCatalogGenerator.PROCESSING_ANNOTATION_SOURCE, (String)"state", (String)"ignored");
                            continue;
                        }
                        Installation installation = SetupContext.createInstallation();
                        Resource installationResource = MarketplaceCatalogGenerator.this.resourceSet.getResourceFactoryRegistry().getFactory(SetupContext.INSTALLATION_SETUP_FILE_NAME_URI).createResource(SetupContext.INSTALLATION_SETUP_FILE_NAME_URI);
                        installationResource.getContents().add((Object)installation);
                        installation.setProductVersion(productVersion);
                        try {
                            final String location = new File(installationLocationRoot, String.valueOf(productVersion.getQualifiedName()) + "." + stream.getQualifiedName()).toString();
                            SetupPrompter prompter = new SetupPrompter(){

                                public boolean promptVariables(List<? extends SetupTaskContext> performers) {
                                    ArrayList unresolveVariables = new ArrayList();
                                    for (SetupTaskContext setupTaskContext : performers) {
                                        List unresolvedVariables = ((SetupTaskPerformer)setupTaskContext).getUnresolvedVariables();
                                        for (VariableTask variable : unresolvedVariables) {
                                            String value = this.getValue(variable);
                                            if (value != null) continue;
                                            unresolvedVariables.add(variable);
                                        }
                                    }
                                    return unresolveVariables.isEmpty();
                                }

                                public String getValue(VariableTask variable) {
                                    return "installation.location".equals(variable.getName()) ? location : null;
                                }

                                public String getVMPath() {
                                    return null;
                                }

                                public UserCallback getUserCallback() {
                                    return null;
                                }

                                public OS getOS() {
                                    return OS.INSTANCE;
                                }
                            };
                            User user = SetupContext.createUser();
                            SetupContext setupContext = SetupContext.create((Installation)installation, (Workspace)workspace, (User)user);
                            SetupTaskPerformer setupTaskPerformer = SetupTaskPerformer.create((URIConverter)MarketplaceCatalogGenerator.this.resourceSet.getURIConverter(), (SetupPrompter)prompter, (Trigger)Trigger.BOOTSTRAP, (SetupContext)setupContext, (boolean)false);
                            if (setupTaskPerformer == null) {
                                setupTaskPerformer = SetupTaskPerformer.create((URIConverter)MarketplaceCatalogGenerator.this.resourceSet.getURIConverter(), (SetupPrompter)prompter, (Trigger)Trigger.BOOTSTRAP, (SetupContext)setupContext, (boolean)false);
                            }
                            EList triggeredSetupTasks = setupTaskPerformer.getTriggeredSetupTasks();
                            InstallationTask installationTask = (InstallationTask)EcoreUtil.getObjectByType((Collection)triggeredSetupTasks, (EClassifier)SetupPackage.Literals.INSTALLATION_TASK);
                            System.out.println("> " + location);
                            installationTask.setLocation(location);
                            P2Task p2Task = (P2Task)EcoreUtil.getObjectByType((Collection)triggeredSetupTasks, (EClassifier)SetupP2Package.Literals.P2_TASK);
                            boolean hasBogusRepo = false;
                            for (Repository repository : p2Task.getRepositories()) {
                                if (BaseUtil.getAnnotation((ModelElement)repository, (String)"BogusRepo", (String)"message") == null) continue;
                                hasBogusRepo = true;
                                break;
                            }
                            if (!hasBogusRepo) {
                                ProfileTransaction.Resolution bogus = new ProfileTransaction.Resolution(){

                                    public ProfileTransaction getProfileTransaction() {
                                        return null;
                                    }

                                    public IProvisioningPlan getProvisioningPlan() {
                                        return null;
                                    }

                                    public boolean commit(IProgressMonitor monitor) throws CoreException {
                                        return false;
                                    }

                                    public void rollback() {
                                    }
                                };
                                setupTaskPerformer.put(ProfileTransaction.Resolution.class, (Object)bogus);
                                setupTaskPerformer.put((Object)"oomph.p2.pool", (Object)MarketplaceCatalogGenerator.this.poolLocation.toString());
                                p2Task.setLicenseConfirmationDisabled(true);
                                p2Task.perform((SetupTaskContext)setupTaskPerformer);
                                ProfileTransaction.Resolution resolution = (ProfileTransaction.Resolution)setupTaskPerformer.get(ProfileTransaction.Resolution.class);
                                if (resolution == bogus) {
                                    System.err.println("###");
                                }
                                IQueryable futureState = resolution.getProvisioningPlan().getFutureState();
                                IQueryResult query = futureState.query(QueryUtil.createIUQuery((String)"org.eclipse.platform"), null);
                                IInstallableUnit platformIU = (IInstallableUnit)query.iterator().next();
                                BaseUtil.setAnnotation((ModelElement)stream, (String)"Resolved", (String)platformIU.getId(), (String)platformIU.getVersion().toString());
                            }
                        }
                        catch (Exception ex) {
                            BaseUtil.setAnnotation((ModelElement)stream, (String)"Unresolved", (String)"exception", (String)MarketplaceCatalogGenerator.this.buildMessage(ex));
                        }
                        BaseUtil.setAnnotation((ModelElement)stream, (String)MarketplaceCatalogGenerator.PROCESSING_ANNOTATION_SOURCE, (String)"state", (String)"done");
                    }
                }
            });
        }
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.HOURS);
        try {
            resource.save(null);
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    private String buildMessage(Throwable throwable) {
        StringBuilder result = new StringBuilder();
        if (throwable instanceof CoreException) {
            CoreException coreException = (CoreException)throwable;
            IStatus status = coreException.getStatus();
            this.buildMessage(result, "", status);
            result.append(StringUtil.NL);
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        result.append(stringWriter.getBuffer());
        return result.toString();
    }

    private void buildMessage(StringBuilder message, String prefix, IStatus status) {
        message.append(prefix).append(status.getMessage()).append(StringUtil.NL);
        prefix = prefix.length() == 0 ? "  - " : "  " + prefix;
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            this.buildMessage(message, prefix, child);
            ++n2;
        }
    }

    private void generateReport(Resource resource) throws Exception {
        ProjectCatalog projectCatalog = (ProjectCatalog)resource.getContents().get(0);
        HashSet<Project> invalidProjects = new HashSet<Project>();
        HashSet<Stream> invalidStreams = new HashSet<Stream>();
        for (Project project : projectCatalog.getProjects()) {
            boolean printedGeneralListing = false;
            EList setupTasks = project.getSetupTasks();
            if (!setupTasks.isEmpty()) {
                Repository repository;
                P2Task p2Task = (P2Task)setupTasks.get(0);
                EList repositories = p2Task.getRepositories();
                if (!repositories.isEmpty() && !(repository = (Repository)repositories.get(0)).getAnnotations().isEmpty()) {
                    String[] stringArray;
                    invalidProjects.add(project);
                    printedGeneralListing = this.printGeneralListing(project, printedGeneralListing);
                    System.out.println("    invalid-update-site=" + repository.getURL());
                    String message = BaseUtil.getAnnotation((ModelElement)repository, (String)"BogusRepo", (String)"message");
                    if (!StringUtil.isEmpty((String)message) && (stringArray = message.split("\\r?\\n")).length != 0) {
                        String line = stringArray[0];
                        System.out.println("      " + line);
                    }
                }
                for (Requirement requirement : p2Task.getRequirements()) {
                    if (!"BogusIU".equals(BaseUtil.getAnnotation((ModelElement)requirement, (String)"Data", (String)"name"))) continue;
                    invalidProjects.add(project);
                    printedGeneralListing = this.printGeneralListing(project, printedGeneralListing);
                    System.out.println("    invalid-iu=" + requirement.getName());
                }
            }
            for (Stream stream : project.getStreams()) {
                if (stream.getAnnotation("Resolved") == null) {
                    invalidStreams.add(stream);
                }
                String specificListing = BaseUtil.getAnnotation((ModelElement)stream, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"marketplace");
                boolean printedSpecificListing = false;
                EList streamSetupTasks = stream.getSetupTasks();
                if (!streamSetupTasks.isEmpty()) {
                    Repository repository;
                    P2Task p2Task = (P2Task)streamSetupTasks.get(0);
                    Iterator repositories = p2Task.getRepositories();
                    if (!repositories.isEmpty() && !(repository = (Repository)repositories.get(0)).getAnnotations().isEmpty()) {
                        String[] stringArray;
                        printedGeneralListing = this.printGeneralListing(project, printedGeneralListing);
                        System.out.println("    " + specificListing);
                        printedSpecificListing = true;
                        System.out.println("      invalid-update-site=" + repository.getURL());
                        String message = BaseUtil.getAnnotation((ModelElement)repository, (String)"BogusRepo", (String)"message");
                        if (!StringUtil.isEmpty((String)message) && (stringArray = message.split("\\n\\r?")).length != 0) {
                            String line = stringArray[0];
                            System.out.println("      " + line);
                        }
                    }
                    for (Requirement requirement : p2Task.getRequirements()) {
                        if (!"BogusIU".equals(BaseUtil.getAnnotation((ModelElement)requirement, (String)"Data", (String)"name"))) continue;
                        printedGeneralListing = this.printGeneralListing(project, printedGeneralListing);
                        if (!printedSpecificListing) {
                            System.out.println("    " + specificListing);
                            printedSpecificListing = true;
                        }
                        System.out.println("      invalid-iu=" + requirement.getName());
                    }
                }
                for (Annotation annotation : stream.getAnnotations()) {
                    String message = (String)annotation.getDetails().get((Object)"message");
                    if (StringUtil.isEmpty((String)message)) continue;
                    if (!printedSpecificListing) {
                        System.out.println("    " + specificListing);
                        printedSpecificListing = true;
                    }
                    System.out.println("      " + message);
                }
                String exception = BaseUtil.getAnnotation((ModelElement)stream, (String)"Unresolved", (String)"exception");
                if (StringUtil.isEmpty((String)exception)) continue;
                printedGeneralListing = this.printGeneralListing(project, printedGeneralListing);
                if (!printedSpecificListing) {
                    System.out.println("    " + specificListing);
                    printedSpecificListing = true;
                    System.out.println("      Failed Resolution:");
                    printedSpecificListing = true;
                }
                String[] stringArray = exception.split("\\n\\r?");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    if (line.startsWith("  - Missing requirement:")) {
                        System.out.println("      " + line);
                    }
                    ++n2;
                }
            }
        }
        EcoreUtil.deleteAll(invalidStreams, (boolean)false);
        for (Project project : projectCatalog.getProjects()) {
            if (!project.getStreams().isEmpty()) continue;
            invalidProjects.add(project);
        }
        EcoreUtil.deleteAll(invalidProjects, (boolean)false);
        URI uri = resource.getURI();
        resource.setURI(uri.trimSegments(1).appendSegment(String.valueOf(uri.trimFileExtension().lastSegment()) + "-pruned.setup"));
        resource.save(null);
    }

    private boolean printGeneralListing(Project project, boolean printedGeneralListing) {
        if (!printedGeneralListing) {
            String id = BaseUtil.getAnnotation((ModelElement)project, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"marketplaceID");
            System.out.println(id);
            System.out.println("  '" + project.getLabel() + "'");
            String generalListing = BaseUtil.getAnnotation((ModelElement)project, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"marketplace");
            System.out.println("  " + generalListing);
        }
        return true;
    }

    private String getContent(EObject eObject, String feature) {
        List value = (List)this.get(eObject, feature);
        if (value == null) {
            return null;
        }
        return this.getContent((AnyType)value.get(0));
    }

    private String getContent(AnyType anyType) {
        StringBuilder result = new StringBuilder();
        for (FeatureMap.Entry entry : anyType.getMixed()) {
            if (!FeatureMapUtil.isCDATA((FeatureMap.Entry)entry) && !FeatureMapUtil.isText((FeatureMap.Entry)entry)) continue;
            result.append(entry.getValue());
        }
        return result.toString().trim();
    }

    private <T> T get(EObject eObject, String feature) {
        AnyType anyType = (AnyType)eObject;
        FeatureMap anyAttribute = anyType.getAnyAttribute();
        for (FeatureMap.Entry entry : anyAttribute) {
            if (!entry.getEStructuralFeature().getName().equals(feature)) continue;
            Object value = entry.getValue();
            return (T)value;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (FeatureMap.Entry entry : anyType.getMixed()) {
            if (!entry.getEStructuralFeature().getName().equals(feature)) continue;
            values.add(entry.getValue());
        }
        if (values.isEmpty()) {
            return null;
        }
        ArrayList<Object> result = values;
        return (T)result;
    }

    private List<AnyType> get(EObject eObject, String feature, String childFeature) {
        ArrayList<AnyType> result = new ArrayList<AnyType>();
        List values = (List)this.get(eObject, feature);
        if (values != null) {
            for (AnyType anyType : values) {
                List childValues = (List)this.get((EObject)anyType, childFeature);
                result.addAll(childValues);
            }
        }
        return result;
    }

    public void stop() {
    }

    private Set<IInstallableUnit> getIUs(String url, String id) {
        TreeSet<IInstallableUnit> result = new TreeSet<IInstallableUnit>();
        try {
            IMetadataRepository repository = this.repos.get(url);
            if (repository == null && !this.bogusRepos.containsKey(url)) {
                repository = this.manager.loadRepository(new java.net.URI(url), null);
                this.handleComposite(repository, id);
                this.repos.put(url, repository);
                System.err.println("loaded: " + url);
            }
            if (repository != null) {
                IQueryResult ius = repository.query(QueryUtil.createIUQuery((String)id), null);
                for (IInstallableUnit iu : ius) {
                    result.add(iu);
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof ProvisionException && ((ProvisionException)ex).getStatus().getException() instanceof SSLHandshakeException && url.startsWith("http:")) {
                System.err.println("retry without https: " + url);
                String httpsURL = "https:" + url.substring("http:".length());
                Set<IInstallableUnit> ius = this.getIUs(httpsURL, id);
                if (!this.bogusRepos.containsKey(httpsURL)) {
                    this.repos.put(url, this.repos.get(httpsURL));
                    return ius;
                }
            }
            System.err.println("failed: " + url);
            this.repos.put(url, null);
            this.bogusRepos.put(url, ex);
        }
        return result;
    }

    private VersionRange getVersionRange(String url, String id) {
        Version minVersion = null;
        Version maxVersion = null;
        Set<IInstallableUnit> result = this.getIUs(url, id);
        for (IInstallableUnit iu : result) {
            Version version = iu.getVersion();
            if (minVersion == null || version.compareTo((Object)minVersion) < 0) {
                minVersion = version;
            }
            if (maxVersion != null && version.compareTo((Object)maxVersion) <= 0) continue;
            maxVersion = version;
        }
        if (minVersion != null) {
            return new VersionRange(minVersion, true, maxVersion, true);
        }
        return null;
    }

    private String getName(String url, String id) {
        Set<IInstallableUnit> result = this.getIUs(url, id);
        Iterator<IInstallableUnit> iterator = result.iterator();
        if (iterator.hasNext()) {
            IInstallableUnit iu = iterator.next();
            return P2Util.getName((IInstallableUnit)iu);
        }
        return null;
    }

    private void handleComposite(IMetadataRepository repository, String id) {
        if (repository instanceof ICompositeRepository) {
            ICompositeRepository compositeRepository = (ICompositeRepository)repository;
            List children = compositeRepository.getChildren();
            for (java.net.URI uri : children) {
                this.getName(uri.toString(), id);
            }
        }
    }

    private IMetadataRepositoryManager getMetadataRepositoryManager() {
        Agent agent = P2Util.getAgentManager().getBundlePool(this.poolLocation).getAgent();
        IMetadataRepositoryManager manager = agent.getMetadataRepositoryManager();
        return manager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RepositoryLoader
    extends WorkerPool<RepositoryLoader, String, LoadJob> {
        private MarketplaceCatalogGenerator generator;

        public RepositoryLoader(MarketplaceCatalogGenerator generatorx) {
            this.generator = generatorx;
            ReflectUtil.setValue((String)"maxWorker", (Object)((Object)this), (Object)50);
        }

        protected LoadJob createWorker(String key, int workerID, boolean secondary) {
            return new LoadJob(this, key, workerID, secondary);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class LoadJob
        extends WorkerPool.Worker<String, RepositoryLoader> {
            private LoadJob(RepositoryLoader loader, String updateURL, int id, boolean secondary) {
                super("Load " + updateURL, (WorkerPool)loader, (Object)updateURL, id, secondary);
            }

            protected IStatus perform(IProgressMonitor monitor) {
                RepositoryLoader.this.generator.getName((String)this.getKey(), "bogus");
                return Status.OK_STATUS;
            }
        }
    }
}

