/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.oomph.setup.ui.Messages;
import org.eclipse.oomph.setup.ui.P2TaskUIServicesPrompter;
import org.eclipse.oomph.setup.ui.Questionnaire;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.EditorSelectionDialog;

public class SetupPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.oomph.setup.SetupPreferencePage";
    private IWorkbench workbench;
    private ComboFieldEditor p2StartupTasks;
    private BooleanFieldEditor skipStartupTasks;
    private Composite parent;

    public void init(IWorkbench workbench) {
        this.workbench = workbench;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return SetupUIPlugin.INSTANCE.getPreferenceStore();
    }

    protected void createFieldEditors() {
        this.parent = this.getFieldEditorParent();
        this.skipStartupTasks = this.addBooleanField(this.parent, "skip.startup.tasks", Messages.SetupPreferencePage_skipStartupTasks_label, Messages.SetupPreferencePage_skipStartupTasks_tooltip);
        this.p2StartupTasks = new ComboFieldEditor("p2.startup.tasks", Messages.SetupPreferencePage_p2StartupTasks_label, (String[][])new String[][]{{Messages.SetupPreferencePage_p2StartupTasks_prompt, P2TaskUIServicesPrompter.Action.PROMPT.name()}, {Messages.SetupPreferencePage_p2StartupTasks_always, P2TaskUIServicesPrompter.Action.ALWAYS.name()}, {Messages.SetupPreferencePage_p2StartupTasks_never, P2TaskUIServicesPrompter.Action.NEVER.name()}}, this.parent);
        this.addField((FieldEditor)this.p2StartupTasks);
        this.p2StartupTasks.fillIntoGrid(this.parent, 3);
        Label p2StartupTasksLabel = this.p2StartupTasks.getLabelControl(this.parent);
        GridData gridData = (GridData)p2StartupTasksLabel.getLayoutData();
        gridData.horizontalIndent = 20;
        p2StartupTasksLabel.setToolTipText(Messages.SetupPreferencePage_p2StartupTasks_labelTooltip);
        this.p2StartupTasks.setEnabled(!this.skipStartupTasks.getBooleanValue(), this.parent);
        this.addBooleanField(this.parent, "showToolBarContributions", Messages.SetupPreferencePage_showToolbarContributions_label, Messages.SetupPreferencePage_showToolbarContributions_tooltip);
        this.addBooleanField(this.parent, "showProgressInWizard", Messages.SetupPreferencePage_showProgressInWizard_label, Messages.SetupPreferencePage_showProgressInWizard_tooltip);
        StringButtonFieldEditor preferredTextEditor = new StringButtonFieldEditor("preferred.text.editor", Messages.SetupPreferencePage_preferredTextEditor_text, this.parent){

            protected String changePressed() {
                IEditorDescriptor descriptor;
                EditorSelectionDialog dialog = new EditorSelectionDialog(SetupPreferencePage.this.getControl().getShell());
                dialog.setMessage(Messages.SetupPreferencePage_preferredTextEditor_dialogMessage);
                if (dialog.open() == 0 && (descriptor = dialog.getSelectedEditor()) != null) {
                    return descriptor.getId();
                }
                return null;
            }
        };
        this.addField((FieldEditor)preferredTextEditor);
        preferredTextEditor.fillIntoGrid(this.parent, 3);
        preferredTextEditor.getLabelControl(this.parent).setToolTipText(Messages.SetupPreferencePage_preferredTextEditor_labelTooltip);
        if (Questionnaire.exists()) {
            Button questionnaireButton = new Button(this.parent, 8);
            questionnaireButton.setText(Messages.SetupPreferencePage_questionnaireButton_text);
            questionnaireButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Shell shell = SetupPreferencePage.this.workbench.getActiveWorkbenchWindow().getShell();
                    IPreferencePageContainer container = SetupPreferencePage.this.getContainer();
                    if (container instanceof IShellProvider) {
                        shell = ((IShellProvider)container).getShell();
                    }
                    Shell parentShell = shell;
                    Questionnaire.perform(parentShell, true);
                }
            });
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() == this.skipStartupTasks) {
            this.p2StartupTasks.setEnabled(!Boolean.TRUE.equals(event.getNewValue()), this.parent);
        }
    }

    private BooleanFieldEditor addBooleanField(Composite parent, String preferenceName, String label, String toolTip) {
        BooleanFieldEditor fieldEditor = new BooleanFieldEditor(preferenceName, label, parent);
        fieldEditor.fillIntoGrid(parent, 3);
        this.addField((FieldEditor)fieldEditor);
        fieldEditor.getDescriptionControl(parent).setToolTipText(toolTip);
        return fieldEditor;
    }
}

