/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Arrays;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkEventFocus;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoRectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class Text
extends Scrollable {
    long bufferHandle;
    long imContext;
    int tabs = 8;
    int lastEventTime = 0;
    long gdkEventKey = 0L;
    int fixStart = -1;
    int fixEnd = -1;
    boolean doubleClick;
    String message = "";
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    int[] segments;
    static final int ITER_SIZEOF = GTK.GtkTextIter_sizeof();
    static final int SPACE_FOR_CURSOR = 1;
    public static final int LIMIT = Integer.MAX_VALUE;
    public static final String DELIMITER = "\n";
    GdkRGBA background;
    GdkRGBA foreground;
    long indexMark = 0L;
    double cachedAdjustment;
    double currentAdjustment;

    public Text(Composite parent, int style) {
        super(parent, Text.checkStyle(style));
        if ((style & 0x80) != 0) {
            this.style |= 0x300;
            if ((style & 0x200) == 0) {
                this.style &= 0xFFFFFDFF;
                GTK.gtk_entry_set_icon_from_icon_name(this.handle, 0, null);
            } else {
                GTK.gtk_entry_set_icon_activatable(this.handle, 0, true);
                GTK.gtk_entry_set_icon_sensitive(this.handle, 0, true);
            }
            if ((style & 0x100) == 0) {
                this.style &= 0xFFFFFEFF;
            }
        }
    }

    static int checkStyle(int style) {
        if ((style & 0x80) != 0) {
            style |= 0x804;
            style &= 0xFFBFFFFF;
        }
        if ((style & 4) != 0 && (style & 2) != 0) {
            style &= 0xFFFFFFFD;
        }
        if (((style = Text.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            style &= 0xFFFFFCBF;
        }
        if ((style & 0x40) != 0) {
            style |= 2;
            style &= 0xFFFFFEFF;
        }
        if ((style & 2) != 0) {
            style &= 0xFFBFFFFF;
        }
        if ((style & 6) != 0) {
            return style;
        }
        if ((style & 0x300) != 0) {
            return style | 2;
        }
        return style | 4;
    }

    @Override
    void createHandle(int index) {
        this.state |= 0x28;
        if ((this.style & 8) != 0 && this.applyThemeBackground() == 1) {
            this.state |= 0x10000;
        }
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        this.gtk_widget_set_has_surface_or_window(this.fixedHandle, true);
        if ((this.style & 4) != 0) {
            this.handle = (this.style & 0x80) != 0 ? GTK.gtk_search_entry_new() : GTK.gtk_entry_new();
            if (this.handle == 0L) {
                this.error(2);
            }
            GTK.gtk_container_add(this.fixedHandle, this.handle);
            GTK.gtk_editable_set_editable(this.handle, (this.style & 8) == 0);
            if ((this.style & 0x800) == 0) {
                GTK.gtk_entry_set_has_frame(this.handle, false);
                long context = GTK.gtk_widget_get_style_context(this.handle);
                String background = this.display.gtk_rgba_to_css_string(this.display.COLOR_LIST_BACKGROUND_RGBA);
                this.gtk_css_provider_load_from_css(context, "entry {border: solid; background: " + background + ";}");
                GTK.gtk_style_context_invalidate(context);
            }
            GTK.gtk_entry_set_visibility(this.handle, (this.style & 0x400000) == 0);
            float alignment = 0.0f;
            if ((this.style & 0x1000000) != 0) {
                alignment = 0.5f;
            }
            if ((this.style & 0x20000) != 0) {
                alignment = 1.0f;
            }
            if (alignment > 0.0f) {
                GTK.gtk_entry_set_alignment(this.handle, alignment);
            }
        } else {
            this.scrolledHandle = GTK.gtk_scrolled_window_new(0L, 0L);
            if (this.scrolledHandle == 0L) {
                this.error(2);
            }
            this.handle = GTK.gtk_text_view_new();
            if (this.handle == 0L) {
                this.error(2);
            }
            this.bufferHandle = GTK.gtk_text_view_get_buffer(this.handle);
            if (this.bufferHandle == 0L) {
                this.error(2);
            }
            GTK.gtk_container_add(this.fixedHandle, this.scrolledHandle);
            GTK.gtk_container_add(this.scrolledHandle, this.handle);
            GTK.gtk_text_view_set_editable(this.handle, (this.style & 8) == 0);
            if ((this.style & 0x40) != 0) {
                GTK.gtk_text_view_set_wrap_mode(this.handle, 3);
            }
            int hsp = (this.style & 0x100) != 0 ? 0 : 2;
            int vsp = (this.style & 0x200) != 0 ? 0 : 2;
            GTK.gtk_scrolled_window_set_policy(this.scrolledHandle, hsp, vsp);
            if ((this.style & 0x800) != 0) {
                GTK.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
            }
            int just = 0;
            if ((this.style & 0x1000000) != 0) {
                just = 2;
            }
            if ((this.style & 0x20000) != 0) {
                just = 1;
            }
            GTK.gtk_text_view_set_justification(this.handle, just);
        }
        this.imContext = OS.imContextLast();
        if ((this.style & 4) != 0) {
            GTK.gtk_entry_set_width_chars(this.handle, 1);
        }
        this.setFontDescription(this.defaultFont().handle);
    }

    @Override
    int applyThemeBackground() {
        return this.backgroundAlpha == 0 || (this.style & 0xB00) == 0 ? 1 : 0;
    }

    @Override
    void createWidget(int index) {
        super.createWidget(index);
        this.doubleClick = true;
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSegmentListener(SegmentListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.addListener(49, new TypedListener(listener));
        this.clearSegments(true);
        this.applySegments();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(string, false);
        this.clearSegments(true);
        if ((this.style & 4) != 0) {
            GTK.gtk_editable_insert_text(this.handle, buffer, buffer.length, new int[]{-1});
            GTK.gtk_editable_set_position(this.handle, -1);
        } else {
            byte[] position = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_end_iter(this.bufferHandle, position);
            GTK.gtk_text_buffer_insert(this.bufferHandle, position, buffer, buffer.length);
            GTK.gtk_text_buffer_place_cursor(this.bufferHandle, position);
            long mark = GTK.gtk_text_buffer_get_insert(this.bufferHandle);
            GTK.gtk_text_view_scroll_to_mark(this.handle, mark, 0.0, true, 0.0, 0.0);
        }
        this.applySegments();
    }

    void applySegments() {
        String string;
        if (this.isDisposed() || !this.hooks(49) && !this.filters(49)) {
            return;
        }
        Event event = new Event();
        event.text = string = this.getText();
        event.segments = this.segments;
        this.sendEvent(49, event);
        this.segments = event.segments;
        if (this.segments == null) {
            return;
        }
        int nSegments = this.segments.length;
        if (nSegments == 0) {
            return;
        }
        int i = 1;
        int length = string == null ? 0 : string.length();
        while (i < nSegments) {
            if (event.segments[i] < event.segments[i - 1] || event.segments[i] > length) {
                this.error(5);
            }
            ++i;
        }
        char[] segmentsChars = event.segmentsChars;
        char[] separator = new char[]{this.getOrientation() == 0x4000000 ? (char)'\u200f' : '\u200e'};
        if ((this.style & 4) != 0) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
            int limit = GTK.gtk_entry_get_max_length(this.handle);
            if (limit != 0) {
                GTK.gtk_entry_set_max_length(this.handle, this.translateOffset(limit));
            }
            int[] pos = new int[1];
            int i2 = 0;
            while (i2 < nSegments) {
                pos[0] = this.segments[i2] + i2;
                if (segmentsChars != null && segmentsChars.length > i2) {
                    separator[0] = segmentsChars[i2];
                }
                byte[] buffer = Converter.wcsToMbcs(separator, false);
                long ptr = GTK.gtk_entry_get_text(this.handle);
                pos[0] = (int)OS.g_utf16_offset_to_utf8_offset(ptr, pos[0]);
                GTK.gtk_editable_insert_text(this.handle, buffer, buffer.length, pos);
                ++i2;
            }
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
        } else {
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            byte[] pos = new byte[ITER_SIZEOF];
            byte[] startIter = new byte[ITER_SIZEOF];
            byte[] endIter = new byte[ITER_SIZEOF];
            int i3 = 0;
            while (i3 < nSegments) {
                GTK.gtk_text_buffer_get_bounds(this.bufferHandle, startIter, endIter);
                long ptr = GTK.gtk_text_buffer_get_text(this.bufferHandle, startIter, endIter, true);
                GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, pos, (int)OS.g_utf16_offset_to_utf8_offset(ptr, this.segments[i3] + i3));
                OS.g_free(ptr);
                if (segmentsChars != null && segmentsChars.length > i3) {
                    separator[0] = segmentsChars[i3];
                }
                byte[] buffer = Converter.wcsToMbcs(separator, false);
                GTK.gtk_text_buffer_insert(this.bufferHandle, pos, buffer, buffer.length);
                ++i3;
            }
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
        }
    }

    void clearSegments(boolean applyText) {
        if (this.segments == null) {
            return;
        }
        int nSegments = this.segments.length;
        if (nSegments == 0) {
            return;
        }
        if ((this.style & 4) != 0) {
            int limit;
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            if (applyText) {
                OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
                long ptr = GTK.gtk_entry_get_text(this.handle);
                int i = 0;
                while (i < nSegments) {
                    int start = (int)OS.g_utf16_offset_to_utf8_offset(ptr, this.segments[i]);
                    int end = (int)OS.g_utf16_offset_to_utf8_offset(ptr, this.segments[i] + 1);
                    GTK.gtk_editable_delete_text(this.handle, start, end);
                    ++i;
                }
                OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
            }
            if ((limit = GTK.gtk_entry_get_max_length(this.handle)) != 0) {
                GTK.gtk_entry_set_max_length(this.handle, this.untranslateOffset(limit));
            }
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        } else if (applyText) {
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 12L);
            byte[] start = new byte[ITER_SIZEOF];
            byte[] end = new byte[ITER_SIZEOF];
            byte[] startIter = new byte[ITER_SIZEOF];
            byte[] endIter = new byte[ITER_SIZEOF];
            int i = 0;
            while (i < nSegments) {
                GTK.gtk_text_buffer_get_bounds(this.bufferHandle, startIter, endIter);
                long ptr = GTK.gtk_text_buffer_get_text(this.bufferHandle, startIter, endIter, true);
                GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, start, (int)OS.g_utf16_offset_to_utf8_offset(ptr, this.segments[i]));
                GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, end, (int)OS.g_utf16_offset_to_utf8_offset(ptr, this.segments[i] + 1));
                GTK.gtk_text_buffer_delete(this.bufferHandle, start, end);
                OS.g_free(ptr);
                ++i;
            }
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 12L);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
        }
        this.segments = null;
    }

    public void clearSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int position = GTK.gtk_editable_get_position(this.handle);
            GTK.gtk_editable_select_region(this.handle, position, position);
        } else {
            byte[] position = new byte[ITER_SIZEOF];
            long insertMark = GTK.gtk_text_buffer_get_insert(this.bufferHandle);
            GTK.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, position, insertMark);
            GTK.gtk_text_buffer_select_range(this.bufferHandle, position, position);
        }
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        int[] w = new int[1];
        int[] h = new int[1];
        if ((this.style & 4) != 0) {
            GTK.gtk_widget_realize(this.handle);
            long layout = GTK.gtk_entry_get_layout(this.handle);
            OS.pango_layout_get_pixel_size(layout, w, h);
        } else {
            byte[] start = new byte[ITER_SIZEOF];
            byte[] end = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_bounds(this.bufferHandle, start, end);
            long text = GTK.gtk_text_buffer_get_text(this.bufferHandle, start, end, true);
            long layout = GTK.gtk_widget_create_pango_layout(this.handle, text);
            OS.g_free(text);
            OS.pango_layout_set_width(layout, wHint * 1024);
            OS.pango_layout_get_pixel_size(layout, w, h);
            OS.g_object_unref(layout);
        }
        int width = w[0];
        int height = h[0];
        if ((this.style & 4) != 0 && this.message.length() > 0) {
            byte[] buffer = Converter.wcsToMbcs(this.message, true);
            long layout = GTK.gtk_widget_create_pango_layout(this.handle, buffer);
            Arrays.fill(buffer, (byte)0);
            OS.pango_layout_get_pixel_size(layout, w, h);
            OS.g_object_unref(layout);
            width = Math.max(width, w[0]);
        }
        if ((this.style & 0x80) != 0) {
            GtkBorder tmp = new GtkBorder();
            long context = GTK.gtk_widget_get_style_context(this.handle);
            int state_flag = GTK.gtk_widget_get_state_flags(this.handle);
            this.gtk_style_context_get_padding(context, state_flag, tmp);
            width += tmp.left + tmp.right;
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        width = wHint == -1 ? width : wHint;
        height = hHint == -1 ? height : hHint;
        Rectangle trim = this.computeTrimInPixels(0, 0, width, height);
        return new Point(trim.width, trim.height);
    }

    @Override
    Rectangle computeTrimInPixels(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle trim = super.computeTrimInPixels(x, y, width, height);
        int xborder = 0;
        int yborder = 0;
        if ((this.style & 4) != 0) {
            GtkBorder tmp = new GtkBorder();
            long context = GTK.gtk_widget_get_style_context(this.handle);
            int state_flag = GTK.gtk_widget_get_state_flags(this.handle);
            this.gtk_style_context_get_padding(context, state_flag, tmp);
            trim.x -= tmp.left;
            trim.y -= tmp.top;
            trim.width += tmp.left + tmp.right;
            if (tmp.bottom == 0 && tmp.top == 0) {
                Point widthNative = this.computeNativeSize(this.handle, trim.width, -1, true);
                trim.height = widthNative.y;
            } else {
                trim.height += tmp.top + tmp.bottom;
            }
            if ((this.style & 0x800) != 0) {
                int state = GTK.gtk_widget_get_state_flags(this.handle);
                this.gtk_style_context_get_border(context, state, tmp);
                trim.x -= tmp.left;
                trim.y -= tmp.top;
                trim.width += tmp.left + tmp.right;
                trim.height += tmp.top + tmp.bottom;
            }
            GdkRectangle icon_area = new GdkRectangle();
            GTK.gtk_entry_get_icon_area(this.handle, 0, icon_area);
            trim.x -= icon_area.width;
            trim.width += icon_area.width;
            GTK.gtk_entry_get_icon_area(this.handle, 1, icon_area);
            trim.width += icon_area.width;
        } else {
            int borderWidth = this.gtk_container_get_border_width_or_margin(this.handle);
            xborder += borderWidth;
            yborder += borderWidth;
        }
        if (!GTK.GTK4) {
            int[] property = new int[1];
            GTK.gtk_widget_style_get(this.handle, OS.interior_focus, property, 0L);
            if (property[0] == 0) {
                GTK.gtk_widget_style_get(this.handle, OS.focus_line_width, property, 0L);
                xborder += property[0];
                yborder += property[0];
            }
        }
        trim.x -= xborder;
        trim.y -= yborder;
        trim.width += 2 * xborder;
        trim.height += 2 * yborder;
        ++trim.width;
        return new Rectangle(trim.x, trim.y, trim.width, trim.height);
    }

    public void copy() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            GTK.gtk_editable_copy_clipboard(this.handle);
        } else {
            long clipboard = GTK.GTK4 ? GDK.gdk_display_get_clipboard(GDK.gdk_display_get_default()) : GTK.gtk_clipboard_get(0L);
            this.clearSegments(true);
            GTK.gtk_text_buffer_copy_clipboard(this.bufferHandle, clipboard);
            this.applySegments();
        }
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            GTK.gtk_editable_cut_clipboard(this.handle);
        } else {
            long clipboard = GTK.GTK4 ? GDK.gdk_display_get_clipboard(GDK.gdk_display_get_default()) : GTK.gtk_clipboard_get(0L);
            this.clearSegments(true);
            GTK.gtk_text_buffer_cut_clipboard(this.bufferHandle, clipboard, GTK.gtk_text_view_get_editable(this.handle));
            this.applySegments();
        }
    }

    char[] deprocessText(char[] text, int start, int end) {
        int nSegments;
        if (text == null) {
            return new char[0];
        }
        if (start < 0) {
            start = 0;
        }
        int length = text.length;
        if (end == -1) {
            end = start + length;
        }
        if (this.segments != null && end > this.segments[0] && (nSegments = this.segments.length) > 0 && start <= this.segments[nSegments - 1]) {
            int nLeadSegments = 0;
            while (start - nLeadSegments > this.segments[nLeadSegments]) {
                ++nLeadSegments;
            }
            int segmentCount = nLeadSegments;
            int i = start;
            while (i < end) {
                if (segmentCount < nSegments && i - segmentCount == this.segments[segmentCount]) {
                    ++segmentCount;
                } else {
                    text[i - segmentCount + nLeadSegments - start] = text[i - start];
                }
                ++i;
            }
            length = end - start - segmentCount + nLeadSegments;
        }
        if (start != 0 || end != start + length) {
            char[] newText = new char[length];
            System.arraycopy(text, 0, newText, 0, length);
            return newText;
        }
        return text;
    }

    @Override
    GdkRGBA defaultBackground() {
        return this.display.getSystemColor((int)25).handle;
    }

    @Override
    void deregister() {
        long imContext;
        super.deregister();
        if (this.bufferHandle != 0L) {
            this.display.removeWidget(this.bufferHandle);
        }
        if ((imContext = this.imContext()) != 0L) {
            this.display.removeWidget(imContext);
        }
    }

    @Override
    boolean dragDetect(int x, int y, boolean filter, boolean dragOnTimeout, boolean[] consume) {
        return false;
    }

    @Override
    long eventWindow() {
        if ((this.style & 4) != 0) {
            long window = super.paintWindow();
            long children = GDK.gdk_window_get_children(window);
            if (children != 0L) {
                do {
                    window = OS.g_list_data(children);
                } while ((children = OS.g_list_next(children)) != 0L);
            }
            OS.g_list_free(children);
            return window;
        }
        return this.paintWindow();
    }

    @Override
    boolean filterKey(int keyval, long event) {
        int time = GDK.gdk_event_get_time(event);
        if (time != this.lastEventTime) {
            this.lastEventTime = time;
            long imContext = this.imContext();
            if (imContext != 0L) {
                return GTK.gtk_im_context_filter_keypress(imContext, event);
            }
        }
        this.gdkEventKey = event;
        return false;
    }

    void fixIM() {
        long imContext;
        if (this.gdkEventKey != 0L && this.gdkEventKey != -1L && (imContext = this.imContext()) != 0L) {
            GTK.gtk_im_context_filter_keypress(imContext, this.gdkEventKey);
            this.gdkEventKey = -1L;
            return;
        }
        this.gdkEventKey = 0L;
    }

    @Override
    int getBorderWidthInPixels() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return super.getBorderWidthInPixels();
        }
        if ((this.style & 0x800) != 0) {
            return this.getThickness((long)this.handle).x;
        }
        return 0;
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        byte[] position = new byte[ITER_SIZEOF];
        long mark = GTK.gtk_text_buffer_get_insert(this.bufferHandle);
        GTK.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, position, mark);
        return GTK.gtk_text_iter_get_line(position);
    }

    public Point getCaretLocation() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getCaretLocationInPixels());
    }

    Point getCaretLocationInPixels() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int index = GTK.gtk_editable_get_position(this.handle);
            index = GTK.gtk_entry_text_index_to_layout_index(this.handle, index);
            int[] offset_x = new int[1];
            int[] offset_y = new int[1];
            GTK.gtk_entry_get_layout_offsets(this.handle, offset_x, offset_y);
            long layout = GTK.gtk_entry_get_layout(this.handle);
            PangoRectangle pos = new PangoRectangle();
            OS.pango_layout_index_to_pos(layout, index, pos);
            int x = offset_x[0] + OS.PANGO_PIXELS(pos.x) - this.getBorderWidthInPixels();
            int y = offset_y[0] + OS.PANGO_PIXELS(pos.y);
            return new Point(x, y);
        }
        byte[] position = new byte[ITER_SIZEOF];
        long mark = GTK.gtk_text_buffer_get_insert(this.bufferHandle);
        GTK.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, position, mark);
        GdkRectangle rect = new GdkRectangle();
        GTK.gtk_text_view_get_iter_location(this.handle, position, rect);
        int[] x = new int[1];
        int[] y = new int[1];
        GTK.gtk_text_view_buffer_to_window_coords(this.handle, 2, rect.x, rect.y, x, y);
        return new Point(x[0], y[0]);
    }

    public int getCaretPosition() {
        int result;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            long ptr = GTK.gtk_entry_get_text(this.handle);
            result = (int)OS.g_utf8_offset_to_utf16_offset(ptr, GTK.gtk_editable_get_position(this.handle));
        } else {
            byte[] position = new byte[ITER_SIZEOF];
            long mark = GTK.gtk_text_buffer_get_insert(this.bufferHandle);
            GTK.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, position, mark);
            byte[] zero = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, zero, 0);
            long ptr = GTK.gtk_text_buffer_get_text(this.bufferHandle, zero, position, true);
            result = (int)OS.g_utf8_offset_to_utf16_offset(ptr, GTK.gtk_text_iter_get_offset(position));
            OS.g_free(ptr);
        }
        return this.untranslateOffset(result);
    }

    public int getCharCount() {
        int result;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            long ptr = GTK.gtk_entry_get_text(this.handle);
            result = (int)OS.g_utf16_strlen(ptr, -1L);
        } else {
            byte[] startIter = new byte[ITER_SIZEOF];
            byte[] endIter = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_bounds(this.bufferHandle, startIter, endIter);
            long ptr = GTK.gtk_text_buffer_get_text(this.bufferHandle, startIter, endIter, true);
            result = (int)OS.g_utf16_strlen(ptr, -1L);
            OS.g_free(ptr);
        }
        return this.untranslateOffset(result);
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClick;
    }

    public char getEchoChar() {
        this.checkWidget();
        if ((this.style & 4) != 0 && !GTK.gtk_entry_get_visibility(this.handle)) {
            return GTK.gtk_entry_get_invisible_char(this.handle);
        }
        return '\u0000';
    }

    public boolean getEditable() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return GTK.gtk_editable_get_editable(this.handle);
        }
        return GTK.gtk_text_view_get_editable(this.handle);
    }

    public int getLineCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 1;
        }
        return GTK.gtk_text_buffer_get_line_count(this.bufferHandle);
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return "\n";
    }

    public int getLineHeight() {
        this.checkWidget();
        return this.fontHeight(this.getFontDescription(), this.handle);
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    @Override
    public int getOrientation() {
        return super.getOrientation();
    }

    int getPosition(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int position = -1;
        if ((this.style & 4) != 0) {
            int[] index = new int[1];
            int[] trailing = new int[1];
            long layout = GTK.gtk_entry_get_layout(this.handle);
            OS.pango_layout_xy_to_index(layout, point.x * 1024, point.y * 1024, index, trailing);
            long ptr = OS.pango_layout_get_text(layout);
            position = (int)OS.g_utf16_pointer_to_offset(ptr, ptr + (long)index[0]) + trailing[0];
        } else {
            byte[] p = new byte[ITER_SIZEOF];
            GTK.gtk_text_view_get_iter_at_location(this.handle, p, point.x, point.y);
            byte[] zero = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, zero, 0);
            long ptr = GTK.gtk_text_buffer_get_text(this.bufferHandle, zero, p, true);
            position = (int)OS.g_utf8_offset_to_utf16_offset(ptr, GTK.gtk_text_iter_get_offset(p));
            OS.g_free(ptr);
        }
        return this.untranslateOffset(position);
    }

    public Point getSelection() {
        Point selection;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int[] start = new int[1];
            int[] end = new int[1];
            GTK.gtk_editable_get_selection_bounds(this.handle, start, end);
            long ptr = GTK.gtk_entry_get_text(this.handle);
            start[0] = (int)OS.g_utf8_offset_to_utf16_offset(ptr, start[0]);
            end[0] = (int)OS.g_utf8_offset_to_utf16_offset(ptr, end[0]);
            selection = new Point(start[0], end[0]);
        } else {
            byte[] startIter = new byte[ITER_SIZEOF];
            byte[] endIter = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_selection_bounds(this.bufferHandle, startIter, endIter);
            byte[] zero = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, zero, 0);
            long ptr = GTK.gtk_text_buffer_get_text(this.bufferHandle, zero, endIter, true);
            int start = (int)OS.g_utf8_offset_to_utf16_offset(ptr, GTK.gtk_text_iter_get_offset(startIter));
            int end = (int)OS.g_utf8_offset_to_utf16_offset(ptr, GTK.gtk_text_iter_get_offset(endIter));
            OS.g_free(ptr);
            selection = new Point(start, end);
        }
        selection.x = this.untranslateOffset(selection.x);
        selection.y = this.untranslateOffset(selection.y);
        return selection;
    }

    public int getSelectionCount() {
        this.checkWidget();
        Point selection = this.getSelection();
        return Math.abs(selection.y - selection.x);
    }

    public String getSelectionText() {
        this.checkWidget();
        Point selection = this.getSelection();
        return this.getText().substring(selection.x, selection.y);
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabs;
    }

    int getTabWidth(int tabs) {
        byte[] buffer = Converter.wcsToMbcs(" ", true);
        long layout = GTK.gtk_widget_create_pango_layout(this.handle, buffer);
        int[] width = new int[1];
        int[] height = new int[1];
        OS.pango_layout_get_size(layout, width, height);
        OS.g_object_unref(layout);
        return width[0] * tabs;
    }

    public String getText() {
        return new String(this.getTextChars());
    }

    public String getText(int start, int end) {
        this.checkWidget();
        if (start > end || end < 0) {
            return "";
        }
        String str = this.getText();
        int length = str.length();
        if (start > (end = Math.min(end, length - 1))) {
            return "";
        }
        start = Math.max(0, start);
        return str.substring(start, end + 1);
    }

    public char[] getTextChars() {
        long address;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            address = GTK.gtk_entry_get_text(this.handle);
        } else {
            byte[] start = new byte[ITER_SIZEOF];
            byte[] end = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_bounds(this.bufferHandle, start, end);
            address = GTK.gtk_text_buffer_get_text(this.bufferHandle, start, end, true);
        }
        if (address == 0L) {
            return new char[0];
        }
        int length = C.strlen(address);
        byte[] buffer = new byte[length];
        C.memmove(buffer, address, (long)length);
        if ((this.style & 2) != 0) {
            OS.g_free(address);
        }
        char[] result = Converter.mbcsToWcs(buffer);
        Arrays.fill(buffer, (byte)0);
        if (this.segments != null) {
            result = this.deprocessText(result, 0, -1);
        }
        return result;
    }

    public int getTextLimit() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return LIMIT;
        }
        int limit = GTK.gtk_entry_get_max_length(this.handle);
        return limit == 0 ? 65535 : this.untranslateOffset(limit);
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        byte[] position = new byte[ITER_SIZEOF];
        long vAdjustment = GTK.gtk_scrollable_get_vadjustment(this.handle);
        this.currentAdjustment = GTK.gtk_adjustment_get_value(vAdjustment);
        if (this.cachedAdjustment == this.currentAdjustment && this.indexMark != 0L) {
            GTK.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, position, this.indexMark);
            return GTK.gtk_text_iter_get_line(position);
        }
        GdkRectangle rect = new GdkRectangle();
        GTK.gtk_text_view_get_visible_rect(this.handle, rect);
        GTK.gtk_text_view_get_line_at_y(this.handle, position, rect.y, null);
        return GTK.gtk_text_iter_get_line(position);
    }

    public int getTopPixel() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getTopPixelInPixels());
    }

    int getTopPixelInPixels() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        byte[] position = new byte[ITER_SIZEOF];
        GdkRectangle rect = new GdkRectangle();
        GTK.gtk_text_view_get_visible_rect(this.handle, rect);
        int[] lineTop = new int[1];
        GTK.gtk_text_view_get_line_at_y(this.handle, position, rect.y, lineTop);
        return lineTop[0];
    }

    @Override
    long gtk_activate(long widget) {
        this.sendSelectionEvent(14);
        return 0L;
    }

    @Override
    long gtk_button_press_event(long widget, long event) {
        long result = super.gtk_button_press_event(widget, event);
        if (result != 0L) {
            return result;
        }
        int eventType = GDK.gdk_event_get_event_type(event);
        if (!this.doubleClick) {
            switch (eventType) {
                case 5: 
                case 6: {
                    return 1L;
                }
            }
        }
        return result;
    }

    @Override
    long gtk_changed(long widget) {
        boolean keyPress = false;
        long eventPtr = GTK.gtk_get_current_event();
        if (eventPtr != 0L) {
            int eventType = GDK.gdk_event_get_event_type(eventPtr);
            eventType = Text.fixGdkEventTypeValues(eventType);
            switch (eventType) {
                case 8: {
                    keyPress = true;
                }
            }
            this.gdk_event_free(eventPtr);
        }
        if (keyPress) {
            this.postEvent(24);
        } else {
            this.sendEvent(24);
        }
        if ((this.style & 0x80) != 0 && (this.style & 0x100) == 0) {
            GTK.gtk_entry_set_icon_from_icon_name(this.handle, 1, null);
        }
        return 0L;
    }

    @Override
    long gtk_commit(long imContext, long text) {
        if (text == 0L) {
            return 0L;
        }
        if ((this.style & 4) != 0 && !GTK.gtk_editable_get_editable(this.handle)) {
            return 0L;
        }
        int length = C.strlen(text);
        if (length == 0) {
            return 0L;
        }
        byte[] buffer = new byte[length];
        C.memmove(buffer, text, (long)length);
        char[] chars = Converter.mbcsToWcs(buffer);
        Arrays.fill(buffer, (byte)0);
        char[] newChars = this.sendIMKeyEvent(1, 0L, chars);
        if (newChars == null) {
            return 0L;
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        OS.g_signal_handlers_block_matched(imContext, 16, 0, 0, 0L, 0L, 9L);
        int id = OS.g_signal_lookup(OS.commit, GTK.gtk_im_context_get_type());
        int mask = 17;
        OS.g_signal_handlers_unblock_matched(imContext, mask, id, 0, 0L, 0L, this.handle);
        if (newChars == chars) {
            OS.g_signal_emit_by_name(imContext, OS.commit, text);
        } else {
            buffer = Converter.wcsToMbcs(newChars, true);
            OS.g_signal_emit_by_name(imContext, OS.commit, buffer);
            Arrays.fill(buffer, (byte)0);
        }
        OS.g_signal_handlers_unblock_matched(imContext, 16, 0, 0, 0L, 0L, 9L);
        OS.g_signal_handlers_block_matched(imContext, mask, id, 0, 0L, 0L, this.handle);
        if ((this.style & 4) != 0 && this.fixStart != -1 && this.fixEnd != -1) {
            GTK.gtk_editable_set_position(this.handle, this.fixStart);
            GTK.gtk_editable_select_region(this.handle, this.fixStart, this.fixEnd);
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        return 0L;
    }

    @Override
    long gtk_delete_range(long widget, long iter1, long iter2) {
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        byte[] startIter = new byte[ITER_SIZEOF];
        byte[] endIter = new byte[ITER_SIZEOF];
        C.memmove(startIter, iter1, (long)startIter.length);
        C.memmove(endIter, iter2, (long)endIter.length);
        int start = GTK.gtk_text_iter_get_offset(startIter);
        int end = GTK.gtk_text_iter_get_offset(endIter);
        byte[] zero = new byte[ITER_SIZEOF];
        GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, zero, 0);
        long ptr = GTK.gtk_text_buffer_get_text(this.bufferHandle, zero, endIter, true);
        start = (int)OS.g_utf8_offset_to_utf16_offset(ptr, start);
        end = (int)OS.g_utf8_offset_to_utf16_offset(ptr, end);
        OS.g_free(ptr);
        String newText = this.verifyText("", start, end);
        if (newText == null) {
            GTK.gtk_text_buffer_get_selection_bounds(this.bufferHandle, startIter, endIter);
            start = GTK.gtk_text_iter_get_offset(startIter);
            end = GTK.gtk_text_iter_get_offset(endIter);
            if (start != end) {
                this.fixStart = start;
                this.fixEnd = end;
            }
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.delete_range);
        } else if (newText.length() > 0) {
            byte[] buffer = Converter.wcsToMbcs(newText, false);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 12L);
            GTK.gtk_text_buffer_delete(this.bufferHandle, startIter, endIter);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 12L);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            GTK.gtk_text_buffer_insert(this.bufferHandle, startIter, buffer, buffer.length);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.delete_range);
            Arrays.fill(buffer, (byte)0);
        }
        return 0L;
    }

    @Override
    long gtk_delete_text(long widget, long start_pos, long end_pos) {
        int end;
        int start;
        String newText;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        long ptr = GTK.gtk_entry_get_text(this.handle);
        if (end_pos == -1L) {
            end_pos = OS.g_utf8_strlen(ptr, -1L);
        }
        if ((newText = this.verifyText("", start = (int)OS.g_utf8_offset_to_utf16_offset(ptr, start_pos), end = (int)OS.g_utf8_offset_to_utf16_offset(ptr, end_pos))) == null) {
            int[] newStart = new int[1];
            int[] newEnd = new int[1];
            GTK.gtk_editable_get_selection_bounds(this.handle, newStart, newEnd);
            if (newStart[0] != newEnd[0]) {
                this.fixStart = newStart[0];
                this.fixEnd = newEnd[0];
            }
            OS.g_signal_stop_emission_by_name(this.handle, OS.delete_text);
        } else if (newText.length() > 0) {
            int[] pos = new int[]{(int)end_pos};
            byte[] buffer = Converter.wcsToMbcs(newText, false);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
            GTK.gtk_editable_insert_text(this.handle, buffer, buffer.length, pos);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_editable_set_position(this.handle, pos[0]);
            Arrays.fill(buffer, (byte)0);
        }
        return 0L;
    }

    @Override
    long gtk_event_after(long widget, long gdkEvent) {
        if (this.cursor != null) {
            this.setCursor(this.cursor.handle);
        }
        if ((this.style & 4) != 0 && this.display.entrySelectOnFocus) {
            int eventType = GDK.gdk_event_get_event_type(gdkEvent);
            eventType = Text.fixGdkEventTypeValues(eventType);
            switch (eventType) {
                case 12: {
                    boolean[] focusIn = new boolean[1];
                    if (GTK.GTK4) {
                        GDK.gdk_event_get_focus_in(gdkEvent, focusIn);
                    } else {
                        GdkEventFocus gdkEventFocus = new GdkEventFocus();
                        OS.memmove(gdkEventFocus, gdkEvent, (long)GdkEventFocus.sizeof);
                        boolean bl = focusIn[0] = gdkEventFocus.in != 0;
                    }
                    if (!focusIn[0]) break;
                    long settings = GTK.gtk_settings_get_default();
                    OS.g_object_set(settings, GTK.gtk_entry_select_on_focus, true, 0L);
                }
            }
        }
        return super.gtk_event_after(widget, gdkEvent);
    }

    @Override
    long gtk_draw(long widget, long cairo) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        long result = super.gtk_draw(widget, cairo);
        return result;
    }

    @Override
    boolean mustBeVisibleOnInitBounds() {
        return true;
    }

    @Override
    long gtk_focus_out_event(long widget, long event) {
        this.fixIM();
        return super.gtk_focus_out_event(widget, event);
    }

    @Override
    long gtk_grab_focus(long widget) {
        long result = super.gtk_grab_focus(widget);
        if ((this.style & 4) != 0 && this.display.entrySelectOnFocus) {
            long settings = GTK.gtk_settings_get_default();
            OS.g_object_set(settings, GTK.gtk_entry_select_on_focus, false, 0L);
        }
        return result;
    }

    @Override
    long gtk_icon_release(long widget, long icon_pos, long event) {
        Event e = new Event();
        e.detail = icon_pos == 0L ? 512 : 256;
        this.sendSelectionEvent(14, e, false);
        return 0L;
    }

    @Override
    long gtk_insert_text(long widget, long new_text, long new_text_length, long position) {
        String newText;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        if (new_text == 0L || new_text_length == 0L) {
            return 0L;
        }
        byte[] buffer = new byte[(int)new_text_length];
        C.memmove(buffer, new_text, (long)buffer.length);
        String oldText = new String(Converter.mbcsToWcs(buffer));
        int[] pos = new int[1];
        C.memmove(pos, position, 4L);
        long ptr = GTK.gtk_entry_get_text(this.handle);
        if (pos[0] == -1) {
            pos[0] = (int)OS.g_utf8_strlen(ptr, -1L);
        }
        int start = pos[0];
        int end = pos[0];
        if (this.fixStart != -1 && this.fixEnd != -1) {
            start = pos[0] = this.fixStart;
            end = this.fixEnd;
            this.fixEnd = -1;
            this.fixStart = -1;
        }
        if ((newText = this.verifyText(oldText, start = (int)OS.g_utf8_offset_to_utf16_offset(ptr, start), end = (int)OS.g_utf8_offset_to_utf16_offset(ptr, end))) != oldText && this.handle != 0L) {
            int[] newStart = new int[1];
            int[] newEnd = new int[1];
            GTK.gtk_editable_get_selection_bounds(this.handle, newStart, newEnd);
            if (newText != null) {
                if (newStart[0] != newEnd[0]) {
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
                    GTK.gtk_editable_delete_selection(this.handle);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
                }
                byte[] buffer3 = Converter.wcsToMbcs(newText, false);
                OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
                GTK.gtk_editable_insert_text(this.handle, buffer3, buffer3.length, pos);
                OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
                newStart[0] = newEnd[0] = pos[0];
            }
            pos[0] = newEnd[0];
            if (newStart[0] != newEnd[0]) {
                this.fixStart = newStart[0];
                this.fixEnd = newEnd[0];
            }
            C.memmove(position, pos, 4L);
            OS.g_signal_stop_emission_by_name(this.handle, OS.insert_text);
        }
        return 0L;
    }

    @Override
    long gtk_key_press_event(long widget, long event) {
        long result;
        boolean handleSegments = false;
        boolean segmentsCleared = false;
        if (this.hooks(49) || this.filters(49)) {
            int length;
            int[] state = new int[1];
            GDK.gdk_event_get_state(event, state);
            if (GTK.GTK4) {
                long[] eventString = new long[1];
                GDK.gdk_event_get_string(event, eventString);
                length = (int)OS.g_utf16_strlen(eventString[0], -1L);
            } else {
                GdkEventKey gdkEvent = new GdkEventKey();
                OS.memmove(gdkEvent, event, (long)GdkEventKey.sizeof);
                length = gdkEvent.length;
            }
            if (length > 0 && (state[0] & 0xC) == 0) {
                handleSegments = true;
                if (this.segments != null) {
                    this.clearSegments(true);
                    segmentsCleared = true;
                }
            }
        }
        if ((result = super.gtk_key_press_event(widget, event)) != 0L) {
            this.fixIM();
        }
        if (this.gdkEventKey == -1L) {
            result = 1L;
        }
        this.gdkEventKey = 0L;
        if (handleSegments && (result != 0L || segmentsCleared)) {
            this.applySegments();
        }
        return result;
    }

    @Override
    long gtk_populate_popup(long widget, long menu) {
        if ((this.style & 0x4000000) != 0) {
            GTK.gtk_widget_set_direction(menu, 2);
            GTK.gtk_container_forall(menu, this.display.setDirectionProc, 2L);
        }
        return 0L;
    }

    @Override
    long gtk_text_buffer_insert_text(long widget, long iter, long text, long length) {
        int start;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        byte[] position = new byte[ITER_SIZEOF];
        C.memmove(position, iter, (long)position.length);
        int end = start = GTK.gtk_text_iter_get_offset(position);
        if (this.fixStart != -1 && this.fixEnd != -1) {
            start = this.fixStart;
            end = this.fixEnd;
            this.fixEnd = -1;
            this.fixStart = -1;
        }
        byte[] zero = new byte[ITER_SIZEOF];
        GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, zero, 0);
        long ptr = GTK.gtk_text_buffer_get_text(this.bufferHandle, zero, position, true);
        start = (int)OS.g_utf8_offset_to_utf16_offset(ptr, start);
        end = (int)OS.g_utf8_offset_to_utf16_offset(ptr, end);
        OS.g_free(ptr);
        byte[] buffer = new byte[(int)length];
        C.memmove(buffer, text, (long)buffer.length);
        String oldText = new String(Converter.mbcsToWcs(buffer));
        String newText = this.verifyText(oldText, start, end);
        if (newText == null) {
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.insert_text);
        } else if (newText != oldText) {
            byte[] buffer1 = Converter.wcsToMbcs(newText, false);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            GTK.gtk_text_buffer_insert(this.bufferHandle, iter, buffer1, buffer1.length);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.insert_text);
        }
        return 0L;
    }

    @Override
    void hookEvents() {
        long imContext;
        super.hookEvents();
        if ((this.style & 4) != 0) {
            OS.g_signal_connect_closure(this.handle, OS.changed, this.display.getClosure(6), true);
            OS.g_signal_connect_closure(this.handle, OS.insert_text, this.display.getClosure(26), false);
            OS.g_signal_connect_closure(this.handle, OS.delete_text, this.display.getClosure(13), false);
            OS.g_signal_connect_closure(this.handle, OS.activate, this.display.getClosure(1), false);
            OS.g_signal_connect_closure(this.handle, OS.grab_focus, this.display.getClosure(23), false);
            OS.g_signal_connect_closure(this.handle, OS.populate_popup, this.display.getClosure(37), false);
            if ((this.style & 0x80) != 0) {
                OS.g_signal_connect_closure(this.handle, OS.icon_release, this.display.getClosure(67), false);
            }
        } else {
            OS.g_signal_connect_closure(this.bufferHandle, OS.changed, this.display.getClosure(6), false);
            OS.g_signal_connect_closure(this.bufferHandle, OS.insert_text, this.display.getClosure(52), false);
            OS.g_signal_connect_closure(this.bufferHandle, OS.delete_range, this.display.getClosure(12), false);
            OS.g_signal_connect_closure(this.handle, OS.populate_popup, this.display.getClosure(37), false);
        }
        if ((imContext = this.imContext()) != 0L) {
            OS.g_signal_connect_closure(imContext, OS.commit, this.display.getClosure(9), false);
            int id = OS.g_signal_lookup(OS.commit, GTK.gtk_im_context_get_type());
            int mask = 17;
            OS.g_signal_handlers_block_matched(imContext, mask, id, 0, 0L, 0L, this.handle);
        }
        OS.g_signal_connect_closure(this.handle, OS.backspace, this.display.getClosure(70), false);
        OS.g_signal_connect_closure(this.handle, OS.backspace, this.display.getClosure(71), true);
        OS.g_signal_connect_closure(this.handle, OS.copy_clipboard, this.display.getClosure(72), false);
        OS.g_signal_connect_closure(this.handle, OS.copy_clipboard, this.display.getClosure(73), true);
        OS.g_signal_connect_closure(this.handle, OS.cut_clipboard, this.display.getClosure(74), false);
        OS.g_signal_connect_closure(this.handle, OS.cut_clipboard, this.display.getClosure(75), true);
        OS.g_signal_connect_closure(this.handle, OS.paste_clipboard, this.display.getClosure(76), false);
        OS.g_signal_connect_closure(this.handle, OS.paste_clipboard, this.display.getClosure(77), true);
        OS.g_signal_connect_closure(this.handle, OS.delete_from_cursor, this.display.getClosure(78), false);
        OS.g_signal_connect_closure(this.handle, OS.delete_from_cursor, this.display.getClosure(79), true);
        OS.g_signal_connect_closure(this.handle, OS.move_cursor, this.display.getClosure(80), false);
        OS.g_signal_connect_closure(this.handle, OS.move_cursor, this.display.getClosure(81), true);
        OS.g_signal_connect_closure(this.handle, OS.direction_changed, this.display.getClosure(82), true);
    }

    long imContext() {
        if (this.imContext != 0L) {
            return this.imContext;
        }
        return 0L;
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.clearSegments(true);
        byte[] buffer = Converter.wcsToMbcs(string, false);
        if ((this.style & 4) != 0) {
            int[] start = new int[1];
            int[] end = new int[1];
            GTK.gtk_editable_get_selection_bounds(this.handle, start, end);
            GTK.gtk_editable_delete_selection(this.handle);
            GTK.gtk_editable_insert_text(this.handle, buffer, buffer.length, start);
            GTK.gtk_editable_set_position(this.handle, start[0]);
        } else {
            byte[] start = new byte[ITER_SIZEOF];
            byte[] end = new byte[ITER_SIZEOF];
            if (GTK.gtk_text_buffer_get_selection_bounds(this.bufferHandle, start, end)) {
                GTK.gtk_text_buffer_delete(this.bufferHandle, start, end);
            }
            GTK.gtk_text_buffer_insert(this.bufferHandle, start, buffer, buffer.length);
            GTK.gtk_text_buffer_place_cursor(this.bufferHandle, start);
            this.scrollIfNotVisible(start, null, true);
        }
        this.applySegments();
    }

    private void scrollIfNotVisible(byte[] iter, byte[] scrollTo, boolean insert) {
        GdkRectangle rect = new GdkRectangle();
        int[] insertionCoordinates = new int[1];
        int[] topIndexCoordinates = new int[1];
        byte[] indexIter = new byte[ITER_SIZEOF];
        GTK.gtk_text_view_get_visible_rect(this.handle, rect);
        int lineHeight = this.getLineHeight();
        int numLinesVisible = rect.height / lineHeight;
        GTK.gtk_text_view_get_line_yrange(this.handle, iter, insertionCoordinates, null);
        if (this.indexMark != 0L) {
            GTK.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, indexIter, this.indexMark);
            GTK.gtk_text_view_get_line_yrange(this.handle, indexIter, topIndexCoordinates, null);
            int distanceTopIndex = (insertionCoordinates[0] - topIndexCoordinates[0]) / lineHeight;
            if (distanceTopIndex >= numLinesVisible) {
                if (insert) {
                    long mark = GTK.gtk_text_buffer_get_insert(this.bufferHandle);
                    GTK.gtk_text_view_scroll_to_mark(this.handle, mark, 0.0, true, 0.0, 0.0);
                } else if (scrollTo != null) {
                    GTK.gtk_text_view_scroll_to_iter(this.handle, scrollTo, 0.0, true, 0.0, 0.0);
                }
            }
        } else {
            topIndexCoordinates[0] = 0;
            int distanceTopIndex = (insertionCoordinates[0] - topIndexCoordinates[0]) / lineHeight;
            if (distanceTopIndex >= numLinesVisible) {
                if (scrollTo != null && !insert) {
                    GTK.gtk_text_view_scroll_to_iter(this.handle, scrollTo, 0.0, true, 0.0, 0.0);
                } else if (insert) {
                    long mark = GTK.gtk_text_buffer_get_insert(this.bufferHandle);
                    GTK.gtk_text_view_scroll_to_mark(this.handle, mark, 0.0, true, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    long paintWindow() {
        if ((this.style & 4) != 0) {
            return super.paintWindow();
        }
        GTK.gtk_widget_realize(this.handle);
        return GTK.gtk_text_view_get_window(this.handle, 2);
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            GTK.gtk_editable_paste_clipboard(this.handle);
        } else {
            long clipboard = GTK.GTK4 ? GDK.gdk_display_get_clipboard(GDK.gdk_display_get_default()) : GTK.gtk_clipboard_get(0L);
            this.clearSegments(true);
            GTK.gtk_text_buffer_paste_clipboard(this.bufferHandle, clipboard, null, GTK.gtk_text_view_get_editable(this.handle));
            this.applySegments();
        }
    }

    @Override
    void register() {
        long imContext;
        super.register();
        if (this.bufferHandle != 0L) {
            this.display.addWidget(this.bufferHandle, this);
        }
        if ((imContext = this.imContext()) != 0L) {
            this.display.addWidget(imContext, this);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.fixIM();
        this.message = null;
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSegmentListener(SegmentListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.eventTable.unhook(49, listener);
        this.clearSegments(true);
        this.applySegments();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            GTK.gtk_editable_select_region(this.handle, 0, -1);
        } else {
            byte[] start = new byte[ITER_SIZEOF];
            byte[] end = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, start, 0);
            GTK.gtk_text_buffer_get_end_iter(this.bufferHandle, end);
            GTK.gtk_text_buffer_select_range(this.bufferHandle, start, end);
        }
    }

    @Override
    GdkRGBA getContextBackgroundGdkRGBA() {
        if (this.background != null && (this.state & 0x2000) != 0) {
            return this.background;
        }
        return this.defaultBackground();
    }

    @Override
    GdkRGBA getContextColorGdkRGBA() {
        if (this.foreground != null) {
            return this.foreground;
        }
        return this.display.COLOR_WIDGET_FOREGROUND_RGBA;
    }

    @Override
    void setBackgroundGdkRGBA(long context, long handle, GdkRGBA rgba) {
        String css;
        this.background = rgba == null ? this.defaultBackground() : rgba;
        GdkRGBA selectedBackground = this.display.getSystemColor((int)26).handle;
        GdkRGBA selectedForeground = this.display.getSystemColor((int)27).handle;
        String properties = (this.style & 4) != 0 ? "entry {background: " + this.display.gtk_rgba_to_css_string(this.background) + ";}\n" + "entry:selected {background-color: " + this.display.gtk_rgba_to_css_string(selectedBackground) + ";}\n" + "entry selection {color: " + this.display.gtk_rgba_to_css_string(selectedForeground) + ";}" : "textview text {background-color: " + this.display.gtk_rgba_to_css_string(this.background) + ";}\n" + "textview text:selected {background-color: " + this.display.gtk_rgba_to_css_string(selectedBackground) + ";}\n" + "textview text selection {color: " + this.display.gtk_rgba_to_css_string(selectedForeground) + ";}";
        this.cssBackground = css = properties;
        String finalCss = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
        this.gtk_css_provider_load_from_css(context, finalCss);
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA rgba) {
        this.foreground = rgba;
        GdkRGBA toSet = rgba == null ? this.display.COLOR_WIDGET_FOREGROUND_RGBA : rgba;
        this.setForegroundGdkRGBA(this.handle, toSet);
    }

    @Override
    void setCursor(long cursor) {
        long defaultCursor = 0L;
        if (cursor == 0L) {
            defaultCursor = GTK.GTK4 ? GDK.gdk_cursor_new_from_name("xterm", 0L) : GDK.gdk_cursor_new_from_name(GDK.gdk_display_get_default(), "xterm");
        }
        super.setCursor(cursor != 0L ? cursor : defaultCursor);
        if (cursor == 0L) {
            OS.g_object_unref(defaultCursor);
        }
    }

    public void setDoubleClickEnabled(boolean doubleClick) {
        this.checkWidget();
        this.doubleClick = doubleClick;
    }

    public void setEchoChar(char echo) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            GTK.gtk_entry_set_visibility(this.handle, echo == '\u0000');
            GTK.gtk_entry_set_invisible_char(this.handle, echo);
        }
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.style &= 0xFFFFFFF7;
        if (!editable) {
            this.style |= 8;
        }
        if ((this.style & 4) != 0) {
            GTK.gtk_editable_set_editable(this.handle, editable);
        } else {
            GTK.gtk_text_view_set_editable(this.handle, editable);
        }
    }

    @Override
    void setFontDescription(long font) {
        super.setFontDescription(font);
        this.setTabStops(this.tabs);
    }

    public void setMessage(String message) {
        this.checkWidget();
        if (message == null) {
            this.error(4);
        }
        this.message = message;
        if ((this.style & 4) != 0) {
            byte[] buffer = Converter.wcsToMbcs(message, true);
            GTK.gtk_entry_set_placeholder_text(this.handle, buffer);
            return;
        }
        this.redraw(false);
    }

    @Override
    public void setOrientation(int orientation) {
        this.checkWidget();
    }

    public void setSelection(int start) {
        this.checkWidget();
        start = this.translateOffset(start);
        if ((this.style & 4) != 0) {
            long ptr = GTK.gtk_entry_get_text(this.handle);
            start = (int)OS.g_utf16_offset_to_utf8_offset(ptr, start);
            GTK.gtk_editable_set_position(this.handle, start);
        } else {
            byte[] startIter = new byte[ITER_SIZEOF];
            byte[] endIter = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_bounds(this.bufferHandle, startIter, endIter);
            long ptr = GTK.gtk_text_buffer_get_text(this.bufferHandle, startIter, endIter, true);
            start = (int)OS.g_utf16_offset_to_utf8_offset(ptr, start);
            OS.g_free(ptr);
            GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, startIter, start);
            GTK.gtk_text_buffer_place_cursor(this.bufferHandle, startIter);
            this.scrollIfNotVisible(startIter, startIter, false);
        }
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        start = this.translateOffset(start);
        end = this.translateOffset(end);
        if ((this.style & 4) != 0) {
            long ptr = GTK.gtk_entry_get_text(this.handle);
            start = (int)OS.g_utf16_offset_to_utf8_offset(ptr, start);
            end = (int)OS.g_utf16_offset_to_utf8_offset(ptr, end);
            GTK.gtk_editable_set_position(this.handle, start);
            GTK.gtk_editable_select_region(this.handle, start, end);
        } else {
            byte[] startIter = new byte[ITER_SIZEOF];
            byte[] endIter = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_bounds(this.bufferHandle, startIter, endIter);
            long ptr = GTK.gtk_text_buffer_get_text(this.bufferHandle, startIter, endIter, true);
            start = (int)OS.g_utf16_offset_to_utf8_offset(ptr, start);
            end = (int)OS.g_utf16_offset_to_utf8_offset(ptr, end);
            OS.g_free(ptr);
            GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, startIter, start);
            GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, endIter, end);
            this.scrollIfNotVisible(startIter, startIter, false);
            GTK.gtk_text_buffer_select_range(this.bufferHandle, startIter, endIter);
        }
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        this.setSelection(selection.x, selection.y);
    }

    public void setTabs(int tabs) {
        this.checkWidget();
        if (tabs < 0) {
            return;
        }
        this.tabs = tabs;
        this.setTabStops(this.tabs);
    }

    void setTabStops(int tabs) {
        int tabWidth = this.getTabWidth(tabs);
        long tabArray = OS.pango_tab_array_new(1, false);
        OS.pango_tab_array_set_tab(tabArray, 0, 0L, tabWidth);
        if ((this.style & 4) != 0) {
            GTK.gtk_entry_set_tabs(this.handle, tabArray);
        } else {
            GTK.gtk_text_view_set_tabs(this.handle, tabArray);
        }
        OS.pango_tab_array_free(tabArray);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, this.getCharCount())) == null) {
            return;
        }
        char[] text = new char[string.length()];
        string.getChars(0, text.length, text, 0);
        this.setText(text);
    }

    public void setTextChars(char[] text) {
        this.checkWidget();
        if (text == null) {
            this.error(4);
        }
        if (this.hooks(25) || this.filters(25)) {
            String string = this.verifyText(new String(text), 0, this.getCharCount());
            if (string == null) {
                return;
            }
            text = new char[string.length()];
            string.getChars(0, text.length, text, 0);
        }
        this.setText(text);
    }

    void setText(char[] text) {
        this.clearSegments(false);
        if ((this.style & 4) != 0) {
            byte[] buffer = Converter.wcsToMbcs(text, true);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
            GTK.gtk_entry_set_text(this.handle, buffer);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
            Arrays.fill(buffer, (byte)0);
        } else {
            byte[] buffer = Converter.wcsToMbcs(text, false);
            byte[] position = new byte[ITER_SIZEOF];
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 12L);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            GTK.gtk_text_buffer_set_text(this.bufferHandle, buffer, buffer.length);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 12L);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, position, 0);
            GTK.gtk_text_buffer_place_cursor(this.bufferHandle, position);
            long mark = GTK.gtk_text_buffer_get_insert(this.bufferHandle);
            GTK.gtk_text_view_scroll_to_mark(this.handle, mark, 0.0, true, 0.0, 0.0);
            Arrays.fill(buffer, (byte)0);
        }
        this.sendEvent(24);
        if ((this.style & 0x80) != 0 && (this.style & 0x100) == 0) {
            GTK.gtk_entry_set_icon_from_icon_name(this.handle, 1, null);
        }
        this.applySegments();
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        if ((this.style & 4) != 0) {
            GTK.gtk_entry_set_max_length(this.handle, this.segments != null ? Math.min(LIMIT, this.translateOffset(limit)) : limit);
        }
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        byte[] position = new byte[ITER_SIZEOF];
        GTK.gtk_text_buffer_get_iter_at_line(this.bufferHandle, position, index);
        byte[] buffer = Converter.wcsToMbcs("index_mark", true);
        this.indexMark = GTK.gtk_text_buffer_create_mark(this.bufferHandle, buffer, position, true);
        GTK.gtk_text_view_scroll_to_mark(this.handle, this.indexMark, 0.0, true, 0.0, 0.0);
        long vAdjustment = GTK.gtk_scrollable_get_vadjustment(this.handle);
        this.cachedAdjustment = GTK.gtk_adjustment_get_value(vAdjustment);
    }

    public void showSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        long mark = GTK.gtk_text_buffer_get_selection_bound(this.bufferHandle);
        GTK.gtk_text_view_scroll_to_mark(this.handle, mark, 0.0, true, 0.0, 0.0);
        mark = GTK.gtk_text_buffer_get_insert(this.bufferHandle);
        GTK.gtk_text_view_scroll_to_mark(this.handle, mark, 0.0, true, 0.0, 0.0);
    }

    int translateOffset(int offset) {
        if (this.segments == null) {
            return offset;
        }
        int i = 0;
        int nSegments = this.segments.length;
        while (i < nSegments && offset - i >= this.segments[i]) {
            ++offset;
            ++i;
        }
        return offset;
    }

    @Override
    boolean translateTraversal(long event) {
        int[] key = new int[1];
        GDK.gdk_event_get_keyval(event, key);
        switch (key[0]) {
            case 65293: 
            case 65421: {
                long imContext = this.imContext();
                if (imContext == 0L) break;
                long[] preeditString = new long[1];
                GTK.gtk_im_context_get_preedit_string(imContext, preeditString, null, null);
                if (preeditString[0] == 0L) break;
                int length = C.strlen(preeditString[0]);
                OS.g_free(preeditString[0]);
                if (length == 0) break;
                return false;
            }
        }
        return super.translateTraversal(event);
    }

    @Override
    int traversalCode(int key, long event) {
        int bits = super.traversalCode(key, event);
        if ((this.style & 8) != 0) {
            return bits;
        }
        if ((this.style & 2) != 0) {
            bits &= 0xFFFFFFFB;
            if (key == 65289 && event != 0L) {
                boolean next;
                int[] eventState = new int[1];
                GDK.gdk_event_get_state(event, eventState);
                boolean bl = next = (eventState[0] & 1) == 0;
                if (next && (eventState[0] & 4) == 0) {
                    bits &= 0xFFFFFFE7;
                }
            }
        }
        return bits;
    }

    int untranslateOffset(int offset) {
        if (this.segments == null) {
            return offset;
        }
        int i = 0;
        int nSegments = this.segments.length;
        while (i < nSegments && offset > this.segments[i]) {
            --offset;
            ++i;
        }
        return offset;
    }

    String verifyText(String string, int start, int end) {
        if (string != null && string.length() == 0 && start == end) {
            return null;
        }
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        long eventPtr = GTK.gtk_get_current_event();
        if (eventPtr != 0L) {
            int type = GDK.gdk_event_get_event_type(eventPtr);
            type = Text.fixGdkEventTypeValues(type);
            switch (type) {
                case 8: {
                    this.setKeyState(event, eventPtr);
                }
            }
            this.gdk_event_free(eventPtr);
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }

    @Override
    long windowProc(long handle, long user_data) {
        if (this.hooks(49) || this.filters(49) || this.segments != null) {
            switch ((int)user_data) {
                case 70: 
                case 72: 
                case 74: 
                case 76: {
                    this.clearSegments(true);
                    break;
                }
                case 71: 
                case 73: 
                case 75: 
                case 77: {
                    this.applySegments();
                }
            }
        }
        return super.windowProc(handle, user_data);
    }

    @Override
    long windowProc(long handle, long arg0, long user_data) {
        if (this.hooks(49) || this.filters(49) || this.segments != null) {
            switch ((int)user_data) {
                case 82: {
                    this.clearSegments(true);
                    this.applySegments();
                }
            }
        }
        return super.windowProc(handle, arg0, user_data);
    }

    @Override
    long windowProc(long handle, long arg0, long arg1, long user_data) {
        if (this.hooks(49) || this.filters(49) || this.segments != null) {
            switch ((int)user_data) {
                case 78: {
                    this.clearSegments(true);
                    break;
                }
                case 79: {
                    this.applySegments();
                }
            }
        }
        return super.windowProc(handle, arg0, arg1, user_data);
    }

    @Override
    long windowProc(long handle, long arg0, long arg1, long arg2, long user_data) {
        if (this.hooks(49) || this.filters(49) || this.segments != null) {
            switch ((int)user_data) {
                case 80: {
                    if (arg0 != 1L) break;
                    this.clearSegments(true);
                    break;
                }
                case 81: {
                    if (arg0 != 1L) break;
                    this.applySegments();
                }
            }
        }
        return super.windowProc(handle, arg0, arg1, arg2, user_data);
    }
}

