/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.equinox.internal.p2.metadata.License;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.ui.LicenseManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AcceptLicensesWizardPage
extends WizardPage {
    private static final String DIALOG_SETTINGS_SECTION = "LicensessPage";
    private static final String LIST_WEIGHT = "ListSashWeight";
    private static final String LICENSE_WEIGHT = "LicenseSashWeight";
    private static final String NAME_COLUMN_WIDTH = "NameColumnWidth";
    private static final String VERSION_COLUMN_WIDTH = "VersionColumnWidth";
    TreeViewer iuViewer;
    Text licenseTextBox;
    Button acceptButton;
    Button declineButton;
    SashForm sashForm;
    private IInstallableUnit[] originalIUs;
    HashMap<ILicense, List<IInstallableUnit>> licensesToIUs;
    private LicenseManager manager;
    IUColumnConfig nameColumn;
    IUColumnConfig versionColumn;

    static String getIUName(IInstallableUnit iu) {
        StringBuilder buf = new StringBuilder();
        String name = iu.getProperty("org.eclipse.equinox.p2.name", null);
        if (name != null) {
            buf.append(name);
        } else {
            buf.append(iu.getId());
        }
        buf.append(" ");
        buf.append(iu.getVersion().toString());
        return buf.toString();
    }

    public AcceptLicensesWizardPage(LicenseManager manager, IInstallableUnit[] ius, ProfileChangeOperation operation) {
        super("AcceptLicenses");
        this.setTitle(ProvUIMessages.AcceptLicensesWizardPage_Title);
        this.manager = manager;
        this.update(ius, operation);
    }

    public void createControl(Composite parent) {
        List<IInstallableUnit> ius;
        this.initializeDialogUnits((Control)parent);
        if (this.licensesToIUs == null || this.licensesToIUs.size() == 0) {
            Label label = new Label(parent, 0);
            this.setControl((Control)label);
        } else if (this.licensesToIUs.size() == 1 && (ius = this.licensesToIUs.values().iterator().next()).size() == 1) {
            this.createLicenseContentSection(parent, ius.get(0));
        } else {
            this.sashForm = new SashForm(parent, 256);
            this.sashForm.setLayout((Layout)new GridLayout());
            GridData gd = new GridData(4, 4, true, true);
            this.sashForm.setLayoutData((Object)gd);
            this.createLicenseListSection((Composite)this.sashForm);
            this.createLicenseContentSection((Composite)this.sashForm, null);
            this.sashForm.setWeights(this.getSashWeights());
            this.setControl((Control)this.sashForm);
        }
        Dialog.applyDialogFont((Control)this.getControl());
    }

    private void createLicenseListSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 0);
        label.setText(ProvUIMessages.AcceptLicensesWizardPage_ItemsLabel);
        this.iuViewer = new TreeViewer(composite, 68352);
        this.iuViewer.setContentProvider((IContentProvider)new LicenseContentProvider());
        this.iuViewer.setLabelProvider((IBaseLabelProvider)new LicenseLabelProvider());
        this.iuViewer.setComparator(new ViewerComparator());
        this.iuViewer.setInput(this.licensesToIUs);
        this.iuViewer.addSelectionChangedListener(event -> this.handleSelectionChanged(event.getStructuredSelection()));
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        this.iuViewer.getControl().setLayoutData((Object)gd);
    }

    private void createLicenseAcceptSection(Composite parent, boolean multiple) {
        Composite buttonContainer = new Composite(parent, 0);
        GridData gd = new GridData(256);
        buttonContainer.setLayout((Layout)new GridLayout());
        buttonContainer.setLayoutData((Object)gd);
        this.acceptButton = new Button(buttonContainer, 16);
        if (multiple) {
            this.acceptButton.setText(ProvUIMessages.AcceptLicensesWizardPage_AcceptMultiple);
        } else {
            this.acceptButton.setText(ProvUIMessages.AcceptLicensesWizardPage_AcceptSingle);
        }
        this.acceptButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.setPageComplete(this.acceptButton.getSelection())));
        this.declineButton = new Button(buttonContainer, 16);
        if (multiple) {
            this.declineButton.setText(ProvUIMessages.AcceptLicensesWizardPage_RejectMultiple);
        } else {
            this.declineButton.setText(ProvUIMessages.AcceptLicensesWizardPage_RejectSingle);
        }
        this.declineButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.setPageComplete(!this.declineButton.getSelection())));
        this.acceptButton.setSelection(false);
        this.declineButton.setSelection(true);
    }

    private void createLicenseContentSection(Composite parent, IInstallableUnit singleIU) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 0);
        if (singleIU == null) {
            label.setText(ProvUIMessages.AcceptLicensesWizardPage_LicenseTextLabel);
        } else {
            label.setText(NLS.bind((String)ProvUIMessages.AcceptLicensesWizardPage_SingleLicenseTextLabel, (Object)AcceptLicensesWizardPage.getIUName(singleIU)));
        }
        this.licenseTextBox = new Text(composite, 2634);
        this.licenseTextBox.setBackground(this.licenseTextBox.getDisplay().getSystemColor(25));
        this.initializeDialogUnits((Control)this.licenseTextBox);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        gd.widthHint = this.convertWidthInCharsToPixels(40);
        this.licenseTextBox.setLayoutData((Object)gd);
        this.createLicenseAcceptSection(composite, this.licensesToIUs.size() > 1);
        if (singleIU != null) {
            ILicense license;
            String licenseBody = "";
            Iterator licenses = singleIU.getLicenses(null).iterator();
            ILicense iLicense = license = licenses.hasNext() ? (ILicense)licenses.next() : null;
            if (license != null && license.getBody() != null) {
                licenseBody = license.getBody();
            }
            this.licenseTextBox.setText(licenseBody);
        }
        this.setControl((Control)composite);
    }

    void handleSelectionChanged(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            Object selected = selection.getFirstElement();
            if (selected instanceof License) {
                this.licenseTextBox.setText(((License)selected).getBody());
            } else if (selected instanceof IUWithLicenseParent) {
                this.licenseTextBox.setText(((IUWithLicenseParent)selected).license.getBody());
            }
        }
    }

    public boolean performFinish() {
        this.rememberAcceptedLicenses();
        return true;
    }

    public boolean hasLicensesToAccept() {
        return this.licensesToIUs != null && this.licensesToIUs.size() > 0;
    }

    public void updateForPlan(IInstallableUnit[] theIUs, IProvisioningPlan plan) {
        this.updateLicenses(theIUs, plan);
    }

    private void updateLicenses(IInstallableUnit[] theIUs, IProvisioningPlan plan) {
        this.originalIUs = theIUs;
        if (theIUs == null) {
            this.licensesToIUs = new HashMap();
        } else {
            this.findUnacceptedLicenses(theIUs, plan);
        }
        this.setDescription();
        this.setPageComplete(this.licensesToIUs.size() == 0);
        if (this.getControl() != null) {
            Composite parent = this.getControl().getParent();
            this.getControl().dispose();
            this.iuViewer = null;
            this.sashForm = null;
            this.createControl(parent);
            parent.layout(true);
        }
    }

    public void update(IInstallableUnit[] theIUs, ProfileChangeOperation operation) {
        if (operation != null && operation.hasResolved()) {
            int sev = operation.getResolutionResult().getSeverity();
            if (sev != 4 && sev != 8) {
                this.updateLicenses(theIUs, operation.getProvisioningPlan());
            } else {
                this.updateLicenses(new IInstallableUnit[0], null);
            }
        }
    }

    private void findUnacceptedLicenses(IInstallableUnit[] selectedIUs, IProvisioningPlan plan) {
        IInstallableUnit[] iusToCheck = selectedIUs;
        if (plan != null) {
            iusToCheck = (IInstallableUnit[])plan.getAdditions().query(QueryUtil.createIUAnyQuery(), null).toArray(IInstallableUnit.class);
        }
        this.licensesToIUs = new HashMap();
        HashMap namesSeen = new HashMap();
        int i = 0;
        while (i < iusToCheck.length) {
            IInstallableUnit iu = iusToCheck[i];
            for (ILicense license : iu.getLicenses(null)) {
                if (this.manager == null || this.manager.isAccepted(license)) continue;
                String name = iu.getProperty("org.eclipse.equinox.p2.name", null);
                if (name == null) {
                    name = iu.getId();
                }
                if (this.licensesToIUs.containsKey(license)) {
                    HashSet names = (HashSet)namesSeen.get(license);
                    if (names.contains(name)) continue;
                    names.add(name);
                    ((ArrayList)this.licensesToIUs.get(license)).add(iu);
                    continue;
                }
                ArrayList<IInstallableUnit> list = new ArrayList<IInstallableUnit>(1);
                list.add(iu);
                this.licensesToIUs.put(license, list);
                HashSet<String> names = new HashSet<String>(1);
                names.add(name);
                namesSeen.put(license, names);
            }
            ++i;
        }
    }

    private void rememberAcceptedLicenses() {
        if (this.licensesToIUs == null || this.manager == null) {
            return;
        }
        for (ILicense license : this.licensesToIUs.keySet()) {
            this.manager.accept(license);
        }
    }

    private void setDescription() {
        if (this.licensesToIUs == null || this.licensesToIUs.size() == 0) {
            this.setDescription(ProvUIMessages.AcceptLicensesWizardPage_NoLicensesDescription);
        } else if (this.licensesToIUs.size() <= this.originalIUs.length) {
            this.setDescription(ProvUIMessages.AcceptLicensesWizardPage_ReviewLicensesDescription);
        } else {
            this.setDescription(ProvUIMessages.AcceptLicensesWizardPage_ReviewExtraLicensesDescription);
        }
    }

    private String getDialogSettingsName() {
        return String.valueOf(this.getWizard().getClass().getName()) + "." + DIALOG_SETTINGS_SECTION;
    }

    public void saveBoundsRelatedSettings() {
        if (this.iuViewer == null || this.iuViewer.getTree().isDisposed()) {
            return;
        }
        IDialogSettings settings = ProvUIActivator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsName());
        }
        section.put(NAME_COLUMN_WIDTH, this.iuViewer.getTree().getColumn(0).getWidth());
        section.put(VERSION_COLUMN_WIDTH, this.iuViewer.getTree().getColumn(1).getWidth());
        if (this.sashForm == null || this.sashForm.isDisposed()) {
            return;
        }
        int[] weights = this.sashForm.getWeights();
        section.put(LIST_WEIGHT, weights[0]);
        section.put(LICENSE_WEIGHT, weights[1]);
    }

    private int[] getSashWeights() {
        IDialogSettings settings = ProvUIActivator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsName());
        if (section != null) {
            try {
                int[] weights = new int[2];
                if (section.get(LIST_WEIGHT) != null) {
                    weights[0] = section.getInt(LIST_WEIGHT);
                    if (section.get(LICENSE_WEIGHT) != null) {
                        weights[1] = section.getInt(LICENSE_WEIGHT);
                        return weights;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new int[]{55, 45};
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.hasLicensesToAccept() && this.iuViewer != null) {
            this.iuViewer.setSelection((ISelection)new StructuredSelection(this.iuViewer.getTree().getItem(0).getData()), true);
        }
    }

    class IUWithLicenseParent {
        IInstallableUnit iu;
        ILicense license;

        IUWithLicenseParent(ILicense license, IInstallableUnit iu) {
            this.license = license;
            this.iu = iu;
        }
    }

    class LicenseContentProvider
    implements ITreeContentProvider {
        LicenseContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (!(parentElement instanceof ILicense)) {
                return new Object[0];
            }
            if (AcceptLicensesWizardPage.this.licensesToIUs.containsKey(parentElement)) {
                List<IInstallableUnit> iusWithLicense = AcceptLicensesWizardPage.this.licensesToIUs.get(parentElement);
                IInstallableUnit[] ius = iusWithLicense.toArray(new IInstallableUnit[iusWithLicense.size()]);
                Object[] children = new IUWithLicenseParent[ius.length];
                int i = 0;
                while (i < ius.length) {
                    children[i] = new IUWithLicenseParent((ILicense)parentElement, ius[i]);
                    ++i;
                }
                return children;
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof IUWithLicenseParent) {
                return ((IUWithLicenseParent)element).license;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return AcceptLicensesWizardPage.this.licensesToIUs.containsKey(element);
        }

        public Object[] getElements(Object inputElement) {
            return AcceptLicensesWizardPage.this.licensesToIUs.keySet().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class LicenseLabelProvider
    extends LabelProvider {
        LicenseLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof License) {
                return this.getFirstLine(((License)element).getBody());
            }
            if (element instanceof IUWithLicenseParent) {
                return AcceptLicensesWizardPage.getIUName(((IUWithLicenseParent)element).iu);
            }
            if (element instanceof IInstallableUnit) {
                return AcceptLicensesWizardPage.getIUName((IInstallableUnit)element);
            }
            return "";
        }

        private String getFirstLine(String body) {
            int i = body.indexOf(10);
            int j = body.indexOf(13);
            if (i > 0) {
                if (j > 0) {
                    return body.substring(0, i < j ? i : j);
                }
                return body.substring(0, i);
            }
            if (j > 0) {
                return body.substring(0, j);
            }
            return body;
        }
    }
}

