/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.presentation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.DecoratingColumLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.oomph.base.provider.BaseEditUtil;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.editor.SetupTemplate;
import org.eclipse.oomph.setup.presentation.Messages;
import org.eclipse.oomph.setup.presentation.SetupEditorPlugin;
import org.eclipse.oomph.setup.presentation.templates.GenericSetupTemplate;
import org.eclipse.oomph.setup.provider.SetupEditPlugin;
import org.eclipse.oomph.setup.ui.SetupLabelProvider;
import org.eclipse.oomph.ui.DelegatingLabelDecorator;
import org.eclipse.oomph.ui.LabelDecorator;
import org.eclipse.oomph.ui.PropertiesViewer;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public abstract class SetupModelWizard
extends Wizard
implements INewWizard {
    public static final List<String> FILE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(SetupEditorPlugin.INSTANCE.getString("_UI_SetupEditorFilenameExtensions").split("\\s*,\\s*")));
    public static final String FORMATTED_FILE_EXTENSIONS = SetupEditorPlugin.INSTANCE.getString("_UI_SetupEditorFilenameExtensions").replaceAll("\\s*,\\s*", ", ");
    protected SetupPackage setupPackage = SetupPackage.eINSTANCE;
    protected SetupFactory setupFactory = this.setupPackage.getSetupFactory();
    protected SetupModelWizardInitialObjectCreationPage initialObjectCreationPage;
    protected TemplateUsagePage templateUsagePage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected List<String> initialObjectNames;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(SetupEditorPlugin.INSTANCE.getString("_UI_Wizard_label"));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(SetupEditorPlugin.INSTANCE.getImage("full/wizban/NewSetup.png")));
    }

    public void addPages() {
        this.templateUsagePage = new TemplateUsagePage("Whatever3");
        this.templateUsagePage.setDescription(SetupEditorPlugin.INSTANCE.getString("_UI_Wizard_initial_object_description"));
        this.configureTemplateUsagePage(this.templateUsagePage);
        this.addPage((IWizardPage)this.templateUsagePage);
    }

    protected abstract void configureTemplateUsagePage(TemplateUsagePage var1);

    public IContainer getDefaultContainer() {
        Object selectedElement;
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                return (IContainer)selectedResource;
            }
        }
        return null;
    }

    protected Collection<String> getInitialObjectNames() {
        if (this.initialObjectNames == null) {
            this.initialObjectNames = new ArrayList<String>();
            for (EClassifier eClassifier : this.setupPackage.getEClassifiers()) {
                EClass eClass;
                if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract()) continue;
                this.initialObjectNames.add(eClass.getName());
            }
            Collections.sort(this.initialObjectNames, CommonPlugin.INSTANCE.getComparator());
        }
        return this.initialObjectNames;
    }

    public boolean canFinish() {
        return this.templateUsagePage.isPageComplete();
    }

    public boolean performFinish() {
        try {
            final Resource modelResource = this.templateUsagePage.getResource();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        try {
                            modelResource.save(null);
                        }
                        catch (Exception exception) {
                            SetupEditorPlugin.INSTANCE.log(exception);
                            progressMonitor.done();
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            IFile modelFile = EcorePlugin.getWorkspaceRoot().getFile((IPath)new Path(modelResource.getURI().toPlatformString(true)));
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    @Override
                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
            }
            catch (PartInitException exception) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)SetupEditorPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), (String)exception.getMessage());
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            SetupEditorPlugin.INSTANCE.log(exception);
            return false;
        }
    }

    public static class NewConfigurationWizard
    extends SetupModelWizard {
        @Override
        protected void configureTemplateUsagePage(TemplateUsagePage templateUsagePage) {
            templateUsagePage.setTitle(SetupEditorPlugin.INSTANCE.getString("_UI_SetupModelWizard_label3"));
            templateUsagePage.addTemplate(Messages.SetupModelWizard_template_simpleConfiguration, "@ConfigurationTemplate@.setup");
            templateUsagePage.addTemplate(Messages.SetupModelWizard_template_copyCurrentConfiguration, "@CopyConfigurationTemplate@.setup");
        }
    }

    public static class NewIndexWizard
    extends SetupModelWizard {
        @Override
        protected void configureTemplateUsagePage(TemplateUsagePage templateUsagePage) {
            templateUsagePage.setTitle(SetupEditorPlugin.INSTANCE.getString("_UI_SetupModelWizard_label4"));
            templateUsagePage.addTemplate(Messages.SetupModelWizard_template_simpleIndex, "@IndexTemplate@.setup");
        }
    }

    public static class NewMacroWizard
    extends SetupModelWizard {
        @Override
        protected void configureTemplateUsagePage(TemplateUsagePage templateUsagePage) {
            templateUsagePage.setTitle(SetupEditorPlugin.INSTANCE.getString("_UI_SetupModelWizard_label7"));
            templateUsagePage.addTemplate(Messages.SetupModelWizard_template_macro, "@MacroTemplate@.setup");
        }
    }

    public static class NewProductCatalogWizard
    extends SetupModelWizard {
        @Override
        protected void configureTemplateUsagePage(TemplateUsagePage templateUsagePage) {
            templateUsagePage.setTitle(SetupEditorPlugin.INSTANCE.getString("_UI_SetupModelWizard_label5"));
            templateUsagePage.addTemplate(Messages.SetupModelWizard_template_simpleProductCatalog, "@ProductCatalogTemplate@.setup");
        }
    }

    public static class NewProductWizard
    extends SetupModelWizard {
        @Override
        protected void configureTemplateUsagePage(TemplateUsagePage templateUsagePage) {
            templateUsagePage.setTitle(SetupEditorPlugin.INSTANCE.getString("_UI_SetupModelWizard_label2"));
            templateUsagePage.addTemplate(Messages.SetupModelWizard_template_simpleUserProduct, "@UserProductTemplate@.setup");
        }
    }

    public static class NewProjectCatalogWizard
    extends SetupModelWizard {
        @Override
        protected void configureTemplateUsagePage(TemplateUsagePage templateUsagePage) {
            templateUsagePage.setTitle(SetupEditorPlugin.INSTANCE.getString("_UI_SetupModelWizard_label6"));
            templateUsagePage.addTemplate(Messages.SetupModelWizard_template_simpleProjectCatalog, "@ProjectCatalogTemplate@.setup");
        }
    }

    public static class NewProjectWizard
    extends SetupModelWizard {
        @Override
        public void init(IWorkbench workbench, IStructuredSelection selection) {
            super.init(workbench, selection);
            this.setWindowTitle(SetupEditorPlugin.INSTANCE.getString("_UI_Wizard_label"));
            this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(SetupEditorPlugin.INSTANCE.getImage("full/wizban/NewSetup.png")));
        }

        @Override
        protected void configureTemplateUsagePage(TemplateUsagePage templateUsagePage) {
            templateUsagePage.setTitle(SetupEditorPlugin.INSTANCE.getString("_UI_SetupModelWizard_label"));
            templateUsagePage.addTemplate(Messages.SetupModelWizard_template_eclipseProject, "@EclipseProjectTemplate@.setup");
            templateUsagePage.addTemplate(Messages.SetupModelWizard_template_simpleProject, "@SimpleProjectTemplate@.setup");
            templateUsagePage.addTemplate(Messages.SetupModelWizard_template_githubProject, "@GithubProjectTemplate@.setup");
        }
    }

    public static class PreviewerLabelProvider
    extends DecoratingColumLabelProvider {
        private LabelDecorator labelDecorator;

        public PreviewerLabelProvider(ILabelProvider labelProvider, LabelDecorator labelDecorator) {
            super(labelProvider, (ILabelDecorator)labelDecorator);
            this.labelDecorator = labelDecorator;
        }

        public Font getFont(Object element) {
            return this.labelDecorator.decorateFont(this.fontProvider.getFont(element), element);
        }

        public Color getBackground(Object element) {
            return this.labelDecorator.decorateBackground(this.colorProvider.getBackground(element), element);
        }

        public Color getForeground(Object element) {
            return this.labelDecorator.decorateForeground(this.colorProvider.getForeground(element), element);
        }
    }

    public class SetupModelWizardInitialObjectCreationPage
    extends WizardPage {
        protected Combo initialObjectField;
        protected List<String> encodings;
        protected Combo encodingField;
        protected ModifyListener validator;

        public SetupModelWizardInitialObjectCreationPage(String pageId) {
            super(pageId);
            this.validator = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SetupModelWizardInitialObjectCreationPage.this.setPageComplete(SetupModelWizardInitialObjectCreationPage.this.validatePage());
                }
            };
        }

        public void createControlGen(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label containerLabel = new Label(composite, 16384);
            containerLabel.setText(SetupEditorPlugin.INSTANCE.getString("_UI_ModelObject"));
            data = new GridData();
            data.horizontalAlignment = 4;
            containerLabel.setLayoutData((Object)data);
            this.initialObjectField = new Combo(composite, 2048);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.initialObjectField.setLayoutData((Object)data);
            for (String objectName : SetupModelWizard.this.getInitialObjectNames()) {
                this.initialObjectField.add(this.getLabel(objectName));
            }
            if (this.initialObjectField.getItemCount() == 1) {
                this.initialObjectField.select(0);
            }
            this.initialObjectField.addModifyListener(this.validator);
            Label encodingLabel = new Label(composite, 16384);
            encodingLabel.setText(SetupEditorPlugin.INSTANCE.getString("_UI_XMLEncoding"));
            GridData data2 = new GridData();
            data2.horizontalAlignment = 4;
            encodingLabel.setLayoutData((Object)data2);
            this.encodingField = new Combo(composite, 2048);
            data2 = new GridData();
            data2.horizontalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            this.encodingField.setLayoutData((Object)data2);
            for (String encoding : this.getEncodings()) {
                this.encodingField.add(encoding);
            }
            this.encodingField.select(0);
            this.encodingField.addModifyListener(this.validator);
            this.setPageComplete(this.validatePage());
            this.setControl((Control)composite);
        }

        public void createControl(Composite parent) {
            this.createControlGen(parent);
            String[] items = this.initialObjectField.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].equals("Project")) {
                    this.initialObjectField.select(i);
                    break;
                }
                ++i;
            }
        }

        protected boolean validatePage() {
            return this.getInitialObjectName() != null && this.getEncodings().contains(this.encodingField.getText());
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                if (this.initialObjectField.getItemCount() == 1) {
                    this.initialObjectField.clearSelection();
                    this.encodingField.setFocus();
                } else {
                    this.encodingField.clearSelection();
                    this.initialObjectField.setFocus();
                }
            }
        }

        public String getInitialObjectName() {
            String label = this.initialObjectField.getText();
            for (String name : SetupModelWizard.this.getInitialObjectNames()) {
                if (!this.getLabel(name).equals(label)) continue;
                return name;
            }
            return null;
        }

        public String getEncoding() {
            return this.encodingField.getText();
        }

        protected String getLabel(String typeName) {
            try {
                return SetupEditPlugin.INSTANCE.getString("_UI_" + typeName + "_type");
            }
            catch (MissingResourceException mre) {
                SetupEditorPlugin.INSTANCE.log(mre);
                return typeName;
            }
        }

        protected Collection<String> getEncodings() {
            if (this.encodings == null) {
                this.encodings = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(SetupEditorPlugin.INSTANCE.getString("_UI_XMLEncodingChoices"));
                while (stringTokenizer.hasMoreTokens()) {
                    this.encodings.add(stringTokenizer.nextToken());
                }
            }
            return this.encodings;
        }
    }

    public class TemplateUsagePage
    extends WizardPage
    implements SetupTemplate.Container {
        private final List<SetupTemplate> templates;
        private final Map<SetupTemplate, Control> templateControls;
        private ComboViewer templatesViewer;
        private Composite templatesContainer;
        private StackLayout templatesStack;
        private TreeViewer previewer;
        private DelegatingLabelDecorator delegatingLabelDecorator;
        private PropertiesViewer propertiesViewer;
        private Button previewButton;
        private SashForm sash;
        private int sashHeight;

        public TemplateUsagePage(String pageId) {
            super(pageId);
            this.templates = new ArrayList<SetupTemplate>();
            this.templateControls = new HashMap<SetupTemplate, Control>();
            this.sashHeight = 400;
            this.setPageComplete(false);
        }

        public void addTemplate(String label, String templateFileName) {
            URI templateFolder = URI.createPlatformPluginURI((String)"org.eclipse.oomph.setup.editor", (boolean)false).appendSegment("templates");
            URI templateFile = templateFolder.appendSegment(templateFileName).appendFragment("/");
            GenericSetupTemplate template = new GenericSetupTemplate(label, templateFile);
            template.init(this);
            this.templates.add(template);
        }

        public Resource getResource() {
            SetupTemplate template = this.getSelectedTemplate();
            return template == null ? null : template.getResource();
        }

        public LabelDecorator getDecorator() {
            SetupTemplate template = this.getSelectedTemplate();
            return template == null ? null : template.getDecorator();
        }

        @Override
        public String getDefaultLocation() {
            IContainer defaultContainer = this.getWizard().getDefaultContainer();
            return defaultContainer == null ? null : defaultContainer.getFullPath().toString();
        }

        protected void updatePreviewer() {
            Resource resource = this.getResource();
            if (this.previewer != null) {
                this.delegatingLabelDecorator.setLabelDecorator(this.getDecorator());
                this.propertiesViewer.getDelegatingLabelDecorator().setLabelDecorator(this.getDecorator());
                this.previewer.setInput((Object)new ItemProvider(Collections.singleton(resource)));
                this.getSelectedTemplate().updatePreview();
            }
        }

        public void createControl(Composite parent) {
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 10;
            final Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)layout);
            UIUtil.grabVertical((GridData)UIUtil.applyGridData((Control)composite));
            this.setControl((Control)composite);
            this.templatesViewer = new ComboViewer(composite, 2048);
            this.templatesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.templatesViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.templatesViewer.setInput(this.templates);
            this.templatesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Control control = TemplateUsagePage.this.getSelectedTemplateControl();
                    if (control != null) {
                        TemplateUsagePage.this.templatesStack.topControl = control;
                        TemplateUsagePage.this.templatesContainer.layout();
                        TemplateUsagePage.this.updatePreviewer();
                    }
                    TemplateUsagePage.this.validate();
                }
            });
            UIUtil.applyGridData((Control)this.templatesViewer.getControl()).heightHint = 64;
            this.templatesStack = new StackLayout();
            this.templatesContainer = new Composite(composite, 0);
            this.templatesContainer.setLayout((Layout)this.templatesStack);
            UIUtil.applyGridData((Control)this.templatesContainer).heightHint = 200;
            this.previewButton = new Button(composite, 8);
            this.previewButton.setText(String.valueOf(Messages.SetupModelWizard_previewButton) + " >>>");
            GridData data = this.setButtonLayoutData(this.previewButton);
            data.horizontalAlignment = 1;
            this.previewButton.setLayoutData((Object)data);
            this.previewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Shell shell = TemplateUsagePage.this.getShell();
                    Point shellSize = shell.getSize();
                    if (TemplateUsagePage.this.sash == null) {
                        TemplateUsagePage.this.sash = new SashForm(composite, 66048);
                        UIUtil.grabVertical((GridData)UIUtil.applyGridData((Control)TemplateUsagePage.this.sash));
                        TemplateUsagePage.this.previewer = new TreeViewer((Composite)TemplateUsagePage.this.sash, 2050);
                        ComposedAdapterFactory adapterFactory = BaseEditUtil.createAdapterFactory();
                        TemplateUsagePage.this.delegatingLabelDecorator = new DelegatingLabelDecorator();
                        TemplateUsagePage.this.previewer.setLabelProvider((IBaseLabelProvider)new PreviewerLabelProvider((ILabelProvider)new SetupLabelProvider((AdapterFactory)adapterFactory, (Viewer)TemplateUsagePage.this.previewer), (LabelDecorator)TemplateUsagePage.this.delegatingLabelDecorator));
                        TemplateUsagePage.this.previewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
                        TemplateUsagePage.this.previewer.addSelectionChangedListener(new ISelectionChangedListener(){

                            public void selectionChanged(SelectionChangedEvent event) {
                                if ((this).TemplateUsagePage.this.propertiesViewer != null) {
                                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                                    if (selection.size() == 1) {
                                        Object element = selection.getFirstElement();
                                        Control control = (this).TemplateUsagePage.this.propertiesViewer.getControl();
                                        try {
                                            control.setRedraw(false);
                                            (this).TemplateUsagePage.this.propertiesViewer.setInput(element);
                                        }
                                        finally {
                                            control.setRedraw(true);
                                        }
                                        return;
                                    }
                                    (this).TemplateUsagePage.this.propertiesViewer.setInput(new Object());
                                }
                            }
                        });
                        UIUtil.grabVertical((GridData)UIUtil.applyGridData((Control)TemplateUsagePage.this.previewer.getControl()));
                        TemplateUsagePage.this.propertiesViewer = new PropertiesViewer((Composite)TemplateUsagePage.this.sash, 2048);
                        TemplateUsagePage.this.propertiesViewer.getDelegatingLabelDecorator().setLabelDecorator(TemplateUsagePage.this.getDecorator());
                        TemplateUsagePage.this.sash.setWeights(new int[]{2, 1});
                        SetupTemplate template = TemplateUsagePage.this.getSelectedTemplate();
                        if (template != null) {
                            TemplateUsagePage.this.updatePreviewer();
                        }
                        shell.setSize(shellSize.x, shellSize.y + TemplateUsagePage.this.sashHeight);
                        composite.layout();
                        TemplateUsagePage.this.previewButton.setText("<<< " + Messages.SetupModelWizard_previewButton);
                    } else {
                        TemplateUsagePage.this.sashHeight = TemplateUsagePage.this.sash.getSize().y;
                        TemplateUsagePage.this.sash.dispose();
                        TemplateUsagePage.this.sash = null;
                        TemplateUsagePage.this.previewer = null;
                        TemplateUsagePage.this.delegatingLabelDecorator = null;
                        TemplateUsagePage.this.propertiesViewer = null;
                        composite.layout();
                        shell.setSize(shellSize.x, shellSize.y - TemplateUsagePage.this.sashHeight);
                        TemplateUsagePage.this.previewButton.setText(String.valueOf(Messages.SetupModelWizard_previewButton) + " >>>");
                    }
                }
            });
            for (SetupTemplate template : this.templates) {
                Control control = template.createControl(this.templatesContainer);
                this.templateControls.put(template, control);
            }
        }

        public void setVisible(boolean visible) {
            if (this.templatesViewer == null) {
                return;
            }
            super.setVisible(visible);
            if (visible) {
                this.templatesViewer.getControl().setFocus();
            }
            if (visible && this.templatesViewer.getSelection().isEmpty() && !this.templates.isEmpty()) {
                this.templatesViewer.setSelection((ISelection)new StructuredSelection((Object)this.templates.get(0)));
            }
        }

        @Override
        public TreeViewer getPreviewer() {
            return this.previewer;
        }

        @Override
        public PropertiesViewer getPropertiesViewer() {
            return this.propertiesViewer;
        }

        @Override
        public void validate() {
            String message = this.getValidationMessage();
            this.setErrorMessage(StringUtil.isEmpty((String)message) ? null : message);
            this.setPageComplete(message == null);
            this.getContainer().updateButtons();
        }

        public SetupModelWizard getWizard() {
            return (SetupModelWizard)super.getWizard();
        }

        public String getValidationMessage() {
            try {
                SetupTemplate template = this.getSelectedTemplate();
                if (template != null) {
                    return template.getMessage();
                }
            }
            catch (Exception ex) {
                SetupEditorPlugin.getPlugin().log(ex);
            }
            return Messages.SetupModelWizard_noTemplateSelected;
        }

        private SetupTemplate getSelectedTemplate() {
            return (SetupTemplate)((IStructuredSelection)this.templatesViewer.getSelection()).getFirstElement();
        }

        private Control getSelectedTemplateControl() {
            SetupTemplate template = this.getSelectedTemplate();
            return this.templateControls.get(template);
        }
    }
}

