/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.preferences.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.oomph.preferences.PreferenceNode;
import org.eclipse.oomph.preferences.PreferencesFactory;
import org.eclipse.oomph.preferences.PreferencesPackage;
import org.eclipse.oomph.preferences.Property;
import org.eclipse.oomph.preferences.util.PreferencesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesRecorder
extends EContentAdapter {
    private static final String INSTANCE_SCOPE = "instance";
    private final Map<Property, URI> paths = new HashMap<Property, URI>();
    private final Map<URI, String> values = new HashMap<URI, String>();
    private PreferenceNode rootPreferenceNode = this.getRootPreferenceNode();

    public PreferencesRecorder() {
        this.rootPreferenceNode.eAdapters().add((Object)this);
    }

    public Map<URI, String> done() {
        TreeIterator it = this.rootPreferenceNode.eResource().getAllContents();
        while (it.hasNext()) {
            ((EObject)it.next()).eAdapters().clear();
        }
        this.rootPreferenceNode = null;
        this.paths.clear();
        return this.values;
    }

    protected PreferenceNode getRootPreferenceNode() {
        return PreferencesUtil.getRootPreferenceNode(Collections.singleton(INSTANCE_SCOPE), true);
    }

    protected void setTarget(EObject target) {
        Property property;
        URI absolutePath;
        String scope;
        super.setTarget(target);
        if (target instanceof Property && INSTANCE_SCOPE.equals(scope = (absolutePath = (property = (Property)target).getAbsolutePath()).authority())) {
            this.paths.put(property, absolutePath);
        }
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (this.rootPreferenceNode != null && !notification.isTouch()) {
            switch (notification.getEventType()) {
                case 1: {
                    if (notification.getFeature() != PreferencesPackage.Literals.PROPERTY__VALUE) break;
                    Property property = (Property)notification.getNotifier();
                    this.notifyChanged(property, property.getValue());
                    break;
                }
                case 3: {
                    if (notification.getFeature() != PreferencesPackage.Literals.PREFERENCE_NODE__PROPERTIES) break;
                    Property property = (Property)notification.getNewValue();
                    this.notifyChanged(property, property.getValue());
                    break;
                }
                case 4: {
                    if (notification.getFeature() != PreferencesPackage.Literals.PREFERENCE_NODE__PROPERTIES) break;
                    Property property = (Property)notification.getOldValue();
                    URI uri = this.paths.get(property);
                    String path = PreferencesFactory.eINSTANCE.convertURI(uri);
                    PreferencesUtil.PreferenceProperty preferenceProperty = new PreferencesUtil.PreferenceProperty(path);
                    String value = preferenceProperty.getEffectiveProperty().get(null);
                    this.notifyChanged(property, value);
                }
            }
        }
    }

    protected void notifyChanged(Property property, String value) {
        URI absolutePath = this.paths.get(property);
        if (absolutePath != null) {
            this.notifyChanged(absolutePath, value);
        }
    }

    protected void notifyChanged(URI absolutePath, String value) {
        this.values.put(absolutePath, value);
    }
}

