/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.impl;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.oomph.setup.LinkLocationTask;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.impl.Messages;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.util.IOUtil;

public class LinkLocationTaskImpl
extends SetupTaskImpl
implements LinkLocationTask {
    protected static final String PATH_EDEFAULT = null;
    protected String path = PATH_EDEFAULT;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    private transient File link;
    private transient File canonicalPath;

    protected LinkLocationTaskImpl() {
    }

    protected EClass eStaticClass() {
        return SetupPackage.Literals.LINK_LOCATION_TASK;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String newPath) {
        String oldPath = this.path;
        this.path = newPath;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldPath, (Object)this.path));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldName, (Object)this.name));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getPath();
            }
            case 11: {
                return this.getName();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setPath((String)newValue);
                return;
            }
            case 11: {
                this.setName((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setPath(PATH_EDEFAULT);
                return;
            }
            case 11: {
                this.setName(NAME_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return PATH_EDEFAULT == null ? this.path != null : !PATH_EDEFAULT.equals(this.path);
            }
            case 11: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (path: ");
        result.append(this.path);
        result.append(", name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }

    public int getPriority() {
        return 200;
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        if (context.isSelfHosting() && context.getTrigger() != Trigger.BOOTSTRAP) {
            return false;
        }
        File links = new File(context.getProductLocation(), "links");
        this.canonicalPath = new File(this.getPath()).getCanonicalFile();
        String name = this.getName();
        if (name == null || name.length() == 0) {
            name = this.canonicalPath.getName();
        }
        this.link = new File(links, String.valueOf(name) + ".link");
        return !this.link.exists();
    }

    public void perform(SetupTaskContext context) throws Exception {
        List<String> lines = Collections.singletonList("path=" + this.canonicalPath.toString().replace("\\", "\\\\"));
        IOUtil.writeLines((File)this.link, null, lines);
        context.setRestartNeeded(Messages.LinkLocationTaskImpl_ProductExtensionLocationsAdded_message);
    }
}

