/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.internal.core.listeners;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.impl.XMLOptionsImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.equinox.internal.p2.repository.Credentials;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.ModelElement;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.internal.core.RootAnalyzer;
import org.eclipse.oomph.targlets.Targlet;
import org.eclipse.oomph.targlets.core.ITargletContainer;
import org.eclipse.oomph.targlets.core.TargletContainerEvent;
import org.eclipse.oomph.targlets.core.WorkspaceIUInfo;
import org.eclipse.oomph.targlets.internal.core.TargletsCorePlugin;
import org.eclipse.oomph.targlets.internal.core.listeners.FileUpdater;
import org.eclipse.oomph.targlets.internal.core.listeners.WorkspaceUpdateListener;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetDefinitionGenerator
extends WorkspaceUpdateListener {
    public static final String ANNOTATION = "http:/www.eclipse.org/oomph/targlets/TargetDefinitionGenerator";
    public static final String ANNOTATION_NAME = "name";
    public static final String ANNOTATION_LOCATION = "location";
    public static final String ANNOTATION_PREFERRED_REPOSITORIES = "preferredRepositories";
    public static final String ANNOTATION_GENERATE_IMPLICIT_UNITS = "generateImplicitUnits";
    public static final String ANNOTATION_MINIMIZE_IMPLICIT_UNITS = "minimizeImplicitUnits";
    public static final String ANNOTATION_GENERATE_VERSIONS = "generateVersions";
    public static final String ANNOTATION_INCLUDE_ALL_PLATFORMS = "includeAllPlatforms";
    public static final String ANNOTATION_INCLUDE_CONFIGURE_PHASE = "includeConfigurePhase";
    public static final String ANNOTATION_INCLUDE_MODE = "includeMode";
    public static final String ANNOTATION_INCLUDE_SOURCE = "includeSource";
    public static final String ANNOTATION_EXTRA_UNITS = "extraUnits";
    public static final String ANNOTATION_SINGLE_LOCATION = "singleLocation";
    public static final String ANNOTATION_GENERATE_SERVER_XML = "generateServerXML";
    public static final String NESTED_ANNOTATION_REPOSITORY_IDS = "RepositoryIDs";
    private static final Pattern SEQUENCE_NUMBER_PATTERN = Pattern.compile("sequenceNumber=\"([0-9]+)\"");
    private static final String TRUE = Boolean.TRUE.toString();
    private static final String SETTINGS_NAMESPACE = "http://maven.apache.org/SETTINGS/1.0.0";

    @Override
    protected void handleTargletContainerEvent(TargletContainerEvent.ProfileUpdateSucceededEvent profileUpdateSucceededEvent, TargletContainerEvent.WorkspaceUpdateFinishedEvent workspaceUpdateFinishedEvent, IProgressMonitor monitor) throws Exception {
        ITargletContainer targletContainer = profileUpdateSucceededEvent.getSource();
        for (Targlet targlet : targletContainer.getTarglets()) {
            for (Annotation annotation : BaseUtil.getAnnotations((ModelElement)targlet, (String)ANNOTATION)) {
                Profile profile = profileUpdateSucceededEvent.getProfile();
                IInstallableUnit artificialRoot = profileUpdateSucceededEvent.getArtificialRoot();
                List<IMetadataRepository> metadataRepositories = profileUpdateSucceededEvent.getMetadataRepositories();
                Map<IInstallableUnit, WorkspaceIUInfo> workspaceIUInfos = profileUpdateSucceededEvent.getWorkspaceIUInfos();
                TargetDefinitionGenerator.generateTargetDefinition(targlet, annotation, profile, artificialRoot, metadataRepositories, workspaceIUInfos, monitor);
            }
        }
    }

    private static void generateTargetDefinition(Targlet targlet, Annotation annotation, Profile profile, IInstallableUnit artificialRoot, final List<IMetadataRepository> metadataRepositories, Map<IInstallableUnit, WorkspaceIUInfo> workspaceIUInfos, final IProgressMonitor monitor) throws Exception {
        monitor.setTaskName("Checking for generated target definition updates");
        EMap details = annotation.getDetails();
        String targletName = (String)details.get((Object)ANNOTATION_NAME);
        final String name = StringUtil.isEmpty((String)targletName) ? "Generated from " + targlet.getName() : targletName;
        String location = (String)details.get((Object)ANNOTATION_LOCATION);
        if (StringUtil.isEmpty((String)location)) {
            location = File.createTempFile("tmp-", ".target").getAbsolutePath();
            TargletsCorePlugin.INSTANCE.log("Generating target definition for targlet " + targlet.getName() + " to " + location);
        }
        File targetDefinition = new File(location);
        Set<IVersionedId> extraUnits = TargetDefinitionGenerator.getExtraUnits(annotation);
        List<String> preferredURLs = TargetDefinitionGenerator.getPreferredRepositories(annotation);
        final boolean singleLocation = TargetDefinitionGenerator.isAnnotationDetail(annotation, ANNOTATION_SINGLE_LOCATION, false);
        boolean generateImplicitUnits = TargetDefinitionGenerator.isAnnotationDetail(annotation, ANNOTATION_GENERATE_IMPLICIT_UNITS, false);
        boolean minimizeImplicitUnits = TargetDefinitionGenerator.isAnnotationDetail(annotation, ANNOTATION_MINIMIZE_IMPLICIT_UNITS, false);
        final boolean versions = TargetDefinitionGenerator.isAnnotationDetail(annotation, ANNOTATION_GENERATE_VERSIONS, false);
        final boolean includeAllPlatforms = TargetDefinitionGenerator.isAnnotationDetail(annotation, ANNOTATION_INCLUDE_ALL_PLATFORMS, targlet.isIncludeAllPlatforms());
        final boolean includeConfigurePhase = TargetDefinitionGenerator.isAnnotationDetail(annotation, ANNOTATION_INCLUDE_CONFIGURE_PHASE, true);
        final String includeMode = TargetDefinitionGenerator.getAnnotationDetail(annotation, ANNOTATION_INCLUDE_MODE, targlet.isIncludeAllRequirements() ? "planner" : "slicer");
        final boolean includeSource = TargetDefinitionGenerator.isAnnotationDetail(annotation, ANNOTATION_INCLUDE_SOURCE, targlet.isIncludeSources());
        boolean generateServerXML = TargetDefinitionGenerator.isAnnotationDetail(annotation, ANNOTATION_GENERATE_SERVER_XML, false);
        final LinkedHashMap<String, String> repositoryIDs = new LinkedHashMap<String, String>();
        Annotation repositoryIDsAnnotation = annotation.getAnnotation(NESTED_ANNOTATION_REPOSITORY_IDS);
        if (repositoryIDsAnnotation != null) {
            for (Map.Entry entry : repositoryIDsAnnotation.getDetails().entrySet()) {
                repositoryIDs.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        final Map<IMetadataRepository, Set<IInstallableUnit>> repositoryIUs = TargetDefinitionGenerator.analyzeRepositories(targlet, profile, artificialRoot, metadataRepositories, workspaceIUInfos, extraUnits, preferredURLs, generateImplicitUnits, minimizeImplicitUnits, singleLocation, monitor);
        new FileUpdater(){
            private int sequenceNumber;

            protected String createNewContents(String oldContents, String encoding, String nl) {
                Matcher matcher;
                if (oldContents != null && (matcher = SEQUENCE_NUMBER_PATTERN.matcher(oldContents)).find()) {
                    this.sequenceNumber = Integer.parseInt(matcher.group(1));
                }
                XML.Escaper escaper = new XML.Escaper(encoding);
                StringBuilder builder = new StringBuilder();
                builder.append("<?xml version=\"1.0\" encoding=\"" + encoding + "\" standalone=\"no\"?>");
                builder.append(nl);
                builder.append("<?pde version=\"3.8\"?>");
                builder.append(nl);
                builder.append("<target name=\"" + escaper.escape(name) + "\" sequenceNumber=\"" + this.sequenceNumber + "\">");
                builder.append(nl);
                builder.append("  <locations>");
                builder.append(nl);
                if (singleLocation) {
                    builder.append("    <location includeAllPlatforms=\"" + includeAllPlatforms + "\" includeConfigurePhase=\"" + includeConfigurePhase + "\" includeMode=\"" + includeMode + "\" includeSource=\"" + includeSource + "\" type=\"InstallableUnit\">");
                    builder.append(nl);
                    boolean first = true;
                    for (Map.Entry entry : repositoryIUs.entrySet()) {
                        ArrayList list;
                        IMetadataRepository repository = (IMetadataRepository)entry.getKey();
                        Set set = (Set)entry.getValue();
                        if (first && !(list = new ArrayList(set)).isEmpty()) {
                            LinkedHashSet<String> elements = new LinkedHashSet<String>();
                            Collections.sort(list);
                            for (IInstallableUnit iu : list) {
                                elements.add(this.formatElement(iu, versions, escaper));
                            }
                            for (String element : elements) {
                                builder.append("      ");
                                builder.append(element);
                                builder.append(nl);
                            }
                            first = false;
                        }
                        builder.append("      <repository ");
                        java.net.URI repositoryLocation = repository.getLocation();
                        String repositoryID = (String)repositoryIDs.get(repositoryLocation.toString());
                        if (repositoryID != null) {
                            builder.append("id=\"").append(repositoryID).append("\" ");
                        }
                        builder.append("location=\"" + escaper.escape(repositoryLocation) + "\"/>");
                        builder.append(nl);
                    }
                    builder.append("    </location>");
                    builder.append(nl);
                } else {
                    for (Map.Entry entry : repositoryIUs.entrySet()) {
                        IMetadataRepository repository = (IMetadataRepository)entry.getKey();
                        Set set = (Set)entry.getValue();
                        ArrayList list = new ArrayList(set);
                        if (list.isEmpty()) continue;
                        builder.append("    <location includeAllPlatforms=\"" + includeAllPlatforms + "\" includeConfigurePhase=\"" + includeConfigurePhase + "\" includeMode=\"" + includeMode + "\" includeSource=\"" + includeSource + "\" type=\"InstallableUnit\">");
                        builder.append(nl);
                        LinkedHashSet<String> elements = new LinkedHashSet<String>();
                        Collections.sort(list);
                        for (IInstallableUnit iu : list) {
                            elements.add(this.formatElement(iu, versions, escaper));
                        }
                        for (String element : elements) {
                            builder.append("      ");
                            builder.append(element);
                            builder.append(nl);
                        }
                        builder.append("      <repository ");
                        java.net.URI repositoryLocation = repository.getLocation();
                        String repositoryID = (String)repositoryIDs.get(repositoryLocation.toString());
                        if (repositoryID != null) {
                            builder.append("id=\"").append(repositoryID).append("\" ");
                        }
                        builder.append("location=\"" + escaper.escape(repositoryLocation) + "\"/>");
                        builder.append(nl);
                        builder.append("    </location>");
                        builder.append(nl);
                    }
                }
                builder.append("  </locations>");
                builder.append(nl);
                builder.append("</target>");
                builder.append(nl);
                return builder.toString();
            }

            protected void setContents(URI uri, String encoding, String contents) throws IOException {
                monitor.subTask("Updating " + (uri.isPlatformResource() ? uri.toPlatformString(true) : uri.toFileString()));
                contents = contents.replace("sequenceNumber=\"" + this.sequenceNumber + "\"", "sequenceNumber=\"" + (this.sequenceNumber + 1) + "\"");
                super.setContents(uri, encoding, contents);
            }

            private String formatElement(IInstallableUnit iu, boolean withVersion, XML.Escaper escaper) {
                Version version = iu.getVersion();
                if (!withVersion || version == null) {
                    version = Version.emptyVersion;
                }
                return "<unit id=\"" + escaper.escape(iu.getId()) + "\" version=\"" + escaper.escape(version) + "\"/>";
            }
        }.update(targetDefinition);
        if (generateServerXML) {
            new FileUpdater(){

                protected String createNewContents(String oldContents, String encoding, String nl) {
                    FeatureMap servers;
                    EStructuralFeature serversElement;
                    EObject documentRoot;
                    AnyType rootElement;
                    List serversGroup;
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    BasicExtendedMetaData extendedMetaData = new BasicExtendedMetaData(resourceSet.getPackageRegistry());
                    resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new ResourceFactoryImpl((ExtendedMetaData)extendedMetaData){
                        private final /* synthetic */ ExtendedMetaData val$extendedMetaData;
                        {
                            this.val$extendedMetaData = extendedMetaData;
                        }

                        public Resource createResource(URI uri) {
                            XMLResourceImpl result = new XMLResourceImpl(uri);
                            result.setEncoding("UTF-8");
                            result.getDefaultSaveOptions().put("EXTENDED_META_DATA", this.val$extendedMetaData);
                            result.getDefaultLoadOptions().put("EXTENDED_META_DATA", this.val$extendedMetaData);
                            result.getDefaultLoadOptions().put("USE_LEXICAL_HANDLER", Boolean.TRUE);
                            result.getDefaultSaveOptions().put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
                            result.getDefaultLoadOptions().put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
                            result.getDefaultSaveOptions().put("SCHEMA_LOCATION", Boolean.TRUE);
                            XMLOptionsImpl xmlOptions = new XMLOptionsImpl();
                            xmlOptions.setProcessAnyXML(true);
                            xmlOptions.setProcessSchemaLocations(false);
                            result.getDefaultLoadOptions().put("XML_OPTIONS", xmlOptions);
                            return result;
                        }
                    });
                    Resource resource = resourceSet.createResource(URI.createURI((String)"settings.xml"));
                    if (!StringUtil.isEmpty((String)oldContents)) {
                        try {
                            resource.load((InputStream)new URIConverter.ReadableInputStream(oldContents), null);
                        }
                        catch (IOException iOException) {}
                    }
                    if (resource.getContents().isEmpty()) {
                        EStructuralFeature settingsElement = extendedMetaData.demandFeature(TargetDefinitionGenerator.SETTINGS_NAMESPACE, "settings", true);
                        EClass documentRootEClass = settingsElement.getEContainingClass();
                        EObject documentRoot2 = EcoreUtil.create((EClass)documentRootEClass);
                        AnyType settings = XMLTypeFactory.eINSTANCE.createAnyType();
                        documentRoot2.eSet(settingsElement, (Object)settings);
                        EMap xmlnsPrefixMap = (EMap)documentRoot2.eGet((EStructuralFeature)extendedMetaData.getXMLNSPrefixMapFeature(documentRootEClass));
                        xmlnsPrefixMap.put((Object)"", (Object)TargetDefinitionGenerator.SETTINGS_NAMESPACE);
                        xmlnsPrefixMap.put((Object)"xsi", (Object)"http://www.w3.org/2001/XMLSchema-instance");
                        EStructuralFeature schemaLocation = extendedMetaData.demandFeature("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", false);
                        settings.eSet(schemaLocation, (Object)"http://maven.apache.org/SETTINGS/1.0.0 http://maven.apache.org/xsd/settings-1.0.0.xsd");
                        resource.getContents().add((Object)documentRoot2);
                    }
                    if ((serversGroup = (List)(rootElement = (AnyType)(documentRoot = (EObject)resource.getContents().get(0)).eContents().get(0)).eGet(serversElement = extendedMetaData.demandFeature(TargetDefinitionGenerator.SETTINGS_NAMESPACE, "servers", true))).isEmpty()) {
                        FeatureMapUtil.addText((FeatureMap)rootElement.getMixed(), (String)(String.valueOf(nl) + "  "));
                        AnyType serversInstance = XMLTypeFactory.eINSTANCE.createAnyType();
                        serversGroup.add(serversInstance);
                        FeatureMapUtil.addText((FeatureMap)rootElement.getMixed(), (String)nl);
                        servers = serversInstance.getMixed();
                    } else {
                        servers = ((AnyType)serversGroup.get(0)).getMixed();
                    }
                    EStructuralFeature serverElement = extendedMetaData.demandFeature(TargetDefinitionGenerator.SETTINGS_NAMESPACE, "server", true);
                    EStructuralFeature idElement = extendedMetaData.demandFeature(TargetDefinitionGenerator.SETTINGS_NAMESPACE, "id", true);
                    EStructuralFeature usernameElement = extendedMetaData.demandFeature(TargetDefinitionGenerator.SETTINGS_NAMESPACE, "username", true);
                    EStructuralFeature passwordElement = extendedMetaData.demandFeature(TargetDefinitionGenerator.SETTINGS_NAMESPACE, "password", true);
                    boolean added = false;
                    block7: for (IMetadataRepository repository : metadataRepositories) {
                        java.net.URI location = repository.getLocation();
                        try {
                            AnyType server2;
                            UIServices.AuthenticationInfo authenticationInfo;
                            String repositoryID = (String)repositoryIDs.get(location.toString());
                            if (repositoryID == null) {
                                repositoryID = location.toString();
                            }
                            if ((authenticationInfo = Credentials.forLocation((java.net.URI)location, (boolean)false)) == null) continue;
                            List serverElements = (List)servers.get(serverElement, true);
                            for (AnyType server2 : serverElements) {
                                List passwordElements;
                                AnyType id;
                                FeatureMap mixed = server2.getMixed();
                                List idElements = (List)mixed.get(idElement, true);
                                if (idElements.size() != 1 || !repositoryID.equals((id = (AnyType)idElements.get(0)).getMixed().getValue(0))) continue;
                                List userNameElements = (List)mixed.get(usernameElement, true);
                                if (userNameElements.size() == 1) {
                                    ((AnyType)userNameElements.get(0)).getMixed().setValue(0, (Object)authenticationInfo.getUserName());
                                }
                                if ((passwordElements = (List)mixed.get(passwordElement, true)).size() != 1) continue block7;
                                ((AnyType)passwordElements.get(0)).getMixed().setValue(0, (Object)authenticationInfo.getPassword());
                                continue block7;
                            }
                            added = true;
                            server2 = XMLTypeFactory.eINSTANCE.createAnyType();
                            FeatureMapUtil.addText((FeatureMap)servers, (String)(String.valueOf(nl) + "    "));
                            servers.add((Object)FeatureMapUtil.createEntry((EStructuralFeature)serverElement, (Object)server2));
                            FeatureMap mixed = server2.getMixed();
                            AnyType id = XMLTypeFactory.eINSTANCE.createAnyType();
                            FeatureMapUtil.addText((FeatureMap)id.getMixed(), (String)repositoryID);
                            FeatureMapUtil.addText((FeatureMap)mixed, (String)(String.valueOf(nl) + "      "));
                            mixed.add((Object)FeatureMapUtil.createEntry((EStructuralFeature)idElement, (Object)id));
                            AnyType username = XMLTypeFactory.eINSTANCE.createAnyType();
                            FeatureMapUtil.addText((FeatureMap)username.getMixed(), (String)authenticationInfo.getUserName());
                            FeatureMapUtil.addText((FeatureMap)mixed, (String)(String.valueOf(nl) + "      "));
                            mixed.add((Object)FeatureMapUtil.createEntry((EStructuralFeature)usernameElement, (Object)username));
                            AnyType password = XMLTypeFactory.eINSTANCE.createAnyType();
                            FeatureMapUtil.addText((FeatureMap)password.getMixed(), (String)authenticationInfo.getPassword());
                            FeatureMapUtil.addText((FeatureMap)mixed, (String)(String.valueOf(nl) + "      "));
                            mixed.add((Object)FeatureMapUtil.createEntry((EStructuralFeature)passwordElement, (Object)password));
                            FeatureMapUtil.addText((FeatureMap)mixed, (String)(String.valueOf(nl) + "    "));
                        }
                        catch (Credentials.LoginCanceledException loginCanceledException) {
                        }
                        catch (CoreException coreException) {}
                    }
                    if (added) {
                        FeatureMapUtil.addText((FeatureMap)servers, (String)(String.valueOf(nl) + "  "));
                    }
                    try {
                        StringWriter writer = new StringWriter();
                        URIConverter.WriteableOutputStream out = new URIConverter.WriteableOutputStream((Writer)writer, encoding);
                        resource.save((OutputStream)out, null);
                        out.close();
                        writer.write(nl);
                        writer.close();
                        return writer.toString();
                    }
                    catch (IOException ex) {
                        throw new IORuntimeException((Throwable)ex);
                    }
                }

                protected void setContents(URI uri, String encoding, String contents) throws IOException {
                    super.setContents(uri, encoding, contents);
                }
            }.update(new File(PropertiesUtil.getUserHome(), ".m2/settings.xml"));
        }
    }

    private static boolean isAnnotationDetail(Annotation annotation, String key, boolean defaultValue) {
        String detail = TargetDefinitionGenerator.getAnnotationDetail(annotation, key, Boolean.toString(defaultValue));
        return TRUE.equalsIgnoreCase(detail);
    }

    private static String getAnnotationDetail(Annotation annotation, String key, String defaultValue) {
        String value = (String)annotation.getDetails().get((Object)key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private static Set<IVersionedId> getExtraUnits(Annotation annotation) {
        HashSet<IVersionedId> extraUnits = new HashSet<IVersionedId>();
        String values = (String)annotation.getDetails().get((Object)ANNOTATION_EXTRA_UNITS);
        if (!StringUtil.isEmpty((String)values)) {
            String[] stringArray = values.replace(',', ' ').split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (!StringUtil.isEmpty((String)value)) {
                    int pos = value.lastIndexOf(95);
                    String id = pos == -1 ? value : value.substring(0, pos);
                    Version version = pos == -1 ? Version.emptyVersion : Version.create((String)value.substring(pos + 1));
                    extraUnits.add((IVersionedId)new VersionedId(id, version));
                }
                ++n2;
            }
        }
        return extraUnits;
    }

    private static List<String> getPreferredRepositories(Annotation annotation) {
        ArrayList<String> preferredRepositories = new ArrayList<String>();
        String values = (String)annotation.getDetails().get((Object)ANNOTATION_PREFERRED_REPOSITORIES);
        if (!StringUtil.isEmpty((String)values)) {
            String[] stringArray = values.replace(',', ' ').split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (!StringUtil.isEmpty((String)value)) {
                    preferredRepositories.add(value);
                }
                ++n2;
            }
        }
        return preferredRepositories;
    }

    private static Map<IMetadataRepository, Set<IInstallableUnit>> analyzeRepositories(Targlet targlet, Profile profile, IInstallableUnit artificialRoot, List<IMetadataRepository> metadataRepositories, Map<IInstallableUnit, WorkspaceIUInfo> workspaceIUInfos, Set<IVersionedId> extraUnits, List<String> preferredURLs, boolean generateImplicitUnits, boolean minimizeImplicitUnits, boolean singleLocation, IProgressMonitor monitor) {
        HashSet<String> workspaceIDs = new HashSet<String>();
        for (IInstallableUnit iu : workspaceIUInfos.keySet()) {
            workspaceIDs.add(iu.getId());
        }
        HashSet<IInstallableUnit> profileIUs = new HashSet<IInstallableUnit>();
        for (IInstallableUnit iu : P2Util.asIterable((IQueryResult)profile.query(QueryUtil.createIUAnyQuery(), monitor))) {
            String id = iu.getId();
            if (id.endsWith(".source") || id.endsWith(".source.feature.group") || id.endsWith(".source.feature.feature.group") || id.endsWith(".feature.jar") || "org.eclipse.oomph.p2.source.container".equals(id) || id.equals("a.jre") || "true".equals(iu.getProperty("org.eclipse.oomph.targlet.source")) || "true".equals(iu.getProperty("org.eclipse.oomph.targlet.workspace")) || workspaceIDs.contains(id)) continue;
            profileIUs.add(iu);
        }
        Map<String, IMetadataRepository> queryables = TargetDefinitionGenerator.sortMetadataRepositories(targlet, metadataRepositories, preferredURLs, monitor);
        return TargetDefinitionGenerator.assignUnits(queryables, extraUnits, generateImplicitUnits, minimizeImplicitUnits, singleLocation, profileIUs, monitor);
    }

    private static Map<String, IMetadataRepository> sortMetadataRepositories(Targlet targlet, List<IMetadataRepository> metadataRepositories, List<String> preferredURLs, IProgressMonitor monitor) {
        String url;
        LinkedHashMap<String, IMetadataRepository> queryables = new LinkedHashMap<String, IMetadataRepository>();
        for (String urlPrefix : preferredURLs) {
            for (IMetadataRepository metadataRepository : metadataRepositories) {
                String url2 = metadataRepository.getLocation().toString();
                if (queryables.containsKey(url2) || !url2.startsWith(urlPrefix)) continue;
                queryables.put(url2, metadataRepository);
            }
        }
        for (Repository repository : targlet.getActiveRepositories()) {
            IMetadataRepository metadataRepository;
            TargletsCorePlugin.checkCancelation((IProgressMonitor)monitor);
            url = repository.getURL();
            if (queryables.containsKey(url) || (metadataRepository = TargetDefinitionGenerator.getMetadataRepository(url, metadataRepositories)) == null) continue;
            queryables.put(url, metadataRepository);
        }
        for (IMetadataRepository metadataRepository : metadataRepositories) {
            url = metadataRepository.getLocation().toString();
            if (queryables.containsKey(url)) continue;
            queryables.put(url, metadataRepository);
        }
        return queryables;
    }

    private static IMetadataRepository getMetadataRepository(String url, List<IMetadataRepository> metadataRepositories) {
        for (IMetadataRepository metadataRepository : metadataRepositories) {
            if (!metadataRepository.getLocation().toString().equals(url)) continue;
            return metadataRepository;
        }
        return null;
    }

    private static Map<IMetadataRepository, Set<IInstallableUnit>> assignUnits(Map<String, IMetadataRepository> queryables, Set<IVersionedId> extraUnits, boolean generateImplicitUnits, boolean minimizeImplicitUnits, boolean singleLocation, Set<IInstallableUnit> resolvedIUs, IProgressMonitor monitor) {
        LinkedHashMap<IMetadataRepository, Set<IInstallableUnit>> result = new LinkedHashMap<IMetadataRepository, Set<IInstallableUnit>>();
        if (singleLocation) {
            IQueryable queryable = QueryUtil.compoundQueryable(queryables.values());
            boolean first = true;
            for (String url : queryables.keySet()) {
                IMetadataRepository metadataRepository = queryables.get(url);
                Set ius = CollectionUtil.getSet(result, (Object)metadataRepository);
                if (!first) continue;
                ius.addAll(resolvedIUs);
                if (!generateImplicitUnits) {
                    RootAnalyzer.removeImplicitUnits((Set)ius, (IQueryable)queryable, (IProgressMonitor)monitor, (boolean)false);
                } else if (minimizeImplicitUnits) {
                    RootAnalyzer.removeImplicitUnits((Set)ius, (IQueryable)queryable, (IProgressMonitor)monitor, (boolean)true);
                }
                for (IVersionedId extraUnit : extraUnits) {
                    Iterator iterator = P2Util.asIterable((IQueryResult)queryable.query(QueryUtil.createIUQuery((IVersionedId)extraUnit), null)).iterator();
                    if (!iterator.hasNext()) continue;
                    IInstallableUnit extraIU = (IInstallableUnit)iterator.next();
                    ius.add(extraIU);
                }
                first = false;
            }
        } else {
            block2: for (IInstallableUnit iu : resolvedIUs) {
                for (IMetadataRepository metadataRepository : queryables.values()) {
                    if (metadataRepository.query(QueryUtil.createIUQuery((IVersionedId)iu), null).isEmpty()) continue;
                    CollectionUtil.add(result, (Object)metadataRepository, (Object)iu);
                    continue block2;
                }
            }
            if (!generateImplicitUnits) {
                RootAnalyzer.removeImplicitUnits(result, (IProgressMonitor)monitor, (boolean)false);
            } else if (minimizeImplicitUnits) {
                RootAnalyzer.removeImplicitUnits(result, (IProgressMonitor)monitor, (boolean)true);
            }
            for (String url : queryables.keySet()) {
                IMetadataRepository metadataRepository;
                metadataRepository = queryables.get(url);
                Set ius = CollectionUtil.getSet(result, (Object)metadataRepository);
                Iterator<IVersionedId> it = extraUnits.iterator();
                while (it.hasNext()) {
                    IVersionedId extraUnit = it.next();
                    Iterator iterator = P2Util.asIterable((IQueryResult)metadataRepository.query(QueryUtil.createIUQuery((IVersionedId)extraUnit), null)).iterator();
                    if (!iterator.hasNext()) continue;
                    IInstallableUnit extraIU = (IInstallableUnit)iterator.next();
                    ius.add(extraIU);
                    it.remove();
                }
            }
        }
        return result;
    }

    private static final class XML
    extends XMLSaveImpl {
        private XML(XMLHelper helper) {
            super(helper);
        }

        public static final class Escaper
        extends XMLSaveImpl.Escape {
            private static final int MAX_UTF_MAPPABLE_CODEPOINT = 0x10FFFF;
            private static final int MAX_LATIN1_MAPPABLE_CODEPOINT = 255;
            private static final int MAX_ASCII_MAPPABLE_CODEPOINT = 127;

            public Escaper(String encoding) {
                int maxSafeChar = 0x10FFFF;
                if (encoding != null) {
                    if (encoding.equalsIgnoreCase("ASCII") || encoding.equalsIgnoreCase("US-ASCII")) {
                        maxSafeChar = 127;
                    } else if (encoding.equalsIgnoreCase("ISO-8859-1")) {
                        maxSafeChar = 255;
                    }
                }
                this.setMappingLimit(maxSafeChar);
            }

            public String escape(Object value) {
                return this.convert(String.valueOf(value));
            }
        }
    }
}

