/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.style.theme;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.style.theme.ThemeConfiguration;

public class ThemeManager {
    private final IConfigRegistry configRegistry;
    private ThemeConfiguration currentTheme;

    public ThemeManager(IConfigRegistry configRegistry) {
        if (configRegistry == null) {
            throw new IllegalArgumentException("IConfigRegistry can not be null!");
        }
        this.configRegistry = configRegistry;
    }

    public void applyTheme(ThemeConfiguration configuration) {
        this.cleanThemeConfiguration();
        configuration.configureRegistry(this.configRegistry);
        this.currentTheme = configuration;
    }

    protected void cleanThemeConfiguration() {
        if (this.currentTheme != null) {
            this.currentTheme.unregisterThemeStyleConfigurations(this.configRegistry);
        }
    }

    public void refreshCurrentTheme() {
        if (this.currentTheme != null) {
            this.currentTheme.configureRegistry(this.configRegistry);
        }
    }
}

