/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.nebula.richtext;

import java.io.Serializable;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringEscapeUtils;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import org.eclipse.nebula.widgets.nattable.extension.nebula.richtext.MarkupProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexMarkupValue
implements MarkupProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(RegexMarkupValue.class);
    private static final String GROUP_INDEX_PLACEHOLDER = "$1";
    private static final Pattern HTML_ENTITY_PATTERN = Pattern.compile("\\&([^\\&])*;");
    private String originalRegexValue;
    private String markupPrefix;
    private String markupSuffix;
    private String markupValue;
    private String markupRegexValue;
    private XMLInputFactory factory = XMLInputFactory.newInstance();
    private boolean caseInsensitive;
    private boolean unicodeCase;

    public RegexMarkupValue(String value, String markupPrefix, String markupSuffix) {
        this.factory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        this.caseInsensitive = true;
        this.unicodeCase = false;
        this.originalRegexValue = StringEscapeUtils.escapeHtml4((String)String.valueOf(value));
        this.markupPrefix = markupPrefix;
        this.markupSuffix = markupSuffix;
        this.markupValue = String.valueOf(markupPrefix) + GROUP_INDEX_PLACEHOLDER + markupSuffix;
        this.markupRegexValue = String.valueOf(markupPrefix) + value + markupSuffix;
    }

    @Override
    public String applyMarkup(String input) {
        String result = "";
        if (this.getOriginalRegexValue() != null && !this.getOriginalRegexValue().isEmpty()) {
            block42: {
                Pattern pattern = null;
                if (this.caseInsensitive) {
                    int flags = this.unicodeCase ? 66 : 2;
                    pattern = Pattern.compile(this.getOriginalRegexValue(), flags);
                } else {
                    pattern = Pattern.compile(this.getOriginalRegexValue());
                }
                XMLEventReader parser = null;
                try {
                    try {
                        Throwable throwable = null;
                        Object var6_9 = null;
                        try (StringReader reader = new StringReader("<root>" + input + "</root>");){
                            parser = this.factory.createXMLEventReader(reader);
                            String textToParse = "";
                            while (parser.hasNext()) {
                                XMLEvent event = parser.nextEvent();
                                switch (event.getEventType()) {
                                    case 7: {
                                        break;
                                    }
                                    case 8: {
                                        parser.close();
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        if (textToParse.length() > 0) {
                                            textToParse = StringEscapeUtils.escapeHtml4((String)String.valueOf(textToParse));
                                            Matcher matcher = pattern.matcher(textToParse);
                                            Matcher htmlMatcher = HTML_ENTITY_PATTERN.matcher(textToParse);
                                            MutableList entityIndexes = Lists.mutable.empty();
                                            while (htmlMatcher.find()) {
                                                entityIndexes.add((Object)PrimitiveTuples.pair((int)htmlMatcher.start(), (int)htmlMatcher.end()));
                                            }
                                            int rStart = 0;
                                            int rEnd = textToParse.length();
                                            while (matcher.find()) {
                                                result = String.valueOf(result) + textToParse.substring(rStart, matcher.start());
                                                if (entityIndexes.anySatisfy((Predicate & Serializable)pair -> matcher.start() > pair.getOne() && matcher.end() < pair.getTwo())) {
                                                    result = String.valueOf(result) + matcher.group();
                                                } else if (matcher.groupCount() > 0) {
                                                    String group = matcher.group();
                                                    Matcher tmpMatcher = pattern.matcher(group);
                                                    result = String.valueOf(result) + tmpMatcher.replaceAll(this.markupValue);
                                                } else {
                                                    result = String.valueOf(result) + this.markupRegexValue;
                                                }
                                                rStart = matcher.end();
                                            }
                                            result = String.valueOf(result) + textToParse.substring(rStart, rEnd);
                                            textToParse = "";
                                        }
                                        result = String.valueOf(result) + event.toString();
                                        break;
                                    }
                                    case 4: {
                                        Characters characters = event.asCharacters();
                                        textToParse = String.valueOf(textToParse) + characters.getData();
                                        break;
                                    }
                                    case 9: {
                                        EntityReference e = (EntityReference)event;
                                        textToParse = String.valueOf(textToParse) + StringEscapeUtils.unescapeHtml4((String)("&" + e.getName() + ";"));
                                        break;
                                    }
                                    default: {
                                        result = String.valueOf(result) + event.toString();
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (XMLStreamException e) {
                        LOG.error("Error on XML processing", (Throwable)e);
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (XMLStreamException e2) {
                                LOG.error("Error on closing the XMLEventReader", (Throwable)e2);
                            }
                        }
                        break block42;
                    }
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (XMLStreamException e) {
                            LOG.error("Error on closing the XMLEventReader", (Throwable)e);
                        }
                    }
                    throw throwable;
                }
                if (parser != null) {
                    try {
                        parser.close();
                    }
                    catch (XMLStreamException e) {
                        LOG.error("Error on closing the XMLEventReader", (Throwable)e);
                    }
                }
            }
            result = result.replace("<root>", "").replace("</root>", "");
        } else {
            result = input;
        }
        return result;
    }

    @Override
    public String removeMarkup(String input) {
        if (this.getOriginalRegexValue() != null && !this.getOriginalRegexValue().isEmpty()) {
            return input.replaceAll(this.markupPrefix, "").replaceAll(this.markupSuffix, "");
        }
        return input;
    }

    public void setRegexValue(String value) {
        this.originalRegexValue = StringEscapeUtils.escapeHtml4((String)String.valueOf(value));
        this.markupRegexValue = String.valueOf(this.markupPrefix) + value + this.markupSuffix;
    }

    protected String getOriginalRegexValue() {
        return this.originalRegexValue;
    }

    protected String getMarkupRegexValue() {
        return this.markupRegexValue;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public boolean isUnicodeCase() {
        return this.unicodeCase;
    }

    public void setUnicodeCase(boolean unicodeCase) {
        this.unicodeCase = unicodeCase;
    }
}

