/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractSelectionDialog<T>
extends TrayDialog {
    private Collection<T> result;
    private List<T> initialSelection;
    private String title;
    private String message = "";
    private int dialogBoundsStrategy = 3;
    private IDialogSettings dialogBoundsSettings = null;

    protected AbstractSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 0);
        if (this.message != null) {
            label.setText(this.message);
        }
        label.setFont(composite.getFont());
        return label;
    }

    protected List<T> getInitialSelection() {
        if (this.initialSelection == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.initialSelection);
    }

    protected String getMessage() {
        return this.message;
    }

    public Collection<T> getResult() {
        return this.result != null ? this.result : Collections.emptyList();
    }

    public Optional<T> getFirstResult() {
        if (this.result != null) {
            return this.result.stream().findFirst();
        }
        return Optional.empty();
    }

    public void setInitialSelection(T ... selectedElements) {
        this.initialSelection = Arrays.asList(selectedElements);
    }

    public void setInitialSelection(Collection<T> selectedElements) {
        this.initialSelection = new ArrayList<T>(selectedElements);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    protected void setResult(Collection<T> newUserSelection) {
        this.result = newUserSelection;
    }

    protected void setResult(T ... newUserSelection) {
        this.result = newUserSelection == null ? null : Arrays.asList(newUserSelection);
    }

    protected void setResult(ISelection selection, Class<T> target) {
        List selected = null;
        if (selection instanceof IStructuredSelection && target != null) {
            IStructuredSelection structured = (IStructuredSelection)selection;
            selected = structured.toList().stream().filter(p -> target.isInstance(p)).map(p -> target.cast(p)).collect(Collectors.toList());
        }
        this.setResult(selected);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDialogBoundsSettings(IDialogSettings settings, int strategy) {
        this.dialogBoundsStrategy = strategy;
        this.dialogBoundsSettings = settings;
    }

    @Override
    protected IDialogSettings getDialogBoundsSettings() {
        return this.dialogBoundsSettings;
    }

    @Override
    protected int getDialogBoundsStrategy() {
        return this.dialogBoundsStrategy;
    }

    @Override
    protected boolean isResizable() {
        return true;
    }
}

