/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.nebula.richtext;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.CellDisplayConversionUtils;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.AbstractCellPainter;
import org.eclipse.nebula.widgets.nattable.resize.command.ColumnResizeCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.RowResizeCommand;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.richtext.RichTextPainter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class RichTextCellPainter
extends AbstractCellPainter {
    protected RichTextPainter richTextPainter;
    protected boolean calculateByTextLength;
    protected boolean calculateByTextHeight;

    public RichTextCellPainter() {
        this(true, false, false);
    }

    public RichTextCellPainter(boolean wrapText) {
        this(wrapText, false, false);
    }

    public RichTextCellPainter(boolean wrapText, boolean calculate) {
        this(wrapText, calculate, calculate);
    }

    public RichTextCellPainter(boolean wrapText, boolean calculateByTextLength, boolean calculateByTextHeight) {
        this.richTextPainter = new RichTextPainter(wrapText);
        this.calculateByTextLength = calculateByTextLength;
        this.calculateByTextHeight = calculateByTextHeight;
    }

    public void paintCell(ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        IStyle cellStyle = CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry);
        this.setupGCFromConfig(gc, cellStyle);
        String htmlText = CellDisplayConversionUtils.convertDataType((ILayerCell)cell, (IConfigRegistry)configRegistry);
        Rectangle painterBounds = new Rectangle(bounds.x, bounds.y - this.richTextPainter.getParagraphSpace(), bounds.width, bounds.height);
        this.richTextPainter.paintHTML(htmlText, gc, painterBounds);
        int height = this.richTextPainter.getPreferredSize().y - 2 * this.richTextPainter.getParagraphSpace();
        if (this.performRowResize(height, painterBounds)) {
            cell.getLayer().doCommand((ILayerCommand)new RowResizeCommand(cell.getLayer(), cell.getRowPosition(), GUIHelper.convertVerticalDpiToPixel((int)height, (IConfigRegistry)configRegistry) + (cell.getBounds().height - bounds.height)));
        }
        if (this.performColumnResize(this.richTextPainter.getPreferredSize().x, painterBounds)) {
            cell.getLayer().doCommand((ILayerCommand)new ColumnResizeCommand(cell.getLayer(), cell.getColumnPosition(), GUIHelper.convertHorizontalDpiToPixel((int)this.richTextPainter.getPreferredSize().x, (IConfigRegistry)configRegistry) + (cell.getBounds().width - bounds.width)));
        }
    }

    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        this.setupGCFromConfig(gc, CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry));
        String htmlText = CellDisplayConversionUtils.convertDataType((ILayerCell)cell, (IConfigRegistry)configRegistry);
        this.richTextPainter.preCalculate(htmlText, gc, new Rectangle(0, 0, 0, cell.getBounds().height), false);
        return this.richTextPainter.getPreferredSize().x;
    }

    public int getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        this.setupGCFromConfig(gc, CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry));
        String htmlText = CellDisplayConversionUtils.convertDataType((ILayerCell)cell, (IConfigRegistry)configRegistry);
        this.richTextPainter.preCalculate(htmlText, gc, new Rectangle(0, 0, cell.getBounds().width, 0), true);
        return this.richTextPainter.getPreferredSize().y - 2 * this.richTextPainter.getParagraphSpace();
    }

    public void setupGCFromConfig(GC gc, IStyle cellStyle) {
        Color fg = (Color)cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR);
        Color bg = (Color)cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
        Font font = (Font)cellStyle.getAttributeValue(CellStyleAttributes.FONT);
        gc.setAntialias(-1);
        gc.setTextAntialias(-1);
        gc.setFont(font);
        gc.setForeground(fg != null ? fg : GUIHelper.COLOR_LIST_FOREGROUND);
        gc.setBackground(bg != null ? bg : GUIHelper.COLOR_LIST_BACKGROUND);
    }

    protected boolean performRowResize(int contentHeight, Rectangle rectangle) {
        return contentHeight > rectangle.height && this.calculateByTextHeight;
    }

    protected boolean performColumnResize(int contentWidth, Rectangle rectangle) {
        return contentWidth > rectangle.width && this.calculateByTextLength;
    }

    public boolean isCalculateByTextLength() {
        return this.calculateByTextLength;
    }

    public void setCalculateByTextLength(boolean calculateByTextLength) {
        this.calculateByTextLength = calculateByTextLength;
    }

    public boolean isCalculateByTextHeight() {
        return this.calculateByTextHeight;
    }

    public void setCalculateByTextHeight(boolean calculateByTextHeight) {
        this.calculateByTextHeight = calculateByTextHeight;
    }
}

