/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.command;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.group.RowGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.group.performance.RowGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiRowReorderCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class GroupMultiRowReorderCommandHandler
extends AbstractLayerCommandHandler<MultiRowReorderCommand> {
    private final RowGroupHeaderLayer rowGroupHeaderLayer;

    public GroupMultiRowReorderCommandHandler(RowGroupHeaderLayer rowGroupHeaderLayer) {
        this.rowGroupHeaderLayer = rowGroupHeaderLayer;
    }

    @Override
    protected boolean doCommand(MultiRowReorderCommand command) {
        SelectionLayer.MoveDirectionEnum moveDirection;
        boolean reorderToTopEdge;
        List<Integer> fromRowPositions = command.getFromRowPositions();
        int toRowPosition = command.getToRowPosition();
        if (!RowGroupUtils.isBetweenTwoGroups(this.rowGroupHeaderLayer, toRowPosition, reorderToTopEdge = command.isReorderToTopEdge(), moveDirection = PositionUtil.getVerticalMoveDirection(fromRowPositions.get(0), toRowPosition))) {
            for (int fromRowPosition : fromRowPositions) {
                if (RowGroupUtils.isReorderValid(this.rowGroupHeaderLayer, fromRowPosition, toRowPosition, reorderToTopEdge)) continue;
                return true;
            }
        }
        int toPositionToCheck = toRowPosition;
        if (SelectionLayer.MoveDirectionEnum.DOWN == moveDirection && reorderToTopEdge) {
            --toPositionToCheck;
        }
        HashMap<GroupModel, Set> collapsed = new HashMap<GroupModel, Set>();
        int level = 0;
        while (level < this.rowGroupHeaderLayer.getLevelCount()) {
            GroupModel model2 = this.rowGroupHeaderLayer.getGroupModel(level);
            for (int fromRowPosition : fromRowPositions) {
                GroupModel.Group fromGroup = this.rowGroupHeaderLayer.getGroupByPosition(level, fromRowPosition);
                if (fromGroup == null || !fromGroup.isCollapsed()) continue;
                HashSet<GroupModel.Group> collapsedGroups2 = (HashSet<GroupModel.Group>)collapsed.get(model2);
                if (collapsedGroups2 == null) {
                    collapsedGroups2 = new HashSet<GroupModel.Group>();
                    collapsed.put(model2, collapsedGroups2);
                }
                collapsedGroups2.add(fromGroup);
            }
            ++level;
        }
        if (!collapsed.isEmpty()) {
            int[] fromIndexes = fromRowPositions.stream().mapToInt(this.rowGroupHeaderLayer.getPositionLayer()::getRowIndexByPosition).toArray();
            int toIndex = this.rowGroupHeaderLayer.getPositionLayer().getRowIndexByPosition(toRowPosition);
            collapsed.forEach((model, collapsedGroups) -> collapsedGroups.forEach(group -> this.rowGroupHeaderLayer.expandGroup((GroupModel)model, (GroupModel.Group)group)));
            int[] fromPositions = Arrays.stream(fromIndexes).map(this.rowGroupHeaderLayer.getPositionLayer()::getRowPositionByIndex).toArray();
            command.updateFromRowPositions(fromPositions);
            toPositionToCheck = this.rowGroupHeaderLayer.getPositionLayer().getRowPositionByIndex(toIndex);
            command.updateToRowPosition(toPositionToCheck);
            if (SelectionLayer.MoveDirectionEnum.RIGHT == moveDirection && reorderToTopEdge) {
                --toPositionToCheck;
            }
        }
        boolean toggleCoordinateByEdge = false;
        GroupModel.Group groupToEnd = null;
        GroupModel.Group groupToStart = null;
        int level2 = 0;
        while (level2 < this.rowGroupHeaderLayer.getLevelCount()) {
            GroupModel.Group toGroup = this.rowGroupHeaderLayer.getGroupByPosition(level2, toPositionToCheck);
            if (toGroup != null && SelectionLayer.MoveDirectionEnum.DOWN == moveDirection && toGroup.isGroupEnd(toPositionToCheck)) {
                toggleCoordinateByEdge = true;
                if (toGroup.isUnbreakable() && toGroup.getVisibleSpan() < toGroup.getOriginalSpan()) {
                    groupToEnd = toGroup;
                }
            } else if (toGroup != null && SelectionLayer.MoveDirectionEnum.UP == moveDirection && toGroup.isGroupStart(toPositionToCheck) && toGroup.isUnbreakable() && toGroup.getVisibleSpan() < toGroup.getOriginalSpan()) {
                groupToStart = toGroup;
            }
            ++level2;
        }
        if (toggleCoordinateByEdge) {
            command.toggleCoordinateByEdge();
        }
        if (groupToEnd != null) {
            return this.rowGroupHeaderLayer.getPositionLayer().getUnderlyingLayerByPosition(0, 0).doCommand(new MultiRowReorderToGroupEndCommand(command, groupToEnd));
        }
        if (groupToStart != null) {
            return this.rowGroupHeaderLayer.getPositionLayer().getUnderlyingLayerByPosition(0, 0).doCommand(new MultiRowReorderToGroupStartCommand(command, groupToStart));
        }
        return false;
    }

    @Override
    public Class<MultiRowReorderCommand> getCommandClass() {
        return MultiRowReorderCommand.class;
    }

    class MultiRowReorderToGroupEndCommand
    extends MultiRowReorderCommand {
        private final GroupModel.Group group;

        public MultiRowReorderToGroupEndCommand(MultiRowReorderCommand command, GroupModel.Group group) {
            super(command);
            this.group = group;
        }

        protected MultiRowReorderToGroupEndCommand(MultiRowReorderToGroupEndCommand command) {
            super(command);
            this.group = command.group;
        }

        @Override
        public boolean convertToTargetLayer(ILayer targetLayer) {
            int groupEndPosition;
            boolean convert = super.convertToTargetLayer(targetLayer);
            if (convert && !this.isReorderToTopEdge() && targetLayer instanceof IUniqueIndexLayer && (groupEndPosition = this.group.getGroupEndPosition((IUniqueIndexLayer)targetLayer)) >= 0 && groupEndPosition > this.getToRowPosition()) {
                this.toRowPositionCoordinate.rowPosition = groupEndPosition;
            }
            return convert;
        }

        @Override
        public MultiRowReorderToGroupEndCommand cloneCommand() {
            return new MultiRowReorderToGroupEndCommand(this);
        }
    }

    class MultiRowReorderToGroupStartCommand
    extends MultiRowReorderCommand {
        private final GroupModel.Group group;

        public MultiRowReorderToGroupStartCommand(MultiRowReorderCommand command, GroupModel.Group group) {
            super(command);
            this.group = group;
        }

        protected MultiRowReorderToGroupStartCommand(MultiRowReorderToGroupStartCommand command) {
            super(command);
            this.group = command.group;
        }

        @Override
        public boolean convertToTargetLayer(ILayer targetLayer) {
            int groupStartPosition;
            boolean convert = super.convertToTargetLayer(targetLayer);
            if (convert && this.isReorderToTopEdge() && targetLayer instanceof IUniqueIndexLayer && (groupStartPosition = ((IUniqueIndexLayer)targetLayer).getRowPositionByIndex(this.group.getStartIndex())) >= 0 && groupStartPosition < this.getToRowPosition()) {
                this.toRowPositionCoordinate.rowPosition = groupStartPosition;
            }
            return convert;
        }

        @Override
        public MultiRowReorderToGroupStartCommand cloneCommand() {
            return new MultiRowReorderToGroupStartCommand(this);
        }
    }
}

