/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.nebula.richtext;

import org.eclipse.nebula.widgets.nattable.edit.editor.AbstractCellEditor;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.richtext.RichTextEditor;
import org.eclipse.nebula.widgets.richtext.RichTextEditorConfiguration;
import org.eclipse.nebula.widgets.richtext.toolbar.JavaCallbackListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class RichTextCellEditor
extends AbstractCellEditor {
    protected RichTextEditor editor = null;
    protected RichTextEditorConfiguration editorConfiguration;
    protected int style;

    public RichTextCellEditor() {
        this(null, 16);
    }

    public RichTextCellEditor(RichTextEditorConfiguration editorConfiguration) {
        this(editorConfiguration, 16);
    }

    public RichTextCellEditor(int style) {
        this(null, style);
    }

    public RichTextCellEditor(RichTextEditorConfiguration editorConfiguration, int style) {
        if (editorConfiguration == null) {
            editorConfiguration = new RichTextEditorConfiguration();
            editorConfiguration.setToolbarCollapsible(true);
            editorConfiguration.setToolbarInitialExpanded(true);
        }
        this.editorConfiguration = editorConfiguration;
        this.style = style | 0x1000000;
    }

    public Object getEditorValue() {
        return this.editor.getText();
    }

    public void setEditorValue(Object value) {
        this.editor.setText(value != null ? (String)value : "");
    }

    public RichTextEditor getEditorControl() {
        return this.editor;
    }

    protected Control activateCell(Composite parent, Object originalCanonicalValue) {
        this.editor = this.createEditorControl(parent);
        this.setCanonicalValue(originalCanonicalValue);
        this.editor.forceFocus();
        return this.editor;
    }

    public RichTextEditor createEditorControl(Composite parent) {
        this.editor = this.createRichTextEditor(parent);
        this.editor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    RichTextCellEditor.this.close();
                }
                if (e.keyCode == 13 && e.stateMask == SWT.MOD1) {
                    RichTextCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.NONE);
                }
            }
        });
        this.editor.addJavaCallbackListener(new JavaCallbackListener(){

            public void javaExecutionStarted() {
                if (RichTextCellEditor.this.focusListener instanceof AbstractCellEditor.InlineFocusListener) {
                    ((AbstractCellEditor.InlineFocusListener)((RichTextCellEditor)RichTextCellEditor.this).focusListener).handleFocusChanges = false;
                }
            }

            public void javaExecutionFinished() {
                if (RichTextCellEditor.this.focusListener instanceof AbstractCellEditor.InlineFocusListener) {
                    ((AbstractCellEditor.InlineFocusListener)((RichTextCellEditor)RichTextCellEditor.this).focusListener).handleFocusChanges = true;
                }
            }
        });
        return this.editor;
    }

    protected RichTextEditor createRichTextEditor(Composite parent) {
        return new RichTextEditor(parent, this.editorConfiguration, this.style){

            protected int getMinimumHeight() {
                return RichTextCellEditor.this.getMinimumDimension().y;
            }

            protected int getMinimumWidth() {
                return RichTextCellEditor.this.getMinimumDimension().x;
            }
        };
    }

    protected Point getMinimumDimension() {
        return new Point(GUIHelper.convertHorizontalPixelToDpi((int)370, (boolean)true), GUIHelper.convertVerticalPixelToDpi((int)220, (boolean)true));
    }
}

