/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.dataset.pricing;

import java.util.LinkedHashMap;
import java.util.Map;

public enum ColumnHeaders {
    ONE("ISIN", "isin", String.class),
    TWO("Bid", "bid", Double.class),
    THREE("Ask", "ask", Double.class),
    FOUR("Pricing Model", "pricingModel", String.class),
    FIVE("Ask Yield", "askYield", Double.class),
    SIX("Bid Yield", "bidYield", Double.class),
    SEVEN("(p) Bid/Ask", "bidOverAsk", Double.class),
    EIGHT("Bid Ask Type", "bidAskType", String.class),
    NINE("Base Issue", "baseIssue", String.class),
    TEN("Closing Price", "closingPrice", Double.class),
    ELEVEN("Closing Yield", "closingYield", Double.class),
    TWELVE("Closing Spread", "closingSpread", Double.class),
    THIRTEEN("Price Change", "priceChange", Double.class),
    FOURTEEN("Yield Change", "yieldChange", Double.class),
    FIFTEEN("Spread Change", "spreadChange", Double.class),
    SIXTEEN("Alias", "alias", String.class),
    SEVENTEEN("Basis Point Value", "basisPointValue", Double.class),
    EIGHTEEN("Mod. Duration", "modDuration", Double.class),
    NINETEEN("Convexity", "convexity", Double.class),
    TWENTY("Native Trading Group", "nativeTradingGroup", String.class),
    TWENTYONE("Error Severity", "errorSeverity", Double.class),
    TWENTYTWO("Error Message", "errorMessage", String.class),
    TWENTYTHREE("Pricing Source", "pricingSource", String.class),
    TWENTYFOUR("Security Type", "securityType", String.class);

    private String label;
    private String property;
    private final Class<?> type;

    private ColumnHeaders(String label, String property, Class<?> type) {
        this.label = label;
        this.property = property;
        this.type = type;
    }

    public static String[] getLabels() {
        String[] labels = new String[ColumnHeaders.values().length];
        int colIndex = 0;
        ColumnHeaders[] columnHeadersArray = ColumnHeaders.values();
        int n = columnHeadersArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnHeaders header = columnHeadersArray[n2];
            labels[colIndex++] = header.getLabel();
            ++n2;
        }
        return labels;
    }

    public String getLabel() {
        return this.label;
    }

    public static String[] getProperties() {
        String[] properties = new String[ColumnHeaders.values().length];
        int colIndex = 0;
        ColumnHeaders[] columnHeadersArray = ColumnHeaders.values();
        int n = columnHeadersArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnHeaders header = columnHeadersArray[n2];
            properties[colIndex++] = header.getProperty();
            ++n2;
        }
        return properties;
    }

    public static Map<String, Integer> getPropertyMap() {
        LinkedHashMap<String, Integer> propertyMap = new LinkedHashMap<String, Integer>();
        String[] properties = ColumnHeaders.getProperties();
        int index = 0;
        while (index < properties.length) {
            propertyMap.put(properties[index], new Integer(index));
            ++index;
        }
        return propertyMap;
    }

    public static LinkedHashMap<String, Class<?>> getPropertyNamesToTypeMap() {
        LinkedHashMap propertyNamesToTypeMap = new LinkedHashMap();
        ColumnHeaders[] columnHeadersArray = ColumnHeaders.values();
        int n = columnHeadersArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnHeaders columnHeader = columnHeadersArray[n2];
            propertyNamesToTypeMap.put(columnHeader.getProperty(), columnHeader.getType());
            ++n2;
        }
        return propertyNamesToTypeMap;
    }

    public String getProperty() {
        return this.property;
    }

    public Class<?> getType() {
        return this.type;
    }
}

