/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.reorder.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.RowReorderLayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiRowReorderCommand;

public class MultiRowReorderCommandHandler
extends AbstractLayerCommandHandler<MultiRowReorderCommand> {
    private final RowReorderLayer rowReorderLayer;

    public MultiRowReorderCommandHandler(RowReorderLayer rowReorderLayer) {
        this.rowReorderLayer = rowReorderLayer;
    }

    @Override
    protected boolean doCommand(MultiRowReorderCommand command) {
        int[] fromRowPositions = command.getFromRowPositionsArray();
        int toRowPosition = command.getToRowPosition();
        boolean reorderToTopEdge = command.isReorderToTopEdge();
        if (!command.isReorderByIndex()) {
            this.rowReorderLayer.reorderMultipleRowPositions(fromRowPositions, toRowPosition, reorderToTopEdge);
        } else {
            this.rowReorderLayer.reorderMultipleRowIndexes(fromRowPositions, toRowPosition, reorderToTopEdge);
        }
        return true;
    }

    @Override
    public Class<MultiRowReorderCommand> getCommandClass() {
        return MultiRowReorderCommand.class;
    }
}

