/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.dataset.pricing;

import java.io.BufferedReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.nebula.widgets.nattable.dataset.pricing.DelimitedFileReader;
import org.eclipse.nebula.widgets.nattable.dataset.pricing.PricingDataBean;

public class PricingDataFileLoader<T> {
    public List<T> loadDataFromFile() throws IOException {
        ArrayList data = new ArrayList();
        try (FilterReader reader = null;){
            reader = new DelimitedFileReader(new BufferedReader(new InputStreamReader(PricingDataFileLoader.class.getResourceAsStream("pricing_data.txt"))), '\t');
            if (reader.ready() && reader.markSupported()) {
                while (((DelimitedFileReader)reader).read() > 0) {
                    this.parseTabDelimitedLine(((DelimitedFileReader)reader).getTabbedLineRead(), data);
                }
            }
        }
        return data;
    }

    public void parseTabDelimitedLine(StringTokenizer tabs, List<T> data) {
        while (tabs.hasMoreElements()) {
            PricingDataBean bean = new PricingDataBean();
            bean.setIsin(this.extractStringFromToken(tabs.nextToken()));
            bean.setBid(this.extractDoubleFromToken(tabs.nextToken()));
            bean.setAsk(this.extractDoubleFromToken(tabs.nextToken()));
            bean.setBidYield(this.extractDoubleFromToken(tabs.nextToken()));
            bean.setAskYield(this.extractDoubleFromToken(tabs.nextToken()));
            bean.setBidSpread(this.extractDoubleFromToken(tabs.nextToken()));
            bean.setAskSpread(this.extractDoubleFromToken(tabs.nextToken()));
            bean.setBidOverAsk(this.extractDoubleFromToken(tabs.nextToken()));
            bean.setBidOverAskP(this.extractDoubleFromToken(tabs.nextToken()));
            bean.setBidAskType(this.extractStringFromToken(tabs.nextToken()));
            bean.setPricingModel(this.extractStringFromToken(tabs.nextToken()));
            bean.setBaseIssue(this.extractStringFromToken(tabs.nextToken()));
            bean.setAlias(this.extractStringFromToken(tabs.nextToken()));
            bean.setErrorMessage(this.extractStringFromToken(tabs.nextToken()));
            bean.setErrorSeverity(this.extractIntFromToken(tabs.nextToken()));
            bean.setPricingSource(this.extractStringFromToken(tabs.nextToken()));
            bean.setSecurityType(this.extractStringFromToken(tabs.nextToken()));
            bean.setComments(this.extractStringFromToken(tabs.nextToken()));
            data.add(bean);
        }
    }

    private int extractIntFromToken(String token) {
        System.out.println("int: " + token);
        return token.trim().equals("") || token.trim().equals("\t") ? 0 : Integer.parseInt(token);
    }

    private double extractDoubleFromToken(String token) {
        System.out.println("double: " + token);
        return token.trim().equals("") || token.trim().equals("\t") ? 0.0 : Double.parseDouble(token);
    }

    private String extractStringFromToken(String token) {
        System.out.println("string: " + token);
        return token == null || token.trim().equals("") || token.trim().equals("\t") ? null : token;
    }
}

