/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.command;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiColumnReorderCommand;

public class GroupMultiColumnReorderCommand
extends MultiColumnReorderCommand {
    private GroupModel.Group groupToLeft;
    private GroupModel.Group groupToRight;

    public GroupMultiColumnReorderCommand(ILayer layer, List<Integer> fromColumnPositions, int toColumnPosition) {
        this(layer, fromColumnPositions, toColumnPosition < layer.getColumnCount() ? toColumnPosition : toColumnPosition - 1, toColumnPosition < layer.getColumnCount());
    }

    public GroupMultiColumnReorderCommand(ILayer layer, List<Integer> fromColumnPositions, int toColumnPosition, boolean reorderToLeftEdge) {
        super(layer, fromColumnPositions.stream().mapToInt(Integer::intValue).toArray(), toColumnPosition, reorderToLeftEdge);
    }

    public GroupMultiColumnReorderCommand(ILayer layer, int[] fromColumnPositions, int toColumnPosition) {
        this(layer, fromColumnPositions, toColumnPosition < layer.getColumnCount() ? toColumnPosition : toColumnPosition - 1, toColumnPosition < layer.getColumnCount());
    }

    public GroupMultiColumnReorderCommand(ILayer layer, int[] fromColumnPositions, int toColumnPosition, boolean reorderToLeftEdge) {
        super(layer, fromColumnPositions, toColumnPosition, reorderToLeftEdge);
    }

    protected GroupMultiColumnReorderCommand(GroupMultiColumnReorderCommand command) {
        super(command);
        this.groupToLeft = command.groupToLeft;
        this.groupToRight = command.groupToRight;
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        if (super.convertToTargetLayer(targetLayer)) {
            int groupEndPosition;
            if (this.groupToRight != null) {
                int groupStartPosition;
                if (this.isReorderToLeftEdge() && targetLayer instanceof IUniqueIndexLayer && (groupStartPosition = ((IUniqueIndexLayer)targetLayer).getColumnPositionByIndex(this.groupToRight.getStartIndex())) >= 0 && groupStartPosition < this.getToColumnPosition()) {
                    this.toColumnPositionCoordinate.columnPosition = groupStartPosition;
                }
            } else if (this.groupToLeft != null && !this.isReorderToLeftEdge() && targetLayer instanceof IUniqueIndexLayer && (groupEndPosition = this.groupToLeft.getGroupEndPosition((IUniqueIndexLayer)targetLayer)) >= 0 && groupEndPosition > this.getToColumnPosition()) {
                this.toColumnPositionCoordinate.columnPosition = groupEndPosition;
            }
            return true;
        }
        return false;
    }

    public void setGroupToLeft(GroupModel.Group groupToLeft) {
        this.groupToLeft = groupToLeft;
    }

    public void setGroupToRight(GroupModel.Group groupToRight) {
        this.groupToRight = groupToRight;
    }

    @Override
    public GroupMultiColumnReorderCommand cloneCommand() {
        return new GroupMultiColumnReorderCommand(this);
    }
}

