/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.tuple;

import java.util.Map;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.Triple;
import org.eclipse.collections.api.tuple.Triplet;
import org.eclipse.collections.api.tuple.Twin;
import org.eclipse.collections.impl.tuple.PairImpl;
import org.eclipse.collections.impl.tuple.TripleImpl;
import org.eclipse.collections.impl.tuple.TripletImpl;
import org.eclipse.collections.impl.tuple.TwinImpl;

public final class Tuples {
    private Tuples() {
    }

    public static <K, V> Pair<K, V> pairFrom(Map.Entry<K, V> entry) {
        return Tuples.pair(entry.getKey(), entry.getValue());
    }

    public static <T1, T2> Pair<T1, T2> pair(T1 one, T2 two) {
        return new PairImpl<T1, T2>(one, two);
    }

    public static <T> Twin<T> twin(T one, T two) {
        return new TwinImpl<T>(one, two);
    }

    public static <T> Twin<T> identicalTwin(T each) {
        return new TwinImpl<T>(each, each);
    }

    public static <T1, T2, T3> Triple<T1, T2, T3> triple(T1 one, T2 two, T3 three) {
        return new TripleImpl<T1, T2, T3>(one, two, three);
    }

    public static <T> Triplet<T> triplet(T one, T two, T three) {
        return new TripletImpl<T>(one, two, three);
    }

    public static <T> Triplet<T> identicalTriplet(T each) {
        return new TripletImpl<T>(each, each, each);
    }
}

