/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.style.VerticalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.ui.matcher.LetterOrDigitKeyEventMatcher;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class NatCombo
extends Composite {
    public static final String DEFAULT_MULTI_SELECT_VALUE_SEPARATOR = ", ";
    public static final String DEFAULT_MULTI_SELECT_PREFIX = "[";
    public static final String DEFAULT_MULTI_SELECT_SUFFIX = "]";
    public static final int DEFAULT_NUM_OF_VISIBLE_ITEMS = 5;
    protected final IStyle cellStyle;
    protected int maxVisibleItems;
    protected List<String> itemList;
    protected Map<String, Boolean> selectionStateMap;
    protected Text filterBox;
    protected Text text;
    protected Shell dropdownShell;
    protected Table dropdownTable;
    protected TableViewer dropdownTableViewer;
    protected Image iconImage;
    protected final int style;
    protected boolean showDropdownFilter;
    protected boolean freeEdit;
    protected boolean multiselect;
    protected boolean useCheckbox;
    protected String multiselectValueSeparator = ", ";
    protected String multiselectTextPrefix = "[";
    protected String multiselectTextSuffix = "]";
    private boolean hasFocus = false;
    private List<FocusListener> focusListener = new ArrayList<FocusListener>();
    private List<KeyListener> keyListener = new ArrayList<KeyListener>();
    private List<TraverseListener> traverseListener = new ArrayList<TraverseListener>();
    private List<MouseListener> mouseListener = new ArrayList<MouseListener>();
    private List<SelectionListener> selectionListener = new ArrayList<SelectionListener>();
    private List<ShellListener> shellListener = new ArrayList<ShellListener>();

    public NatCombo(Composite parent, IStyle cellStyle, int style) {
        this(parent, cellStyle, 5, style, GUIHelper.getImage("down_2"));
    }

    public NatCombo(Composite parent, IStyle cellStyle, int maxVisibleItems, int style) {
        this(parent, cellStyle, maxVisibleItems, style, GUIHelper.getImage("down_2"));
    }

    public NatCombo(Composite parent, IStyle cellStyle, int maxVisibleItems, int style, boolean showDropdownFilter) {
        this(parent, cellStyle, maxVisibleItems, style, GUIHelper.getImage("down_2"), showDropdownFilter);
    }

    public NatCombo(Composite parent, IStyle cellStyle, int maxVisibleItems, int style, Image iconImage) {
        this(parent, cellStyle, maxVisibleItems, style, GUIHelper.getImage("down_2"), false);
    }

    public NatCombo(Composite parent, IStyle cellStyle, int maxVisibleItems, int style, Image iconImage, boolean showDropdownFilter) {
        super(parent, 0);
        this.cellStyle = cellStyle;
        this.maxVisibleItems = maxVisibleItems;
        this.iconImage = iconImage;
        this.style = style;
        this.showDropdownFilter = showDropdownFilter;
        this.freeEdit = (style & 8) == 0;
        this.multiselect = (style & 2) != 0;
        this.useCheckbox = (style & 0x20) != 0;
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.createTextControl(style);
        final Listener moveListener = new Listener(){

            public void handleEvent(Event event) {
                NatCombo.this.calculateBounds();
            }
        };
        this.getShell().addListener(10, moveListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (NatCombo.this.dropdownShell != null) {
                    NatCombo.this.dropdownShell.dispose();
                }
                NatCombo.this.text.dispose();
                NatCombo.this.getShell().removeListener(10, moveListener);
            }
        });
    }

    public void setItems(String[] items) {
        if (items != null) {
            this.itemList = Arrays.asList(items);
            this.selectionStateMap = new LinkedHashMap<String, Boolean>();
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                this.selectionStateMap.put(item, Boolean.FALSE);
                ++n2;
            }
            if (this.dropdownTable != null && !this.dropdownTable.isDisposed()) {
                this.dropdownTableViewer.setInput((Object)items);
            }
        }
    }

    protected void createTextControl(int style) {
        int widgetStyle = style | HorizontalAlignmentEnum.getSWTStyle(this.cellStyle);
        this.text = new Text((Composite)this, widgetStyle);
        this.text.setBackground(this.cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR));
        this.text.setForeground(this.cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR));
        this.text.setFont(this.cellStyle.getAttributeValue(CellStyleAttributes.FONT));
        GridData gridData = new GridData(4, 4, true, true);
        this.text.setLayoutData((Object)gridData);
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x1000002 || event.keyCode == 0x1000001) {
                    NatCombo.this.showDropdownControl();
                    int selectionIndex = NatCombo.this.getDropdownTable().getSelectionIndex();
                    if (selectionIndex < 0) {
                        NatCombo.this.select(0);
                    } else {
                        NatCombo.this.getDropdownTable().select(selectionIndex);
                    }
                    event.doit = false;
                } else if (!LetterOrDigitKeyEventMatcher.isLetterOrDigit(event.character)) {
                    if (NatCombo.this.freeEdit) {
                        if (!NatCombo.this.getDropdownTable().isDisposed()) {
                            NatCombo.this.getDropdownTable().deselectAll();
                            for (Map.Entry<String, Boolean> entry : NatCombo.this.selectionStateMap.entrySet()) {
                                entry.setValue(Boolean.FALSE);
                            }
                        }
                    } else {
                        NatCombo.this.showDropdownControl();
                    }
                }
            }
        });
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (!NatCombo.this.freeEdit) {
                    if (NatCombo.this.getDropdownTable().isDisposed() || !NatCombo.this.getDropdownTable().isVisible()) {
                        NatCombo.this.showDropdownControl();
                    } else {
                        NatCombo.this.getDropdownTable().forceFocus();
                    }
                }
            }
        });
        this.text.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                NatCombo.this.calculateBounds();
            }

            public void controlMoved(ControlEvent e) {
                NatCombo.this.calculateBounds();
            }
        });
        this.text.addFocusListener((FocusListener)new FocusListenerWrapper());
        final Canvas iconCanvas = new Canvas(this, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Rectangle iconImageBounds = NatCombo.this.iconImage.getBounds();
                return new Point(iconImageBounds.width + 2, iconImageBounds.height + 2);
            }
        };
        gridData = new GridData(1, 4, false, true);
        iconCanvas.setLayoutData((Object)gridData);
        iconCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                GC gc = event.gc;
                Rectangle iconCanvasBounds = iconCanvas.getBounds();
                Rectangle iconImageBounds = NatCombo.this.iconImage.getBounds();
                int horizontalAlignmentPadding = CellStyleUtil.getHorizontalAlignmentPadding(HorizontalAlignmentEnum.CENTER, iconCanvasBounds, iconImageBounds.width);
                int verticalAlignmentPadding = CellStyleUtil.getVerticalAlignmentPadding(VerticalAlignmentEnum.MIDDLE, iconCanvasBounds, iconImageBounds.height);
                gc.drawImage(NatCombo.this.iconImage, horizontalAlignmentPadding, verticalAlignmentPadding);
                Color originalFg = gc.getForeground();
                gc.setForeground(GUIHelper.COLOR_WIDGET_BORDER);
                gc.drawRectangle(0, 0, iconCanvasBounds.width - 1, iconCanvasBounds.height - 1);
                gc.setForeground(originalFg);
            }
        });
        iconCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (NatCombo.this.dropdownShell != null && !NatCombo.this.dropdownShell.isDisposed()) {
                    if (NatCombo.this.dropdownShell.isVisible()) {
                        NatCombo.this.text.forceFocus();
                        NatCombo.this.hideDropdownControl();
                    } else {
                        NatCombo.this.showDropdownControl();
                    }
                } else {
                    NatCombo.this.showDropdownControl();
                }
            }
        });
    }

    protected void createDropdownControl(int style) {
        this.dropdownShell = new Shell(this.getShell(), 0);
        int scrollStyle = this.itemList != null && this.itemList.size() > this.maxVisibleItems && this.maxVisibleItems > 0 ? 528 : 16;
        int dropdownListStyle = style | scrollStyle | HorizontalAlignmentEnum.getSWTStyle(this.cellStyle) | 0x10000;
        this.dropdownTable = new Table((Composite)this.dropdownShell, dropdownListStyle);
        this.dropdownTableViewer = new TableViewer(this.dropdownTable);
        this.dropdownTable.setBackground(this.cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR));
        this.dropdownTable.setForeground(this.cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR));
        this.dropdownTable.setFont(this.cellStyle.getAttributeValue(CellStyleAttributes.FONT));
        new TableColumn(this.dropdownTable, 0);
        this.dropdownTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }
        });
        this.dropdownTableViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getText(Object element) {
                return element.toString();
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        this.dropdownTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                int selected;
                if (event.keyCode == 0x1000002 && (selected = NatCombo.this.dropdownTable.getSelectionIndex()) < 0) {
                    if (!NatCombo.this.useCheckbox) {
                        NatCombo.this.select(0);
                    } else {
                        NatCombo.this.getDropdownTable().select(0);
                    }
                    event.doit = false;
                }
            }
        });
        this.dropdownTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = e.detail != 32;
                boolean isCtrlPressed = (e.stateMask & SWT.MODIFIER_MASK) == 262144;
                TableItem chosenItem = (TableItem)e.item;
                int itemTableIndex = NatCombo.this.dropdownTable.indexOf(chosenItem);
                if (!selected) {
                    if (!chosenItem.getChecked()) {
                        NatCombo.this.selectionStateMap.put(chosenItem.getText(), Boolean.FALSE);
                    } else {
                        NatCombo.this.selectionStateMap.put(chosenItem.getText(), Boolean.TRUE);
                    }
                } else if (!NatCombo.this.useCheckbox) {
                    if (NatCombo.this.multiselect && isCtrlPressed) {
                        boolean isSelected = NatCombo.this.dropdownTable.isSelected(itemTableIndex);
                        NatCombo.this.selectionStateMap.put(chosenItem.getText(), isSelected);
                        if (NatCombo.this.useCheckbox) {
                            chosenItem.setChecked(isSelected);
                        }
                    } else {
                        for (String item : NatCombo.this.itemList) {
                            NatCombo.this.selectionStateMap.put(item, Boolean.FALSE);
                        }
                        NatCombo.this.selectionStateMap.put(chosenItem.getText(), Boolean.TRUE);
                    }
                }
                NatCombo.this.updateTextControl(false);
            }
        });
        this.dropdownTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    NatCombo.this.updateTextControl(true);
                } else if (event.keyCode == 0x100000B && NatCombo.this.freeEdit) {
                    NatCombo.this.text.forceFocus();
                    NatCombo.this.hideDropdownControl();
                }
            }
        });
        this.dropdownTable.addFocusListener((FocusListener)new FocusListenerWrapper());
        FormLayout layout = new FormLayout();
        layout.spacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.dropdownShell.setLayout((Layout)layout);
        FormData dropDownLayoutData = new FormData();
        dropDownLayoutData.left = new FormAttachment(0);
        dropDownLayoutData.right = new FormAttachment(100);
        dropDownLayoutData.bottom = new FormAttachment(100);
        if (this.showDropdownFilter) {
            this.filterBox = new Text((Composite)this.dropdownShell, 2048);
            this.filterBox.setFont(this.cellStyle.getAttributeValue(CellStyleAttributes.FONT));
            this.filterBox.setEnabled(true);
            this.filterBox.setEditable(true);
            this.filterBox.addFocusListener((FocusListener)new FocusListenerWrapper());
            this.filterBox.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (NatCombo.this.dropdownTableViewer != null && !NatCombo.this.dropdownTable.isDisposed()) {
                        NatCombo.this.dropdownTableViewer.refresh();
                        NatCombo.this.calculateBounds();
                        NatCombo.this.setDropdownSelection(NatCombo.this.getTextAsArray());
                    }
                }
            });
            FormData data = new FormData();
            data.top = new FormAttachment(0);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            this.filterBox.setLayoutData((Object)data);
            data = new FormData();
            dropDownLayoutData.top = this.showDropdownFilter ? new FormAttachment((Control)this.filterBox, 0, 1024) : new FormAttachment((Control)this.dropdownShell, 0, 128);
            this.dropdownTable.setLayoutData((Object)dropDownLayoutData);
            ViewerFilter viewerFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element != null && element instanceof String) {
                        return ((String)element).toLowerCase().contains(NatCombo.this.filterBox.getText().toLowerCase());
                    }
                    return false;
                }
            };
            this.dropdownTableViewer.addFilter(viewerFilter);
        } else {
            dropDownLayoutData.top = new FormAttachment(0);
            this.dropdownTable.setLayoutData((Object)dropDownLayoutData);
        }
        if (this.itemList != null) {
            this.setItems(this.itemList.toArray(new String[0]));
        }
        this.applyDropdownListener();
        this.setDropdownSelection(this.getTextAsArray());
    }

    protected void updateTextControl(boolean hideDropdown) {
        this.text.setText(this.getTransformedTextForSelection());
        if (hideDropdown) {
            this.hideDropdownControl();
        }
    }

    public void showDropdownControl() {
        this.showDropdownControl(false);
    }

    public void showDropdownControl(boolean focusOnText) {
        if (this.dropdownShell == null || this.dropdownShell.isDisposed()) {
            this.createDropdownControl(this.style);
        }
        this.calculateBounds();
        this.dropdownShell.open();
        if (focusOnText) {
            this.text.forceFocus();
            this.text.setSelection(this.text.getText().length());
        }
    }

    protected Table getDropdownTable() {
        if (this.dropdownTable == null) {
            this.createDropdownControl(this.style);
        }
        return this.dropdownTable;
    }

    public void hideDropdownControl() {
        if (this.dropdownShell != null && !this.dropdownShell.isDisposed()) {
            this.dropdownShell.setVisible(false);
        }
    }

    protected int getVisibleItemCount() {
        int itemCount = this.getDropdownTable().getItemCount();
        if (itemCount > 0) {
            int visibleItemCount = itemCount;
            if (this.maxVisibleItems > 0) {
                visibleItemCount = Math.min(itemCount, this.maxVisibleItems);
            }
            itemCount = visibleItemCount;
        }
        return itemCount;
    }

    protected void calculateBounds() {
        if (this.dropdownShell != null && !this.dropdownShell.isDisposed()) {
            Point size = this.getSize();
            int listHeight = (this.getVisibleItemCount() > 0 ? this.getVisibleItemCount() : 3) * this.dropdownTable.getItemHeight() + this.dropdownTable.getGridLineWidth() * 2;
            this.dropdownTable.getColumn(0).pack();
            int listWidth = Math.max(this.dropdownTable.computeSize((int)-1, (int)listHeight, (boolean)true).x, size.x);
            Point textPosition = this.text.toDisplay(this.text.getLocation());
            int dropdownShellStartingY = textPosition.y + this.text.getBounds().height;
            int textBottomY = textPosition.y + this.text.getBounds().height + listHeight;
            if (textBottomY > Display.getCurrent().getBounds().height) {
                dropdownShellStartingY = textPosition.y - listHeight;
            }
            Rectangle parentBounds = this.getParent().getBounds();
            Point parentStart = this.getParent().toDisplay(parentBounds.x, parentBounds.y);
            int parentBottomY = parentStart.y + parentBounds.height - parentBounds.y;
            if (this.getParent().getHorizontalBar() != null && this.getParent().getHorizontalBar().isVisible()) {
                parentBottomY -= this.getParent().getHorizontalBar().getSize().y;
            }
            if (dropdownShellStartingY > parentBottomY) {
                dropdownShellStartingY = parentBottomY;
            }
            int filterTextBoxHeight = this.showDropdownFilter ? this.filterBox.computeSize((int)-1, (int)-1).y : 0;
            Rectangle shellBounds = new Rectangle(textPosition.x, dropdownShellStartingY, listWidth + this.dropdownTable.getGridLineWidth() * 2, listHeight + filterTextBoxHeight);
            this.dropdownShell.setBounds(shellBounds);
            this.calculateColumnWidth();
        }
    }

    protected void calculateColumnWidth() {
        int width = this.dropdownTable.getBounds().width;
        if (this.dropdownTable.getVerticalBar() != null && this.dropdownTable.getItemCount() > this.maxVisibleItems && this.maxVisibleItems > 0) {
            width -= this.dropdownTable.getVerticalBar().getSize().x;
        }
        this.dropdownTable.getColumn(0).setWidth(width);
    }

    public int getSelectionIndex() {
        if (this.selectionStateMap != null) {
            for (String item : this.selectionStateMap.keySet()) {
                if (!this.selectionStateMap.get(item).booleanValue()) continue;
                return this.itemList.indexOf(item);
            }
        } else if (!this.text.isDisposed()) {
            return this.itemList.indexOf(this.text.getText());
        }
        return -1;
    }

    public int[] getSelectionIndices() {
        if (this.selectionStateMap != null) {
            ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
            for (String item : this.selectionStateMap.keySet()) {
                if (!this.selectionStateMap.get(item).booleanValue()) continue;
                selectedIndices.add(this.itemList.indexOf(item));
            }
            int[] indices = new int[selectedIndices.size()];
            int i = 0;
            while (i < selectedIndices.size()) {
                indices[i] = (Integer)selectedIndices.get(i);
                ++i;
            }
            return indices;
        }
        String[] selectedItems = this.getTextAsArray();
        int[] result = new int[selectedItems.length];
        int i = 0;
        while (i < selectedItems.length) {
            result[i] = this.itemList.indexOf(selectedItems[i]);
            ++i;
        }
        return result;
    }

    public int getSelectionCount() {
        if (this.selectionStateMap != null) {
            ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
            for (String item : this.selectionStateMap.keySet()) {
                if (!this.selectionStateMap.get(item).booleanValue()) continue;
                selectedIndices.add(this.itemList.indexOf(item));
            }
            return selectedIndices.size();
        }
        return this.getTextAsArray().length;
    }

    public String[] getSelection() {
        String[] result = this.getTransformedSelection();
        if (result == null || result.length == 0 && !this.text.isDisposed() && this.text.getText().length() > 0) {
            result = this.getTextAsArray();
        }
        return result;
    }

    public void setSelection(String[] items) {
        String textValue = "";
        if (items != null) {
            if (!this.getDropdownTable().isDisposed()) {
                this.setDropdownSelection(items);
                textValue = this.freeEdit && this.getDropdownTable().getSelectionCount() == 0 ? this.getTransformedText(items) : this.getTransformedTextForSelection();
            } else {
                textValue = this.getTransformedText(items);
            }
        }
        this.text.setText(textValue);
        if (this.multiselect) {
            this.text.setSelection(textValue.length() - this.multiselectTextSuffix.length());
        }
    }

    public void select(int index) {
        if (!this.getDropdownTable().isDisposed()) {
            this.getDropdownTable().select(index);
            int i = 0;
            while (i < this.itemList.size()) {
                this.selectionStateMap.put(this.itemList.get(i), i == index);
                ++i;
            }
            this.text.setText(this.getTransformedTextForSelection());
        } else if (index >= 0) {
            this.text.setText(this.itemList.get(index));
        }
    }

    public void select(int[] indices) {
        if (!this.getDropdownTable().isDisposed()) {
            this.getDropdownTable().select(indices);
            List<Integer> indicesList = ArrayUtil.asIntegerList(indices);
            int i = 0;
            while (i < this.itemList.size()) {
                this.selectionStateMap.put(this.itemList.get(i), indicesList.contains(i));
                ++i;
            }
            this.text.setText(this.getTransformedTextForSelection());
        } else {
            String[] selectedItems = new String[indices.length];
            int i = 0;
            while (i < indices.length) {
                if (indices[i] >= 0) {
                    selectedItems[i] = this.itemList.get(indices[i]);
                }
                ++i;
            }
            this.text.setText(this.getTransformedText(selectedItems));
        }
    }

    protected void applyDropdownListener() {
        for (KeyListener keyListener : this.keyListener) {
            if (this.dropdownTable == null || this.dropdownTable.isDisposed()) continue;
            this.dropdownTable.addKeyListener(keyListener);
        }
        for (TraverseListener traverseListener : this.traverseListener) {
            if (this.dropdownTable == null || this.dropdownTable.isDisposed()) continue;
            this.dropdownTable.addTraverseListener(traverseListener);
        }
        for (MouseListener mouseListener : this.mouseListener) {
            if (this.dropdownTable == null || this.dropdownTable.isDisposed()) continue;
            this.dropdownTable.addMouseListener(mouseListener);
        }
        for (SelectionListener selectionListener : this.selectionListener) {
            if (this.dropdownTable == null || this.dropdownTable.isDisposed()) continue;
            this.dropdownTable.addSelectionListener(selectionListener);
        }
        for (ShellListener shellListener : this.shellListener) {
            if (this.dropdownShell == null || this.dropdownShell.isDisposed()) continue;
            this.dropdownShell.addShellListener(shellListener);
        }
    }

    public void addKeyListener(KeyListener listener) {
        if (listener != null) {
            if (this.text != null && !this.text.isDisposed()) {
                this.text.addKeyListener(listener);
            }
            if (this.dropdownTable != null && !this.dropdownTable.isDisposed()) {
                this.dropdownTable.addKeyListener(listener);
            }
            this.keyListener.add(listener);
        }
    }

    public void removeKeyListener(KeyListener listener) {
        if (this.text != null && !this.text.isDisposed()) {
            this.text.removeKeyListener(listener);
        }
        if (this.dropdownTable != null && !this.dropdownTable.isDisposed()) {
            this.dropdownTable.removeKeyListener(listener);
        }
        this.keyListener.remove(listener);
    }

    public void addTraverseListener(TraverseListener listener) {
        if (listener != null) {
            if (this.text != null && !this.text.isDisposed()) {
                this.text.addTraverseListener(listener);
            }
            if (this.dropdownTable != null && !this.dropdownTable.isDisposed()) {
                this.dropdownTable.addTraverseListener(listener);
            }
            this.traverseListener.add(listener);
        }
    }

    public void removeTraverseListener(TraverseListener listener) {
        if (this.text != null && !this.text.isDisposed()) {
            this.text.removeTraverseListener(listener);
        }
        if (this.dropdownTable != null && !this.dropdownTable.isDisposed()) {
            this.dropdownTable.removeTraverseListener(listener);
        }
        this.traverseListener.remove(listener);
    }

    public void addMouseListener(MouseListener listener) {
        if (listener != null) {
            if (this.dropdownTable != null && !this.dropdownTable.isDisposed()) {
                this.dropdownTable.addMouseListener(listener);
            }
            this.mouseListener.add(listener);
        }
    }

    public void removeMouseListener(MouseListener listener) {
        if (this.dropdownTable != null && !this.dropdownTable.isDisposed()) {
            this.dropdownTable.removeMouseListener(listener);
        }
        this.mouseListener.remove(listener);
    }

    public void notifyListeners(int eventType, Event event) {
        if (this.dropdownTable != null && !this.dropdownTable.isDisposed()) {
            this.dropdownTable.notifyListeners(eventType, event);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        if (listener != null) {
            if (this.dropdownTable != null && !this.dropdownTable.isDisposed()) {
                this.dropdownTable.addSelectionListener(listener);
            }
            this.selectionListener.add(listener);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this.dropdownTable != null && !this.dropdownTable.isDisposed()) {
            this.dropdownTable.removeSelectionListener(listener);
        }
        this.selectionListener.remove(listener);
    }

    public void addShellListener(ShellListener listener) {
        if (listener != null) {
            if (this.dropdownShell != null && !this.dropdownShell.isDisposed()) {
                this.dropdownShell.addShellListener(listener);
            }
            this.shellListener.add(listener);
        }
    }

    public void removeShellListener(ShellListener listener) {
        if (this.dropdownShell != null && !this.dropdownShell.isDisposed()) {
            this.dropdownShell.removeShellListener(listener);
        }
        this.shellListener.remove(listener);
    }

    public void addTextControlListener(ControlListener listener) {
        if (listener != null && this.text != null && !this.text.isDisposed()) {
            this.text.addControlListener(listener);
        }
    }

    public void removeTextControlListener(ControlListener listener) {
        if (this.text != null && !this.text.isDisposed()) {
            this.text.removeControlListener(listener);
        }
    }

    public boolean isFocusControl() {
        return this.hasFocus;
    }

    public boolean forceFocus() {
        return this.text.forceFocus();
    }

    public void addFocusListener(FocusListener listener) {
        if (listener != null) {
            this.focusListener.add(listener);
        }
    }

    public void removeFocusListener(FocusListener listener) {
        this.focusListener.remove(listener);
    }

    protected String[] getTransformedSelection() {
        ArrayList<String> selectedItems = new ArrayList<String>();
        for (String item : this.selectionStateMap.keySet()) {
            Boolean isSelected = this.selectionStateMap.get(item);
            if (isSelected == null || !isSelected.booleanValue()) continue;
            selectedItems.add(item);
        }
        return selectedItems.toArray(new String[selectedItems.size()]);
    }

    protected void setDropdownSelection(String[] selection) {
        List<String> selectionList = Arrays.asList(selection);
        ArrayList<TableItem> selectedItems = new ArrayList<TableItem>();
        TableItem[] tableItemArray = this.getDropdownTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (selectionList.contains("SELECT_ALL") || selectionList.contains(item.getText())) {
                this.selectionStateMap.put(item.getText(), Boolean.TRUE);
                if (this.useCheckbox) {
                    item.setChecked(true);
                } else {
                    selectedItems.add(item);
                }
            } else {
                this.selectionStateMap.put(item.getText(), Boolean.FALSE);
            }
            ++n2;
        }
        this.getDropdownTable().setSelection(selectedItems.toArray(new TableItem[0]));
    }

    protected String[] getTextAsArray() {
        String transform;
        if (!this.text.isDisposed() && (transform = this.text.getText()).length() > 0) {
            if (this.multiselect) {
                int prefixLength = this.multiselectTextPrefix.length();
                int suffixLength = this.multiselectTextSuffix.length();
                if (this.freeEdit) {
                    if (!transform.startsWith(this.multiselectTextPrefix)) {
                        prefixLength = 0;
                    }
                    if (!transform.endsWith(this.multiselectTextSuffix)) {
                        suffixLength = 0;
                    }
                }
                if ((transform = transform.substring(prefixLength, transform.length() - suffixLength)).length() > 0) {
                    return transform.split(this.multiselectValueSeparator);
                }
            }
            return new String[]{transform};
        }
        return new String[0];
    }

    protected String getTransformedTextForSelection() {
        String result = "";
        String[] selection = this.getTransformedSelection();
        if (selection != null) {
            result = this.getTransformedText(selection);
        }
        return result;
    }

    protected String getTransformedText(String[] values) {
        String result = "";
        if (this.multiselect) {
            int i = 0;
            while (i < values.length) {
                String selection = values[i];
                result = String.valueOf(result) + selection;
                if (i + 1 < values.length) {
                    result = String.valueOf(result) + this.multiselectValueSeparator;
                }
                ++i;
            }
            result = String.valueOf(this.multiselectTextPrefix) + result + this.multiselectTextSuffix;
        } else if (values.length > 0) {
            result = values[0];
        }
        return result;
    }

    public void setMultiselectValueSeparator(String multiselectValueSeparator) {
        this.multiselectValueSeparator = multiselectValueSeparator == null ? DEFAULT_MULTI_SELECT_VALUE_SEPARATOR : multiselectValueSeparator;
    }

    public void setMultiselectTextBracket(String multiselectTextPrefix, String multiselectTextSuffix) {
        this.multiselectTextPrefix = multiselectTextPrefix == null ? DEFAULT_MULTI_SELECT_PREFIX : multiselectTextPrefix;
        this.multiselectTextSuffix = multiselectTextSuffix == null ? DEFAULT_MULTI_SELECT_SUFFIX : multiselectTextSuffix;
    }

    public class FocusListenerWrapper
    implements FocusListener {
        public void focusLost(final FocusEvent e) {
            NatCombo.this.hasFocus = false;
            Display.getCurrent().timerExec(100, new Runnable(){

                @Override
                public void run() {
                    if (!NatCombo.this.hasFocus) {
                        ArrayList copy = new ArrayList(NatCombo.this.focusListener);
                        for (FocusListener f : copy) {
                            f.focusLost(e);
                        }
                    }
                }
            });
        }

        public void focusGained(FocusEvent e) {
            NatCombo.this.hasFocus = true;
            for (FocusListener f : NatCombo.this.focusListener) {
                f.focusGained(e);
            }
        }
    }
}

