/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.performance.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;

public class ColumnGroupUtils {
    public static SelectionLayer.MoveDirectionEnum getMoveDirection(int fromColumnPosition, int toColumnPosition) {
        if (fromColumnPosition > toColumnPosition) {
            return SelectionLayer.MoveDirectionEnum.LEFT;
        }
        if (fromColumnPosition < toColumnPosition) {
            return SelectionLayer.MoveDirectionEnum.RIGHT;
        }
        return SelectionLayer.MoveDirectionEnum.NONE;
    }

    public static boolean isInTheSameGroup(int fromColumnIndex, int toColumnIndex, ColumnGroupModel model) {
        ColumnGroupModel.ColumnGroup fromColumnGroup = model.getColumnGroupByIndex(fromColumnIndex);
        ColumnGroupModel.ColumnGroup toColumnGroup = model.getColumnGroupByIndex(toColumnIndex);
        return fromColumnGroup != null && toColumnGroup != null && fromColumnGroup == toColumnGroup;
    }

    public static boolean isStaticOrFirstVisibleColumn(int columnIndex, ILayer layer, IUniqueIndexLayer underlyingLayer, ColumnGroupModel model) {
        ColumnGroupModel.ColumnGroup columnGroup = model.getColumnGroupByIndex(columnIndex);
        if (columnGroup.getStaticColumnIndexes().size() == 0) {
            return ColumnGroupUtils.isFirstVisibleColumnIndexInGroup(columnIndex, layer, underlyingLayer, model);
        }
        return model.isStaticColumn(columnIndex);
    }

    public static boolean isFirstVisibleColumnIndexInGroup(int columnIndex, ILayer layer, IUniqueIndexLayer underlyingLayer, ColumnGroupModel model) {
        if (ColumnGroupUtils.isColumnIndexHiddenInUnderLyingLayer(columnIndex, layer, underlyingLayer)) {
            return false;
        }
        int columnPosition = underlyingLayer.getColumnPositionByIndex(columnIndex);
        List<Integer> columnIndexesInGroup = model.getColumnGroupByIndex(columnIndex).getMembers();
        ArrayList<Integer> previousVisibleColumnIndexes = new ArrayList<Integer>();
        for (Integer currentIndex : columnIndexesInGroup) {
            int currentPosition = underlyingLayer.getColumnPositionByIndex(currentIndex);
            if (ColumnGroupUtils.isColumnIndexHiddenInUnderLyingLayer(currentIndex, layer, underlyingLayer) || currentPosition >= columnPosition) continue;
            previousVisibleColumnIndexes.add(currentIndex);
        }
        return previousVisibleColumnIndexes.isEmpty();
    }

    public static boolean isLastVisibleColumnIndexInGroup(int columnIndex, ILayer layer, IUniqueIndexLayer underlyingLayer, ColumnGroupModel model) {
        if (ColumnGroupUtils.isColumnIndexHiddenInUnderLyingLayer(columnIndex, layer, underlyingLayer)) {
            return false;
        }
        List<Integer> visibleIndexesToTheRight = ColumnGroupUtils.getVisibleIndexesToTheRight(columnIndex, layer, underlyingLayer, model);
        return visibleIndexesToTheRight.size() == 1 && visibleIndexesToTheRight.get(0) == columnIndex;
    }

    public static List<Integer> getVisibleIndexesToTheRight(int columnIndex, ILayer layer, IUniqueIndexLayer underlyingLayer, ColumnGroupModel model) {
        ColumnGroupModel.ColumnGroup columnGroup = model.getColumnGroupByIndex(columnIndex);
        if (columnGroup.isCollapsed()) {
            return Collections.emptyList();
        }
        List<Integer> columnIndexesInGroup = columnGroup.getMembers();
        int columnPosition = underlyingLayer.getColumnPositionByIndex(columnIndex);
        ArrayList<Integer> visibleColumnIndexesOnRight = new ArrayList<Integer>();
        for (Integer currentIndex : columnIndexesInGroup) {
            int currentPosition = underlyingLayer.getColumnPositionByIndex(currentIndex);
            if (ColumnGroupUtils.isColumnIndexHiddenInUnderLyingLayer(currentIndex, layer, underlyingLayer) || currentPosition < columnPosition) continue;
            visibleColumnIndexesOnRight.add(currentIndex);
        }
        return visibleColumnIndexesOnRight;
    }

    public static boolean isColumnIndexHiddenInUnderLyingLayer(int columnIndex, ILayer layer, IUniqueIndexLayer underlyingLayer) {
        return underlyingLayer.getColumnPositionByIndex(columnIndex) == -1;
    }

    public static boolean isColumnPositionHiddenInUnderLyingLayer(int columnPosition, ILayer layer, IUniqueIndexLayer underlyingLayer) {
        if (columnPosition < underlyingLayer.getColumnCount() && columnPosition >= 0) {
            int columnIndex = underlyingLayer.getColumnIndexByPosition(columnPosition);
            return ColumnGroupUtils.isColumnIndexHiddenInUnderLyingLayer(columnIndex, layer, underlyingLayer);
        }
        return true;
    }

    public static boolean isRightEdgeOfAColumnGroup(ILayer natLayer, int columnPosition, int columnIndex, ColumnGroupModel model) {
        int nextColumnPosition = columnPosition + 1;
        if (nextColumnPosition < natLayer.getColumnCount()) {
            int nextColumnIndex = natLayer.getColumnIndexByPosition(nextColumnPosition);
            if (model.isPartOfAGroup(columnIndex) && !model.isPartOfAGroup(nextColumnIndex)) {
                return true;
            }
            if (model.isPartOfAGroup(columnIndex) && model.isPartOfAGroup(nextColumnIndex) && !ColumnGroupUtils.isInTheSameGroup(columnIndex, nextColumnIndex, model)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isLeftEdgeOfAColumnGroup(ILayer natLayer, int columnPosition, int columnIndex, ColumnGroupModel model) {
        int previousColumnPosition = columnPosition - 1;
        if (columnPosition == 0 && model.isPartOfAGroup(columnIndex)) {
            return true;
        }
        if (previousColumnPosition >= 0) {
            int previousColumnIndex = natLayer.getColumnIndexByPosition(previousColumnPosition);
            if (model.isPartOfAGroup(columnIndex) && !model.isPartOfAGroup(previousColumnIndex)) {
                return true;
            }
            if (model.isPartOfAGroup(columnIndex) && model.isPartOfAGroup(previousColumnIndex) && !ColumnGroupUtils.isInTheSameGroup(columnIndex, previousColumnIndex, model)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isBetweenTwoGroups(ILayer natLayer, int startX, int endX, ColumnGroupModel model) {
        return !ColumnGroupUtils.isInTheSameGroup(natLayer.getColumnIndexByPosition(natLayer.getColumnPositionByX(startX)), natLayer.getColumnIndexByPosition(natLayer.getColumnPositionByX(endX)), model);
    }

    public static boolean isInTheSameGroup(ColumnGroupHeaderLayer layer, int level, int fromPosition, int toPosition) {
        GroupModel.Group fromColumnGroup = layer.getGroupModel(level).getGroupByPosition(fromPosition);
        GroupModel.Group toColumnGroup = layer.getGroupModel(level).getGroupByPosition(toPosition);
        return fromColumnGroup != null && toColumnGroup != null && fromColumnGroup == toColumnGroup;
    }

    public static boolean isBetweenTwoGroups(ILayer natLayer, int startX, int endX, ColumnGroupHeaderLayer layer, int level) {
        int toPosition;
        boolean result;
        int natFromPosition = natLayer.getColumnPositionByX(startX);
        int natToPosition = natLayer.getColumnPositionByX(endX);
        int fromPosition = LayerUtil.convertColumnPosition(natLayer, natFromPosition, layer.getPositionLayer());
        boolean bl = result = !ColumnGroupUtils.isInTheSameGroup(layer, level, fromPosition, toPosition = LayerUtil.convertColumnPosition(natLayer, natToPosition, layer.getPositionLayer()));
        if (!result && fromPosition == toPosition && natFromPosition < natToPosition) {
            result = true;
        }
        return result;
    }

    public static boolean isBetweenTwoGroups(ColumnGroupHeaderLayer columnGroupHeaderLayer, int toPosition, boolean reorderToLeftEdge, SelectionLayer.MoveDirectionEnum moveDirection) {
        if (toPosition == 0 && reorderToLeftEdge || toPosition == columnGroupHeaderLayer.getPositionLayer().getColumnCount() - 1 && !reorderToLeftEdge) {
            return true;
        }
        int toPositionToCheck = toPosition;
        if (reorderToLeftEdge && SelectionLayer.MoveDirectionEnum.RIGHT == moveDirection) {
            --toPositionToCheck;
        }
        boolean valid = true;
        int level = 0;
        while (level < columnGroupHeaderLayer.getLevelCount()) {
            if (SelectionLayer.MoveDirectionEnum.RIGHT == moveDirection) {
                valid = !ColumnGroupUtils.isInTheSameGroup(columnGroupHeaderLayer, level, toPosition, toPositionToCheck);
            } else {
                boolean bl = valid = !ColumnGroupUtils.isInTheSameGroup(columnGroupHeaderLayer, level, toPosition, toPositionToCheck + (reorderToLeftEdge ? -1 : 1));
            }
            if (!valid) break;
            ++level;
        }
        return valid;
    }

    public static boolean isBetweenTwoGroups(ColumnGroupHeaderLayer columnGroupHeaderLayer, int level, int toPosition, boolean reorderToLeftEdge, SelectionLayer.MoveDirectionEnum moveDirection) {
        if (toPosition == 0 && reorderToLeftEdge || toPosition == columnGroupHeaderLayer.getPositionLayer().getColumnCount() - 1 && !reorderToLeftEdge) {
            return true;
        }
        int toPositionToCheck = toPosition;
        if (SelectionLayer.MoveDirectionEnum.RIGHT == moveDirection) {
            toPositionToCheck = reorderToLeftEdge ? --toPositionToCheck : ++toPositionToCheck;
        }
        boolean valid = true;
        if (SelectionLayer.MoveDirectionEnum.RIGHT == moveDirection) {
            valid = !ColumnGroupUtils.isInTheSameGroup(columnGroupHeaderLayer, level, toPosition, toPositionToCheck);
        } else {
            boolean bl = valid = !ColumnGroupUtils.isInTheSameGroup(columnGroupHeaderLayer, level, toPosition, toPositionToCheck + (reorderToLeftEdge ? -1 : 1));
        }
        if (valid && level > 0) {
            valid = ColumnGroupUtils.isBetweenTwoGroups(columnGroupHeaderLayer, level - 1, toPosition, reorderToLeftEdge, moveDirection);
        }
        return valid;
    }

    public static boolean isReorderValid(ColumnGroupHeaderLayer columnGroupHeaderLayer, int fromPosition, int toPosition, boolean reorderToLeftEdge) {
        int level = 0;
        while (level < columnGroupHeaderLayer.getLevelCount()) {
            if (!ColumnGroupUtils.isReorderValid(columnGroupHeaderLayer, level, fromPosition, toPosition, reorderToLeftEdge)) {
                return false;
            }
            ++level;
        }
        return true;
    }

    public static boolean isReorderValid(ColumnGroupHeaderLayer columnGroupHeaderLayer, int level, int fromPosition, int toPosition, boolean reorderToLeftEdge) {
        SelectionLayer.MoveDirectionEnum moveDirection = PositionUtil.getHorizontalMoveDirection(fromPosition, toPosition);
        int toPositionToCheck = toPosition;
        if (SelectionLayer.MoveDirectionEnum.RIGHT == moveDirection && reorderToLeftEdge || toPosition == columnGroupHeaderLayer.getPositionLayer().getColumnCount() && !reorderToLeftEdge) {
            --toPositionToCheck;
        }
        boolean fromUnbreakable = false;
        boolean valid = true;
        GroupModel model = columnGroupHeaderLayer.getGroupModel(level);
        GroupModel.Group group = model.getGroupByPosition(fromPosition);
        if (group != null && group.isUnbreakable() && group.getVisibleSpan() > 1) {
            fromUnbreakable = true;
            valid = ColumnGroupUtils.isInTheSameGroup(columnGroupHeaderLayer, level, fromPosition, toPositionToCheck);
        }
        if (!fromUnbreakable) {
            if (toPosition == 0 && reorderToLeftEdge || toPosition == columnGroupHeaderLayer.getPositionLayer().getColumnCount() - 1 && !reorderToLeftEdge) {
                return true;
            }
            if (model.isPartOfAnUnbreakableGroup(toPositionToCheck)) {
                valid = SelectionLayer.MoveDirectionEnum.RIGHT == moveDirection ? !ColumnGroupUtils.isInTheSameGroup(columnGroupHeaderLayer, level, toPosition, toPositionToCheck) : !ColumnGroupUtils.isInTheSameGroup(columnGroupHeaderLayer, level, toPosition, toPositionToCheck + (reorderToLeftEdge ? -1 : 1));
            }
        }
        return valid;
    }

    public static boolean isGroupReordered(GroupModel.Group fromGroup, int[] fromColumnPositions) {
        Collection<Integer> visiblePositions = fromGroup.getVisiblePositions();
        if (visiblePositions.size() > fromColumnPositions.length) {
            return false;
        }
        if (visiblePositions.size() < fromColumnPositions.length) {
            List<Integer> fromPositions = ArrayUtil.asIntegerList(fromColumnPositions);
            return fromPositions.containsAll(visiblePositions);
        }
        int[] positionsArray = ArrayUtil.asIntArray(visiblePositions);
        return Arrays.equals(positionsArray, fromColumnPositions);
    }
}

