/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.mode;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.nebula.widgets.nattable.ui.action.DragModeEventHandler;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseClickAction;
import org.eclipse.nebula.widgets.nattable.ui.mode.AbstractModeEventHandler;
import org.eclipse.nebula.widgets.nattable.ui.mode.ModeSupport;
import org.eclipse.nebula.widgets.nattable.ui.util.MouseEventHelper;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;

public class MouseModeEventHandler
extends AbstractModeEventHandler {
    private MouseEvent initialMouseDownEvent;
    private IMouseAction singleClickAction;
    private IMouseAction doubleClickAction;
    private boolean mouseDown = true;
    private IDragMode dragMode;
    private boolean doubleClick;
    private boolean skipProcessing = false;
    private Runnable delayedSingleClickRunnable = null;

    public MouseModeEventHandler(ModeSupport modeSupport, NatTable natTable, MouseEvent initialMouseDownEvent, IMouseAction singleClickAction, IMouseAction doubleClickAction, IDragMode dragMode) {
        super(modeSupport, natTable);
        this.initialMouseDownEvent = initialMouseDownEvent;
        this.singleClickAction = singleClickAction;
        this.doubleClickAction = doubleClickAction;
        this.dragMode = dragMode;
    }

    @Override
    public void mouseUp(final MouseEvent event) {
        this.mouseDown = false;
        if (this.delayedSingleClickRunnable != null) {
            this.mouseDoubleClick(event);
            return;
        }
        this.doubleClick = false;
        if (this.singleClickAction != null) {
            if (this.natTable.commitAndCloseActiveCellEditor()) {
                if (this.doubleClickAction != null && (this.isActionExclusive(this.singleClickAction) || this.isActionExclusive(this.doubleClickAction))) {
                    this.delayedSingleClickRunnable = new Runnable(){

                        @Override
                        public void run() {
                            MouseModeEventHandler.this.delayedSingleClickRunnable = null;
                            if (!MouseModeEventHandler.this.doubleClick && !MouseModeEventHandler.this.skipProcessing) {
                                MouseModeEventHandler.this.executeClickAction(MouseModeEventHandler.this.singleClickAction, event);
                            }
                        }
                    };
                    event.display.timerExec(event.display.getDoubleClickTime(), this.delayedSingleClickRunnable);
                } else {
                    this.executeClickAction(this.singleClickAction, event);
                }
            }
        } else if (this.doubleClickAction == null) {
            this.switchMode("NORMAL_MODE");
        }
    }

    @Override
    public void mouseDown(MouseEvent event) {
        if (event.button != this.initialMouseDownEvent.button || event.stateMask != this.initialMouseDownEvent.stateMask) {
            this.skipProcessing = true;
            this.executeClickAction(this.singleClickAction, this.initialMouseDownEvent);
            this.switchMode("NORMAL_MODE");
            this.getModeSupport().mouseDown(event);
        }
    }

    @Override
    public void keyPressed(KeyEvent event) {
        this.skipProcessing = true;
        this.executeClickAction(this.singleClickAction, this.initialMouseDownEvent);
        this.switchMode("NORMAL_MODE");
        this.getModeSupport().keyPressed(event);
    }

    @Override
    public void mouseDoubleClick(MouseEvent event) {
        this.doubleClick = true;
        this.executeClickAction(this.doubleClickAction, event);
    }

    @Override
    public synchronized void mouseMove(MouseEvent event) {
        if (this.mouseDown && this.dragMode != null) {
            if (this.natTable.commitAndCloseActiveCellEditor()) {
                this.dragMode.mouseDown(this.natTable, this.initialMouseDownEvent);
                this.switchMode(new DragModeEventHandler(this.getModeSupport(), this.natTable, this.dragMode, this, this.initialMouseDownEvent));
            } else {
                this.switchMode("NORMAL_MODE");
            }
        } else if (!this.mouseDown && !MouseEventHelper.treatAsClick(this.initialMouseDownEvent, event)) {
            if (this.doubleClickAction != null) {
                this.skipProcessing = true;
                this.executeClickAction(this.singleClickAction, this.initialMouseDownEvent);
            }
            this.switchMode("NORMAL_MODE");
        }
    }

    private void executeClickAction(IMouseAction action, MouseEvent event) {
        if (this.natTable.commitAndCloseActiveCellEditor() && action != null && event != null) {
            event.data = NatEventData.createInstanceFromEvent(event);
            action.run(this.natTable, event);
            this.switchMode("NORMAL_MODE");
        }
    }

    private boolean isActionExclusive(IMouseAction action) {
        if (action instanceof IMouseClickAction) {
            return ((IMouseClickAction)action).isExclusive();
        }
        return false;
    }
}

