/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.export.excel;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.export.FileOutputStreamProvider;
import org.eclipse.nebula.widgets.nattable.export.ILayerExporter;
import org.eclipse.nebula.widgets.nattable.export.IOutputStreamProvider;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleProxy;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Shell;

public class ExcelExporter
implements ILayerExporter {
    private static final Log log = LogFactory.getLog(ExcelExporter.class);
    private static final String EXCEL_HEADER_FILE = "excelExportHeader.txt";
    private static final String CHARSET_PLACEHOLDER = "${charset}";
    private static final String SHEETNAME_PLACEHOLDER = "${sheetname}";
    private String charset = "windows-1252";
    private Charset exportCharSet;
    private String sheetname = "Sheet1";
    private final IOutputStreamProvider outputStreamProvider;

    public ExcelExporter() {
        this(new FileOutputStreamProvider("table_export.xls", new String[]{"Excel Workbook (*.xls)"}, new String[]{"*.xls"}));
    }

    public ExcelExporter(IOutputStreamProvider outputStreamProvider) {
        this.outputStreamProvider = outputStreamProvider;
    }

    @Override
    public OutputStream getOutputStream(Shell shell) {
        return this.outputStreamProvider.getOutputStream(shell);
    }

    @Override
    public void exportBegin(OutputStream outputStream) throws IOException {
        this.exportCharSet = Charset.forName(this.charset);
    }

    @Override
    public void exportEnd(OutputStream outputStream) throws IOException {
    }

    @Override
    public void exportLayerBegin(OutputStream outputStream, String layerName) throws IOException {
        this.writeHeader(outputStream);
        outputStream.write(this.asBytes("<body><table border='1'>"));
    }

    private void writeHeader(OutputStream outputStream) throws IOException {
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(EXCEL_HEADER_FILE)));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    line = line.replace(CHARSET_PLACEHOLDER, this.charset);
                    line = line.replace(SHEETNAME_PLACEHOLDER, this.sheetname);
                    outputStream.write(line.getBytes());
                    outputStream.write(System.getProperty("line.separator").getBytes());
                }
            }
            catch (Exception e) {
                log.error((Object)("Excel Exporter failed: " + e.getMessage()), (Throwable)e);
                if (reader != null) {
                    reader.close();
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Override
    public void exportLayerEnd(OutputStream outputStream, String layerName) throws IOException {
        outputStream.write(this.asBytes("</table></body></html>"));
    }

    @Override
    public void exportRowBegin(OutputStream outputStream, int rowPosition) throws IOException {
        outputStream.write(this.asBytes("<tr>\n"));
    }

    @Override
    public void exportRowEnd(OutputStream outputStream, int rowPosition) throws IOException {
        outputStream.write(this.asBytes("</tr>\n"));
    }

    @Override
    public void exportCell(OutputStream outputStream, Object exportDisplayValue, ILayerCell cell, IConfigRegistry configRegistry) throws IOException {
        String htmlText;
        if (cell.getBounds().width == 0 || cell.getBounds().height == 0) {
            return;
        }
        CellStyleProxy cellStyle = new CellStyleProxy(configRegistry, "NORMAL", cell.getConfigLabels().getLabels());
        Color fg = cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR);
        Color bg = cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
        Font font = cellStyle.getAttributeValue(CellStyleAttributes.FONT);
        if (fg == null) {
            fg = GUIHelper.COLOR_BLACK;
        }
        if (bg == null) {
            bg = GUIHelper.COLOR_WHITE;
        }
        if (font == null) {
            font = GUIHelper.DEFAULT_FONT;
        }
        String htmlAttributes = String.format("style='color: %s; background-color: %s; %s;'", this.getColorInCSSFormat(fg), this.getColorInCSSFormat(bg), this.getFontInCSSFormat(font));
        String string = htmlText = exportDisplayValue != null ? exportDisplayValue.toString() : "";
        if (htmlText.startsWith(" ")) {
            htmlAttributes = String.valueOf(htmlAttributes) + " x:str=\"'" + htmlText + "\";";
            htmlText = htmlText.replaceFirst("^(\\ *)", "<span style='mso-spacerun:yes'>$1</span>");
        }
        outputStream.write(this.asBytes(String.format("\t<td %s>%s</td>\n", htmlAttributes, htmlText)));
    }

    private byte[] asBytes(String string) {
        return string.getBytes(this.exportCharSet);
    }

    private String getFontInCSSFormat(Font font) {
        FontData fontData = font.getFontData()[0];
        String fontName = fontData.getName();
        int fontStyle = fontData.getStyle();
        String[] HTML_STYLES = new String[]{"NORMAL", "BOLD", "ITALIC"};
        return String.format("font: %s; font-family: %s", fontStyle <= 2 ? HTML_STYLES[fontStyle] : HTML_STYLES[0], fontName);
    }

    private String getColorInCSSFormat(Color color) {
        return String.format("rgb(%d,%d,%d)", color.getRed(), color.getGreen(), color.getBlue());
    }

    @Override
    public Object getResult() {
        return this.outputStreamProvider.getResult();
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setSheetname(String sheetname) {
        this.sheetname = sheetname;
    }
}

