/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.cwt.v;

import org.eclipse.nebula.cwt.v.VButton;
import org.eclipse.nebula.cwt.v.VControl;
import org.eclipse.nebula.cwt.v.VControlPainter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;

public class VButtonPainter
extends VControlPainter {
    public void paintBackground(VControl control, Event e) {
        VButton button = (VButton)control;
        if (button.hasState(6)) {
            if (e.gc.getAlpha() == 255) {
                this.doPaintBackground(e.gc, button.bounds, button.getState());
            } else {
                Image img = new Image((Device)e.display, new Rectangle(0, 0, button.bounds.width, button.bounds.height));
                GC gc = new GC((Drawable)img);
                this.doPaintBackground(gc, img.getBounds(), button.getState());
                e.gc.drawImage(img, button.bounds.x, button.bounds.y);
                gc.dispose();
                img.dispose();
            }
        } else {
            super.paintBackground(control, e);
        }
    }

    private void doPaintBackground(GC gc, Rectangle bounds, int state) {
        Color outline = null;
        Color bkBlue = null;
        if ((state & 4) == 4) {
            outline = new Color(gc.getDevice(), 1, 85, 153);
            bkBlue = new Color(gc.getDevice(), 204, 228, 247);
        } else if ((state & 2) == 2) {
            outline = new Color(gc.getDevice(), 1, 121, 215);
            bkBlue = new Color(gc.getDevice(), 229, 241, 251);
        }
        if (outline != null && bkBlue != null) {
            gc.setBackground(bkBlue);
            gc.setForeground(outline);
            gc.fillRectangle(0, 0, bounds.width - 1, bounds.height - 1);
            gc.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
            outline.dispose();
            bkBlue.dispose();
        }
    }
}

