/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.tickupdate;

public interface ITickUpdateHandler {
    public static final ITickUpdateHandler DEFAULT_TICK_UPDATE_HANDLER = new ITickUpdateHandler(){

        @Override
        public boolean isApplicableFor(Object value) {
            return value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof Float;
        }

        @Override
        public Object getIncrementedValue(Object currentValue) {
            return this.getIncrementedValue(currentValue, 1.0);
        }

        @Override
        public Object getIncrementedValue(Object currentValue, double incrementSize) {
            if (currentValue instanceof Byte) {
                return Integer.valueOf((Byte)currentValue + Double.valueOf(Math.abs(incrementSize)).byteValue()).byteValue();
            }
            if (currentValue instanceof Short) {
                return Integer.valueOf((Short)currentValue + Double.valueOf(Math.abs(incrementSize)).shortValue()).shortValue();
            }
            if (currentValue instanceof Integer) {
                return (Integer)currentValue + Double.valueOf(Math.abs(incrementSize)).intValue();
            }
            if (currentValue instanceof Long) {
                return (Long)currentValue + Double.valueOf(Math.abs(incrementSize)).longValue();
            }
            if (currentValue instanceof Double) {
                return (Double)currentValue + Math.abs(incrementSize);
            }
            if (currentValue instanceof Float) {
                return Float.valueOf(((Float)currentValue).floatValue() + Double.valueOf(Math.abs(incrementSize)).floatValue());
            }
            return currentValue;
        }

        @Override
        public Object getDecrementedValue(Object currentValue) {
            return this.getDecrementedValue(currentValue, 1.0);
        }

        @Override
        public Object getDecrementedValue(Object currentValue, double decrementSize) {
            if (currentValue instanceof Byte) {
                return Integer.valueOf((Byte)currentValue - Double.valueOf(Math.abs(decrementSize)).byteValue()).byteValue();
            }
            if (currentValue instanceof Short) {
                return Integer.valueOf((Short)currentValue - Double.valueOf(Math.abs(decrementSize)).shortValue()).shortValue();
            }
            if (currentValue instanceof Integer) {
                return (Integer)currentValue - Double.valueOf(Math.abs(decrementSize)).intValue();
            }
            if (currentValue instanceof Long) {
                return (Long)currentValue - Double.valueOf(Math.abs(decrementSize)).longValue();
            }
            if (currentValue instanceof Double) {
                return (Double)currentValue - Math.abs(decrementSize);
            }
            if (currentValue instanceof Float) {
                return Float.valueOf(((Float)currentValue).floatValue() - Double.valueOf(Math.abs(decrementSize)).floatValue());
            }
            return currentValue;
        }
    };

    public boolean isApplicableFor(Object var1);

    public Object getIncrementedValue(Object var1);

    public Object getIncrementedValue(Object var1, double var2);

    public Object getDecrementedValue(Object var1);

    public Object getDecrementedValue(Object var1, double var2);
}

