/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.command.CreateColumnGroupCommand;
import org.eclipse.nebula.widgets.nattable.group.command.DisplayColumnGroupRenameDialogCommand;
import org.eclipse.nebula.widgets.nattable.group.command.IColumnGroupCommand;
import org.eclipse.nebula.widgets.nattable.group.command.RemoveColumnGroupCommand;
import org.eclipse.nebula.widgets.nattable.group.command.UngroupColumnCommand;
import org.eclipse.nebula.widgets.nattable.group.event.GroupColumnsEvent;
import org.eclipse.nebula.widgets.nattable.group.event.UngroupColumnsEvent;
import org.eclipse.nebula.widgets.nattable.group.performance.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.group.performance.command.ColumnGroupExpandCommand;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiColumnReorderCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.rename.HeaderRenameDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;

public class ColumnGroupsCommandHandler
extends AbstractLayerCommandHandler<IColumnGroupCommand> {
    private final ColumnGroupHeaderLayer contextLayer;
    private final SelectionLayer selectionLayer;

    public ColumnGroupsCommandHandler(ColumnGroupHeaderLayer contextLayer, SelectionLayer selectionLayer) {
        this.contextLayer = contextLayer;
        this.selectionLayer = selectionLayer;
    }

    @Override
    public boolean doCommand(IColumnGroupCommand command) {
        if (command instanceof CreateColumnGroupCommand) {
            CreateColumnGroupCommand createCommand = (CreateColumnGroupCommand)command;
            if (!this.handleCreateColumnGroupCommand(createCommand.getColumnGroupName())) {
                MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 33);
                messageBox.setText(Messages.getString("ErrorDialog.title"));
                messageBox.setMessage(Messages.getString("ColumnGroups.selectNonGroupedColumns"));
                messageBox.open();
            }
            return true;
        }
        if (command instanceof RemoveColumnGroupCommand) {
            RemoveColumnGroupCommand removeColumnGroupCommand = (RemoveColumnGroupCommand)command;
            int columnIndex = removeColumnGroupCommand.getColumnIndex();
            this.handleRemoveColumnGroupCommand(columnIndex);
            return true;
        }
        if (command instanceof UngroupColumnCommand) {
            this.handleUngroupCommand();
            return true;
        }
        if (command instanceof DisplayColumnGroupRenameDialogCommand) {
            return this.displayColumnGroupRenameDialog((DisplayColumnGroupRenameDialogCommand)command);
        }
        return false;
    }

    protected boolean handleCreateColumnGroupCommand(String columnGroupName) {
        int[] fullySelectedColumns = this.selectionLayer.getFullySelectedColumnPositions();
        GroupModel model = this.contextLayer.getGroupModel();
        TreeSet<Integer> positionsToGroup = new TreeSet<Integer>();
        if (fullySelectedColumns != null && fullySelectedColumns.length > 0) {
            int[] nArray = fullySelectedColumns;
            int n = fullySelectedColumns.length;
            int n2 = 0;
            while (n2 < n) {
                int column = nArray[n2];
                int converted = LayerUtil.convertColumnPosition(this.selectionLayer, column, this.contextLayer.getPositionLayer());
                if (converted > -1) {
                    positionsToGroup.add(converted);
                }
                ++n2;
            }
            HashSet<GroupModel.Group> existingGroups = new HashSet<GroupModel.Group>();
            Iterator it = positionsToGroup.iterator();
            while (it.hasNext()) {
                int column = (Integer)it.next();
                GroupModel.Group group = model.getGroupByPosition(column);
                if (group == null) continue;
                if (!group.isUnbreakable()) {
                    existingGroups.add(group);
                    continue;
                }
                it.remove();
            }
            if (!existingGroups.isEmpty()) {
                this.contextLayer.doCommand(new ColumnGroupExpandCommand(model, existingGroups));
                for (GroupModel.Group group : existingGroups) {
                    positionsToGroup.addAll(group.getVisiblePositions());
                    this.contextLayer.removeGroup(group);
                }
            }
            ArrayList<Integer> selectedPositions = new ArrayList<Integer>(positionsToGroup);
            this.selectionLayer.doCommand(new MultiColumnReorderCommand(this.selectionLayer, selectedPositions, (Integer)selectedPositions.get(0)));
            this.contextLayer.addGroup(columnGroupName, this.selectionLayer.getColumnIndexByPosition((Integer)selectedPositions.get(0)), positionsToGroup.size());
            this.selectionLayer.clear();
            this.contextLayer.fireLayerEvent(new GroupColumnsEvent(this.contextLayer));
            return true;
        }
        return false;
    }

    protected void handleRemoveColumnGroupCommand(int columnIndex) {
        int selectedPosition = this.selectionLayer.getColumnPositionByIndex(columnIndex);
        int converted = LayerUtil.convertColumnPosition(this.selectionLayer, selectedPosition, this.contextLayer.getPositionLayer());
        GroupModel model = this.contextLayer.getGroupModel();
        GroupModel.Group group = model.getGroupByPosition(converted);
        if (group != null && !group.isUnbreakable()) {
            if (group.isCollapsed()) {
                this.contextLayer.doCommand(new ColumnGroupExpandCommand(model, group));
            }
            model.removeGroup(group);
            this.contextLayer.fireLayerEvent(new GroupColumnsEvent(this.contextLayer));
        }
    }

    protected void handleUngroupCommand() {
        int[] fullySelectedColumns = this.selectionLayer.getFullySelectedColumnPositions();
        if (fullySelectedColumns != null && fullySelectedColumns.length > 0) {
            int endPos;
            TreeSet<Integer> positionsToUngroup = new TreeSet<Integer>();
            Object object = fullySelectedColumns;
            int n = fullySelectedColumns.length;
            int n2 = 0;
            while (n2 < n) {
                int column = object[n2];
                int converted = LayerUtil.convertColumnPosition(this.selectionLayer, column, this.contextLayer.getPositionLayer());
                if (converted > -1) {
                    positionsToUngroup.add(converted);
                }
                ++n2;
            }
            GroupModel model = this.contextLayer.getGroupModel();
            HashMap<GroupModel.Group, ArrayList<Integer>> toRemove = new HashMap<GroupModel.Group, ArrayList<Integer>>();
            object = positionsToUngroup.iterator();
            while (object.hasNext()) {
                int n3 = (Integer)object.next();
                GroupModel.Group group = model.getGroupByPosition(n3);
                if (group == null) continue;
                endPos = group.getVisibleStartPosition() + group.getVisibleSpan();
                if (n3 < endPos && !group.isGroupStart(n3)) {
                    ArrayList<Integer> remove = (ArrayList<Integer>)toRemove.get(group);
                    if (remove == null) {
                        remove = new ArrayList<Integer>();
                        toRemove.put(group, remove);
                    }
                    remove.add(n3);
                    continue;
                }
                model.removePositionsFromGroup(group, n3);
            }
            if (!toRemove.isEmpty()) {
                for (Map.Entry entry : toRemove.entrySet()) {
                    GroupModel.Group group = (GroupModel.Group)entry.getKey();
                    endPos = group.getVisibleStartPosition() + group.getVisibleSpan();
                    this.selectionLayer.doCommand(new MultiColumnReorderCommand(this.selectionLayer, (List)entry.getValue(), endPos));
                    List value = (List)entry.getValue();
                    int start = endPos - value.size();
                    int[] positionsToRemove = new int[value.size()];
                    int i = 0;
                    while (i < ((List)entry.getValue()).size()) {
                        positionsToRemove[i] = start + i;
                        ++i;
                    }
                    model.removePositionsFromGroup(group, positionsToRemove);
                }
            }
            this.selectionLayer.clear();
            this.contextLayer.fireLayerEvent(new UngroupColumnsEvent(this.contextLayer));
        }
    }

    protected boolean displayColumnGroupRenameDialog(DisplayColumnGroupRenameDialogCommand command) {
        int columnPosition = command.getColumnPosition();
        HeaderRenameDialog dialog = new HeaderRenameDialog(Display.getDefault().getActiveShell(), null, null, HeaderRenameDialog.RenameDialogLabels.COLUMN_RENAME);
        Rectangle colHeaderBounds = this.contextLayer.getBoundsByPosition(columnPosition, 0);
        Point point = new Point(colHeaderBounds.x, colHeaderBounds.y + colHeaderBounds.height);
        dialog.setLocation(command.toDisplayCoordinates(point));
        dialog.open();
        if (!dialog.isCancelPressed()) {
            GroupModel.Group columnGroup = this.contextLayer.getGroupByPosition(columnPosition);
            columnGroup.setName(dialog.getNewLabel());
        }
        return true;
    }

    @Override
    public Class<IColumnGroupCommand> getCommandClass() {
        return IColumnGroupCommand.class;
    }
}

