/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.search.action;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.search.CellValueAsStringComparator;
import org.eclipse.nebula.widgets.nattable.search.gui.SearchDialog;
import org.eclipse.nebula.widgets.nattable.ui.action.IKeyAction;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;

public class SearchAction
implements IKeyAction {
    private static SearchDialog dialog;
    private NatTable natTable;
    private IDialogSettings dialogSettings;
    private boolean modal;
    private DisposeListener listener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            if (dialog != null) {
                if (dialog.isModal()) {
                    dialog.close();
                    dialog = null;
                } else {
                    dialog.setInput(null, null);
                }
            }
        }
    };

    public SearchAction() {
        this(null, null, true);
    }

    public SearchAction(NatTable natTable, IDialogSettings dialogSettings) {
        this(natTable, dialogSettings, false);
        if (natTable == null) {
            throw new IllegalArgumentException();
        }
    }

    private SearchAction(NatTable natTable, IDialogSettings dialogSettings, boolean modal) {
        this.natTable = natTable;
        this.dialogSettings = dialogSettings;
        this.modal = modal;
        if (natTable != null) {
            natTable.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    SearchAction.this.setActiveContext();
                }
            });
            natTable.addDisposeListener(this.listener);
        }
    }

    protected void setActiveContext() {
        if (dialog != null && dialog.getNatTable() != null && !this.isEquivalentToActiveContext()) {
            dialog.close();
            dialog = null;
        }
        if (dialog != null) {
            dialog.setInput(this.natTable, this.dialogSettings);
        }
    }

    private boolean isEquivalentToActiveContext() {
        if (this.modal) {
            return this.natTable == dialog.getNatTable() && this.dialogSettings == dialog.getOriginalDialogSettings() && this.modal == dialog.isModal();
        }
        if (dialog.isModal()) {
            return false;
        }
        return !this.natTable.isDisposed() && dialog.getNatTable() != null && !dialog.getNatTable().isDisposed() && this.natTable.getShell().equals(dialog.getNatTable().getShell()) && (this.dialogSettings == null && dialog.getOriginalDialogSettings() == null || this.dialogSettings.equals(dialog.getOriginalDialogSettings()));
    }

    @Override
    public void run(NatTable natTable, KeyEvent event) {
        if (this.natTable != natTable) {
            if (this.natTable != null) {
                this.natTable.removeDisposeListener(this.listener);
            }
            this.natTable = natTable;
            this.natTable.addDisposeListener(this.listener);
        }
        this.setActiveContext();
        if (dialog == null) {
            dialog = new SearchDialog(this.natTable.getShell(), new CellValueAsStringComparator(), this.modal ? 0 : 65536);
            dialog.setInput(this.natTable, this.dialogSettings);
        }
        dialog.open();
    }
}

