/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree;

import ca.odell.glazedlists.TreeList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.tree.ITreeData;

public class GlazedListTreeData<T>
implements ITreeData<T> {
    private final TreeList<T> treeList;

    public GlazedListTreeData(TreeList<T> treeList) {
        this.treeList = treeList;
    }

    @Deprecated
    public String formatDataForDepth(int depth, int index) {
        return this.formatDataForDepth(depth, this.getDataAtIndex(index));
    }

    @Deprecated
    public String formatDataForDepth(int depth, T object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public T getDataAtIndex(int index) {
        if (!this.isValidIndex(index)) {
            return null;
        }
        return (T)this.treeList.get(index);
    }

    public int getDepthOfData(T object) {
        return this.getDepthOfData(this.indexOf(object));
    }

    public int getDepthOfData(int index) {
        if (!this.isValidIndex(index)) {
            return 0;
        }
        return this.treeList.depth(index);
    }

    public int indexOf(T object) {
        return this.treeList.indexOf(object);
    }

    public boolean hasChildren(T object) {
        return this.hasChildren(this.indexOf(object));
    }

    public boolean hasChildren(int index) {
        if (!this.isValidIndex(index)) {
            return false;
        }
        return this.treeList.hasChildren(index);
    }

    public List<T> getChildren(T object) {
        return this.getChildren(this.indexOf(object));
    }

    private List<T> getNodeChildren(TreeList.Node<T> treeNode) {
        ArrayList<Object> children = new ArrayList<Object>();
        for (TreeList.Node child : treeNode.getChildren()) {
            children.add(child.getElement());
            children.addAll(this.getNodeChildren(child));
        }
        return children;
    }

    public List<T> getChildren(T object, boolean fullDepth) {
        if (!fullDepth) {
            return this.getChildren(object);
        }
        int index = this.indexOf(object);
        if (index >= 0) {
            TreeList.Node treeNode = this.treeList.getTreeNode(index);
            return this.getNodeChildren(treeNode);
        }
        return Collections.emptyList();
    }

    public List<T> getChildren(int index) {
        TreeList.Node treeNode;
        if (!this.isValidIndex(index)) {
            return null;
        }
        ArrayList<Object> children = null;
        if (index >= 0 && (treeNode = this.treeList.getTreeNode(index)) != null) {
            List childrenNodes = treeNode.getChildren();
            children = new ArrayList(childrenNodes.size());
            for (TreeList.Node node : childrenNodes) {
                children.add(node.getElement());
            }
        }
        return children != null ? children : new ArrayList<Object>();
    }

    public int getElementCount() {
        return this.treeList.size();
    }

    @Deprecated
    public void collapse(T object) {
        this.collapse(this.indexOf(object));
    }

    @Deprecated
    public void expand(T object) {
        this.expand(this.indexOf(object));
    }

    @Deprecated
    public void collapse(int index) {
        if (!this.isValidIndex(index)) {
            return;
        }
        this.treeList.setExpanded(index, false);
    }

    @Deprecated
    public void expand(int index) {
        if (!this.isValidIndex(index)) {
            return;
        }
        this.treeList.setExpanded(index, true);
    }

    @Deprecated
    public void collapseAll() {
        this.treeList.getReadWriteLock().writeLock().lock();
        try {
            int i = this.treeList.size() - 1;
            while (i >= 0) {
                if (this.hasChildren(i) && this.isExpanded(i)) {
                    this.treeList.setExpanded(i, false);
                }
                --i;
            }
        }
        finally {
            this.treeList.getReadWriteLock().writeLock().unlock();
        }
    }

    @Deprecated
    public void expandAll() {
        boolean expandPerformed = false;
        this.treeList.getReadWriteLock().writeLock().lock();
        try {
            int i = this.treeList.size() - 1;
            while (i >= 0) {
                if (this.hasChildren(i) && !this.isExpanded(i)) {
                    this.treeList.setExpanded(i, true);
                    expandPerformed = true;
                }
                --i;
            }
        }
        finally {
            this.treeList.getReadWriteLock().writeLock().unlock();
        }
        if (expandPerformed) {
            this.expandAll();
        }
    }

    @Deprecated
    public boolean isExpanded(T object) {
        return this.isExpanded(this.indexOf(object));
    }

    @Deprecated
    public boolean isExpanded(int index) {
        if (!this.isValidIndex(index)) {
            return false;
        }
        return this.treeList.isExpanded(index);
    }

    public boolean isValidIndex(int index) {
        return index >= 0 && index < this.treeList.size();
    }

    public TreeList<T> getTreeList() {
        return this.treeList;
    }
}

