/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.cdatetime;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import org.eclipse.nebula.cwt.v.VButton;
import org.eclipse.nebula.cwt.v.VGridLayout;
import org.eclipse.nebula.cwt.v.VLabel;
import org.eclipse.nebula.cwt.v.VLayout;
import org.eclipse.nebula.cwt.v.VPanel;
import org.eclipse.nebula.cwt.v.VSpacer;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class DiscreteTimePicker
extends VPanel {
    VButton[] hours;
    VButton[] minutes;
    VButton[] am_pm;
    private boolean is24Hour;
    private boolean isHorizontal;
    private int cdtStyle;
    private CDateTime cdt;

    public DiscreteTimePicker(CDateTime parent) {
        super(parent.pickerPanel, parent.style);
        this.cdt = parent;
        this.cdtStyle = parent.getStyle();
        this.isHorizontal = (parent.getStyle() & 0x1000) == 0;
    }

    private void clearButtons() {
        int i = 0;
        while (i < this.hours.length) {
            this.hours[i].setSelection(false);
            ++i;
        }
        i = 0;
        while (i < this.minutes.length) {
            this.minutes[i].setSelection(false);
            ++i;
        }
        i = 0;
        while (i < this.am_pm.length) {
            this.am_pm[i].setSelection(false);
            ++i;
        }
    }

    protected void createContents() {
        VGridLayout layout = new VGridLayout();
        layout.numColumns = this.isHorizontal ? (this.is24Hour ? 12 : 14) : (this.is24Hour ? 4 : 3);
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.setLayout((VLayout)layout);
        this.hours = new VButton[this.is24Hour ? 24 : 12];
        this.minutes = new VButton[12];
        this.am_pm = new VButton[this.is24Hour ? 0 : 2];
        if (this.isHorizontal) {
            this.createHorizontal();
        } else {
            this.createVertical();
        }
    }

    private void createHorizontal() {
        int i = 0;
        while (i < this.hours.length) {
            this.hours[i] = new VButton((VPanel)this, 524290);
            this.hours[i].setSquare(true);
            this.hours[i].setLayoutData(new GridData(4, 4, true, true));
            this.hours[i].addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    VButton[] vButtonArray = DiscreteTimePicker.this.hours;
                    int n = DiscreteTimePicker.this.hours.length;
                    int n2 = 0;
                    while (n2 < n) {
                        VButton button = vButtonArray[n2];
                        if (button != event.data) {
                            button.setSelection(false);
                        }
                        ++n2;
                    }
                    DiscreteTimePicker.this.updateSelection();
                }
            });
            if (!this.is24Hour && i == 11) {
                VLabel lbl = new VLabel((VPanel)this, 2);
                GridData data = new GridData(4, 4, false, false);
                data.verticalSpan = 3;
                lbl.setLayoutData(data);
                this.am_pm[0] = new VButton((VPanel)this, 524290);
                this.am_pm[0].setSquare(true);
                this.am_pm[0].setLayoutData(new GridData(4, 4, true, true));
                this.am_pm[0].addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        VButton[] vButtonArray = DiscreteTimePicker.this.am_pm;
                        int n = DiscreteTimePicker.this.am_pm.length;
                        int n2 = 0;
                        while (n2 < n) {
                            VButton button = vButtonArray[n2];
                            if (button != event.data) {
                                button.setSelection(false);
                            }
                            ++n2;
                        }
                        DiscreteTimePicker.this.updateSelection();
                    }
                });
            }
            ++i;
        }
        VLabel lbl = new VLabel((VPanel)this, 258);
        GridData data = new GridData(4, 0x1000000, false, false);
        data.horizontalSpan = 12;
        lbl.setLayoutData(data);
        if (!this.is24Hour) {
            lbl = new VLabel((VPanel)this, 0);
            data = new GridData(4, 0x1000000, false, false);
            data.heightHint = 1;
            lbl.setLayoutData(data);
        }
        int i2 = 0;
        while (i2 < this.minutes.length) {
            this.minutes[i2] = new VButton((VPanel)this, 524290);
            this.minutes[i2].setSquare(true);
            this.minutes[i2].setLayoutData(new GridData(4, 4, true, true));
            this.minutes[i2].setBackground(this.getDisplay().getSystemColor(1));
            this.minutes[i2].addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    VButton[] vButtonArray = DiscreteTimePicker.this.minutes;
                    int n = DiscreteTimePicker.this.minutes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        VButton button = vButtonArray[n2];
                        if (button != event.data) {
                            button.setSelection(false);
                        }
                        ++n2;
                    }
                    DiscreteTimePicker.this.updateSelection();
                }
            });
            ++i2;
        }
        if (!this.is24Hour) {
            this.am_pm[1] = new VButton((VPanel)this, 524290);
            this.am_pm[1].setSquare(true);
            this.am_pm[1].setLayoutData(new GridData(4, 4, true, true));
            this.am_pm[1].addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    VButton[] vButtonArray = DiscreteTimePicker.this.am_pm;
                    int n = DiscreteTimePicker.this.am_pm.length;
                    int n2 = 0;
                    while (n2 < n) {
                        VButton button = vButtonArray[n2];
                        if (button != event.data) {
                            button.setSelection(false);
                        }
                        ++n2;
                    }
                    DiscreteTimePicker.this.updateSelection();
                }
            });
        }
    }

    private void createVertical() {
        int i = 0;
        while (i < this.minutes.length) {
            this.hours[i] = new VButton((VPanel)this, 524290);
            this.hours[i].setSquare(true);
            this.hours[i].setLayoutData(new GridData(4, 4, true, true));
            this.hours[i].addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    VButton[] vButtonArray = DiscreteTimePicker.this.hours;
                    int n = DiscreteTimePicker.this.hours.length;
                    int n2 = 0;
                    while (n2 < n) {
                        VButton button = vButtonArray[n2];
                        if (button != event.data) {
                            button.setSelection(false);
                        }
                        ++n2;
                    }
                    DiscreteTimePicker.this.updateSelection();
                }
            });
            int j = i + 12;
            if (j < this.hours.length) {
                this.hours[j] = new VButton((VPanel)this, 524290);
                this.hours[i].setSquare(true);
                this.hours[j].setLayoutData(new GridData(4, 4, true, true));
                this.hours[j].addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        VButton[] vButtonArray = DiscreteTimePicker.this.hours;
                        int n = DiscreteTimePicker.this.hours.length;
                        int n2 = 0;
                        while (n2 < n) {
                            VButton button = vButtonArray[n2];
                            if (button != event.data) {
                                button.setSelection(false);
                            }
                            ++n2;
                        }
                        DiscreteTimePicker.this.updateSelection();
                    }
                });
            }
            if (i == 0) {
                VLabel lbl = new VLabel((VPanel)this, 2);
                GridData data = new GridData(4, 4, false, false);
                data.verticalSpan = 12;
                lbl.setLayoutData(data);
            }
            this.minutes[i] = new VButton((VPanel)this, 524290);
            this.minutes[i].setSquare(true);
            this.minutes[i].setLayoutData(new GridData(4, 4, true, true));
            this.minutes[i].setBackground(this.getDisplay().getSystemColor(1));
            this.minutes[i].addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    VButton[] vButtonArray = DiscreteTimePicker.this.minutes;
                    int n = DiscreteTimePicker.this.minutes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        VButton button = vButtonArray[n2];
                        if (button != event.data) {
                            button.setSelection(false);
                        }
                        ++n2;
                    }
                    DiscreteTimePicker.this.updateSelection();
                }
            });
            ++i;
        }
        if (!this.is24Hour) {
            VLabel lbl = new VLabel((VPanel)this, 258);
            GridData data = new GridData(4, 4, false, false);
            data.horizontalSpan = 3;
            lbl.setLayoutData(data);
        }
        i = 0;
        while (i < this.am_pm.length) {
            this.am_pm[i] = new VButton((VPanel)this, 524290);
            this.am_pm[i].setSquare(true);
            this.am_pm[i].setLayoutData(new GridData(4, 4, true, true));
            this.am_pm[i].addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    VButton[] vButtonArray = DiscreteTimePicker.this.am_pm;
                    int n = DiscreteTimePicker.this.am_pm.length;
                    int n2 = 0;
                    while (n2 < n) {
                        VButton button = vButtonArray[n2];
                        if (button != event.data) {
                            button.setSelection(false);
                        }
                        ++n2;
                    }
                    DiscreteTimePicker.this.updateSelection();
                }
            });
            if (i == 0) {
                new VSpacer((VPanel)this, 0);
            }
            ++i;
        }
    }

    public int[] getFields() {
        return new int[]{11, 12};
    }

    public void setFields(int[] calendarFields) {
        this.is24Hour = false;
        int[] nArray = calendarFields;
        int n = calendarFields.length;
        int n2 = 0;
        while (n2 < n) {
            int field = nArray[n2];
            if (field == 11) {
                this.is24Hour = true;
            }
            ++n2;
        }
        if ((this.cdtStyle & 0x10000000) != 0) {
            this.is24Hour = false;
        } else if ((this.cdtStyle & 0x20000000) != 0) {
            this.is24Hour = true;
        }
        this.createContents();
        this.updateLabels();
    }

    public boolean setFocus() {
        return true;
    }

    protected void updateLabels() {
        Calendar cal = this.cdt.getCalendarInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        Locale locale = this.cdt.getLocale();
        String pattern = ((SimpleDateFormat)DateFormat.getTimeInstance(3, locale)).toPattern();
        SimpleDateFormat sdf = null;
        sdf = pattern.indexOf("HH") > -1 ? new SimpleDateFormat("HH", locale) : (pattern.indexOf("H") > -1 ? new SimpleDateFormat("H", locale) : (pattern.indexOf("hh") > -1 ? new SimpleDateFormat("h", locale) : new SimpleDateFormat("h", locale)));
        sdf.setTimeZone(cal.getTimeZone());
        int i = 0;
        while (i < this.hours.length) {
            this.hours[i].setText(sdf.format(cal.getTime()));
            cal.add(11, 1);
            ++i;
        }
        sdf.applyPattern(":mm");
        i = 0;
        while (i < this.minutes.length) {
            this.minutes[i].setText(sdf.format(cal.getTime()));
            cal.add(12, 5);
            ++i;
        }
        sdf.applyPattern("a");
        if (!this.is24Hour) {
            cal.set(11, 1);
            this.am_pm[0].setText(sdf.format(cal.getTime()));
            cal.set(11, 13);
            this.am_pm[1].setText(sdf.format(cal.getTime()));
        }
    }

    protected void updateSelection() {
        boolean ampm_set;
        Calendar cal = this.cdt.getCalendarInstance();
        boolean hour_set = false;
        int i = 0;
        while (i < this.hours.length) {
            if (this.hours[i].getSelection()) {
                cal.set(11, i);
                hour_set = true;
                break;
            }
            ++i;
        }
        boolean min_set = false;
        int i2 = 0;
        while (i2 < this.minutes.length) {
            if (this.minutes[i2].getSelection()) {
                cal.set(12, i2 * 5);
                min_set = true;
                break;
            }
            ++i2;
        }
        boolean bl = ampm_set = this.is24Hour || this.am_pm[0].getSelection() || this.am_pm[1].getSelection();
        if (!this.is24Hour && this.am_pm[1].getSelection()) {
            cal.add(11, 12);
        }
        if (hour_set && min_set && ampm_set) {
            this.cdt.setSelection(cal.getTime());
            this.cdt.fireSelectionChanged();
        }
    }

    protected void updateView() {
        this.clearButtons();
    }
}

