/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.columnCategories.gui;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.columnCategories.Node;
import org.eclipse.nebula.widgets.nattable.columnChooser.ColumnChooserUtils;
import org.eclipse.nebula.widgets.nattable.columnChooser.ColumnEntry;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;

public class ColumnCategoriesLabelProvider
extends LabelProvider {
    private static final Log log = LogFactory.getLog(ColumnCategoriesLabelProvider.class);
    List<ColumnEntry> hiddenEntries;

    public ColumnCategoriesLabelProvider(List<ColumnEntry> hiddenEntries) {
        this.hiddenEntries = hiddenEntries;
    }

    public String getText(Object element) {
        Node node = (Node)element;
        switch (node.getType()) {
            case CATEGORY: {
                return node.getData();
            }
            case COLUMN: {
                int index = Integer.parseInt(node.getData());
                ColumnEntry columnEntry = ColumnChooserUtils.find(this.hiddenEntries, index);
                if (ObjectUtils.isNull(columnEntry)) {
                    log.error((Object)("Column index " + index + " is present " + "in the Column Categories model, " + "but not in the underlying data"));
                    return String.valueOf(index);
                }
                return columnEntry.getLabel();
            }
        }
        return Messages.getString("Unknown");
    }
}

