/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._110_Editing;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultBooleanDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDoubleDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultIntegerDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.dataset.person.Person;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.CheckBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.MultiLineTextCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.PasswordCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.TextCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.gui.FileDialogCellEditor;
import org.eclipse.nebula.widgets.nattable.examples.examples._110_Editing.EditorExample;
import org.eclipse.nebula.widgets.nattable.painter.cell.CheckBoxPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ComboBoxPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.PasswordTextPainter;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.tickupdate.TickUpdateConfigAttributes;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

class EditorConfiguration
extends AbstractRegistryConfiguration {
    EditorConfiguration() {
    }

    public void configureRegistry(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE);
        this.registerEditors(configRegistry);
    }

    private void registerEditors(IConfigRegistry configRegistry) {
        this.registerColumnTwoTextEditor(configRegistry);
        this.registerColumnThreePasswordEditor(configRegistry);
        this.registerColumnFourMultiLineEditor(configRegistry);
        this.registerColumnFiveIntegerEditor(configRegistry);
        this.registerColumnSixDoubleEditor(configRegistry);
        this.registerColumnSevenCheckbox(configRegistry);
        this.registerColumnEightCheckbox(configRegistry);
        this.registerColumnNineComboBox(configRegistry);
        this.registerColumnTenComboBox(configRegistry);
        this.registerColumnElevenComboBox(configRegistry);
        this.registerColumnTwelveComboBox(configRegistry);
        this.registerColumnThirteenFileDialogEditor(configRegistry);
    }

    private void registerColumnTwoTextEditor(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new TextCellEditor(true, true), "NORMAL", EditorExample.COLUMN_TWO_LABEL);
        configRegistry.registerConfigAttribute(EditConfigAttributes.OPEN_ADJACENT_EDITOR, (Object)Boolean.TRUE, "EDIT", EditorExample.COLUMN_TWO_LABEL);
        HashMap<String, String> editDialogSettings = new HashMap<String, String>();
        editDialogSettings.put("DIALOG_MESSAGE", "Please specify the lastname in here:");
        configRegistry.registerConfigAttribute(EditConfigAttributes.EDIT_DIALOG_SETTINGS, editDialogSettings, "EDIT", EditorExample.COLUMN_TWO_LABEL);
    }

    private void registerColumnThreePasswordEditor(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new PasswordCellEditor(), "NORMAL", EditorExample.COLUMN_THREE_LABEL);
        configRegistry.registerConfigAttribute(EditConfigAttributes.SUPPORT_MULTI_EDIT, (Object)Boolean.FALSE, "EDIT", EditorExample.COLUMN_THREE_LABEL);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new PasswordTextPainter(), "NORMAL", EditorExample.COLUMN_THREE_LABEL);
    }

    private void registerColumnFourMultiLineEditor(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new MultiLineTextCellEditor(false), "NORMAL", EditorExample.COLUMN_FOUR_LABEL);
        configRegistry.registerConfigAttribute(EditConfigAttributes.OPEN_IN_DIALOG, (Object)Boolean.TRUE, "EDIT", EditorExample.COLUMN_FOUR_LABEL);
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignmentEnum.LEFT);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, "NORMAL", EditorExample.COLUMN_FOUR_LABEL);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, "EDIT", EditorExample.COLUMN_FOUR_LABEL);
        Display display = Display.getCurrent();
        HashMap<String, Object> editDialogSettings = new HashMap<String, Object>();
        editDialogSettings.put("DIALOG_SHELL_TITLE", "My custom value");
        editDialogSettings.put("DIALOG_SHELL_ICON", display.getSystemImage(8));
        editDialogSettings.put("DIALOG_SHELL_RESIZABLE", Boolean.TRUE);
        Point size = new Point(400, 300);
        editDialogSettings.put("DIALOG_SHELL_SIZE", size);
        int screenWidth = display.getBounds().width;
        int screenHeight = display.getBounds().height;
        Point location = new Point(screenWidth / (2 * display.getMonitors().length) - size.x / 2, screenHeight / 2 - size.y / 2);
        editDialogSettings.put("DIALOG_SHELL_LOCATION", location);
        editDialogSettings.put("DIALOG_MESSAGE", "Enter some free text in here:");
        configRegistry.registerConfigAttribute(EditConfigAttributes.EDIT_DIALOG_SETTINGS, editDialogSettings, "EDIT", EditorExample.COLUMN_FOUR_LABEL);
    }

    private void registerColumnFiveIntegerEditor(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new TextCellEditor(false, true), "NORMAL", EditorExample.COLUMN_FIVE_LABEL);
        configRegistry.registerConfigAttribute(EditConfigAttributes.OPEN_ADJACENT_EDITOR, (Object)Boolean.TRUE, "EDIT", EditorExample.COLUMN_FIVE_LABEL);
        configRegistry.registerConfigAttribute(EditConfigAttributes.OPEN_IN_DIALOG, (Object)Boolean.TRUE, "EDIT", EditorExample.COLUMN_FIVE_LABEL);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultIntegerDisplayConverter(), "NORMAL", EditorExample.COLUMN_FIVE_LABEL);
    }

    private void registerColumnSixDoubleEditor(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new TextCellEditor(false, true), "NORMAL", EditorExample.COLUMN_SIX_LABEL);
        configRegistry.registerConfigAttribute(EditConfigAttributes.OPEN_ADJACENT_EDITOR, (Object)Boolean.TRUE, "EDIT", EditorExample.COLUMN_SIX_LABEL);
        configRegistry.registerConfigAttribute(EditConfigAttributes.OPEN_IN_DIALOG, (Object)Boolean.TRUE, "EDIT", EditorExample.COLUMN_SIX_LABEL);
        configRegistry.registerConfigAttribute(TickUpdateConfigAttributes.USE_ADJUST_BY, (Object)Boolean.TRUE, "EDIT", EditorExample.COLUMN_SIX_LABEL);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultDoubleDisplayConverter(), "NORMAL", EditorExample.COLUMN_SIX_LABEL);
    }

    private void registerColumnSevenCheckbox(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new CheckBoxCellEditor(), "EDIT", EditorExample.COLUMN_SEVEN_LABEL);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new CheckBoxPainter(), "NORMAL", EditorExample.COLUMN_SEVEN_LABEL);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultBooleanDisplayConverter(), "NORMAL", EditorExample.COLUMN_SEVEN_LABEL);
    }

    private void registerColumnEightCheckbox(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new CheckBoxCellEditor(), "EDIT", EditorExample.COLUMN_EIGHT_LABEL);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new CheckBoxPainter(GUIHelper.getImage((String)"arrow_up"), GUIHelper.getImage((String)"arrow_down")), "NORMAL", EditorExample.COLUMN_EIGHT_LABEL);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)this.getGenderBooleanConverter(), "NORMAL", EditorExample.COLUMN_EIGHT_LABEL);
    }

    private void registerColumnNineComboBox(IConfigRegistry configRegistry) {
        ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor(Arrays.asList(PersonService.getStreetNames()));
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)comboBoxCellEditor, "EDIT", EditorExample.COLUMN_NINE_LABEL);
    }

    private void registerColumnTenComboBox(IConfigRegistry configRegistry) {
        ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor(Arrays.asList(PersonService.getCityNames()), -1);
        comboBoxCellEditor.setFreeEdit(true);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)comboBoxCellEditor, "EDIT", EditorExample.COLUMN_TEN_LABEL);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new ComboBoxPainter(), "NORMAL", EditorExample.COLUMN_TEN_LABEL);
    }

    private void registerColumnElevenComboBox(IConfigRegistry configRegistry) {
        ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor(Arrays.asList(PersonService.getFoodList()), -1);
        comboBoxCellEditor.setMultiselect(true);
        comboBoxCellEditor.setUseCheckbox(true);
        comboBoxCellEditor.setMultiselectTextBracket("", "");
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultDisplayConverter(){

            public Object canonicalToDisplayValue(Object canonicalValue) {
                if (canonicalValue instanceof Collection) {
                    String result = canonicalValue.toString();
                    result = result.substring(1, result.length() - 1);
                    return result;
                }
                return super.canonicalToDisplayValue(canonicalValue);
            }
        }, "NORMAL", EditorExample.COLUMN_ELEVEN_LABEL);
        comboBoxCellEditor.setIconImage(GUIHelper.getImage((String)"plus"));
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)comboBoxCellEditor, "EDIT", EditorExample.COLUMN_ELEVEN_LABEL);
    }

    private void registerColumnTwelveComboBox(IConfigRegistry configRegistry) {
        ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor(Arrays.asList(PersonService.getDrinkList()), -1);
        comboBoxCellEditor.setFreeEdit(true);
        comboBoxCellEditor.setMultiselect(true);
        comboBoxCellEditor.setIconImage(GUIHelper.getImage((String)"plus"));
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)comboBoxCellEditor, "EDIT", EditorExample.COLUMN_TWELVE_LABEL);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new ComboBoxPainter(GUIHelper.getImage((String)"plus")), "NORMAL", EditorExample.COLUMN_TWELVE_LABEL);
    }

    private void registerColumnThirteenFileDialogEditor(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new FileDialogCellEditor(), "EDIT", EditorExample.COLUMN_THIRTEEN_LABEL);
    }

    private IDisplayConverter getGenderBooleanConverter() {
        return new DisplayConverter(){

            public Object canonicalToDisplayValue(Object canonicalValue) {
                if (canonicalValue instanceof Person.Gender) {
                    if ((Person.Gender)canonicalValue == Person.Gender.MALE) {
                        return true;
                    }
                    return false;
                }
                return null;
            }

            public Object displayToCanonicalValue(Object displayValue) {
                Boolean displayBoolean = Boolean.valueOf(displayValue.toString());
                return displayBoolean != false ? Person.Gender.MALE : Person.Gender.FEMALE;
            }
        };
    }
}

