/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._110_Editing;

import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDateDisplayConverter;
import org.eclipse.nebula.widgets.nattable.dataset.EventData;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.config.DialogErrorHandling;
import org.eclipse.nebula.widgets.nattable.examples.examples._110_Editing.CrossValidationGridExample;
import org.eclipse.nebula.widgets.nattable.examples.examples._110_Editing.EventDataValidator;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;

class CrossValidationEditConfiguration
extends AbstractRegistryConfiguration {
    private IRowDataProvider<EventData> bodyDataProvider;

    CrossValidationEditConfiguration(IRowDataProvider<EventData> bodyDataProvider) {
        this.bodyDataProvider = bodyDataProvider;
    }

    public void configureRegistry(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultDateDisplayConverter(), "NORMAL", CrossValidationGridExample.DATE_LABEL);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultDateDisplayConverter(), "EDIT", CrossValidationGridExample.DATE_LABEL);
        Style validationErrorStyle = new Style();
        validationErrorStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_RED);
        validationErrorStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)GUIHelper.COLOR_WHITE);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)validationErrorStyle, "NORMAL", CrossValidationGridExample.INVALID_LABEL);
        configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)new EventDataValidator(this.bodyDataProvider), "EDIT", CrossValidationGridExample.DATE_LABEL);
        configRegistry.registerConfigAttribute(EditConfigAttributes.VALIDATION_ERROR_HANDLER, (Object)new DialogErrorHandling(true), "EDIT", CrossValidationGridExample.DATE_LABEL);
    }
}

