/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._104_Styling;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.PercentageDisplayConverter;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.data.DummyColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.painter.cell.PercentageBarCellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.PercentageBarDecorator;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.style.VerticalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class _002_Using_a_custom_cell_painter
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(new _002_Using_a_custom_cell_painter());
    }

    @Override
    public Control createExampleControl(Composite parent) {
        MyDataProvider myDataProvider = new MyDataProvider();
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)myDataProvider));
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)new DummyColumnHeaderDataProvider((IDataProvider)myDataProvider)), (ILayer)selectionLayer, selectionLayer);
        CompositeLayer compositeLayer = new CompositeLayer(1, 2);
        compositeLayer.setChildLayer("COLUMN_HEADER", (ILayer)columnHeaderLayer, 0, 0);
        compositeLayer.setChildLayer("BODY", (ILayer)selectionLayer, 0, 1);
        NatTable natTable = new NatTable(parent, (ILayer)compositeLayer, false);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new CustomPaintingConfig());
        natTable.configure();
        return natTable;
    }

    class CustomPaintingConfig
    extends AbstractRegistryConfiguration {
        CustomPaintingConfig() {
        }

        public void configureRegistry(IConfigRegistry configRegistry) {
            Style cellStyle = new Style();
            cellStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignmentEnum.CENTER);
            cellStyle.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, (Object)VerticalAlignmentEnum.MIDDLE);
            cellStyle.setAttributeValue(PercentageBarDecorator.PERCENTAGE_BAR_COMPLETE_REGION_START_COLOR, (Object)GUIHelper.getColor((RGB)new RGB(251, 149, 123)));
            cellStyle.setAttributeValue(PercentageBarDecorator.PERCENTAGE_BAR_COMPLETE_REGION_END_COLOR, (Object)GUIHelper.getColor((RGB)new RGB(248, 253, 219)));
            cellStyle.setAttributeValue(PercentageBarDecorator.PERCENTAGE_BAR_INCOMPLETE_REGION_COLOR, (Object)GUIHelper.getColor((RGB)new RGB(236, 217, 255)));
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new PercentageBarCellPainter(), "NORMAL", "BODY".toString());
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new PercentageDisplayConverter(), "NORMAL", "BODY".toString());
        }
    }

    class MyDataProvider
    implements IDataProvider {
        MyDataProvider() {
        }

        public int getColumnCount() {
            return 10;
        }

        public int getRowCount() {
            return 10;
        }

        public Object getDataValue(int columnIndex, int rowIndex) {
            return (double)(rowIndex * 10 + columnIndex) / 100.0;
        }

        public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        }
    }
}

