/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._500_Layers._512_SummaryRow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.copy.command.CopyDataCommandHandler;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.dataset.NumberValues;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.FixedSummaryRowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.summaryrow.DefaultSummaryRowConfiguration;
import org.eclipse.nebula.widgets.nattable.summaryrow.FixedSummaryRowLayer;
import org.eclipse.nebula.widgets.nattable.summaryrow.ISummaryProvider;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummaryRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummationSummaryProvider;
import org.eclipse.nebula.widgets.nattable.ui.menu.DebugMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class _5124_SummaryRowPositionGridExample
extends AbstractNatExample {
    static final String SUMMARY_REGION = "SUMMARY";

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 400, new _5124_SummaryRowPositionGridExample());
    }

    @Override
    public String getDescription() {
        return "This example demonstrates how to add a summary row to the end of a grid.\n\nFeatures\n\tDifferent style can be applied to the whole row\n\tDifferent style can be applied to the individual cells in the summary row\n\tPlug-in your own summary formulas via ISummaryProvider interface (Default is summation)";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 20;
        panel.setLayout((Layout)layout);
        String[] propertyNames = new String[]{"columnOneNumber", "columnTwoNumber", "columnThreeNumber", "columnFourNumber", "columnFiveNumber"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("columnOneNumber", "Column 1");
        propertyToLabelMap.put("columnTwoNumber", "Column 2");
        propertyToLabelMap.put("columnThreeNumber", "Column 3");
        propertyToLabelMap.put("columnFourNumber", "Column 4");
        propertyToLabelMap.put("columnFiveNumber", "Column 5");
        ReflectiveColumnPropertyAccessor cpa = new ReflectiveColumnPropertyAccessor(propertyNames);
        ListDataProvider dataProvider = new ListDataProvider(this.createNumberValueList(), (IColumnAccessor)cpa);
        ConfigRegistry configRegistry = new ConfigRegistry();
        SummaryRowGridLayer gridLayerWithSummary = new SummaryRowGridLayer((IDataProvider)dataProvider, configRegistry, propertyNames, propertyToLabelMap, true);
        NatTable natTable = new NatTable(panel, (ILayer)gridLayerWithSummary, false);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new DebugMenuConfiguration(natTable));
        natTable.configure();
        final SummaryRowGridLayer gridLayer = new SummaryRowGridLayer((IDataProvider)dataProvider, configRegistry, propertyNames, propertyToLabelMap, false);
        FixedSummaryRowLayer summaryRowLayer = new FixedSummaryRowLayer((IUniqueIndexLayer)gridLayer.getBodyDataLayer(), (ILayer)gridLayer, (IConfigRegistry)configRegistry, false);
        summaryRowLayer.addConfiguration((IConfiguration)new ExampleSummaryRowGridConfiguration(gridLayer.getBodyDataLayer().getDataProvider()));
        summaryRowLayer.setSummaryRowLabel("\u2211");
        CompositeLayer composite = new CompositeLayer(1, 2);
        composite.setChildLayer("GRID", (ILayer)gridLayer, 0, 0);
        composite.setChildLayer(SUMMARY_REGION, (ILayer)summaryRowLayer, 0, 1);
        natTable = new NatTable(panel, (ILayer)composite, false);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        natTable.addOverlayPainter(new IOverlayPainter(){

            public void paintOverlay(GC gc, ILayer layer) {
                Color beforeColor = gc.getForeground();
                gc.setForeground(GUIHelper.COLOR_GRAY);
                int gridBorderY = gridLayer.getHeight() - 1;
                gc.drawLine(0, gridBorderY, layer.getWidth() - 1, gridBorderY);
                gc.setForeground(beforeColor);
            }
        });
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new DebugMenuConfiguration(natTable));
        natTable.configure();
        return panel;
    }

    private List<NumberValues> createNumberValueList() {
        ArrayList<NumberValues> result = new ArrayList<NumberValues>();
        int i = 0;
        while (i < 25) {
            NumberValues nv = new NumberValues();
            nv.setColumnOneNumber(5);
            nv.setColumnTwoNumber(4);
            nv.setColumnThreeNumber(3);
            nv.setColumnFourNumber(1);
            nv.setColumnFiveNumber(1);
            result.add(nv);
            nv = new NumberValues();
            nv.setColumnOneNumber(1);
            nv.setColumnTwoNumber(1);
            nv.setColumnThreeNumber(2);
            nv.setColumnFourNumber(2);
            nv.setColumnFiveNumber(3);
            result.add(nv);
            nv = new NumberValues();
            nv.setColumnOneNumber(1);
            nv.setColumnTwoNumber(2);
            nv.setColumnThreeNumber(2);
            nv.setColumnFourNumber(3);
            nv.setColumnFiveNumber(3);
            result.add(nv);
            nv = new NumberValues();
            nv.setColumnOneNumber(1);
            nv.setColumnTwoNumber(2);
            nv.setColumnThreeNumber(4);
            nv.setColumnFourNumber(4);
            nv.setColumnFiveNumber(3);
            result.add(nv);
            nv = new NumberValues();
            nv.setColumnOneNumber(5);
            nv.setColumnTwoNumber(4);
            nv.setColumnThreeNumber(4);
            nv.setColumnFourNumber(4);
            nv.setColumnFiveNumber(7);
            result.add(nv);
            ++i;
        }
        return result;
    }

    class ExampleSummaryRowGridConfiguration
    extends DefaultSummaryRowConfiguration {
        private final IDataProvider dataProvider;

        public ExampleSummaryRowGridConfiguration(IDataProvider dataProvider) {
            this.dataProvider = dataProvider;
            this.summaryRowBgColor = GUIHelper.COLOR_BLUE;
            this.summaryRowFgColor = GUIHelper.COLOR_WHITE;
        }

        public void addSummaryProviderConfig(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(SummaryRowConfigAttributes.SUMMARY_PROVIDER, (Object)new SummationSummaryProvider(this.dataProvider), "NORMAL", "SummaryRow");
            configRegistry.registerConfigAttribute(SummaryRowConfigAttributes.SUMMARY_PROVIDER, (Object)new AverageSummaryProvider(), "NORMAL", "SummaryColumn_4");
        }

        class AverageSummaryProvider
        implements ISummaryProvider {
            AverageSummaryProvider() {
            }

            public Object summarize(int columnIndex) {
                double total = 0.0;
                int rowCount = ExampleSummaryRowGridConfiguration.this.dataProvider.getRowCount();
                int rowIndex = 0;
                while (rowIndex < rowCount) {
                    Object dataValue = ExampleSummaryRowGridConfiguration.this.dataProvider.getDataValue(columnIndex, rowIndex);
                    total += Double.parseDouble(dataValue.toString());
                    ++rowIndex;
                }
                return "Avg: " + total / (double)rowCount;
            }
        }
    }

    class SummaryRowBodyLayerStack
    extends AbstractLayerTransform {
        private final DataLayer bodyDataLayer;
        private final ColumnReorderLayer columnReorderLayer;
        private final ColumnHideShowLayer columnHideShowLayer;
        private final SelectionLayer selectionLayer;
        private final ViewportLayer viewportLayer;

        public SummaryRowBodyLayerStack(IDataProvider dataProvider, ConfigRegistry configRegistry, boolean summaryRowOnTop) {
            this.bodyDataLayer = new DataLayer(dataProvider);
            this.columnReorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)this.bodyDataLayer);
            this.columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)this.columnReorderLayer);
            this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)this.columnHideShowLayer);
            this.viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.selectionLayer);
            if (summaryRowOnTop) {
                FixedSummaryRowLayer summaryRowLayer = new FixedSummaryRowLayer((IUniqueIndexLayer)this.bodyDataLayer, (ILayer)this.viewportLayer, (IConfigRegistry)configRegistry, false);
                summaryRowLayer.setHorizontalCompositeDependency(false);
                summaryRowLayer.addConfiguration((IConfiguration)new ExampleSummaryRowGridConfiguration(this.bodyDataLayer.getDataProvider()));
                CompositeLayer composite = new CompositeLayer(1, 2);
                composite.setChildLayer(_5124_SummaryRowPositionGridExample.SUMMARY_REGION, (ILayer)summaryRowLayer, 0, 0);
                composite.setChildLayer("BODY", (ILayer)this.viewportLayer, 0, 1);
                this.setUnderlyingLayer((ILayer)composite);
            } else {
                this.setUnderlyingLayer((ILayer)this.viewportLayer);
            }
            this.registerCommandHandler((ILayerCommandHandler)new CopyDataCommandHandler(this.selectionLayer));
        }

        public DataLayer getDataLayer() {
            return this.bodyDataLayer;
        }

        public SelectionLayer getSelectionLayer() {
            return this.selectionLayer;
        }

        public ViewportLayer getViewportLayer() {
            return this.viewportLayer;
        }
    }

    class SummaryRowGridLayer
    extends GridLayer {
        public SummaryRowGridLayer(IDataProvider dataProvider, ConfigRegistry configRegistry, String[] propertyNames, Map<String, String> propertyToLabelMap, boolean summaryRowOnTop) {
            super(true);
            this.init(dataProvider, configRegistry, propertyNames, propertyToLabelMap, summaryRowOnTop);
        }

        private void init(IDataProvider dataProvider, ConfigRegistry configRegistry, String[] propertyNames, Map<String, String> propertyToLabelMap, boolean summaryRowOnTop) {
            SummaryRowBodyLayerStack bodyLayer = new SummaryRowBodyLayerStack(dataProvider, configRegistry, summaryRowOnTop);
            SelectionLayer selectionLayer = bodyLayer.getSelectionLayer();
            DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
            ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider), (ILayer)bodyLayer.getViewportLayer(), selectionLayer);
            DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider(bodyLayer.getDataLayer().getDataProvider());
            DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
            FixedSummaryRowHeaderLayer rowHeaderLayer = null;
            if (summaryRowOnTop) {
                rowHeaderLayer = new FixedSummaryRowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)bodyLayer, selectionLayer);
                rowHeaderLayer.setSummaryRowLabel("\u2211");
            } else {
                rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)bodyLayer, selectionLayer);
            }
            CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider)), (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
            this.setBodyLayer((ILayer)bodyLayer);
            this.setColumnHeaderLayer((ILayer)columnHeaderLayer);
            this.setRowHeaderLayer((ILayer)rowHeaderLayer);
            this.setCornerLayer((ILayer)cornerLayer);
        }

        public DataLayer getBodyDataLayer() {
            return ((SummaryRowBodyLayerStack)this.getBodyLayer()).getDataLayer();
        }
    }
}

