/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.evaluator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.UnitLocation;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMRootEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.utils.ASTBindingHelper;
import org.eclipse.ocl.examples.debug.vm.utils.VMRuntimeException;
import org.eclipse.ocl.examples.debug.vm.utils.VMStackTraceBuilder;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.qvtd.debug.core.QVTiDebugCore;
import org.eclipse.qvtd.debug.evaluator.IQVTiVMEvaluationEnvironment;
import org.eclipse.qvtd.debug.evaluator.QVTiVMModelManager;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiModelManager;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiRootEvaluationEnvironment;

public class QVTiVMRootEvaluationEnvironment
extends QVTiRootEvaluationEnvironment
implements IQVTiVMEvaluationEnvironment,
IVMRootEvaluationEnvironment<Transformation> {
    private List<Runnable> myDeferredTasks;
    private boolean myIsDeferedExecution;
    @NonNull
    private Element myCurrentIP;
    private final long id;
    @NonNull
    private final Variable pcVariable;
    @NonNull
    private final Stack<IVMEvaluationEnvironment.StepperEntry> stepperStack = new Stack();

    public QVTiVMRootEvaluationEnvironment(@NonNull MetaModelManager metaModelManager, @NonNull QVTiModelManager modelManager, @NonNull Transformation transformation, long id) {
        super(metaModelManager, modelManager, transformation);
        this.myCurrentIP = transformation;
        this.id = id;
        this.pcVariable = (Variable)DomainUtil.nonNullEMF((Object)PivotFactory.eINSTANCE.createVariable());
        this.pcVariable.setName("$pc");
        String typeName = (String)DomainUtil.nonNullEMF((Object)PivotPackage.Literals.OCL_EXPRESSION.getName());
        this.pcVariable.setType(metaModelManager.getPivotType(typeName));
    }

    @Override
    @NonNull
    public IQVTiVMEvaluationEnvironment createClonedEvaluationEnvironment() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public Element getCurrentIP() {
        return this.myCurrentIP;
    }

    @Override
    @NonNull
    public UnitLocation getCurrentLocation() {
        int startPosition = ASTBindingHelper.getStartPosition((Element)this.myCurrentIP);
        int endPosition = ASTBindingHelper.getEndPosition((Element)this.myCurrentIP);
        return new UnitLocation(startPosition, endPosition, (IVMEvaluationEnvironment)this, this.myCurrentIP);
    }

    @NonNull
    public QVTiDebugCore getDebugCore() {
        return QVTiDebugCore.INSTANCE;
    }

    @NonNull
    public Transformation getDebuggableElement() {
        return this.transformation;
    }

    public int getDepth() {
        return 1;
    }

    public long getID() {
        return this.id;
    }

    @Override
    @NonNull
    public QVTiVMModelManager getModelManager() {
        return (QVTiVMModelManager)super.getModelManager();
    }

    @NonNull
    public Map<String, Resource> getModelParameterVariables() {
        Transformation currentModule = this.getTransformation();
        HashMap<String, Resource> result = new HashMap<String, Resource>(2);
        Transformation currentTransformation = currentModule;
        QVTiVMModelManager modelManager = this.getModelManager();
        for (TypedModel typedModel : currentTransformation.getModelParameter()) {
            if (typedModel == null) continue;
            Resource model = modelManager.getModel(typedModel);
            result.put(typedModel.getName(), model);
        }
        return result;
    }

    @NonNull
    public NamedElement getOperation() {
        return this.transformation;
    }

    @Override
    @Nullable
    public QVTiVMRootEvaluationEnvironment getParentEvaluationEnvironment() {
        return (QVTiVMRootEvaluationEnvironment)super.getParentEvaluationEnvironment();
    }

    @NonNull
    public Variable getPCVariable() {
        return this.pcVariable;
    }

    @Override
    @NonNull
    public QVTiVMRootEvaluationEnvironment getRootEvaluationEnvironment() {
        return this;
    }

    @NonNull
    public Stack<IVMEvaluationEnvironment.StepperEntry> getStepperStack() {
        return this.stepperStack;
    }

    public boolean isDeferredExecution() {
        return this.myIsDeferedExecution;
    }

    @Override
    public void processDeferredTasks() {
        if (this.myDeferredTasks != null) {
            try {
                this.myIsDeferedExecution = true;
                ArrayList<Runnable> tasksCopy = new ArrayList<Runnable>(this.myDeferredTasks);
                for (Runnable task : tasksCopy) {
                    task.run();
                }
            }
            finally {
                this.myIsDeferedExecution = false;
            }
        }
    }

    protected void saveThrownException(@NonNull VMRuntimeException exception) {
    }

    @Override
    @NonNull
    public Element setCurrentIP(@NonNull Element element) {
        Element prevValue = this.myCurrentIP;
        this.myCurrentIP = element;
        return prevValue;
    }

    public void setException(@NonNull VMRuntimeException exception) {
        this.saveThrownException(exception);
    }

    @Override
    public void throwVMException(@NonNull VMRuntimeException exception) throws VMRuntimeException {
        try {
            this.saveThrownException(exception);
            exception.setStackVMTrace(new VMStackTraceBuilder((IVMEvaluationEnvironment)this).buildStackTrace());
        }
        catch (Exception e) {
            this.getDebugCore().error("Failed to build VM stack trace", e);
        }
        throw exception;
    }
}

